/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.RenderReportCmd;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.VBHTMLRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class GenerateReportAction
implements IObjectActionDelegate {
    private static final Logger log;
    private IWorkbenchPart targetPart;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.actions.GenerateReportAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public final void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public final void run(IAction iAction) {
        log.info((Object)"Generation Report action requested");
        ISelection iSelection = this.targetPart.getSite().getSelectionProvider().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            try {
                IProject iProject = this.getProject((IStructuredSelection)iSelection);
                if (iProject != null) {
                    RenderReportCmd renderReportCmd = new RenderReportCmd();
                    renderReportCmd.setProject(iProject);
                    renderReportCmd.setUserInitiated(true);
                    renderReportCmd.registerRenderer((Renderer)new HTMLRenderer(), "pmd-report.html");
                    renderReportCmd.registerRenderer((Renderer)new CSVRenderer(), "pmd-report.csv");
                    renderReportCmd.registerRenderer((Renderer)new XMLRenderer(), "pmd-report.xml");
                    renderReportCmd.registerRenderer((Renderer)new TextRenderer(), "pmd-report.txt");
                    renderReportCmd.registerRenderer((Renderer)new VBHTMLRenderer(), "pmd-report.vb.html");
                    renderReportCmd.performExecute();
                }
            }
            catch (CommandException commandException) {
                PMDPlugin.getDefault().showError(PMDPlugin.getDefault().getStringTable().getString("message.error.pmd_exception"), commandException);
            }
        }
    }

    public final void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private IProject getProject(IStructuredSelection iStructuredSelection) {
        IProject iProject = null;
        Object object = iStructuredSelection.getFirstElement();
        if (object != null && object instanceof IAdaptable) {
            IResource iResource;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                iProject = iResource.getProject();
            }
        }
        return iProject;
    }
}

