/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ClearReviewsAction
implements IObjectActionDelegate,
IResourceVisitor,
IViewActionDelegate {
    private static final Logger log;
    private IWorkbenchPart targetPart;
    private IProgressMonitor monitor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.actions.ClearReviewsAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void init(IViewPart iViewPart) {
        this.targetPart = iViewPart.getSite().getPage().getActivePart();
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        log.info((Object)"Remove violation reviews requested.");
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    ClearReviewsAction.this.setMonitor(iProgressMonitor);
                    ClearReviewsAction.this.clearReviews();
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            PMDPlugin.getDefault().logError("Invocation Target Exception when removing violations reviews", invocationTargetException.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            PMDPlugin.getDefault().logError("Interrupted Exception when removing violations reviews", interruptedException);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    protected void monitorWorked() {
        if (this.getMonitor() != null) {
            this.getMonitor().worked(1);
        }
    }

    protected void monitorSubTask(String string) {
        if (this.getMonitor() != null) {
            this.getMonitor().subTask(string);
        }
    }

    protected void clearReviews() {
        try {
            ISelection iSelection;
            if (this.targetPart instanceof IViewPart && (iSelection = this.targetPart.getSite().getSelectionProvider().getSelection()) != null && iSelection instanceof IStructuredSelection) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                if (this.getMonitor() != null) {
                    this.getMonitor().beginTask(this.getString("monitor.remove_reviews"), -1);
                    Iterator iterator = iStructuredSelection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        IResource iResource = null;
                        if (e instanceof IMarker) {
                            iResource = ((IMarker)e).getResource();
                        } else if (e instanceof IAdaptable) {
                            IAdaptable iAdaptable = (IAdaptable)e;
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                        } else {
                            log.warn((Object)"The selected object is not adaptable");
                            log.debug((Object)("   -> selected object = " + e));
                        }
                        if (iResource != null) {
                            iResource.accept((IResourceVisitor)this);
                            continue;
                        }
                        log.warn((Object)"The selected object cannot adapt to a resource.");
                        log.debug((Object)("   -> selected object" + e));
                    }
                }
            }
            if (this.targetPart instanceof IEditorPart) {
                iSelection = ((IEditorPart)this.targetPart).getEditorInput();
                if (iSelection instanceof IFileEditorInput) {
                    ((IFileEditorInput)iSelection).getFile().accept((IResourceVisitor)this);
                } else {
                    log.debug((Object)("The kind of editor input is not supported. The editor input if of type: " + iSelection.getClass().getName()));
                }
            } else {
                log.debug((Object)("This action is not supported on this kind of part. This part type is: " + this.targetPart.getClass().getName()));
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("Core Exception when clearing violations reviews", coreException);
        }
    }

    private void clearReviews(IFile iFile) {
        this.monitorSubTask(iFile.getName());
        String string = this.removeReviews(iFile);
        if (string != null) {
            this.saveNewContent(iFile, string);
        }
        this.monitorWorked();
    }

    private String removeReviews(IFile iFile) {
        String string = iFile.getName().toLowerCase();
        if (!string.endsWith(".java") && !string.endsWith(".jsp")) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        try {
            boolean bl2 = false;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(iFile.getContents()));
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            while (bufferedReader.ready()) {
                String string2 = bufferedReader.readLine();
                String string3 = string2.trim();
                int n = string2.indexOf("// NOPMD");
                int n2 = string2.indexOf(34);
                if (string3.startsWith("/*")) {
                    if (string3.indexOf("*/") == -1) {
                        bl2 = true;
                    }
                    printWriter.println(string2);
                    continue;
                }
                if (bl2 && string3.indexOf("*/") != -1) {
                    bl2 = false;
                    printWriter.println(string2);
                    continue;
                }
                if (!bl2 && string3.startsWith("// @PMD:REVIEWED:")) {
                    bl = false;
                    continue;
                }
                if (!(bl2 || n == -1 || n2 != -1 && n2 < n && n < string2.lastIndexOf(34))) {
                    bl = false;
                    printWriter.println(string2.substring(0, n));
                    continue;
                }
                printWriter.println(string2);
            }
            printWriter.flush();
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.core_exception", coreException);
        }
        catch (IOException iOException) {
            PMDPlugin.getDefault().logError("message.error.io_exception", iOException);
        }
        return bl ? null : byteArrayOutputStream.toString();
    }

    private void saveNewContent(IFile iFile, String string) {
        try {
            iFile.setContents((InputStream)new ByteArrayInputStream(string.getBytes()), false, true, this.getMonitor());
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.core_exception", coreException);
        }
    }

    public boolean visit(IResource iResource) throws CoreException {
        if (iResource instanceof IFile) {
            this.clearReviews((IFile)iResource);
        }
        return iResource instanceof IProject || iResource instanceof IFolder;
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

