/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.writer.impl;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.eclipse.runtime.writer.IAstWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class AstWriterImpl
implements IAstWriter {
    private static final Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.writer.impl.AstWriterImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    AstWriterImpl() {
    }

    public void write(OutputStream outputStream, ASTCompilationUnit aSTCompilationUnit) throws WriterException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = this.getElement(document, (SimpleNode)aSTCompilationUnit);
            document.appendChild(element);
            OutputFormat outputFormat = new OutputFormat(document, "UTF-8", true);
            outputFormat.setLineWidth(0);
            XMLSerializer xMLSerializer = new XMLSerializer(outputStream, outputFormat);
            xMLSerializer.serialize(document);
        }
        catch (DOMException dOMException) {
            throw new WriterException(dOMException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new WriterException(factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WriterException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new WriterException(iOException);
        }
    }

    private Element getElement(Document document, SimpleNode simpleNode) {
        log.debug((Object)("creating element " + simpleNode));
        Element element = document.createElement(simpleNode.toString());
        this.addAttributes(element, simpleNode);
        int n = 0;
        while (n < simpleNode.jjtGetNumChildren()) {
            Node node = simpleNode.jjtGetChild(n);
            Element element2 = this.getElement(document, (SimpleNode)node);
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    private void addAttributes(Element element, SimpleNode simpleNode) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(simpleNode.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                block9: {
                    String string = propertyDescriptorArray[n].getName();
                    if (!string.equals("class") && !string.equals("scope")) {
                        log.debug((Object)("   processing attribute " + propertyDescriptorArray[n].getName()));
                        Method method = propertyDescriptorArray[n].getReadMethod();
                        if (method != null) {
                            try {
                                Object object = method.invoke((Object)simpleNode, null);
                                if (object != null) {
                                    log.debug((Object)"      added");
                                    element.setAttribute(propertyDescriptorArray[n].getName(), object.toString());
                                    break block9;
                                }
                                log.debug((Object)"      not added attribute is null");
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                log.debug((Object)"      not added calling getter has failed");
                            }
                        } else {
                            log.debug((Object)"      not added getter is null");
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            log.debug((Object)"Error introspecting properties. Ignored", (Throwable)exception);
        }
    }
}

