/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;

public class ReviewResourceForRuleCommand
extends AbstractDefaultCommand {
    private static final long serialVersionUID = 1L;
    private IResource resource;
    private RuleContext context;
    private Rule rule;
    private List listenerList;
    static /* synthetic */ Class class$0;

    public ReviewResourceForRuleCommand() {
        this.setDescription("Review a resource for a specific rule.");
        this.setName("ReviewResourceForRuleCommand");
        this.setOutputProperties(true);
        this.setReadOnly(true);
        this.setTerminated(false);
        this.listenerList = new ArrayList();
    }

    public void setResource(IResource iResource) {
        this.resource = iResource;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.listenerList.add(iPropertyListener);
    }

    public boolean isReadyToExecute() {
        return this.resource != null && this.rule != null;
    }

    public void reset() {
        this.setResource(null);
        this.setRule(null);
        this.listenerList = new ArrayList();
    }

    public void execute() throws CommandException {
        IProject iProject = this.resource.getProject();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IFile iFile = (IFile)this.resource.getAdapter((Class)clazz);
        this.beginTask("PMD Checking for specific rule...", 1);
        if (iFile != null && iFile.getFileExtension() != null && iFile.getFileExtension().equals("java")) {
            RuleSet ruleSet = new RuleSet();
            ruleSet.addRule(this.rule);
            PMD pMD = this.getPmdEngineForProject(iProject);
            try {
                this.context = new RuleContext();
                this.context.setSourceCodeFile(iFile.getFullPath().toFile());
                this.context.setSourceCodeFilename(iFile.getName());
                this.context.setReport(new Report());
                InputStreamReader inputStreamReader = new InputStreamReader(iFile.getContents(), iFile.getCharset());
                pMD.processFile((Reader)inputStreamReader, ruleSet, this.context);
                ((Reader)inputStreamReader).close();
            }
            catch (CoreException coreException) {
                throw new CommandException(coreException);
            }
            catch (PMDException pMDException) {
                throw new CommandException(pMDException);
            }
            catch (IOException iOException) {
                throw new CommandException(iOException);
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    Iterator iterator = ReviewResourceForRuleCommand.this.listenerList.iterator();
                    while (iterator.hasNext()) {
                        IPropertyListener iPropertyListener = (IPropertyListener)iterator.next();
                        iPropertyListener.propertyChanged((Object)ReviewResourceForRuleCommand.this.context.getReport().iterator(), 1112);
                    }
                }
            });
        }
    }
}

