/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import name.herlin.command.AbstractProcessableCommand;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.JavaProjectClassLoader;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public abstract class AbstractDefaultCommand
extends AbstractProcessableCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger log;
    private boolean readOnly;
    private boolean outputProperties;
    private boolean readyToExecute;
    private String description;
    private String name;
    private IProgressMonitor monitor;
    private int stepsCount;
    private boolean userInitiated;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOutputProperties(boolean bl) {
        this.outputProperties = bl;
    }

    public boolean hasOutputProperties() {
        return this.outputProperties;
    }

    public boolean isReadyToExecute() {
        return this.readyToExecute;
    }

    public void setReadyToExecute(boolean bl) {
        this.readyToExecute = bl;
    }

    public int getStepsCount() {
        return this.stepsCount;
    }

    public void setStepsCount(int n) {
        this.stepsCount = n;
    }

    public boolean isUserInitiated() {
        return this.userInitiated;
    }

    public void setUserInitiated(boolean bl) {
        this.userInitiated = bl;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    public abstract void execute() throws CommandException;

    public abstract void reset();

    protected void beginTask(String string, int n) {
        if (this.monitor != null) {
            this.monitor.beginTask(string, n);
        }
    }

    protected void done() {
        if (this.monitor != null) {
            this.monitor.done();
        }
        this.setTerminated(true);
    }

    protected boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    protected void setTaskName(String string) {
        if (this.monitor != null) {
            this.monitor.setTaskName(string);
        }
    }

    protected void subTask(String string) {
        if (this.monitor != null) {
            this.monitor.subTask(string);
        }
    }

    protected void worked(int n) {
        if (this.monitor != null) {
            this.monitor.worked(n);
        }
    }

    protected PMD getPmdEngineForProject(IProject iProject) throws CommandException {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        PMD pMD = new PMD();
        if (iJavaProject.exists()) {
            String string = iJavaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            log.debug((Object)("compilerCompliance = " + string));
            SourceType sourceType = SourceType.getSourceTypeForId((String)("java " + string));
            if (sourceType == null) {
                throw new CommandException("The target JDK, " + string + " is not yet supported");
            }
            pMD.setJavaVersion(sourceType);
            IPreferences iPreferences = PMDPlugin.getDefault().loadPreferences();
            if (iPreferences.isProjectBuildPathEnabled()) {
                pMD.setClassLoader((ClassLoader)new JavaProjectClassLoader(pMD.getClassLoader(), iJavaProject));
            }
        } else {
            throw new CommandException("The project " + iProject.getName() + " is not a Java project");
        }
        return pMD;
    }
}

