/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.jboss.tools.smooks.model.fileRouting;

import org.jboss.tools.smooks.model.smooks.ElementVisitor;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Output Stream</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 *     			File output stream
 *     		
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getFileNamePattern <em>File Name Pattern</em>}</li>
 *   <li>{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getDestinationDirectoryPattern <em>Destination Directory Pattern</em>}</li>
 *   <li>{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getListFileNamePattern <em>List File Name Pattern</em>}</li>
 *   <li>{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getHighWaterMark <em>High Water Mark</em>}</li>
 *   <li>{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getCloseOnCondition <em>Close On Condition</em>}</li>
 *   <li>{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getEncoding <em>Encoding</em>}</li>
 *   <li>{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getOpenOnElement <em>Open On Element</em>}</li>
 *   <li>{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getOpenOnElementNS <em>Open On Element NS</em>}</li>
 *   <li>{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getResourceName <em>Resource Name</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream()
 * @model extendedMetaData="name='outputStream' kind='elementOnly'"
 * @generated
 */
public interface OutputStream extends ElementVisitor {
	/**
	 * Returns the value of the '<em><b>File Name Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 				    			The pattern that will be used to generate file names.
	 * 				    			The file is created in the directory defined by the 'destinationDirectoryPattern' element.
	 * 				    			Templating support is available via the FreeMarker template engine.
	 * 			    			
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>File Name Pattern</em>' attribute.
	 * @see #setFileNamePattern(String)
	 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream_FileNamePattern()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 *        extendedMetaData="kind='element' name='fileNamePattern' namespace='##targetNamespace'"
	 * @generated
	 */
	String getFileNamePattern();

	/**
	 * Sets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getFileNamePattern <em>File Name Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>File Name Pattern</em>' attribute.
	 * @see #getFileNamePattern()
	 * @generated
	 */
	void setFileNamePattern(String value);

	/**
	 * Returns the value of the '<em><b>Destination Directory Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 				    			The destination directory for files created by this router.
	 * 				    			Templating support is available via the FreeMarker template engine.
	 * 			    			
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Destination Directory Pattern</em>' attribute.
	 * @see #setDestinationDirectoryPattern(String)
	 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream_DestinationDirectoryPattern()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 *        extendedMetaData="kind='element' name='destinationDirectoryPattern' namespace='##targetNamespace'"
	 * @generated
	 */
	String getDestinationDirectoryPattern();

	/**
	 * Sets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getDestinationDirectoryPattern <em>Destination Directory Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Destination Directory Pattern</em>' attribute.
	 * @see #getDestinationDirectoryPattern()
	 * @generated
	 */
	void setDestinationDirectoryPattern(String value);

	/**
	 * Returns the value of the '<em><b>List File Name Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 				    			The name of the file that will contain the file names generated by this configuration.
	 * 				    			The file is created in the directory defined by the 'destinationDirectoryPattern' element.
	 * 			    			
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>List File Name Pattern</em>' attribute.
	 * @see #setListFileNamePattern(String)
	 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream_ListFileNamePattern()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 *        extendedMetaData="kind='element' name='listFileNamePattern' namespace='##targetNamespace'"
	 * @generated
	 */
	String getListFileNamePattern();

	/**
	 * Sets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getListFileNamePattern <em>List File Name Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>List File Name Pattern</em>' attribute.
	 * @see #getListFileNamePattern()
	 * @generated
	 */
	void setListFileNamePattern(String value);

	/**
	 * Returns the value of the '<em><b>High Water Mark</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 				    			Sets the configuration for the max number of output files in the destination directory at any time.
	 * 			    			
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>High Water Mark</em>' containment reference.
	 * @see #setHighWaterMark(HighWaterMark)
	 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream_HighWaterMark()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='highWaterMark' namespace='##targetNamespace'"
	 * @generated
	 */
	HighWaterMark getHighWaterMark();

	/**
	 * Sets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getHighWaterMark <em>High Water Mark</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>High Water Mark</em>' containment reference.
	 * @see #getHighWaterMark()
	 * @generated
	 */
	void setHighWaterMark(HighWaterMark value);

	/**
	 * Returns the value of the '<em><b>Close On Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 				    			An MVEL expression. If it returns true then the output stream is closed on the visitAfter event
	 * 				    			else it is kept open. If the expression is not set then output stream is closed by default.
	 * 			    			
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Close On Condition</em>' attribute.
	 * @see #setCloseOnCondition(String)
	 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream_CloseOnCondition()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='closeOnCondition' namespace='##targetNamespace'"
	 * @generated
	 */
	String getCloseOnCondition();

	/**
	 * Sets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getCloseOnCondition <em>Close On Condition</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Close On Condition</em>' attribute.
	 * @see #getCloseOnCondition()
	 * @generated
	 */
	void setCloseOnCondition(String value);

	/**
	 * Returns the value of the '<em><b>Encoding</b></em>' attribute.
	 * The default value is <code>"UTF-8"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 *     						The encoding to be used by any writers on this resource. Default is 'UTF-8'.
	 * 						
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Encoding</em>' attribute.
	 * @see #isSetEncoding()
	 * @see #unsetEncoding()
	 * @see #setEncoding(String)
	 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream_Encoding()
	 * @model default="UTF-8" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='attribute' name='encoding'"
	 * @generated
	 */
	String getEncoding();

	/**
	 * Sets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getEncoding <em>Encoding</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Encoding</em>' attribute.
	 * @see #isSetEncoding()
	 * @see #unsetEncoding()
	 * @see #getEncoding()
	 * @generated
	 */
	void setEncoding(String value);

	/**
	 * Unsets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getEncoding <em>Encoding</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetEncoding()
	 * @see #getEncoding()
	 * @see #setEncoding(String)
	 * @generated
	 */
	void unsetEncoding();

	/**
	 * Returns whether the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getEncoding <em>Encoding</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Encoding</em>' attribute is set.
	 * @see #unsetEncoding()
	 * @see #getEncoding()
	 * @see #setEncoding(String)
	 * @generated
	 */
	boolean isSetEncoding();

	/**
	 * Returns the value of the '<em><b>Open On Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 			    			The element on which the output stream resource should be opened. If opened, the stream will be
	 *                             closed at the end of the same element (on the visitAfter).  This behaviour can be overridden
	 *                             through the &lt;closeOnCondition&gt; element.  In that case, the resource is only closed
	 *                             when the MVEL condition is met.
	 * 			    		
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Open On Element</em>' attribute.
	 * @see #setOpenOnElement(String)
	 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream_OpenOnElement()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 *        extendedMetaData="kind='attribute' name='openOnElement'"
	 * @generated
	 */
	String getOpenOnElement();

	/**
	 * Sets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getOpenOnElement <em>Open On Element</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Open On Element</em>' attribute.
	 * @see #getOpenOnElement()
	 * @generated
	 */
	void setOpenOnElement(String value);

	/**
	 * Returns the value of the '<em><b>Open On Element NS</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 			    			The namespace of the openOnElement element.
	 * 			    		
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Open On Element NS</em>' attribute.
	 * @see #setOpenOnElementNS(String)
	 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream_OpenOnElementNS()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='attribute' name='openOnElementNS'"
	 * @generated
	 */
	String getOpenOnElementNS();

	/**
	 * Sets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getOpenOnElementNS <em>Open On Element NS</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Open On Element NS</em>' attribute.
	 * @see #getOpenOnElementNS()
	 * @generated
	 */
	void setOpenOnElementNS(String value);

	/**
	 * Returns the value of the '<em><b>Resource Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 *     						The name on which the output stream resource is referenced.
	 *     					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Resource Name</em>' attribute.
	 * @see #setResourceName(String)
	 * @see org.jboss.tools.smooks.model.fileRouting.FileRoutingPackage#getOutputStream_ResourceName()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 *        extendedMetaData="kind='attribute' name='resourceName'"
	 * @generated
	 */
	String getResourceName();

	/**
	 * Sets the value of the '{@link org.jboss.tools.smooks.model.fileRouting.OutputStream#getResourceName <em>Resource Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Resource Name</em>' attribute.
	 * @see #getResourceName()
	 * @generated
	 */
	void setResourceName(String value);

} // OutputStream
