/*
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.
 *
 * This software is made available by Red Hat, Inc. under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution and is
 * available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * See the AUTHORS.txt file in the distribution for a full listing of
 * individual contributors.
 */
package org.jboss.tools.modeshape.rest;

import org.modeshape.common.i18n.I18n;

/**
 * The <code>RestClientI18n</code> class provides localized messages.
 */
public final class RestClientI18n {

    public static I18n basePublishingActionPublishingWizardErrorMsg;
    public static I18n basePublishingActionUnpublishingWizardErrorMsg;

    public static I18n collapseActionToolTip;

    public static I18n deleteServerActionText;
    public static I18n deleteServerActionToolTip;

    public static I18n deleteServerDialogErrorsOccurredMsg;
    public static I18n deleteServerDialogMultipleServersMsg;
    public static I18n deleteServerDialogOneServerMsg;
    public static I18n deleteServerDialogTitle;

    public static I18n editServerActionText;
    public static I18n editServerActionToolTip;
    public static I18n errorDeletingServerRegistryFile;
    public static I18n errorDialogTitle;
    public static I18n errorRestoringServerRegistry;
    public static I18n errorSavingServerRegistry;

    public static I18n missingImage;

    public static I18n newFilteredFileExtensionDialogLabel;
    public static I18n newFilteredFileExtensionDialogTitle;

    public static I18n newFilteredFolderNameDialogLabel;
    public static I18n newFilteredFolderNameDialogTitle;

    public static I18n newServerActionText;
    public static I18n newServerActionToolTip;

    public static I18n prefUtilsPropertyFileNotFound;
    public static I18n prefUtilsPropertyNotFound;

    public static I18n publishedLocationsDialogCopyUrlButton;
    public static I18n publishedLocationsDialogCopyUrlButtonToolTip;
    public static I18n publishedLocationsDialogErrorObtainingUrlMsg;
    public static I18n publishedLocationsDialogFileUrlColumnHeader;
    public static I18n publishedLocationsDialogMsg;
    public static I18n publishedLocationsDialogRepositoryColumnHeader;
    public static I18n publishedLocationsDialogServerUrlColumnHeader;
    public static I18n publishedLocationsDialogTitle;
    public static I18n publishedLocationsDialogUserColumnHeader;
    public static I18n publishedLocationsDialogWorkspaceColumnHeader;

    public static I18n publishedResourcePropertyErrorMsg;

    public static I18n publishingConsoleName;
    public static I18n publishingConsoleProblemCreatingHyperlinkMsg;
    public static I18n publishingConsoleFilePathNotFoundMsg;

    public static I18n preferencePageDescription;
    public static I18n preferencePageFilteredFileExtensionsLabel;
    public static I18n preferencePageFilteredFolderNamesLabel;
    public static I18n preferencePageMessage;
    public static I18n preferencePageTitle;

    public static I18n publishJobCanceled;
    public static I18n publishJobDurationMsg;
    public static I18n publishJobDurationNoHoursMsg;
    public static I18n publishJobDurationNoHoursNoMinutesMsg;
    public static I18n publishJobDurationShortMsg;
    public static I18n publishJobPublish;
    public static I18n publishJobPublishCanceledMsg;
    public static I18n publishJobPublishFile;
    public static I18n publishJobPublishFileFailed;
    public static I18n publishJobPublishFileInfo;
    public static I18n publishJobPublishFileWarning;
    public static I18n publishJobPublishFinishedMsg;
    public static I18n publishJobPublishName;
    public static I18n publishJobPublishTaskName;
    public static I18n publishJobUnexpectedErrorMsg;
    public static I18n publishJobUnpublish;
    public static I18n publishJobUnpublishCanceledMsg;
    public static I18n publishJobUnpublishFile;
    public static I18n publishJobUnpublishFileFailed;
    public static I18n publishJobUnpublishFileInfo;
    public static I18n publishJobUnpublishFileWarning;
    public static I18n publishJobUnpublishFinishedMsg;
    public static I18n publishJobUnpublishName;
    public static I18n publishJobUnpublishTaskName;

    public static I18n publishPagePublishTitle;
    public static I18n publishPageLocationGroupTitle;
    public static I18n publishPageMissingRepositoryStatusMsg;
    public static I18n publishPageMissingServerStatusMsg;
    public static I18n publishPageMissingWorkspaceStatusMsg;
    public static I18n publishPageNewServerButton;
    public static I18n publishPageNoAvailableRepositoriesStatusMsg;
    public static I18n publishPageNoAvailableServersStatusMsg;
    public static I18n publishPageNoAvailableWorkspacesStatusMsg;
    public static I18n publishPageNoResourcesToPublishStatusMsg;
    public static I18n publishPageNoResourcesToUnpublishStatusMsg;
    public static I18n publishPagePublishOkStatusMsg;
    public static I18n publishPagePublishResourcesLabel;
    public static I18n publishPageRecurseCheckBox;
    public static I18n publishPageRecurseCheckBoxToolTip;
    public static I18n publishPageRecurseProcessingErrorMsg;
    public static I18n publishPageRepositoryLabel;
    public static I18n publishPageRepositoryToolTip;
    public static I18n publishPageServerLabel;
    public static I18n publishPageServerToolTip;
    public static I18n publishPageUnpublishOkStatusMsg;
    public static I18n publishPageUnpublishResourcesLabel;
    public static I18n publishPageUnpublishTitle;
    public static I18n publishPageWorkspaceLabel;
    public static I18n publishPageWorkspacePublishToolTip;
    public static I18n publishPageWorkspaceUnpublishToolTip;

    public static I18n publishWizardPublishErrorMsg;
    public static I18n publishWizardPublishTitle;
    public static I18n publishWizardUnpublishTitle;
    public static I18n publishWizardUnpublishErrorMsg;

    public static I18n reconnectJobTaskName;

    public static I18n serverEmptyUrlMsg;
    public static I18n serverEmptyUserMsg;
    public static I18n serverExistsMsg;
    public static I18n serverInvalidUrlMsg;

    public static I18n serverManagerConnectionEstablishedMsg;
    public static I18n serverManagerConnectionFailedMsg;
    public static I18n serverManagerGetRepositoriesExceptionMsg;
    public static I18n serverManagerGetWorkspacesExceptionMsg;
    public static I18n serverManagerRegistryAddUnexpectedError;
    public static I18n serverManagerRegistryListenerError;
    public static I18n serverManagerRegistryListenerErrorsOccurred;
    public static I18n serverManagerRegistryRemoveUnexpectedError;
    public static I18n serverManagerRegistryUpdateAddError;
    public static I18n serverManagerRegistryUpdateRemoveError;
    public static I18n serverManagerUnregisteredServer;

    public static I18n serverPageAuthenticationGroupTitle;
    public static I18n serverPageInvalidServerProperties;
    public static I18n serverPageOkStatusMsg;
    public static I18n serverPagePasswordLabel;
    public static I18n serverPagePasswordToolTip;
    public static I18n serverPageSavePasswordButton;
    public static I18n serverPageSavePasswordLabel;
    public static I18n serverPageSavePasswordToolTip;
    public static I18n serverPageTestConnectionLabel;
    public static I18n serverPageTestConnectionButton;
    public static I18n serverPageTestConnectionButtonToolTip;
    public static I18n serverPageTestConnectionDialogFailureMsg;
    public static I18n serverPageTestConnectionDialogTitle;
    public static I18n serverPageTestConnectionDialogSuccessMsg;
    public static I18n serverPageTitle;
    public static I18n serverPageUrlLabel;
    public static I18n serverPageUrlToolTip;
    public static I18n serverPageUserLabel;
    public static I18n serverPageUserToolTip;

    public static I18n serverReconnectActionText;
    public static I18n serverReconnectActionToolTip;

    public static I18n serverViewToolTip;

    public static I18n serverWizardEditServerErrorMsg;
    public static I18n serverWizardEditServerTitle;
    public static I18n serverWizardNewServerErrorMsg;
    public static I18n serverWizardNewServerTitle;

    public static I18n showPublishedLocationsErrorMsg;

    public static I18n testServerActionText;
    public static I18n testServerActionToolTip;

    static {
        try {
            I18n.initialize(RestClientI18n.class);
        } catch (Exception e) {
            System.err.println(e);
        }
    }

}
