/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.federation;

import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.spi.graph.connection.RepositoryConnection;
import org.jboss.dna.spi.graph.connection.RepositoryConnectionFactory;
import org.jboss.dna.spi.graph.connection.RepositoryConnectionPool;
import org.jboss.dna.spi.graph.connection.RepositorySource;
import org.jboss.dna.spi.graph.connection.RepositorySourceException;

@ThreadSafe
public class FederatedSource
implements RepositoryConnectionFactory {
    private final RepositorySource source;
    private final RepositoryConnectionPool connectionPool;

    public FederatedSource(RepositorySource source) {
        ArgCheck.isNotNull((Object)source, (String)"source");
        this.source = source;
        this.connectionPool = new RepositoryConnectionPool((RepositoryConnectionFactory)source);
    }

    protected FederatedSource(RepositorySource source, RepositoryConnectionPool connectionPool) {
        ArgCheck.isNotNull((Object)source, (String)"source");
        this.source = source;
        this.connectionPool = connectionPool;
    }

    public String getName() {
        return this.source.getName();
    }

    public RepositorySource getRepositorySource() {
        return this.source;
    }

    protected RepositoryConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public RepositoryConnection getConnection() throws RepositorySourceException, InterruptedException {
        return this.connectionPool.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(long timeToWait, TimeUnit unit) {
        RepositoryConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            boolean bl = connection.ping(timeToWait, unit);
            return bl;
        }
        catch (IllegalStateException e) {
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
    }

    public int hashCode() {
        return this.source.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FederatedSource) {
            FederatedSource that = (FederatedSource)obj;
            return this.source.getName().equals(that.source.getName());
        }
        return false;
    }
}

