/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.federation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.federation.FederatedRepository;
import org.jboss.dna.repository.federation.FederatedRepositoryConnection;
import org.jboss.dna.repository.federation.FederationService;
import org.jboss.dna.spi.graph.connection.RepositoryConnection;
import org.jboss.dna.spi.graph.connection.RepositorySource;
import org.jboss.dna.spi.graph.connection.RepositorySourceException;

@ThreadSafe
public class FederatedRepositorySource
implements RepositorySource {
    private static final long serialVersionUID = 7587346948013486977L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    protected static final String USERNAME = "username";
    protected static final String CREDENTIALS = "credentials";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String REPOSITORY_NAME = "repositoryName";
    protected static final String RETRY_LIMIT = "retryLimit";
    protected static final String FEDERATION_SERVICE_JNDI_NAME = "fedServiceJndiName";
    private String repositoryName;
    private FederationService federationService;
    private String sourceName;
    private int retryLimit = 0;
    private String username;
    private String credentials;

    public FederatedRepositorySource() {
    }

    public FederatedRepositorySource(FederationService federationService, String repositoryName) {
        ArgCheck.isNotNull((Object)federationService, (String)"federationService");
        ArgCheck.isNotNull((Object)repositoryName, (String)REPOSITORY_NAME);
        this.federationService = federationService;
        this.repositoryName = repositoryName;
    }

    public FederationService getFederationService() {
        return this.federationService;
    }

    public void setFederationService(FederationService federationService) {
        ArgCheck.isNotNull((Object)federationService, (String)"federatedService");
        this.federationService = federationService;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int limit) {
        this.retryLimit = limit > 0 ? limit : 0;
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        FederatedRepository repository = this.federationService.getRepository(this.repositoryName);
        if (repository == null) {
            throw new RepositorySourceException(RepositoryI18n.unableToCreateConnectionToFederatedRepository.text(new Object[]{this.repositoryName}));
        }
        String username = this.username;
        String credentials = this.credentials;
        if (!repository.authenticate(username, credentials)) {
            throw new RepositorySourceException(RepositoryI18n.unableToAuthenticateConnectionToFederatedRepository.text(new Object[]{this.repositoryName, username}));
        }
        return new FederatedRepositoryConnection(repository, this);
    }

    public String getName() {
        return this.sourceName;
    }

    public void setName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        ArgCheck.isNotEmpty((String)repositoryName, (String)REPOSITORY_NAME);
        this.repositoryName = repositoryName;
    }

    public Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = NamingContextObjectFactory.class.getName();
        Reference ref = new Reference(className, factoryClassName, null);
        ref.add(new StringRefAddr(USERNAME, this.getUsername()));
        ref.add(new StringRefAddr(CREDENTIALS, this.getCredentials()));
        ref.add(new StringRefAddr(SOURCE_NAME, this.sourceName));
        ref.add(new StringRefAddr(REPOSITORY_NAME, this.repositoryName));
        ref.add(new StringRefAddr(FEDERATION_SERVICE_JNDI_NAME, this.federationService.getJndiName()));
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    public int hashCode() {
        return this.repositoryName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FederatedRepositorySource) {
            FederatedRepositorySource that = (FederatedRepositorySource)obj;
            if (!this.getRepositoryName().equals(that.getRepositoryName())) {
                return false;
            }
            if (!this.getFederationService().equals(that.getFederationService())) {
                return false;
            }
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamingContextObjectFactory
    implements ObjectFactory {
        @Override
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
            if (obj instanceof Reference) {
                HashMap<String, String> values = new HashMap<String, String>();
                Reference ref = (Reference)obj;
                Enumeration<RefAddr> en = ref.getAll();
                while (en.hasMoreElements()) {
                    RefAddr subref = en.nextElement();
                    String key = subref.getType();
                    Object value = subref.getContent();
                    values.put(key, (String)value);
                }
                String repositoryName = (String)values.get(FederatedRepositorySource.REPOSITORY_NAME);
                String username = (String)values.get(FederatedRepositorySource.USERNAME);
                String credentials = (String)values.get(FederatedRepositorySource.CREDENTIALS);
                String retryLimit = (String)values.get(FederatedRepositorySource.RETRY_LIMIT);
                String sourceName = (String)values.get(FederatedRepositorySource.SOURCE_NAME);
                String federationSourceJndiName = (String)values.get(FederatedRepositorySource.FEDERATION_SERVICE_JNDI_NAME);
                FederationService federationService = (FederationService)nameCtx.lookup(federationSourceJndiName);
                FederatedRepositorySource source = new FederatedRepositorySource(federationService, repositoryName);
                if (retryLimit != null) {
                    source.setRetryLimit(Integer.parseInt(retryLimit));
                }
                if (sourceName != null) {
                    source.setName(sourceName);
                }
                if (username != null) {
                    source.setUsername(username);
                }
                if (credentials != null) {
                    source.setCredentials(credentials);
                }
                return source;
            }
            return null;
        }
    }
}

