CREATE FOREIGN TABLE "accounts.ACCOUNT" (
        ACCOUNT_ID long NOT NULL DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '`ACCOUNT_ID`', NATIVE_TYPE 'INT'),
        SSN string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`SSN`', NATIVE_TYPE 'CHAR'),
        STATUS string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`STATUS`', NATIVE_TYPE 'CHAR'),
        TYPE string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`TYPE`', NATIVE_TYPE 'CHAR'),
        DATEOPENED timestamp NOT NULL DEFAULT 'CURRENT_TIMESTAMP' OPTIONS (ANNOTATION '', NAMEINSOURCE '`DATEOPENED`', NATIVE_TYPE 'TIMESTAMP'),
        DATECLOSED timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' OPTIONS (ANNOTATION '', NAMEINSOURCE '`DATECLOSED`', NATIVE_TYPE 'TIMESTAMP')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '`accounts`.`ACCOUNT`', UPDATABLE TRUE);

CREATE FOREIGN TABLE "accounts.CUSTOMER" (
        SSN string(10) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '`SSN`', NATIVE_TYPE 'CHAR'),
        FIRSTNAME string(64) OPTIONS (ANNOTATION '', NAMEINSOURCE '`FIRSTNAME`', NATIVE_TYPE 'VARCHAR'),
        LASTNAME string(64) OPTIONS (ANNOTATION '', NAMEINSOURCE '`LASTNAME`', NATIVE_TYPE 'VARCHAR'),
        ST_ADDRESS string(256) OPTIONS (ANNOTATION '', NAMEINSOURCE '`ST_ADDRESS`', NATIVE_TYPE 'VARCHAR'),
        APT_NUMBER string(32) OPTIONS (ANNOTATION '', NAMEINSOURCE '`APT_NUMBER`', NATIVE_TYPE 'VARCHAR'),
        CITY string(64) OPTIONS (ANNOTATION '', NAMEINSOURCE '`CITY`', NATIVE_TYPE 'VARCHAR'),
        STATE string(32) OPTIONS (ANNOTATION '', NAMEINSOURCE '`STATE`', NATIVE_TYPE 'VARCHAR'),
        ZIPCODE string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`ZIPCODE`', NATIVE_TYPE 'VARCHAR'),
        PHONE string(15) OPTIONS (ANNOTATION '', NAMEINSOURCE '`PHONE`', NATIVE_TYPE 'VARCHAR')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '`accounts`.`CUSTOMER`', UPDATABLE TRUE);

CREATE FOREIGN TABLE "accounts.HOLDINGS" (
        TRANSACTION_ID long NOT NULL AUTO_INCREMENT OPTIONS (ANNOTATION '', NAMEINSOURCE '`TRANSACTION_ID`', NATIVE_TYPE 'INT'),
        ACCOUNT_ID long OPTIONS (ANNOTATION '', NAMEINSOURCE '`ACCOUNT_ID`', NATIVE_TYPE 'INT'),
        PRODUCT_ID long OPTIONS (ANNOTATION '', NAMEINSOURCE '`PRODUCT_ID`', NATIVE_TYPE 'INT'),
        PURCHASE_DATE timestamp NOT NULL DEFAULT 'CURRENT_TIMESTAMP' OPTIONS (ANNOTATION '', NAMEINSOURCE '`PURCHASE_DATE`', NATIVE_TYPE 'TIMESTAMP'),
        SHARES_COUNT long OPTIONS (ANNOTATION '', NAMEINSOURCE '`SHARES_COUNT`', NATIVE_TYPE 'INT')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '`accounts`.`HOLDINGS`', UPDATABLE TRUE);

CREATE FOREIGN TABLE "accounts.PRODUCT" (
        ID long NOT NULL DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '`ID`', NATIVE_TYPE 'INT'),
        SYMBOL string(16) OPTIONS (ANNOTATION '', NAMEINSOURCE '`SYMBOL`', NATIVE_TYPE 'VARCHAR'),
        COMPANY_NAME string(256) OPTIONS (ANNOTATION '', NAMEINSOURCE '`COMPANY_NAME`', NATIVE_TYPE 'VARCHAR')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '`accounts`.`PRODUCT`', UPDATABLE TRUE);

CREATE FOREIGN TABLE "accounts.SUBSCRIPTIONS" (
        "value" string(15) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '`value`', NATIVE_TYPE 'CHAR'),
        type string(45) NOT NULL DEFAULT '' OPTIONS (ANNOTATION '', NAMEINSOURCE '`type`', NATIVE_TYPE 'CHAR'),
        end_date date NOT NULL DEFAULT '2012-12-31' OPTIONS (ANNOTATION '', NAMEINSOURCE '`end_date`', NATIVE_TYPE 'DATE')
) OPTIONS (ANNOTATION '', NAMEINSOURCE '`accounts`.`SUBSCRIPTIONS`', UPDATABLE TRUE);