/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */
package org.komodo.relational.commands.vdb;

import org.komodo.utils.i18n.I18n;

/**
 * Localized messages for the {@link org.komodo.relational.commands.vdb}.
 */
@SuppressWarnings( "javadoc" )
public final class VdbCommandsI18n extends I18n {

    public static String addDataRoleExamples;
    public static String addDataRoleHelp;
    public static String addDataRoleUsage;

    public static String addEntryExamples;
    public static String addEntryHelp;
    public static String addEntryUsage;

    public static String addImportExamples;
    public static String addImportHelp;
    public static String addImportUsage;

    public static String addModelExamples;
    public static String addModelHelp;
    public static String addModelUsage;

    public static String addTranslatorExamples;
    public static String addTranslatorHelp;
    public static String addTranslatorUsage;

    public static String deleteDataRoleExamples;
    public static String deleteDataRoleHelp;
    public static String deleteDataRoleUsage;

    public static String deleteEntryExamples;
    public static String deleteEntryHelp;
    public static String deleteEntryUsage;

    public static String deleteImportExamples;
    public static String deleteImportHelp;
    public static String deleteImportUsage;

    public static String deleteModelExamples;
    public static String deleteModelHelp;
    public static String deleteModelUsage;

    public static String deleteTranslatorExamples;
    public static String deleteTranslatorHelp;
    public static String deleteTranslatorUsage;

    public static String setVdbPropertyExamples;
    public static String setVdbPropertyHelp;
    public static String setVdbPropertyUsage;

    public static String showDataRolesExamples;
    public static String showDataRolesHelp;
    public static String showDataRolesUsage;

    public static String showEntriesExamples;
    public static String showEntriesHelp;
    public static String showEntriesUsage;

    public static String showImportsExamples;
    public static String showImportsHelp;
    public static String showImportsUsage;

    public static String showModelsExamples;
    public static String showModelsHelp;
    public static String showModelsUsage;

    public static String showTranslatorsExamples;
    public static String showTranslatorsHelp;
    public static String showTranslatorsUsage;

    public static String showVdbExamples;
    public static String showVdbHelp;
    public static String showVdbUsage;

    public static String unsetVdbPropertyExamples;
    public static String unsetVdbPropertyHelp;
    public static String unsetVdbPropertyUsage;

    public static String uploadModelExamples;
    public static String uploadModelHelp;
    public static String uploadModelUsage;

    public static String validateVdbExamples;
    public static String validateVdbHelp;
    public static String validateVdbUsage;

    public static String dataRoleAdded;
    public static String dataRoleDeleted;
    public static String dataRolesHeader;
    public static String entriesHeader;
    public static String entryAdded;
    public static String entryDeleted;
    public static String importAdded;
    public static String importDeleted;
    public static String importsHeader;
    public static String invalidOverwriteArg;
    public static String matchingDataRolesHeader;
    public static String matchingEntriesHeader;
    public static String matchingImportsHeader;
    public static String matchingModelsHeader;
    public static String matchingTranslatorsHeader;
    public static String missingDataRoleName;
    public static String missingEntryName;
    public static String missingEntryPath;
    public static String missingImportName;
    public static String missingInputModelFilePath;
    public static String missingModelName;
    public static String missingModelNameForUpload;
    public static String missingModelType;
    public static String missingTranslatorName;
    public static String missingTranslatorType;
    public static String modelAdded;
    public static String modelDeleted;
    public static String modelInputFileIsEmpty;
    public static String modelOverwriteDisabled;
    public static String modelTypeError;
    public static String modelUploaded;
    public static String modelsHeader;
    public static String noDataRoles;
    public static String noEntries;
    public static String noImports;
    public static String noMatchingDataRoles;
    public static String noMatchingEntries;
    public static String noMatchingImports;
    public static String noMatchingModels;
    public static String noMatchingTranslators;
    public static String noModels;
    public static String noTranslators;
    public static String translatorAdded;
    public static String translatorDeleted;
    public static String translatorsHeader;
    public static String validationError;
    public static String validationSuccess;
    public static String vdbExported;
    public static String vdbValidationErrorsHeader;
    public static String vdbValidationSuccessMsg;
    public static String vdbValidationWarningsHeader;

    static {
        final VdbCommandsI18n i18n = new VdbCommandsI18n();
        i18n.initialize();
    }

    /**
     * Don't allow construction outside of this class.
     */
    private VdbCommandsI18n() {
        // nothing to do
    }

}
