import org.jsoup.select.Elements;
import org.junit.*;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by jianpli on 6/13/17.
 */
public class LicenseHtmlRemoteTest
{
    private static HtmlPaser htmlPaser;
    private static boolean isFailed;
    private static volatile int problemsCount = 0;

    @BeforeClass
    public static void setup()
    {
        System.out.println("**************************************** start to test remote license ****************************************");
        htmlPaser = new HtmlPaser("target/download-licenses/licenses.html");
    }


    private static boolean verifyRemoteUrl(String remoteUrl, String group, String artifact, String version)
    {
        boolean flag = true;

        try
        {
            URL remoteLicenseUrl = new URL(remoteUrl);
            try
            {
                HttpURLConnection licenseCon = (HttpURLConnection) remoteLicenseUrl.openConnection();
                licenseCon.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");

                int respCode = licenseCon.getResponseCode();
                if (respCode > 399)
                {
                    System.out.println("URI debug ---> " + group + ":" + artifact + ":" + version + " ---> remote license ---> \"" + remoteUrl + "\" can't be reached!");
                    flag = false;
                    isFailed = true;
                }
            } catch (IOException e)
            {
                e.printStackTrace();
            }
        } catch (MalformedURLException e)
        {
            System.out.println("URI debug ---> " + group + ":" + artifact + ":" + version + " ---> remote license ---> \"" + remoteUrl + "\" can't be reached!");
            flag = false;
            isFailed = true;
//                e.printStackTrace();
        }

        if (!flag)
        {
            problemsCount += 1;
        }

        return flag;
    }

    @Test
    public void remoteUriTest()
    {
        if (htmlPaser.licensesFromTable.size() < 2)
        {
            return;
        }

        ExecutorService threadPool = Executors.newFixedThreadPool(10);


        for (int row = 1; row < htmlPaser.licensesFromTable.size(); row++)
        {
            try
            {
                Thread.sleep(30);
            } catch (InterruptedException e)
            {
                e.printStackTrace();
            }

            Elements oneLicense = htmlPaser.licensesFromTable.get(row).select("td");
            final String group = oneLicense.get(0).text();
            final String artifact = oneLicense.get(1).text();
            final String version = oneLicense.get(2).text();
            final String remoteLicenseUri = oneLicense.get(3).select("a").attr("href");

            threadPool.execute(new Runnable()
            {
                public void run()
                {
                    boolean remoteFlag = verifyRemoteUrl(remoteLicenseUri, group, artifact, version);
                }
            });
        }


        try
        {
            Thread.sleep(3000);
            System.out.println("into ---> analysing ...");
            Thread.sleep(9000);
        } catch (InterruptedException e)
        {
            e.printStackTrace();
        }
        Assert.assertFalse(isFailed);
    }

    @AfterClass
    public static void afterTest()
    {
        System.out.println("---------------------------------------------");
        System.out.println("count of problems: " + problemsCount);
        System.out.println("---------------------------------------------");
        System.out.println("***************************************** End of test remote license *****************************************");
    }
}
