import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.junit.Assert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * Created by jianpli on 7/6/17.
 */
public class HtmlPaser
{
    File licensesHtmlFile;
    Elements licensesFromTable;
    int jarsCount;

    public HtmlPaser(String htmlPath)
    {
        licensesHtmlFile = new File(htmlPath);
        Document licensesHtml = null;
        try
        {
            licensesHtml = Jsoup.parse(licensesHtmlFile, "UTF-8");
        } catch (IOException e)
        {
            System.out.println("error ---> fail to find licenses.html");
            e.printStackTrace();
        }
        licensesFromTable = licensesHtml.select("table").select("tr");

        Properties infoProp = new Properties();
        try
        {
            infoProp.load(new FileInputStream(new File("target/record/info_for_junit")));
            jarsCount = Integer.parseInt(infoProp.getProperty("jarsCount"));
        } catch (IOException e)
        {
            Assert.assertFalse(true);
            System.out.println("error ---> fail to find properties file info_for_junit");
            e.printStackTrace();
        }
    }
}
