<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" encoding="UTF-8" indent="yes" standalone="no" />
  <xsl:strip-space elements="*" />
  <xsl:key name="gav" match="dependency" use="concat(groupId,':',artifactId,':',version)"/>

  <xsl:template match="@* | node()">
    <xsl:copy>
      <xsl:apply-templates select="@* | node()"/>
    </xsl:copy>
  </xsl:template>
  <!-- <xsl:template match="dependency[not(generate-id() = generate-id(key('gav', concat(groupId,':',artifactId,':',version))[1]))]" /> -->
  <xsl:template match="dependencies">
    <xsl:copy>
      <xsl:apply-templates select="dependency[generate-id() = generate-id(key('gav', concat(groupId,':',artifactId,':',version))[1])]">
        <xsl:sort select="groupId" />
        <xsl:sort select="artifactId" />
        <xsl:sort select="version" />
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="dependency/version"></xsl:template>
  <xsl:template match="dependency[artifactId='jsr173_api']//licenses">
   <xsl:copy>
    <xsl:copy-of select="@*" />
        <license>
          <name>CDDL 1.1</name>
          <url>https://glassfish.java.net/public/CDDL+GPL_1_1.html</url>
          <distribution>repo</distribution>
        </license>
        <license>
          <name>GPL2 w/ CPE</name>
          <url>https://glassfish.java.net/public/CDDL+GPL_1_1.html</url>
          <distribution>repo</distribution>
        </license>
   </xsl:copy>
  </xsl:template>
  <xsl:template match="dependency[artifactId='org.osgi.enterprise']//licenses">
   <xsl:copy>
    <xsl:copy-of select="@*" />
        <license>
          <name>Apache License, Version 2.0</name>
          <url>http://opensource.org/licenses/apache2.0.php</url>
          <distribution>repo</distribution>
        </license>
   </xsl:copy>
  </xsl:template>
  <xsl:template match="dependency[artifactId='activation']//licenses | dependency[artifactId='servlet-api']//licenses">
   <xsl:copy>
    <xsl:copy-of select="@*" />
        <license>
          <name>CDDL + GPLv2 with classpath exception</name>
          <url>https://glassfish.dev.java.net/nonav/public/CDDL+GPL.html</url>
          <distribution>repo</distribution>
          <comments>A business-friendly OSS license</comments>
        </license>
   </xsl:copy>
  </xsl:template>
<!--  <xsl:template match="license[url='http://repository.jboss.org/licenses/apache-2.0.txt']/name/text()">Apache License, Version 2.0</xsl:template>
  <xsl:template match="license[url='https://www.apache.org/licenses/LICENSE-2.0.txt']/name/text()">Apache License, Version 2.0</xsl:template>
  <xsl:template match="license[url='http://www.apache.org/licenses/LICENSE-2.0']/name/text()">Apache License, Version 2.0</xsl:template>
  <xsl:template match="license[url='http://www.apache.org/licenses/LICENSE-2.0.html']/name/text()">Apache License 2.0</xsl:template>
  <xsl:template match="license[url='http://www.apache.org/licenses/LICENSE-2.0.txt']/name/text()">Apache License, Version 2.0</xsl:template>
  <xsl:template match="license[url='http://www.opensource.org/licenses/mit-license.php']/name/text()">MIT license</xsl:template>-->
</xsl:stylesheet>
