
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:jb="urn:jboss:domain:1.4"
	exclude-result-prefixes="xs xsl xsi fn xdt jb cache-container">
	<xsl:output method="xml" version="1.0" encoding="UTF-8"
		indent="yes" />

	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="node()[name(.)='dependency']">
		<xsl:choose>
			<xsl:when test="groupId='aopalliance'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Public Domain, per Creative Commons CC0</name>
							<url>https://creativecommons.org/publicdomain/zero/1.0/legalcode</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='avalon-framework'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>https://svn.apache.org/repos/asf/avalon/site/framework/license.html</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='batik'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>https://xmlgraphics.apache.org/batik/license.html</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='commons-configuration'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>http://www.apache.org/licenses/LICENSE-2.0.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='commons-logging'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>http://www.apache.org/licenses/LICENSE-2.0.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>		
			<xsl:when test="groupId='commons-vfs'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>http://www.apache.org/licenses/LICENSE-2.0.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>				
			<xsl:when test="groupId='com.force.api'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Free BSD License</name>
							<url>https://www.freebsd.org/copyright/freebsd-license.html</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>				
			<xsl:when test="groupId='com.twitter'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Public Domain, per Creative Commons CC0</name>
							<url>https://creativecommons.org/publicdomain/zero/1.0/legalcode</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='com.google.jsinterop'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>http://www.apache.org/licenses/LICENSE-2.0.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='com.github.virtuald'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>CDDL+GPL License</name>
							<url>https://javaee.github.io/glassfish/LICENSE</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='com.sun.xml.bind' and artifactId='jaxb-impl'">
					<xsl:copy>
						<xsl:apply-templates select="@*|*[not(self::licenses)]" />
						<licenses>
							<license>
								<name>CDDL+GPL License</name>
								<url>https://javaee.github.io/glassfish/LICENSE</url>
								<distribution>repo</distribution>
							</license>
						</licenses>
					</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='com.sun.xml.bind' and artifactId='jaxb-core'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>CDDL+GPL License</name>
							<url>https://javaee.github.io/glassfish/LICENSE</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='com.sun.xml.bind'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>BSD License</name>
							<url>https://opensource.org/licenses/BSD-3-Clause</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			
			<xsl:when test="groupId='dom4j'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>BSD 2.0 +</name>
							<url>https://raw.githubusercontent.com/dom4j/dom4j/dom4j_1_6_1/LICENSE.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='jakarta-regexp'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>http://www.apache.org/licenses/LICENSE-2.0.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>			
			<xsl:when test="groupId='javax.interceptor' and artifactId='javax.interceptor-api'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>CDDL + GPLv2 with classpath exception</name>
							<url>https://javaee.github.io/glassfish/LICENSE</url>
							<distribution>repo</distribution>
							<comments>A business-friendly OSS license</comments>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='javax.activation' and artifactId='activation'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0</name>
							<url>https://javaee.github.io/glassfish/LICENSE</url>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='javax.jcr'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Adobe Day JCR License</name>
							<url>https://docs.adobe.com/content/docs/en/spec/jcr/2.0/license.html</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>				
			<xsl:when test="groupId='javax.mail' and artifactId='mail'">
					<xsl:copy>
						<xsl:apply-templates select="@*|*[not(self::licenses)]" />
						<licenses>
							<license>
								<name>CDDL</name>
								<url>https://opensource.org/licenses/cddl1.php</url>
								<distribution>repo</distribution>
								<comments>A business-friendly OSS license</comments>
							</license>
							<license>
								<name>GPLv2+CE</name>
								<url>https://javaee.github.io/glassfish/LICENSE</url>
								<distribution>repo</distribution>
								<comments>GPL version 2 plus the Classpath Exception</comments>
							</license>
						</licenses>
					</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='javax.measure' and artifactId='jsr-275'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>JScience BSD License</name>
							<url>http://jscience.org/doc/license.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>						
			<xsl:when test="groupId='javax.validation'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>http://www.apache.org/licenses/LICENSE-2.0.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>

			<xsl:when test="groupId='javax.xml.stream' and artifactId='stax-api'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>GNU General Public Library</name>
							<url>http://www.gnu.org/licenses/gpl.txt</url>
							<distribution>repo</distribution>
						</license>
						<license>
							<name>COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0</name>
							<url>https://opensource.org/licenses/cddl1.php</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<!-- stax-api was changed to java.xml.stream -->
			<xsl:when test="groupId='stax' and artifactId='stax-api'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>GNU General Public Library</name>
							<url>http://www.gnu.org/licenses/gpl.txt</url>
							<distribution>repo</distribution>
							<comments>stax group has been changed to javax.xml.stream and its related licenses</comments>
						</license>
						<license>
							<name>COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0</name>
							<url>https://opensource.org/licenses/cddl1.php</url>
							<distribution>repo</distribution>
							<comments>stax group has been changed to javax.xml.stream and its related licenses</comments>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>			
			<!-- Can't find jsr94 source -->
			<xsl:when test="groupId='jsr94'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Under BEA System</name>
                            <url>http://download.oracle.com/otndocs/jcp/jreng-1_0a-fr-spec-api-oth-JSpec/</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='org.apache.zookeeper'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>http://www.apache.org/licenses/LICENSE-2.0.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='org.apache.httpcomponents'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>http://www.apache.org/licenses/LICENSE-2.0.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>				
			<xsl:when test="groupId='org.eclipse'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Eclipse Public License - v 1.0</name>
							<url>http://www.eclipse.org/legal/epl-v10.html</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='org.eclipse.jgit'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Eclipse Public License - v 1.0</name>
							<url>http://www.eclipse.org/legal/epl-v10.html</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='org.hdrhistogram'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Public Domain, per Creative Commons CC0</name>
							<url>https://creativecommons.org/publicdomain/zero/1.0/legalcode</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='org.jdom'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
                            <name>Similar to Apache License but with the acknowledgment clause removed</name>
                            <url>https://raw.github.com/hunterhacker/jdom/master/LICENSE.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='org.jboss.spec.javax.annotation' and artifactId='jboss-annotations-api_1.2_spec'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>CDDL or GPLv2 with exceptions</name>
							<url>https://javaee.github.io/glassfish/LICENSE</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='org.jboss.spec.javax.xml.bind'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>CDDL or GPLv2 with exceptions</name>
							<url>https://javaee.github.io/glassfish/LICENSE</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='org.yaml'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Apache License, Version 2.0</name>
							<url>http://www.apache.org/licenses/LICENSE-2.0.txt</url>
							<distribution>repo</distribution>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="groupId='xpp3'">
				<xsl:copy>
					<xsl:apply-templates select="@*|*[not(self::licenses)]" />
					<licenses>
						<license>
							<name>Indiana University Extreme! Lab Software License, vesion 1.1.1</name>
                            <url>https://raw.githubusercontent.com/aslom/xpp3/master/LICENSE.txt</url>
							<distribution>repo</distribution>
							<comments>The license applies to the Xpp3 classes (all classes below the org.xmlpull package with exception of classes directly in package org.xmlpull.v1 )</comments>
						</license>
						<license>
							<name>Public Domain, per Creative Commons CC0</name>
                            <url>https://creativecommons.org/publicdomain/zero/1.0/legalcode</url>
                            <distribution>repo</distribution>
							<comments>The license applies to the XmlPull API (all classes directly in the org.xmlpull.v1 package)</comments>
						</license>
					</licenses>
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*|node()" />
				</xsl:copy>
			</xsl:otherwise>

		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>

