SET NAMESPACE 'http://www.teiid.org/translator/salesforce/2012' AS teiid_sf;

CREATE FOREIGN TABLE Account (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	MasterRecordId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Name string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Enterprise Existing,Enterprise New,Federal,OEM Partner,SLED,SMB,Partner - Distributor,Partner - ISV,Partner - OEM,Partner - Other,Partner - Systems Integrator,Partner - Technology,Partner - Training,Partner - Value Added Reseller,Sales - Customer,Sales - Hosting,Sales - Key Account,Sales - Other,Sales - Prospect,Sales - SMB,Sales - Strategic'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingStreet string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingCity string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingState string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingPostalCode string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingCountry string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ShippingStreet string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ShippingCity string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ShippingState string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ShippingPostalCode string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ShippingCountry string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Phone string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Fax string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccountNumber string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Website string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Sic string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Industry string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Aerospace,Construction,Consulting,Education,Financial Services,Government,Government-Military,Healthcare,Information Technology,Insurance,Life Sciences,Manufacturing,Media and Entertainment,Non Profit Organization,Oil and Gas,Other,Product Distributor,Retail,Services,State/County/Local Government,Tech Online,Telecom,Transportation,Utilities'),
	AnnualRevenue double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfEmployees integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Ownership string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Joint Venture,Private,Public,Subsidiary'),
	TickerSymbol string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Rating string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Hot,Warm,Cold'),
	Site string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsPartner boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsCustomerPortal boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OracleAccountNumber__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RHNLogin__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	D_U_N_S__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NamedAccount__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'BeNeLux,CEE,Channel,DISTI,Enterprise-Existing,Enterprise-New,Federal,GLS,Key - East,Key - West,LATAM,Nordics,North Asia Pacific,OEM,Runtime,SEMEA,SLED,SMB,South Asia Pacific,Strategic,UK,WEB'),
	DateOfLastCreditCheck__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CreditLimit__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PaymentTerms__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Prepay,Net 30,Net 45,Net 60,IMMEDIATE,EOM +1,EOM +2,10 NET,15 NET,45 NET,50 NET,60 NET,EOM +60,EOM Next Month,90 NET,75 NET,EOM+30,EOM+40,EOM+45,CONSOLIDATE,EOM+60,EOM+120,EOM+90,Prepayment Reqd,CO10th+40,CO15th+60,CO20th+45,CO25th+40,CONSOLIDATE TERM'),
	VATNumber__c string(15) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Time_and_Date_Approved__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ASIDST__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ASIDBT__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OracleAccountID__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	EstAnnualRevForWWOrg__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '$1-$100M,$101 Million or more,Unknown,1-50M,51-100M,101-150M,151-250M,251-300M,301-500M,501-750M,751-1B>'),
	NumberOfEmployeesInWWOrg__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Unknown,Less than 500,501-1000,More than 1001,1-10,11-25,26-50,51-100,101-500'),
	NumberOfServerClassSystemsInWWOrg__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1-50,51 or more,Unknown'),
	Credit_Approved_by__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Jacqui Fleury,Pam Waltrous,Sheree Alhmer'),
	OtherHWVendor__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AccountClassification__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Commercial,Duplicate Account - Delete,EMEA - Hosting,Enterprise,ETR,GLOBAL,Hosting/T2 OEM,Hybrid,Incremental,Internal Use Account,INTRA GEO GLOBAL,KEY,Mid-Market,Named,New,Partner - Advanced Partner,Partner - Certified Services Partner,Partner - Distributor,Partner - ISV,Partner - OEM,Partner - Other,Partner - Premier,Partner - Premier Partner,Partner - Premier System Integrator,Partner - Ready Partner,Partner - Sub-Distributor,Partner - Systems Integrator,Partner - Technology,Partner - Training,Partner - Unaffiliated,Partner - Value Added Reseller,Prospect,PSR,Sales - Canadian Federal Government,Sales - Commercial,Sales - Commercial New,Sales - EDU,Sales - Enterprise,Sales - Enterprise Named,Sales - Enterprise Territory,Sales - Focus,Sales - Global,Sales - Government,Sales - Hosting,Sales - Key,Sales - SMB,Sales - State and Local,Sales - Strategic,Sales - Territory,Sales - Unallocated,Sales – Unallocated,Sales - US Federal Government,SMB,STRATEGIC,TERRITORY,TERRITORY - ASSIGN,UNALLOCATED,Vertical - FSI,Vertical - Healthcare,Verticals,Vertical - Telco'),
	AccountRating__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Target,Develop,Nurture,Top 25,Mid 25,Bottom 50'),
	OraclePartyID__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OraclePartyNumber__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Description_of_Business__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Primary_Hardware_Vendor__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'IBM,HP,Dell,Other'),
	Cluster_File_Systems__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'GFS,IBM GPFS,Lustre,OCFS1,OCFS2,Polyserve,Veritas VxFS,XFS'),
	ERP_Systems__c string(25) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Directory_Server__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Active Directory,Netscape Directory Server,Novell Directory Services (NDS),Oracle Internet Directory (OID),SunOne Directory Server,Tivoli Directory Server'),
	File_Systems__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ext3,JFS,ReiserFS,XFS'),
	OS_Environment__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AIX,FreeBSD,HP-UX,Linux (Other),Linux (RHEL Clone),Linux (SuSE),Other,RHEL,Solaris,UNIX,Windows,z/OS'),
	Primary_HW_Vendor_Other__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Software_Management__c string(25) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Database__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'DB2,Informix,MySQL,Oracle,Oracle RAC,PostgreSQL,SQL,Sybase'),
	Monitoring__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'BMC Patrol,HP Openview,Legato,Nagios,Novell Zenworks,Opsware,RHN,Tivoli'),
	Infrastructure_Details__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Business_Pains__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Business_Pains_2__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Purchasing_Process__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Hardware_Environment__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Itanium,POWER/OpenPower,x86,x86-64(AMD),x86-64(Intel),zSeries'),
	RH_Sales_Strategy__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Red_Hat_Agreements_on_File__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Click-Through/Subscription Order Form,Cygwin License,Distribution,Engineering Services,Evaluation,Framework /Master Service,Framework /MSA - SOW/Work Order,Hardware Partner - OEM Advanced,Hardware Partner - OEM Ready,Hardware Partner - Runtime Advanced,Hardware Partner - Runtime Ready,Hosting Provider Program,ISV Partner,Learning Services,None on File,OEM Partner,Professional Services,Professional Services  - SOW,Red Hat Academy Services,Reseller/Business Partner,RSS,Subscription,Subscription Agreement with RSS Addendum,Toolchain/GNUPro Services Support,Training Partner'),
	Key_Obstacles__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	SIC_Code__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	What_are_you_using_RedHat_Others_for__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'File/Print,DNS,Web Servers,Email/Messaging Servers,Database,Storage Environment,Clustering'),
	Budget_Cycle__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'January,February,March,April,May,June,July,August,September,October,November,December'),
	Back_up_Recovery__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Arkeia,Legato Networker,Tivoli Storage Manager,Veritas Netbackup'),
	PreferredHWVendor__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Dell,Don’t Have One,Fujitsu,Gateway,HP,IBM,Other,Sun,Toshiba,Unknown'),
	Storage__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'JBOD,NAS,SAN'),
	Workloads_Deployed_on_Linux__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CreditPreApproved__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Application_Server__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'JBoss,Oracle Application Server,Resin,SunOne,TomCat,Weblogic,Websphere'),
	Customer_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not a Customer,Red Hat,JBoss,Red Hat and JBoss'),
	Renewal_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Renewal_Amount__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Named_Account__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	PrimaryBillToAcct__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Territorydonotuse__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'California,Canada,Central,East,Great Lakes,Mid-Atlantic,New England,Northeast,Northwest,NY/NJ,Pacific Northwest,South,Southeast,Southwest,West'),
	PrimaryIndustry__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PrimaryStorageVendor__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'NetApp,EMC,StorageTek,Dell,IBM,Sun,HP,Other'),
	Linux_Servers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UNIX_Servers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Microsoft_Servers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Servers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PrimaryBillingAccountNumber__c string(8) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	firs_profileid__c string(6) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	firs_Industry_Profile_Name__c string(100) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	firs_Opp_Rating_Image__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	firs_Profile_Link__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	firs_Opp_Rating__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	firs_Rating_Desc__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Executive_Sponsor__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Fiscal_Year_End__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	isAccountActive__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	isOnCreditHold__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	AccountOracleStatus__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Toll_Free_Number__c string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_mkt_touched__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Location_Type__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Products_Services__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Business_Structure__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Ultimate_Parent_D_U_N_S__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Ultimate_Parent_Account__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Immediate_Parent_D_U_N_S__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Immediate_Parent_Account__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Subsidiary_Status__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_of_Subsidiaries_if_Parent__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Recent_Major_Events__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_mkt_sourced__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Significant_Branch_Locations__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Vertical__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Education,Energy,Financial Services,Government,Healthcare,Media and Tech,Public Sector,Retail,Telcom,Transportation'),
	All_NAICS_Codes__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Primary_Billing_Account_Name__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Employee_Growth__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Sales_Growth__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Net_Income__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Net_Income_Growth__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Assets__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	R_D__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Market_Value__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Exchange__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	One_Year_Stock_Price_History__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Profitability_vs_Industry__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	P_L__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	IT_Budget__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Key_Industry_Ratios__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Cost_Income_Ratios__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Budget_Planning__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Annual_Reports_Available__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Target_Revenue_for_Red_Hat_yearly__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Advertising__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Discount__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Enrollment_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Points__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Accreditation__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_of_RHCE__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_of_RHCT_Certifications__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_of_RHCA_Certifications__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Class_of_Trade__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Distributor,DMR,ISV,OEM,VAR'),
	Partner_Account_Status__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Revenue_to_Date__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Alias_Name__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Num_of_End_Customer_Account__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Priority__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'High,Medium,Low'),
	EMEA_SE_Required__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Territory1__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Canada,Central,East,Hosting,Hosting/T2 OEM,Verticals,West'),
	SubTerritory__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'British Columbia,CENT,Central,CSMB,East,East Canada,Education,Federal,FINANCIAL SERVICES,HEALTHCARE,MEDIA AND TECH,Mid Atlantic,NE,NE Central,NW,NW Central,Ontario,Ontario East,Ontario Public Sector,Ontario West,Public Sector,Quebec Enterprise,S. Central,SE,SW,SWO,TELECOM,WEST,West Canada,West Enterprise'),
	Super_Industry__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	True_Up_Account__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Anniversary_Date_True_Up_Accounts__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Reminder_Frequency__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Quarterly,Bi-Annually,Annually'),
	Frequency_Days__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Reminder_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Disable_Send_Partner_Notification__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Describe__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Completeness__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Industry_Vertical_Expertise__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Aerospace,Construction,Education,Financial Services,Government,Government-Military,Healthcare,Information Technology,Insurance,Life Sciences,Manufacturing,Media and Entertainment,Non Profit Organization,Oil and Gas,Other,Product Distributor,Retail,Services,State/County/Local Government,Tech Online,Telecom,Transportation,Utilities'),
	Key_Contact__c string(50) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Key_Contact_Cell_Phone__c string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Key_Contact_Email__c string(80) OPTIONS (NATIVE_TYPE 'email', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Key_Contact_Primary_Phone__c string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_of_RHCSS_Certifications__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_of_Trained_JBoss_Professionals__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Red_Hat_or_JBoss_certified_employees__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Partner_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'VAR,Reseller,ISV,OEM,Distributor,DMR,Systems Integrator,Corporate Reseller,Regional SI,Service/Cloud Provider'),
	Service_Offerings__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Jboss,RHEL,RHEV'),
	Solution_Partners__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'BEA,BMC Software,Hyperion,IBM SWG,Oracle,Platform Computing,SAP,Sybase,Symantec,VMWare'),
	Special_Service_Offerings_or_Skills__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Sweet_Spot__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Technology_Solutions_Expertise__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Application Development,Application Integration,Application Maintenance,BI,CRM,Database,ERP,High Availability,HPC,Linux,Managed Services,SOA,Virtualization,Web Services'),
	Service_Area__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'NORTH AMERICA,CANADA,MEXICO,UNITED STATES,US-CENTRAL,US-EAST,US-MIDWEST,US-NORTHEAST,US-NORTHWEST,US-SOUTHEAST,US-SOUTHWEST,US-WEST,ALABAMA,ALASKA,AMERICAN SAMOA,ARIZONA,ARKANSAS,CALIFORNIA,COLORADO,CONNECTICUT,DELAWARE,DISTRICT OF COLUMBIA,FEDERATED STATES OF MICRONESIA,FLORIDA,GEORGIA,GUAM,HAWAII,IDAHO,ILLINOIS,INDIANA,IOWA,KANSAS,KENTUCKY,LOUISIANA,MAINE,MARSHALL ISLANDS,MARYLAND,MASSACHUSETTS,MICHIGAN,MINNESOTA,MISSISSIPPI,MISSOURI,MONTANA,NEBRASKA,NEVADA,NEW HAMPSHIRE,NEW JERSEY,NEW MEXICO,NEW YORK,NORTH CAROLINA,NORTH DAKOTA,NORTHERN MARIANA ISLANDS,OHIO,OKLAHOMA,OREGON,PALAU,PENNSYLVANIA,PUERTO RICO,RHODE ISLAND,SOUTH CAROLINA,SOUTH DAKOTA,TENNESSEE,TEXAS,UTAH,VERMONT,VIRGIN ISLANDS,VIRGINIA,WASHINGTON,WEST VIRGINIA,WISCONSIN,WYOMING'),
	Key_Contact_Secondary_Phone__c string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	I_Agree_to_the_Terms_and_Conditions__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Name_of_Partner_Accepting_Legal_T_s__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Date_Legal_T_s_C_s_Accepted__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Center_ID__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Global_Region__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'NA,APAC,LATAM,EMEA'),
	Subregion__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ASEAN,ANZ,India,Hong Kong,Greater China,Japan,Korea,Taiwan,Northeast,Central,Southeast,West,Canada,National,Fed Sled,High Volume,Distributor,Brazil,Mexico,NA,CE,NEE,SWE,Northwest,Southwest,SEMEA,North Central,South Central,Mid-Atlantic,SAC'),
	HMMI_Ent_ID__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Enterprise_Name__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	FCPA_Check__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Channel Operations Review,Failed,Failed with Comments,Legal Review,Passed,Passed with Comments'),
	Date_FCPA_Check_Performed__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	FCPA_Check_Comments__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Compliance_Score__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Prospect_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'A,B,C'),
	PartnerStatuses__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Advanced - Corporate Reseller,Advanced - ISV,Advanced - Regional SI,Advanced - Reseller,Advanced - SI,Advanced - Systems Integrator,Affiliated - Cloud/Virtualization,Affiliated - Distributor,Affiliated - OEM,Affiliated - Service/Cloud Provider,None,Premier - Corporate Reseller,Premier - ISV,Premier - Regional SI,Premier - Reseller,Premier - SI,Premier - Systems Integrator,Ready - Corporate Reseller,Ready - Hosting,Ready - ISV,Ready - Regional SI,Ready - Reseller,Ready - SI,Ready - Systems Integrator,Unaffiliated - Distributor,Unaffiliated - ISV,Unaffiliated - OEM,Unaffiliated Renewal not Met - Reseller,Unaffiliated - Reseller,Unaffiliated - Service/Cloud Provider,Unaffiliated - SI,Unaffiliated - Systems Integrator,Unaffiliated - Training'),
	RedHatSyncable__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Additional_Countries_of_Operation__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Afghanistan,Åland,Albania,Algeria,Antigua,Argentina,Armenia,Aruba,Australia,Austria,Azerbaijan,Bahamas,Bahrain,Barbados,Barbuda,Belarus,Belgium,Belize,Benelux,Benin,Bermuda,Bolivia,Bosnia and Herzegovina,Botswana,Brazil,British Virgin Islands,Bulgaria,Burkina Faso,Burundi,Cameroon,Canada,Canary Islands,Cape Verde,Cayman Islands,Central African Republic,Chad,Chile,China,Colombia,Comoros,Congo,Costa Rica,Croatia,Cyprus,Czech Republic,Democratic Republic of Congo,Denmark,Djibouti,Dominica,Dominican Republic,Finland,France,French Guiana,Gabon,Gambia,Georgia,Germany,Ghana,Gibraltar,Greece,Grenada,Guadeloupe,Guam,Guatema,Guinea-Bissau,Guyana,Haiti,Honduras,Hong Kong,Hungary,Iceland,India,Indonesia,Ireland,Isle of Man,Israel,Italy,Jamaica,Japan,Jersey,Jordan,Kazakstan,Kenya,Kuwait,Kyrgyzstan,Laos,Latvia,Lebanon,Liberia,Libya,Liechtenstein,Lithuania,Luxembourg,Macedonia,Madagascar,Madeira Islands,Mali,Malta,Mexico,Moldova,Monaco,Montenegro,Namibia,Netherlands,New Zealand,Nicaragua,Norway,Oman,Panama,Paraguay,Peru,Philippines,Poland,Portugal,Qatar,Romania,Russia,Rwanda,Sao Tome and Principe,Saudi Arabia,Senegal,Sierra Leone,Singapore,Slovakia,South Africa,South Korea,Spain,Sri Lanka,Suriname,Swaziland,Sweden,Switzerland,Tajikistan,Togo,Trinidad,Tunisia,Turkey,Ukraine,United Arab Emirates,United Kingdom,United States,Venezuela,Virgin Islands,Western Sahara,Yemen,Zambia,Zimbabwe'),
	Additional_Partnerships__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AMD,Cisco,Citrix,Fujitsu,HP Hardware,HP Software,IBM Hardware,IBM Software,Intel,Microsoft,None,Novell SuSE,Oracle/BEA,SAP,Siemens,VMWare'),
	Application_Types__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'None,Application Design/Construction,Application Design/Construction/IDE,Application Life-Cycle Management,Application Life-Cycle Mgt,Authoring,Back-Office Enterprise,Collaboration/Groupware,Collaboration/Groupware/Messaging,Consumer,Content Management,Content Management/Authoring,Customer Relationship Management,Database/Information/Data Management,Delivery/Mining/Portal,Engineering,Enterprise Resource Planning,Information Access,Information Access/Delivery/Mining,Middleware/Message-oriented,Middleware/Message-Oriented/Transaction,Networking,Other Development Tools,Security,ServerWare/Clustering/Web/VM,Storage,System-Level Software,Systems Management,Transaction Network Management'),
	Date_Last_Cleansed__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Hardware_Focus__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'No Hardware Focus,Mainframe,Intel based servers,Power-PC RISC Workstations,Notebooks/Desktop Solutions/Thin Clients'),
	Hardware_Platform__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'None,IBM zSeries,IBM Power Series,IBM s390,IBM pSeries,IBM iSeries,Intel Itanium,Intel 64,Intel x86,AMD 64,Sun Sparc'),
	Have_They_been_Convicted__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	If_Other_Middleware__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Industry_Focus__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Aerospace,All Industries (Horizontal Application),Automotive and Transport Equipment,Construction,Consulting,Discrete Manufacturing,Discrete Manufacturing - Aerospace/Def,Discrete Manufacturing - Automotive,Discrete Manufacturing - High Tech,Discrete Manufacturing - Industrials,Education,Electronic Design Automation,Energy,Engineering,Environment,Financial,Financial Services,Financial Services - Banking,Financial Services - Securities,Government,Government-Military,Healthcare,Information Technology,Insurance,Legal Services,Leisure,Life Sciences,Manufacturing,Media and Entertainment,Non Profit Organization,Oil and Gas,Other,Pharmaceuticals,Process Manufacturing,Process Manufacturing - Chemicals,Process Manufacturing - Consumer Product,Process Manufacturing - Oil/Gas,Product Distributor,Public Services,Publishing,Retail,Services,State/County/Local Government,Tech Online,Telecom,Transportation,Utilities,Wholesale'),
	Middleware_Supported__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'JBoss,Websphere,Weblogic,Other,None'),
	MigrationSource__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Onboarded,Legacy Partner Center New,Legacy Partner Center Merged'),
	NumberOfSalesPeople__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfTechnicalPeople__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Operating_System_Supported__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Red Hat Enterprise Linux,SuSe Linux,Windows,Solaris,Fedora,FreeBSD,CentOS,Ubuntu,OEL,HPUX,AIX,Other'),
	Other_Countries__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Other_Partnerships__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Ownership_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Other,Public,Private,Subsidiary'),
	PrimaryPartnerUser__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Promo_Code__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Software_Focus__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'OS,Middleware,Virtualization'),
	State_Province__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Target_Market_Size__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Small,Medium,Large,Enterprise'),
	Total_Annual_Revenue__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '< $1 Million,$1 Million - $20 Million,$2 Million - $50 Million,$50 Million - $100 Million,> $100 Million,Unknown'),
	YearEstablished__c string(4) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Distributors_Purchased_Through__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Avnet,Carahsoft,Ingram Micro,Synnex,Tech Data,None'),
	Number_Enrolled_Sales_Cert__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_Middleware_Sales_Certs__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_Platform_Sales_Certs__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Ready_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Committed,Engaged in Discussions,Key Player,Low Touch,Maintenance,Not Interested,Other,Undetermined'),
	Core_Specializations_Reselling__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Marketing_Plan_Received__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Geographic_Sales_Coverage__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'National,Regional,Local'),
	JBoss_Middleware_Skills__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Marketing_Plan_Achievement_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_of_Customers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_of_Sales_Certifications__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Number_of_Technical_Certifications__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Open_Source_Practice__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Previous_Year_Revenue__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RH_Webinar_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Sales_Certification_Acheivement_by_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	JBoss_Account_ID__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Current_JB_Owner__c string(30) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Sales_Ops_Reviewed__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Size_of_Companies_Targeted__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Fortune 1,000,Medium - Fortune 1,000,Medium <999,Small - Medium,Small - Very Small,Small <99,Very Small <20'),
	Technical_Course_Enrolled__c string(45) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Technical_Enrollment_Achievement_by_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Webinar_Attending__c string(30) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Webinar_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	What_Markets_are_Targeted__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Vertical market,Education Market,Government Markets Federal,Government Markets State,Government Markets Local,Other industries'),
	Years_in_Business__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Referenceable__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'No,Yes'),
	Agree_to_Sales_Certification__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes/Agree,No/Does Not Agree,Completed,Enrolled'),
	Agree_to_Technical_Enrollment__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes/Agree,No/Does Not Agree,Completed,Enrolled'),
	Agree_to_Attend_RH_Webinar__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes/Agree,No/Does Not Agree,Completed,Enrolled'),
	Agree_to_Submit_Marketing_Plan__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes/Agree,No/Does Not Agree,Completed,Submitted'),
	Ready_Status_Detail__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Committed - In process,Activated - Sales Engaged With Red Hat,Engaged In Discussions,Not Interested - Bad Experience With RH,Not Interested - Closed 5 Call Attempts,Not Interested - Follow Up,Not Interested - General,Not Interested - No Open Source Interest,Not Interested - Not Reselling,Undetermined,Bad Number,Duplicate Partner Entry,Federal Gov - Sent To Brian,ISV - Sent To Brian,Moved to Advanced,Out of Business,RH Do Not Call,Maintenance,Assessment Complete,Agreed to Solution Accelerator Plan (SAP),SAP Complete,DG In Progress,DG Generating Leads,DG Generating Revenue,ISV Self Certified,ISV OEM Embedded,Self Certify Track,OEM/Embedding Track,Highly Engaged,Enablement Complete,Enablement in Progress,ABP Candidate'),
	Number_Virtualization_Sales_Certs__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AccountKey__c string(21) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HasAccountTeamAssigned__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Account_OwnerName__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PrimaryPartnerContact__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Certified_Service_Provider__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Hosting_Partner__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Hosting Distributors,Hosting Resellers,Hosting Partners'),
	Select_Specialization_s__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cloud Infrastructure,Data Center Infrastructure,Middleware Solutions,Public Sector'),
	Total_Partner_Sales_Certifications__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Partner_Technical_Certifications__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HooversId__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	issalescertification__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Recruiting_Distributor__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Ingram Micr,Synnex,Tech Data'),
	Offices_Locations__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_s_Largest_Customer__c string(120) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Program_Requirements__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RequalStatus__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Eligible,In Progress,Overdue,Not Completed,Submitted,Completed,Removed,Not Approved at this time,Manager Completed'),
	RequalificationDate__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	RequalificationLatestId__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Requalification_Approver__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Requalification_Reinstated__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Requalification_Submitter__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Requalification_Extended__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	ReferenceStor__Import_into_ReferenceStor__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Eligible_Day__c date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Overdue_Date__c date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Pre_sales_Course_Completions__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	SEA_Concern__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Doing_Business_As__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	VisibleApprovedStatuses__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Data_Status_Message__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Data_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Pending Data Review,Pending Sales Ops,Locked,Pending Update'),
	Hours_to_Review__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Finder_Partner_Tier__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Finder_Partner_Type__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Finder_Sort_Hint__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Is_Partner_Published__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	PartnerKeywords__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Training_Partner_Specifications__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Red Hat Certified Training Partner,Red Hat Academy,RHEL Courses,JBoss Courses,RHEL Exams'),
	JBossProductCount__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Product_SE_Linux_Support__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PlatformProductCount__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PartnerProductCount__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AliasPublicViewable__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Public_Sector_Market__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'US Federal Government,US State and Local Government,Education'),
	Is_Primary_Public_Sector__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Global__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Partner_Status_Visible__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Domestic_Ultimate_D_U_N_S__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Is_Top_Level_Account__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Top_Level_Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Other_Account_ID__c string(25) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OORID__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Record_Source__c string(45) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Specializations__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Partner_Organization__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Profile__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Role__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RecordType__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AllowedEmailDomains__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Anti_Corruption_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cleared,Completed,Failed,No Review Required,Passed,Review Required'),
	Direct_Purchasing_Agreement__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Finder_Partner_Role__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Primary__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'OEM,SI,Training,Service/Cloud Provider'),
	Organization__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Department of Defense,EDU,Federal Civilian,Independent/Other Agencies,Intelligence,State and Local'),
	Sub_Organization__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '2-Year Career School,2-Year Community College,4-Year University/College,Board of Governors of the Federal Reserve System,Board of Regents,City Government,Commodity Futures Trading Commission (CFTC),Consumer Product Safety Commission (CPSC),County Government,Defense Finance & Accounting Service (DFAS),Defense Information Systems Agency (DISA),Defense Intelligence Agency (DIA),Defense Logistics Agency (DLA),Defense Threat Reduction Agency (DTRA),Department of Agriculture (USDA),Department of Commerce (DOC),Department of Education,Department of Energy (DOE),Department of Health & Human Services (HHS),Department of Homeland Security (DHS),Department of Housing & Urban Development (HUD),Department of Justice (DOJ),Department of Labor (DOL),Department of State (DOS),Department of the Air Force (USAF),Department of the Army (USA),Department of the Interior (DOI),Department of the Navy (USN),Department of Transportation (DOT),Department of Treasury (TRE),Department of Veterans Affairs (VA),Environmental Protection Agency (EPA),Equal Employment Opportunity Commission (EEOC),Export-Import Bank of the United States,FED-C,Federal Communications Commission (FCC),Federal Deposit Insurance Corporation (FDIC),Federal Reserve Bank,Federal Retirement Thrift Investment Board,Federal Trade Commission (FTC),For Profit EDU,General Services Administration(GSA),Government Printing Office (GPO),Joint Chiefs of Staff (JCS),K-12,Library of Congress,Maryland Procurement Office (MPO),Missile Defense Agency (MDA),National Aeronautics and Space Administration (NASA),National Geospatial Intelligence Agency (NGA),National Railroad Passenger Corporation (Amtrak),National Reconnaissance Office (NRO),National Science Foundation (NSF),Office of Personnel Management,Office of the Secretary of Defense (OSD),Other – DOD,Other - EDU,Other - Federal Civilian,Other – Independent/Other Agency,Other - Intelligence,Other – State and Local,Peace Corps,Pension Benefit Guaranty Corporation,Postal Regulatory Commission,Quasi-Governmental,Railroad Retirement Board,Small Business Administration (SBA),State Government,Teaching Hospital,The National Guard,U.S. House of Representative,U.S. Senate,Unified Combatant Commands (COCOMs),United States International Trade Commission (USITC),United States Marine Corps (USMC),United States Postal Service,Utility District'),
	StatusExpirationDate__c date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AccountProfileCount__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Middleware_Compliance_Score__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Finder_Partner_Tier_Name__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Finder_Partner_Type_Name__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Partner_Delivery_Certifications__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AC_Level_1_Bypass__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Underlying_Facts__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Skill__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Platform,Platform Migration,Virtualization,Storage,Application Development,Middleware Migration,Middleware Integration,Business Process Automation,PaaS Development,Cloud Management,IaaS,PaaS'),
	Eligible_for_Disti_Annual_Pay_Program__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CCP_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Full,Diagnostic'),
	CustomTerms__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Financial_Terms_Approve_Date__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Financial_Terms_Approver__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HasCustomTerms__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Special_Programs__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Lighthouse - MW,Lighthouse - VIRT'),
	CDH_Party_Number__c string(30) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Bill_To_Address_Conv__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CDH_Party_Conv__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	EBS_Account_Conv__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	EBS_Party_Conv__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Identifying_Address__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Sales_Account_Type_Conv__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Status_Conv__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	X11i_Account_Conv__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	X11i_Party_Conv__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Company_Email_Address__c string(80) OPTIONS (NATIVE_TYPE 'email', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Has_Partner_Ever_Been_Published__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	OEM_Tier__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Tier 1,Tier 2,Tier 3'),
	Partner_Classification_Code_Conv__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Address_Line_1__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CDH_Party_Name__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	City__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Country__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Do_Not_Do_Business_With__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Domestic_Ultimate__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	EBS_Account_Numbers__c string(131072) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Global_Ultimate__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Headquarters__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	State__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Active,Inactive'),
	Zip_Postal_Code__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Count_Of_Identifying_Address__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Known_As__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Billing_Address__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CDHPartyNumber__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CDH_Party_Type__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Headquarters_CDH_Party_Number__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Onboarding_Application__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Trade_Style__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_ParentId FOREIGN KEY(ParentId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'ChildAccounts'),
	CONSTRAINT FK_Account_Partner_Account__c FOREIGN KEY(Partner_Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Accounts__r'),
	CONSTRAINT FK_Account_Top_Level_Account__c FOREIGN KEY(Top_Level_Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Top_Level_Account__r'),
	CONSTRAINT FK_CDH_Party__c_CDH_Party_Name__c FOREIGN KEY(CDH_Party_Name__c) REFERENCES CDH_Party__c (Id) OPTIONS (NAMEINSOURCE 'Accounts__r'),
	CONSTRAINT FK_CDH_Party__c_Domestic_Ultimate__c FOREIGN KEY(Domestic_Ultimate__c) REFERENCES CDH_Party__c (Id) OPTIONS (NAMEINSOURCE 'Accounts1__r'),
	CONSTRAINT FK_CDH_Party__c_Global_Ultimate__c FOREIGN KEY(Global_Ultimate__c) REFERENCES CDH_Party__c (Id) OPTIONS (NAMEINSOURCE 'Accounts2__r'),
	CONSTRAINT FK_CDH_Party__c_Headquarters__c FOREIGN KEY(Headquarters__c) REFERENCES CDH_Party__c (Id) OPTIONS (NAMEINSOURCE 'Accounts3__r'),
	CONSTRAINT FK_Classification__c_Finder_Partner_Role__c FOREIGN KEY(Finder_Partner_Role__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Accounts2__r'),
	CONSTRAINT FK_Classification__c_Finder_Partner_Tier__c FOREIGN KEY(Finder_Partner_Tier__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Accounts__r'),
	CONSTRAINT FK_Classification__c_Finder_Partner_Type__c FOREIGN KEY(Finder_Partner_Type__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Accounts1__r'),
	CONSTRAINT FK_Contact_PrimaryPartnerContact__c FOREIGN KEY(PrimaryPartnerContact__c) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Accounts__r'),
	CONSTRAINT FK_PartnerRequalification__c_RequalificationLatestId__c FOREIGN KEY(RequalificationLatestId__c) REFERENCES PartnerRequalification__c (Id) OPTIONS (NAMEINSOURCE 'Accounts__r'),
	CONSTRAINT FK_Partner_Onboarding_Registration__c_Partner_Onboarding_Application__c FOREIGN KEY(Partner_Onboarding_Application__c) REFERENCES Partner_Onboarding_Registration__c (Id) OPTIONS (NAMEINSOURCE 'Accounts__r'),
	CONSTRAINT FK_State__c_State_Province__c FOREIGN KEY(State_Province__c) REFERENCES State__c (Id) OPTIONS (NAMEINSOURCE 'Accounts__r'),
	CONSTRAINT FK_User__Executive_Sponsor__c FOREIGN KEY(Executive_Sponsor__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Account__r'),
	CONSTRAINT FK_User__Financial_Terms_Approver__c FOREIGN KEY(Financial_Terms_Approver__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Accounts1__r'),
	CONSTRAINT FK_User__Name_of_Partner_Accepting_Legal_T_s__c FOREIGN KEY(Name_of_Partner_Accepting_Legal_T_s__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Accounts__r'),
	CONSTRAINT FK_User__Owner__c FOREIGN KEY(Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'AccountsOwned__r'),
	CONSTRAINT FK_User__PrimaryPartnerUser__c FOREIGN KEY(PrimaryPartnerUser__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'AccountsByPrimaryPartnerUser__r'),
	CONSTRAINT FK_User__Requalification_Approver__c FOREIGN KEY(Requalification_Approver__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Requalification_Approver1__r'),
	CONSTRAINT FK_User__Requalification_Submitter__c FOREIGN KEY(Requalification_Submitter__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Requalification_Submitter__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'true', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Account_Profile__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Workloads_Deployed_on_Linux__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Application Server,DB,Desktop,DNS,EDA Workstation,FTP,Game,HPCC,Mail,Web'),
	X_Strengths_of_Account_s_Product_Service__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Mail__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cyrus,Dovecut,Lotus Domino,MS Exchange,Scalix,Zimbra'),
	Linux_Servers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Major_Markets_Account_Services__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_s_Biggest_Competitor_s__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Industry_Position_Market_Share_History__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Middleware_Interface__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Crossflo,Hibernate,Mercator,Tibco,Vitria,WebMethods'),
	Critical_Success_Factors__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Microsoft_Version__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Windows 2000,Windows 2003,Windows 95/98,Windows Longhorn,Windows ME,Windows NT,Windows Vista,Windows XP'),
	Industry_Conditions__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Directory_Server__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Apple Open Directory,Critical Path Directory Server,Fedora Directory Server,IBM Tivoli Directory Server,Microsoft Active Directory,Microsoft Windows NTDS,Netscape,Novell eDirectory - formerly NDS,OID,OpenLDAP,Red Hat Directory Server,Sun Directory Server,Sun One Directory'),
	Solution_to_Attain_Strategic_Initiatives__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	C_Level_Priority_Goals__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Business_Pains__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Virtualization__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'VirtualPC,VMWare,XenSource'),
	Total_Servers__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_s_Distribution_Channels__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Company_Mission_Statement__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Distinction_Between_Account_Competitor__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Primary__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Dell,EMC,Fujitsu,HDS,Hitachi,HP,IBM,Intel,Netapp,StorageTek,Sun'),
	Key_Obstacles__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_s_Open_Source_Maturity__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	File_Systems__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'EXT3,REISERFS,NFS,VFAT,NTFS,EXT2,JFS,GFS,OCFS,XFS,ZFS'),
	Purchasing_Process__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Positives_About_Current_Infrastructure__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_s_Partners_Alliances__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Application_Server__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Websphere,Weblogic,Jboss,Sun One,Oracle App Server,Tomcat,IIS,Apache,Tmacsoft'),
	Primary_HW_Vendor_Other__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Current_IT_Architecture__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Primary_Hardware_Vendor__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AMD Whitebos,Apple,Bull,Dell,Eslim,Fujitsu,HP,IBM,Inspur,Intell Whitebox,Lenovo,Samsung,SGI,Sun,Toshiba,Unisys,Uniwide'),
	Unix_Version__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AIX,FreeBSD,HP-UX,Irix,Open Solaris,SCO-Unix,Solaris,Tru64'),
	OS_Environment__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AIX,AS400,BSD Family,China Standard Linux,Fedora Core,HP-UX,Linux,Netware,Red Flag,RHEL,SLES,TurboLinux,Unix,Windows 2000,Windows 2003'),
	Annual_Budget_Begins__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'January,February,March,April,May,June,July,August,September,October,November,December'),
	Corporate_Objectives__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Microsoft_Servers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Back_up_Recovery__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Veritas,Tivoli,Netbackup,Bakbone,Netvault,Dump,Tar,BrightStore(CA),Amanda,Arkeia,Arcronis,CommVault,Legato Networker'),
	Challenges_About_Current_Infrastructure__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Storage__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'DAS,iSCSI,JBOD,NAS,SAN'),
	DB_Systems_Installed__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Microsoft Visual Studio'),
	ERP_System__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Oracle,PeopleSoft,SAP,Siebel'),
	Installed_Open__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'NEED VALUES'),
	Preferred_Platform_Vendor__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'HP,IBM,Microsoft,Novell,Red Flag,Red Hat,Sun,TurboLinux'),
	Account_s_Largest_Customer__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Other_Servers_Type_Version__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Unix_Servers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Certified_Open_Source_Apps__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'NEED VALUES'),
	RH_Sales_Strategy__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Drivers_for_this_Account__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Cluster_File_System__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'GFS,OCFS,Sanique,Veritas,XFS'),
	Other_Servers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Linux_Version__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Asianux,Debian,Fedora 4,Fedora 5,Fedora 6,Gentoo,Oracle Linux,RedFlag,RedHat Linux (Legacy),RH9,RHEL 2.1,RHEL3,RHEL4,RHEL 5,SLES9,SuSE 10,SuSE 9,Turbo Linux,Ubuntu'),
	Critical_Applications__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Corporate_Strategy_Current_Initiatives__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Monitoring__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'OpenView,TNG-Unicenter,Legato,Tivoli,RHN Satellite,HP OpenView,Altiris,BMC Patrol,CA Unicenter,Nagios,Ganglia'),
	Software_Management__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Avocent - formerly Landesk,BMC Marimba,CA Unicenter,HP Openview,IBM Tivoli,Maxigent,Microsoft SMS,Novell,Opsware,RHN Satellite,RPM,SUN N1,Symantec - formerly Altiris/OnTechnology,Xenworks'),
	Hardware_Environment__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AMD64,HP PA-RISC,IA64,IBM AS400,IBM Power,IBM z-series,Itanium,Itanium 2,Mainframe,S390,SPARC,X86_64,X86 AMD,X86 Intel'),
	Network_Infrastructure_Equipment__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '3Comm,Cisco,Dell,Foundry,HP,HuaWei,IBM,LinkSys,NetGear,Nortell,OEM,Samsung,Sun'),
	Workloads_Deployed_on_Linux_Historical__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Renewal_Amount__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Database__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'DB2,EnterpriseDB,Informix,Ingres,MS SQL,MySQL,Oracle,Oracle RAC,PostgreSQL,SQLServer,Sybase,Vertica'),
	Hardware_Platform__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Development_Tools__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Borland Developer Studio,Eclipse,Microsoft.net,MS Visual Studio,NetBeans'),
	Server_Information_Source__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Internet,Customer,Private'),
	Account_Profile_Notes__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Comments__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Virtualization_OS__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AIX,AS400,BSD Family,China Standard Linux,Fedora Core,HP-UX,Linux,Netware,Red Flag,RHEL,SLES,TurboLinux,Unix,Windows 2000,Windows 2003'),
	Workloads_Deployed_on_Microsoft__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Application Server,DB,Desktop,DNS,EDA Workstation,FTP,Game,HPCC,Mail,Web'),
	Workloads_Deployed_on_Unix__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Application Server,DB,Desktop,DNS,EDA Workstation,FTP,Game,HPCC,Mail,Web'),
	Mail_Application__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'MS,Red Hat,AIX,HPUX'),
	Web__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'MS,Red Hat,AIX,HPUX'),
	DNS__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'MS,Red Hat,AIX,HPUX'),
	DB__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'MS,Red Hat,AIX,HPUX'),
	App_Server__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'MS,Red Hat,AIX,HPUX'),
	JBoss_Perspective__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Development Shop,Off the Shelf Package'),
	Platform_Status_for_JBoss_RHEL__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1 Not Approved,2 Approved Platform,3 Approved Platform - in use and a Strategic Platform,4 Default Strategic Platform,5 Default Strategic Platform plus Big Installed Base'),
	Est_Computer_Budget__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Est_Software_Budget__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Est_Storage_Budget__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DBMS_Vendor__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Large_IT_Sites__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Data_Centers__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	IT_Employees__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_PCs__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Groupware_Vendor__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Web_Dev_Vendor__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Enterprise_Application_Vendor__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Profile_Currency__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_end_users__c string(500) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Cultural_and_political_landscape__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Direct_Indirect__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Direct,Indirect,No Preference'),
	Fiscal_Year_End__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'January,February,March,April,May,June,July,August,September,October,November,December'),
	MSA_in_Place__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Number_of_Employees__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Pain_Point_1__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Pain_Point_2__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Pain_Point_3__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	What_makes_them_successful__c string(500) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Cores_All_Types__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Cores_Additional_Middleware__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Cores_Application_Servers__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Cores_Point_Solutions_Apps__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Cores_Strategic_Platforms__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Formatted_Storage_Capacity__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Number_of_Servers__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Number_of_Virtualization_Instances__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AnnualITBudget__c double OPTIONS (UPDATABLE FALSE, CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AnnualRevenue__c double OPTIONS (UPDATABLE FALSE, CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Industry__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Account__c FOREIGN KEY(Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Account_Profile__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Account_Profile__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account__c,Account_end_users__c,Account_Profile_Notes__c,Account_s_Biggest_Competitor_s__c,Account_s_Distribution_Channels__c,Account_s_Largest_Customer__c,Account_s_Open_Source_Maturity__c,Account_s_Partners_Alliances__c,Annual_Budget_Begins__c,App_Server__c,Application_Server__c,Back_up_Recovery__c,Business_Pains__c,C_Level_Priority_Goals__c,Certified_Open_Source_Apps__c,Challenges_About_Current_Infrastructure__c,Cluster_File_System__c,Comments__c,Company_Mission_Statement__c,Corporate_Objectives__c,Corporate_Strategy_Current_Initiatives__c,created,Critical_Applications__c,Critical_Success_Factors__c,Cultural_and_political_landscape__c,CurrencyIsoCode,Current_IT_Architecture__c,Database__c,DB__c,DB_Systems_Installed__c,DBMS_Vendor__c,Development_Tools__c,Direct_Indirect__c,Directory_Server__c,Distinction_Between_Account_Competitor__c,DNS__c,Drivers_for_this_Account__c,Enterprise_Application_Vendor__c,ERP_System__c,Est_Computer_Budget__c,Est_Software_Budget__c,Est_Storage_Budget__c,feedEvent,File_Systems__c,Fiscal_Year_End__c,Groupware_Vendor__c,Hardware_Environment__c,Hardware_Platform__c,Industry_Conditions__c,Industry_Position_Market_Share_History__c,Installed_Open__c,IT_Employees__c,JBoss_Perspective__c,Key_Obstacles__c,Linux_Servers__c,Linux_Version__c,Mail__c,Mail_Application__c,Major_Markets_Account_Services__c,Microsoft_Servers__c,Microsoft_Version__c,Middleware_Interface__c,Monitoring__c,MSA_in_Place__c,Name,Network_Infrastructure_Equipment__c,Number_of_Employees__c,OS_Environment__c,Other_Servers__c,Other_Servers_Type_Version__c,ownerAccepted,ownerAssignment,Pain_Point_1__c,Pain_Point_2__c,Pain_Point_3__c,Platform_Status_for_JBoss_RHEL__c,Positives_About_Current_Infrastructure__c,Preferred_Platform_Vendor__c,Primary__c,Primary_Hardware_Vendor__c,Primary_HW_Vendor_Other__c,Purchasing_Process__c,locked,unlocked,Renewal_Amount__c,RH_Sales_Strategy__c,Server_Information_Source__c,Software_Management__c,Solution_to_Attain_Strategic_Initiatives__c,Storage__c,Total_Data_Centers__c,Total_Large_IT_Sites__c,Total_PCs__c,Unix_Servers__c,Unix_Version__c,Virtualization__c,Virtualization_OS__c,Web__c,Web_Dev_Vendor__c,What_makes_them_successful__c,Workloads_Deployed_on_Linux__c,Workloads_Deployed_on_Linux_Historical__c,Workloads_Deployed_on_Microsoft__c,Workloads_Deployed_on_Unix__c,X_Strengths_of_Account_s_Product_Service__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile__c_ParentId FOREIGN KEY(ParentId) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Account_Profile__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile__c_ItemId FOREIGN KEY(ItemId) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Account_Profile_Other_Partner__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account_Profile__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Type__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile__c_Account_Profile__c FOREIGN KEY(Account_Profile__c) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Account_Profile_Other_Partners__r'),
	CONSTRAINT FK_Classification__c_Partner_Type__c FOREIGN KEY(Partner_Type__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Account_Profile_Other_Partners__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Account_Profile_Other_Partner__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile_Other_Partner__c_ItemId FOREIGN KEY(ItemId) REFERENCES Account_Profile_Other_Partner__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Account_Profile_Power_Map__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account_Profile__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Business_Agenda__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Buyer_Role__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'User,Champion (Red Hat Advocate),Sponsor (Evaluator),Power Sponsor (Approver or Decision Maker)'),
	Change_Oriented__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Innovator,Visionary,Pragmatist,Conservative,Laggard,Unknown'),
	CustomerKeyContact__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Level_of_Contact__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'No Contact,Brief Contact,Multiple,In depth'),
	Personal_Agenda__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Point_Person_on_Red_Hat_Account_Team__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Reports_To__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Title__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Your_Relationship__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Mentor,Supporter,Neutral,Non Supporter,Enemy'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Account__c FOREIGN KEY(Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Account_Profile_Power_Maps__r'),
	CONSTRAINT FK_Account_Profile__c_Account_Profile__c FOREIGN KEY(Account_Profile__c) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Account_Profile_Power_Maps__r'),
	CONSTRAINT FK_Contact_CustomerKeyContact__c FOREIGN KEY(CustomerKeyContact__c) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Customer_Key_Contacts__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Account_Profile_Power_Map__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile_Power_Map__c_ItemId FOREIGN KEY(ItemId) REFERENCES Account_Profile_Power_Map__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Account_Profile_SWOT__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account_Profile__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Statement__c string(120) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Red Hat Strength,Red Hat Weakness,Account Opportunity,Account Threat'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile__c_Account_Profile__c FOREIGN KEY(Account_Profile__c) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Account_Profile_SWOTs__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Account_Profile_SWOT__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile_SWOT__c_ItemId FOREIGN KEY(ItemId) REFERENCES Account_Profile_SWOT__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Account_SWOT_Analysis__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account_s_Internal_Weaknesses__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Profile__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_s_External_Opportunities__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_s_Internal_Strengths__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_s_External_Threats__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile__c_Account_Profile__c FOREIGN KEY(Account_Profile__c) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'SWOT_Analysis__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Account_SWOT_Analysis__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account_Profile__c,Account_s_External_Opportunities__c,Account_s_External_Threats__c,Account_s_Internal_Strengths__c,Account_s_Internal_Weaknesses__c,created,CurrencyIsoCode,feedEvent,Name,Owner,ownerAccepted,ownerAssignment,locked,unlocked'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_SWOT_Analysis__c_ParentId FOREIGN KEY(ParentId) REFERENCES Account_SWOT_Analysis__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Account_SWOT_Analysis__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_SWOT_Analysis__c_ItemId FOREIGN KEY(ItemId) REFERENCES Account_SWOT_Analysis__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountCatalogRelationship__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AccountCatalogRelationship__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountCatalogRelationship__c_ItemId FOREIGN KEY(ItemId) REFERENCES AccountCatalogRelationship__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountChangeRequest__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Comments__c string OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Hours_to_Review__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Pending Review,Reviewed'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Account__c FOREIGN KEY(Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Account_Change_Requests__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AccountChangeRequest__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountChangeRequest__c_ItemId FOREIGN KEY(ItemId) REFERENCES AccountChangeRequest__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountChangeRequestField__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	ChangeRequest__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Approved__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BooleanValue__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	DateTimeValue__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DateValue__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	FieldName__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account_Alias_Name__c,D_U_N_S__c,Do_Not_Do_Business_With__c,Fax,Industry,Name,Phone,SEA_Concern__c,VATNumber__c,Website'),
	OriginalBooleanValue__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	OriginalDateTimeValue__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OriginalDateValue__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OriginalTextValue__c string(4096) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	TextValue__c string(4096) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountChangeRequest__c_ChangeRequest__c FOREIGN KEY(ChangeRequest__c) REFERENCES AccountChangeRequest__c (Id) OPTIONS (NAMEINSOURCE 'Account_Change_Request_Fields__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AccountChangeRequestField__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountChangeRequestField__c_ItemId FOREIGN KEY(ItemId) REFERENCES AccountChangeRequestField__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountContactRole (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	AccountId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ContactId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Role string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Buyer,Decision Maker,Finance Contact,Payables Contact,RH Advocate,Senior Sponsor,Shipping Contact,System Administrator'),
	IsPrimary boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_AccountId FOREIGN KEY(AccountId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'AccountContactRoles'),
	CONSTRAINT FK_Contact_ContactId FOREIGN KEY(ContactId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'AccountContactRoles')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountFeed (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeedPostId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'TrackedChange,UserStatus,TextPost,AdvancedTextPost,LinkPost,ContentPost,PollPost,RypplePost,ProfileSkillPost,DashboardComponentSnapshot,ApprovalPost,CaseCommentPost,ReplyPost,EmailMessageEvent,CallLogPost,ChangeStatusPost,AttachArticleEvent,MilestoneEvent,ActivityEvent,ChatTranscriptPost,CollaborationGroupCreated,CollaborationGroupUnarchived,SocialPost,QuestionPost,FacebookPost,BasicTemplateFeedItem,CreateRecordEvent,CanvasPost,AnnouncementPost'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_ParentId FOREIGN KEY(ParentId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Feeds')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountFields__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(38) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	fieldId__c string(30) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AccountFields__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountFields__c_ItemId FOREIGN KEY(ItemId) REFERENCES AccountFields__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountHierarchy__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AccountId__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_ParentId__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	IsCurrent__c boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Parent__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UltimateParentId__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UltimateParent__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Account__c FOREIGN KEY(Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Account_Hierarchies__r'),
	CONSTRAINT FK_AccountHierarchy__c_Parent__c FOREIGN KEY(Parent__c) REFERENCES AccountHierarchy__c (Id) OPTIONS (NAMEINSOURCE 'Account_Hierarchies_Parent__r'),
	CONSTRAINT FK_AccountHierarchy__c_UltimateParent__c FOREIGN KEY(UltimateParent__c) REFERENCES AccountHierarchy__c (Id) OPTIONS (NAMEINSOURCE 'Account_Hierarchies_Ultimate_Parent__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AccountHierarchy__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountHierarchy__c_ItemId FOREIGN KEY(ItemId) REFERENCES AccountHierarchy__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountHistory (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	AccountId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AC_Level_1_Bypass__c,Account_Alias_Name__c,Account_Assets__c,Account_External_Id__c,Account_OwnerName__c,Account_Priority__c,AccountClassification__c,AccountKey__c,accountMerged,AccountNumber,AccountRating__c,AccountSource,Accreditation__c,Additional_Countries_of_Operation__c,Additional_Partnerships__c,Address_Line_1__c,Address_Line_2__c,Address_Line_3__c,Address_Line_4__c,Advertising__c,Agree_to_Attend_RH_Webinar__c,Agree_to_Sales_Certification__c,Agree_to_Submit_Marketing_Plan__c,Agree_to_Technical_Enrollment__c,AliasPublicViewable__c,All_NAICS_Codes__c,AllowedEmailDomains__c,Anniversary_Date_True_Up_Accounts__c,Annual_Reports_Available__c,AnnualRevenue,Anti_Corruption_Status__c,Application_Server__c,Application_Types__c,ASIDBT__c,ASIDST__c,Back_up_Recovery__c,BigMachines__Partner_Organization__c,BillingAddress,BillingCity,BillingCountry,BillingLatitude,BillingLongitude,BillingPostalCode,BillingState,BillingStreet,Budget_Cycle__c,Budget_Planning__c,Business_Pains__c,Business_Pains_2__c,Business_Structure__c,CCP_Type__c,CDH_Party_Conv__c,CDH_Party_Name__c,CDH_Party_Number__c,Certified_Service_Provider__c,City__c,Class_of_Trade__c,CleanStatus,Cluster_File_Systems__c,Company_Email_Address__c,Completeness__c,Compliance_Score__c,Core_Specializations_Reselling__c,Cost_Income_Ratios__c,Country__c,County__c,created,accountCreatedFromLead,Credit_Approved_by__c,CreditLimit__c,CreditPreApproved__c,CurrencyIsoCode,Current_JB_Owner__c,Customer_Status__c,CustomTerms__c,D_U_N_S__c,DandbCompany,Data_Status__c,Database__c,Date_FCPA_Check_Performed__c,Date_Last_Cleansed__c,Date_Legal_T_s_C_s_Accepted__c,DateOfLastCreditCheck__c,Describe__c,Description,Description_of_Business__c,Direct_Purchasing_Agreement__c,Directory_Server__c,Disable_Send_Partner_Notification__c,Discount__c,Distributors_Purchased_Through__c,Do_Not_Do_Business_With__c,Doing_Business_As__c,Domestic_Ultimate__c,Domestic_Ultimate_D_U_N_S__c,DunsNumber,EBS_Account_Conv__c,EBS_Account_Numbers__c,EBS_Party_Conv__c,Eligible_for_Disti_Annual_Pay_Program__c,EMEA_SE_Required__c,Employee_Growth__c,Enrollment_Date__c,Enterprise_Name__c,Entitle_To_Address_Conv__c,ERP_Systems__c,EstAnnualRevForWWOrg__c,Exchange__c,Executive_Sponsor__c,Fax,FCPA_Check__c,FCPA_Check_Comments__c,feedEvent,File_Systems__c,Financial_Terms_Approve_Date__c,Financial_Terms_Approver__c,Finder_Partner_Role__c,Finder_Partner_Tier__c,Finder_Partner_Type__c,Finder_Sort_Hint__c,firs_Industry_Profile_Name__c,firs_Opp_Rating_Image__c,firs_profileid__c,firs_Rating_Desc__c,Fiscal_Year_End__c,Geographic_Sales_Coverage__c,Global__c,Global_Region__c,Global_Ultimate__c,Hardware_Environment__c,Hardware_Focus__c,Hardware_Platform__c,Has_Partner_Ever_Been_Published__c,HasAccountTeamAssigned__c,HasCustomTerms__c,Have_They_been_Convicted__c,Headquarters__c,HMMI_Ent_ID__c,HooversId__c,Hosting_Partner__c,Hours_to_Review__c,I_Agree_to_the_Terms_and_Conditions__c,Identifying_Address__c,If_Other_Middleware__c,Immediate_Parent_Account__c,Immediate_Parent_D_U_N_S__c,Industry,Industry_Focus__c,Industry_Vertical_Expertise__c,Infrastructure_Details__c,Is_Financials_Approved__c,Is_Partner_Published__c,Is_Primary_Public_Sector__c,Is_Top_Level_Account__c,isAccountActive__c,isOnCreditHold__c,IsPartner,issalescertification__c,IT_Budget__c,JBoss_Account_ID__c,JBoss_Middleware_Skills__c,Jigsaw,Key_Contact__c,Key_Contact_Cell_Phone__c,Key_Contact_Email__c,Key_Contact_Primary_Phone__c,Key_Contact_Secondary_Phone__c,Key_Industry_Ratios__c,Key_Obstacles__c,Known_As__c,accountUpdatedByLead,personAccountUpdatedByLead,Linkedin_URL__c,Linux_Servers__c,Location_Type__c,Market_Value__c,Marketing_Plan_Achievement_Date__c,Marketing_Plan_Received__c,Microsoft_Servers__c,Middleware_Compliance_Score__c,Middleware_Supported__c,MigrationSource__c,mkt_cl_mkt_sourced__c,mkt_cl_mkt_touched__c,Monitoring__c,NaicsCode,NaicsDesc,Name,Name_of_Partner_Accepting_Legal_T_s__c,Named_Account__c,NamedAccount__c,Net_Income__c,Net_Income_Growth__c,Num_of_End_Customer_Account__c,Number_Enrolled_Sales_Cert__c,Number_Middleware_Sales_Certs__c,Number_of_Customers__c,Number_of_RHCA_Certifications__c,Number_of_RHCE__c,Number_of_RHCSS_Certifications__c,Number_of_RHCT_Certifications__c,Number_of_Sales_Certifications__c,Number_of_Technical_Certifications__c,Number_of_Trained_JBoss_Professionals__c,Number_Platform_Sales_Certs__c,Number_Virtualization_Sales_Certs__c,NumberOfEmployees,NumberOfEmployeesInWWOrg__c,NumberOfSalesPeople__c,NumberOfServerClassSystemsInWWOrg__c,NumberOfTechnicalPeople__c,OEM_Tier__c,Offices_Locations__c,One_Year_Stock_Price_History__c,OORID__c,Open_Source_Practice__c,Operating_System_Supported__c,OracleAccountID__c,OracleAccountNumber__c,OraclePartyID__c,OraclePartyNumber__c,Organization__c,OS_Environment__c,Other_Account_ID__c,Other_Countries__c,Other_Partnerships__c,OtherHWVendor__c,Owner,Owner__c,ownerAccepted,ownerAssignment,Ownership,Ownership_Type__c,P_L__c,Parent,Partner_Account__c,Partner_Account_Status__c,Partner_Center_ID__c,Partner_Onboarding_Application__c,Partner_Points__c,Partner_Prospect_Type__c,Partner_s_Largest_Customer__c,Partner_Skill__c,Partner_Type__c,PartnerKeywords__c,PartnerStatuses__c,PaymentTerms__c,Phone,PreferredHWVendor__c,Previous_Year_Revenue__c,Primary__c,Primary_Billing_Account_Name__c,Primary_Hardware_Vendor__c,Primary_HW_Vendor_Other__c,PrimaryBillingAccountNumber__c,PrimaryBillToAcct__c,PrimaryIndustry__c,PrimaryPartnerContact__c,PrimaryPartnerUser__c,PrimaryStorageVendor__c,Products_Services__c,Profitability_vs_Industry__c,Promo_Code__c,Province__c,Public_Sector_Market__c,Purchasing_Process__c,R_D__c,Rating,Ready_Status__c,Ready_Status_Detail__c,Recent_Major_Events__c,Record_Source__c,locked,RecordType,unlocked,Recruiting_Distributor__c,Red_Hat_Agreements_on_File__c,Red_Hat_or_JBoss_certified_employees__c,RedHatSyncable__c,Referenceable__c,ReferenceStor__Import_into_ReferenceStor__c,Reminder_Date__c,Reminder_Frequency__c,Renewal_Amount__c,Renewal_Date__c,Requalification_Approver__c,Requalification_Extended__c,Requalification_Reinstated__c,Requalification_Submitter__c,RequalificationDate__c,RequalificationLatestId__c,RequalStatus__c,Revenue_to_Date__c,RH_Sales_Strategy__c,RH_Webinar_Date__c,RHNLogin__c,Sales_Certification_Acheivement_by_Date__c,Sales_Growth__c,Sales_Ops_Reviewed__c,SEA_Concern__c,Select_Specialization_s__c,Service_Area__c,Service_Offerings__c,Ship_To_Address_Conv__c,ShippingAddress,ShippingCity,ShippingCountry,ShippingLatitude,ShippingLongitude,ShippingPostalCode,ShippingState,ShippingStreet,Sic,SIC_Code__c,SicDesc,Significant_Branch_Locations__c,Site,Size_of_Companies_Targeted__c,Software_Focus__c,Software_Management__c,Sold_To_Address_Conv__c,Solution_Partners__c,Special_Programs__c,Special_Service_Offerings_or_Skills__c,State__c,State_Province__c,Status__c,Storage__c,Sub_Organization__c,Subregion__c,Subsidiary_Status__c,SubTerritory__c,Super_Industry__c,Sweet_Spot__c,Target_Market_Size__c,Target_Revenue_for_Red_Hat_yearly__c,Technical_Course_Enrolled__c,Technical_Enrollment_Achievement_by_Date__c,Technology_Solutions_Expertise__c,Territory1__c,Territorydonotuse__c,TextName,TickerSymbol,Time_and_Date_Approved__c,Toll_Free_Number__c,Top_Level_Account__c,Total_Annual_Revenue__c,Total_of_Subsidiaries_if_Parent__c,Total_Servers__c,Trade_Style__c,Tradestyle,Training_Partner_Specifications__c,True_Up_Account__c,Type,Ultimate_Parent_Account__c,Ultimate_Parent_D_U_N_S__c,Underlying_Facts__c,UNIX_Servers__c,VATNumber__c,Vertical__c,Webinar_Attending__c,Webinar_Date__c,Website,What_are_you_using_RedHat_Others_for__c,What_Markets_are_Targeted__c,Workloads_Deployed_on_Linux__c,X11i_Account_Conv__c,X11i_Party_Conv__c,YearEstablished__c,Years_in_Business__c,YearStarted,Zip_Postal_Code__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_AccountId FOREIGN KEY(AccountId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountPartner (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	AccountFromId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccountToId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OpportunityId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Role string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Advanced Partner,Chip,Distributor,ISV,OEM,Other,System Integrator,Technology,Training,Value Added Reseller'),
	IsPrimary boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ReversePartnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_AccountFromId FOREIGN KEY(AccountFromId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'AccountPartnersFrom'),
	CONSTRAINT FK_Account_AccountToId FOREIGN KEY(AccountToId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'AccountPartnersTo'),
	CONSTRAINT FK_Opportunity_OpportunityId FOREIGN KEY(OpportunityId) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'AccountPartners')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountProfile_PartnerStatus__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account_Profile__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PartnerStatus__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile__c_Account_Profile__c FOREIGN KEY(Account_Profile__c) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Account_Profile_Partner_Statuses__r'),
	CONSTRAINT FK_PartnerStatus__c_PartnerStatus__c FOREIGN KEY(PartnerStatus__c) REFERENCES PartnerStatus__c (Id) OPTIONS (NAMEINSOURCE 'AccountProfile_PartnerStatuses__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AccountProfile_PartnerStatus__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountProfile_PartnerStatus__c_ItemId FOREIGN KEY(ItemId) REFERENCES AccountProfile_PartnerStatus__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountReadOnly__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	AccountClassification__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Alias_Name__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BillingCity__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BillingCountry__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ExternalId__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Parent__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PartnerStatuses__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PrimaryBillingAccountNumber__c string(8) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Obsolete__c boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Account__c FOREIGN KEY(Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Accounts_Read_Only__r'),
	CONSTRAINT FK_Account_Parent__c FOREIGN KEY(Parent__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Account_Read_Only_Parent__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AccountReadOnly__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountReadOnly__c_ItemId FOREIGN KEY(ItemId) REFERENCES AccountReadOnly__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountRecordType__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(38) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	RecordTypeId__c string(25) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RecordTypeName__c string(50) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AccountRecordType__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountRecordType__c_ItemId FOREIGN KEY(ItemId) REFERENCES AccountRecordType__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Accounts_Special_Program__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Special_Program__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	End_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Start_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Account__c FOREIGN KEY(Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Special_Program_Junction_Objects__r'),
	CONSTRAINT FK_Special_Program__c_Special_Program__c FOREIGN KEY(Special_Program__c) REFERENCES Special_Program__c (Id) OPTIONS (NAMEINSOURCE 'Special_Program_Junction_Objects__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Accounts_Special_Program__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account__c,created,CurrencyIsoCode,End_Date__c,feedEvent,Name,ownerAccepted,ownerAssignment,locked,unlocked,Special_Program__c,Start_Date__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Accounts_Special_Program__c_ParentId FOREIGN KEY(ParentId) REFERENCES Accounts_Special_Program__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Accounts_Special_Program__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Accounts_Special_Program__c_ItemId FOREIGN KEY(ItemId) REFERENCES Accounts_Special_Program__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountShare (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	AccountId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UserOrGroupId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccountAccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'Read,Edit,All'),
	OpportunityAccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'None,Read,Edit'),
	CaseAccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'None,Read,Edit'),
	ContactAccessLevel string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'None,Read,Edit'),
	RowCause string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Owner,Manual,Rule,ImplicitChild,ImplicitParent,Team,Territory,TerritoryManual,TerritoryRule,Territory2Forecast'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_AccountId FOREIGN KEY(AccountId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Shares')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountTag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_ItemId FOREIGN KEY(ItemId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountTeamMember (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	AccountId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UserId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TeamMemberRole string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Back-Up,Business Affairs,Business Development,Channel Account Manager,Channel Marketing - EMEA,Channel Marketing Manager - Country,Cloud Rep,DA,Engagement SA,Fusesource Middleware,Inside Channel Account Manager,Inside Rep,Inside Sales Owned Opportunity,Inside SE,ISV Recruit,ISV Rep,Local Strategic Rep,Marketing Program Manager,Middleware Inside Rep,Middleware Rep,OEM Inside Sales,Opportunity Owner,Outside Rep,Outside SE,Partner,Partner Manager,Partner Relationship Manager,Partner Relationship Manager - Regional,Presales Owner,PSR,Public Cloud Tier 2 Team Rep,Public Cloud Tiger Team Rep,Rescue Team,Secondary Outside Rep,Service Delivery Manager,SI Rep,SSI Vendor Rep,SSP,Storage Rep,Strategic Account Manager,Support Relationship Manager,Technical Account Manager,Technology Development Manager,Vertical Marketing'),
	AccountAccessLevel string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'None,Read,Edit,All'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_AccountId FOREIGN KEY(AccountId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'AccountTeamMembers'),
	CONSTRAINT FK_User__UserId FOREIGN KEY(UserId) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'AccountTeams')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountTeamRule__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	AccountAccessLevel__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Read Only,Read/Write,Owner'),
	CaseAccessLevel__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Private,Read Only,Read/Write'),
	ContactAccessLevel__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Private,Read Only,Read/Write'),
	Country__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Description__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	GlobalRegion__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'NA,EMEA,APAC,LATAM'),
	IsActive__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	MatchingAccountsAuto__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	MatchingAccounts__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OpportunityAccessLevel__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Private,Read Only,Read/Write'),
	PartnerTier__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PartnerType__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Priority__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Subregion__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Unknown,Northeast,Southeast,Central,Northwest,Southwest,Canada,ANZ,ASEAN,Brazil,CE,Distributor,Fed Sled,Greater China,High Volume,Hong Kong,India,Japan,Korea,Mexico,NA,National,Taiwan,SWE,NEE,SEMEA,North Central,South Central,Mid-Atlantic,SAC'),
	TeamMemberRole__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Channel Account Manager,Channel Marketing - EMEA,Channel Marketing Manager - Country,Inside Channel Account Manager,Marketing Program Manager,Partner,Partner Manager,Partner Relationship Manager,Partner Relationship Manager - Regional'),
	User__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Classification__c_PartnerTier__c FOREIGN KEY(PartnerTier__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'AccountTeamMappingsByPartnerTier__r'),
	CONSTRAINT FK_Classification__c_PartnerType__c FOREIGN KEY(PartnerType__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'AccountTeamMappingsByPartnerType__r'),
	CONSTRAINT FK_Country__c_Country__c FOREIGN KEY(Country__c) REFERENCES Country__c (Id) OPTIONS (NAMEINSOURCE 'Account_Team_Rules__r'),
	CONSTRAINT FK_User__User__c FOREIGN KEY(User__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Account_Team_Mappings__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AccountTeamRule__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AccountAccessLevel__c,CaseAccessLevel__c,ContactAccessLevel__c,Country__c,created,CurrencyIsoCode,feedEvent,GlobalRegion__c,IsActive__c,MatchingAccountsAuto__c,Name,OpportunityAccessLevel__c,Owner,ownerAccepted,ownerAssignment,PartnerTier__c,PartnerType__c,locked,unlocked,Subregion__c,TeamMemberRole__c,User__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountTeamRule__c_ParentId FOREIGN KEY(ParentId) REFERENCES AccountTeamRule__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AccountTeamRule__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AccountTeamRule__c_ItemId FOREIGN KEY(ItemId) REFERENCES AccountTeamRule__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AcctPicklistSync__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	AccountId__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AcctPicklistSync__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AcctPicklistSync__c_ItemId FOREIGN KEY(ItemId) REFERENCES AcctPicklistSync__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Action_Items__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Teaming_Agreement__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Action_Item__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Completed__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Due_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Red_Hat_Partner_Owner__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Partner,Red Hat,Both'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Teaming_Agreement__c_Teaming_Agreement__c FOREIGN KEY(Teaming_Agreement__c) REFERENCES Teaming_Agreement__c (Id) OPTIONS (NAMEINSOURCE 'Action_Items__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Action_Items__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Action_Item__c,Completed__c,created,CurrencyIsoCode,Due_Date__c,feedEvent,Name,ownerAccepted,ownerAssignment,locked,unlocked,Red_Hat_Partner_Owner__c,Teaming_Agreement__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Action_Items__c_ParentId FOREIGN KEY(ParentId) REFERENCES Action_Items__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Action_Items__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Action_Items__c_ItemId FOREIGN KEY(ItemId) REFERENCES Action_Items__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ActivityHistory (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	AccountId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	WhoId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	WhatId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Subject string(80) OPTIONS (NATIVE_TYPE 'combobox', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsTask boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ActivityDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Status string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not Started,In Progress,Waiting for RSM,Waiting for SA,Completed,Waiting on someone else,Deferred,Triage - Credit,Triage - Finance,Triage - Sales,System Deferred,Triage - Legal,Sent,0 Day Renewal Notice'),
	Priority string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'High,Normal,Low'),
	ActivityType string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Call,Call,Email,Email,Meeting,Meeting,Other,Other'),
	IsClosed boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsAllDayEvent boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsVisibleInSelfService boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	DurationInMinutes integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Location string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CallDurationInSeconds integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CallType string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Internal,Inbound,Outbound'),
	CallDisposition string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CallObject string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ReminderDateTime timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsReminderSet boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	BestTimeToCall__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Morning,Noon,Night'),
	externalIdName__c string(30) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	RejectionReason__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '0.00 Amount not approved,Backdate Subsc Start-date,Billing/Shipping Info Missing,Billing Account Number Invalid,Billing Acct/Info Incorrect/Missing,Billing Address Incorrect,Billing Address Missing,Contract Incorrect/Missing/Unsigned,Contract Missing/Not Signed,Contract Numbers Incorrect,Contract Numbers Missing,Co-Terms Info Incorrect/Missing,Credit Card Declined,Credit Related/Payment Terms Issues,Credit Status/Payment Terms Issues,Customer Hold or Delivery Delay,Cut-Off Time Exceeded,Description Missing,Discount Not Approved,Duplicate Order,EU Login Incorrect/Missing,Finance Approval Required,Handwritten Change Not Acceptable,Incorrect Account Classification,Incorrect SKUs,Invalid RH Entitlement Login,Legal/BD Review & Approval,Legal Agreement not attached / Missing,Legal Approval,Legal Approval Required,Legal Entity Not Correct,Login/Acct # Invalid/Missing,Missing Pages,Missing Reference to Existing Agreement,Missing Signatures,Missing SKUs,New Party / Account Request,No PO Letter needs Approval,No PO Letter Required,Other,Payment Terms Missing,Payment Terms Not Approved,PO/Credit Card Info Incorrect/Missing,PO Missing,PO not attached / missing,Pricing Incorrect,Product/Discount Approval Required,Qty/Price/Products Not Equal,Renewal Dates are Incorrect/Missing,Renewal Info/Start Date Needed,Renewal Information Incorrect/Missing,Sales Mgmt or PM Approval Required,Shipping Address Incorrect,Shipping Address Missing,Shipping Info Incorrect/Missing,SKU/Qty/Currency/Price Incorrect,SKU Qty/Price/Desc Issue,Start/End Date Missing,Start Date Over 14 Days Old,Subsc Dates/Term Issue,Tax Info Missing/Incorrect,Unclear - Auto entitlement Vs Keys,VAT # Missing/Incorrect,VAT number missing/incorrect,Waiting Saba # or CM# or Others'' Info,Wrong Billing Acct#,Wrong Currency'),
	OMComments__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Prepay_Required__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	OE_Form_Printed__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Prepay_Paid__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Task_Duration__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Credit_Finance_Comments__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OM_Verified__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Strategic_Selling_Category__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Created__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Sales_Comments__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Category__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Goal,Tandem Review,Education (webinar, house fair, product presentation, workshops  etc.),Reporting (quarterly performance review, progress analysis, plain numbers),Documentation (creation of account profile, account plan, account overview etc.),Task (anything else)'),
	Requester__c string(200) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Last_Due_date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Due_date_changed_on__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Contents__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Related_Opportunity_Region__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Send_Notification__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Billing_Comments__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Actions_from_Visit__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Notes_from_Visit__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Reason_of_Visit__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OM_Comments_Continued__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OM_Comments_Final__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Call_Results__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Bad Number,Left Message,Obtained Information Needed,Scheduled Follow Up,Sent Email'),
	Partner_Comments__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Purpose__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Welcome - Schedule Initial Call,Qualification - Reselling?,Commitment - Obtainment,Commitment - Monitoring,Nurturing - Sales Activation,Nurturing - Monitoring'),
	Escalation_Stage__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Customer Identified,Waiting Customer Response,Negotiation With Customer,Proposal Approved,CIO Letter,Voluntary Assessment (Rho),Assessment (Program),Assessment (Migrate),Assessment (Terminate),Audit,Termination Letter,Certification (Migrate),Certification (Decommissioned),Certification (No Distribution ISV),Certification (Over-Deployment),Waiting PO,Sales Team Engaged,Compliance Team Engaged,Self Assessment,Self-Assessment (Migrate),Self-Assessment (Terminate)'),
	Summary__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Project_Account_Comments__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	GLS_Comments__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Age_of_Escalation_Stage__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Clearances__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'US Citizen,US DoD Secret,US DoD Top Secret,US DoD Top Secret/SCI,Other'),
	Date_Escalation_Stage_Set__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Distributor__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Carahsoft,DLT,Other,Not Applicable'),
	Legal_Comments__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Other__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Task_Source_Detail__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Task_Source__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'GSS ID,Sales ID,SEAP ID'),
	Contract_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Current_Contract__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Click Through,MSA'),
	Latest_Expiration__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Server_Environment_Size__c string(25) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Servers_Checking_In__c string(25) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Support_Tickets__c string(25) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ClosedDate__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Due_Date_Time__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Profile__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Legacy_Role__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Owner__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Monitor__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	MonitoredActivityId__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OORID__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Record_Source__c string(45) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ActionSubject__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	End__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Start__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Attendees__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Sent_To__c string(80) OPTIONS (NATIVE_TYPE 'email', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_DGRP__Dynamic_Group__c_WhatId FOREIGN KEY(WhatId) REFERENCES APPR_DGRP__Dynamic_Group__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_APPR_DGRP__Group_Rule__c_WhatId FOREIGN KEY(WhatId) REFERENCES APPR_DGRP__Group_Rule__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Account_AccountId FOREIGN KEY(AccountId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Action_Items__c_WhatId FOREIGN KEY(WhatId) REFERENCES Action_Items__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Anti_corruption__c_WhatId FOREIGN KEY(WhatId) REFERENCES Anti_corruption__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_ApprovalCustom__c_WhatId FOREIGN KEY(WhatId) REFERENCES ApprovalCustom__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Asset_WhatId FOREIGN KEY(WhatId) REFERENCES Asset (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_BigMachines__Quote__c_WhatId FOREIGN KEY(WhatId) REFERENCES BigMachines__Quote__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_CCB_Event__c_WhatId FOREIGN KEY(WhatId) REFERENCES CCB_Event__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Campaign_WhatId FOREIGN KEY(WhatId) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_CampaignTag__c_WhatId FOREIGN KEY(WhatId) REFERENCES CampaignTag__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Case__WhatId FOREIGN KEY(WhatId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Change_Management__c_WhatId FOREIGN KEY(WhatId) REFERENCES Change_Management__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Change_Request__c_WhatId FOREIGN KEY(WhatId) REFERENCES Change_Request__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Change_Requests__c_WhatId FOREIGN KEY(WhatId) REFERENCES Change_Requests__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Component__c_WhatId FOREIGN KEY(WhatId) REFERENCES Component__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Contact_WhoId FOREIGN KEY(WhoId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Contract_WhatId FOREIGN KEY(WhatId) REFERENCES Contract (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Credit__c_WhatId FOREIGN KEY(WhatId) REFERENCES Credit__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Customer_Reference__c_WhatId FOREIGN KEY(WhatId) REFERENCES Customer_Reference__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Defect_Requirement_Join__c_WhatId FOREIGN KEY(WhatId) REFERENCES Defect_Requirement_Join__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Defect__c_WhatId FOREIGN KEY(WhatId) REFERENCES Defect__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Deliverables__c_WhatId FOREIGN KEY(WhatId) REFERENCES Deliverables__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_EBS_Account__c_WhatId FOREIGN KEY(WhatId) REFERENCES EBS_Account__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Evaluation__c_WhatId FOREIGN KEY(WhatId) REFERENCES Evaluation__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_LMS_Training_Request__c_WhatId FOREIGN KEY(WhatId) REFERENCES LMS_Training_Request__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Lead_WhoId FOREIGN KEY(WhoId) REFERENCES Lead (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Lead_SuperRegion_Mapping__c_WhatId FOREIGN KEY(WhatId) REFERENCES Lead_SuperRegion_Mapping__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Marketing_Activity__c_WhatId FOREIGN KEY(WhatId) REFERENCES Marketing_Activity__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Milestone__c_WhatId FOREIGN KEY(WhatId) REFERENCES Milestone__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_MonitoredActivity__c_WhatId FOREIGN KEY(WhatId) REFERENCES MonitoredActivity__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_NFR_Request__c_WhatId FOREIGN KEY(WhatId) REFERENCES NFR_Request__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_NonPrimaryBillingAddress__c_WhatId FOREIGN KEY(WhatId) REFERENCES NonPrimaryBillingAddress__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_NonPrimaryShippingAddress__c_WhatId FOREIGN KEY(WhatId) REFERENCES NonPrimaryShippingAddress__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Opportunity_WhatId FOREIGN KEY(WhatId) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Order_Tracking__c_WhatId FOREIGN KEY(WhatId) REFERENCES Order_Tracking__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Partner_Onboarding_Registration__c_WhatId FOREIGN KEY(WhatId) REFERENCES Partner_Onboarding_Registration__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Partner_Profile__c_WhatId FOREIGN KEY(WhatId) REFERENCES Partner_Profile__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Partner_Program_Tier__c_WhatId FOREIGN KEY(WhatId) REFERENCES Partner_Program_Tier__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Partner_Registration__c_WhatId FOREIGN KEY(WhatId) REFERENCES Partner_Registration__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Product2_WhatId FOREIGN KEY(WhatId) REFERENCES Product2 (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Project_Item__c_WhatId FOREIGN KEY(WhatId) REFERENCES Project_Item__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Project_Status__c_WhatId FOREIGN KEY(WhatId) REFERENCES Project_Status__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Project__c_WhatId FOREIGN KEY(WhatId) REFERENCES Project__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Red_Hat_Attachment__c_WhatId FOREIGN KEY(WhatId) REFERENCES Red_Hat_Attachment__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Reference_Collateral__c_WhatId FOREIGN KEY(WhatId) REFERENCES Reference_Collateral__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Release__c_WhatId FOREIGN KEY(WhatId) REFERENCES Release__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Requirement__c_WhatId FOREIGN KEY(WhatId) REFERENCES Requirement__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Resource__c_WhatId FOREIGN KEY(WhatId) REFERENCES Resource__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_SFDC_Channel_Account_Plan__c_WhatId FOREIGN KEY(WhatId) REFERENCES SFDC_Channel_Account_Plan__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_SFDC_Objective__c_WhatId FOREIGN KEY(WhatId) REFERENCES SFDC_Objective__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Schedule_Exports__c_WhatId FOREIGN KEY(WhatId) REFERENCES Schedule_Exports__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Solution_WhatId FOREIGN KEY(WhatId) REFERENCES Solution (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_SteeringCommittee__c_WhatId FOREIGN KEY(WhatId) REFERENCES SteeringCommittee__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_StrategicPlan_Solution__c_WhatId FOREIGN KEY(WhatId) REFERENCES StrategicPlan_Solution__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_StrategicPlan_Strategy__c_WhatId FOREIGN KEY(WhatId) REFERENCES StrategicPlan_Strategy__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_StrategicPlan__c_WhatId FOREIGN KEY(WhatId) REFERENCES StrategicPlan__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_SubscriptionBatch__c_WhatId FOREIGN KEY(WhatId) REFERENCES SubscriptionBatch__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_SubscriptionLine__c_WhatId FOREIGN KEY(WhatId) REFERENCES SubscriptionLine__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_SubscriptionPartner__c_WhatId FOREIGN KEY(WhatId) REFERENCES SubscriptionPartner__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Subscription__c_WhatId FOREIGN KEY(WhatId) REFERENCES Subscription__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_SumTotal_Catalog__c_WhatId FOREIGN KEY(WhatId) REFERENCES SumTotal_Catalog__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Teaming_Agreement__c_WhatId FOREIGN KEY(WhatId) REFERENCES Teaming_Agreement__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Temporal_Content__c_WhatId FOREIGN KEY(WhatId) REFERENCES Temporal_Content__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Test_Case__c_WhatId FOREIGN KEY(WhatId) REFERENCES Test_Case__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Use_Case__c_WhatId FOREIGN KEY(WhatId) REFERENCES Use_Case__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Verifiable_Outcome__c_WhatId FOREIGN KEY(WhatId) REFERENCES Verifiable_Outcome__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Work_Package__c_WhatId FOREIGN KEY(WhatId) REFERENCES Work_Package__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories'),
	CONSTRAINT FK_Work_Plan__c_WhatId FOREIGN KEY(WhatId) REFERENCES Work_Plan__c (Id) OPTIONS (NAMEINSOURCE 'ActivityHistories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'false', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'false', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AdditionalNumber (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CallCenterId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Phone string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Address__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Sales_Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Address_External_Id__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Address_Line1__c string(240) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Address_Line2__c string(240) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Address_Line3__c string(240) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Address_Line4__c string(240) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Address_Lines__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Bill_To_Address__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CDH_Party_Site_Number__c string(60) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CDH_Party__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	City__c string(60) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Country__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AG,AI,AL,AN,AQ,AR,AS,AU,AW,AZ,BA,BB,BD,BF,BG,BJ,BM,BR,BS,BT,BW,BY,BZ,CC,CF,CG,CH,CK,CL,CR,CU,CX,CY,DJ,DK,DM,DZ,EE,EG,EH,ER,ET,FI,FJ,FM,FO,GB,GD,GH,GI,GM,GN,GR,GS,GT,GW,HK,HN,HR,HT,ID,IL,IO,IQ,IR,IS,IT,JP,KG,KH,KI,KM,KP,KW,KY,KZ,LA,LB,LC,LI,LT,LV,LX,LY,MD,MG,ML,MM,MN,MO,MQ,MS,MT,MU,MX,MY,MZ,NC,NE,NF,NO,NP,NR,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PN,PR,PS,PT,PW,PY,QA,RE,RO,RU,RW,SA,SB,SC,SD,SE,SG,SH,SI,SJ,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TF,TG,TH,TJ,TK,TM,TN,TO,TP,TR,TT,TV,TW,TZ,UA,UG,UM,US,UY,UZ,VA,VC,VE,VG,VI,VN,VU,WF,WS,YE,YT,YU,ZA,ZM,ZR,ZW,FR,GA,AO,BH,BV,CV,CD,DO,GF,GU,IN,KE,LR,MH,MA,NG,AE,TL,CS,CM,EC,FX,GP,HM,JM,LK,MK,MW,NU,BL,MF,AF,AD,AM,AT,BE,BO,BN,CA,CN,CI,CZ,GQ,FK,GE,GL,GY,HU,IE,JO,KR,LS,LU,MV,MR,MC,NA,NL,MP,KN,ES,RS,ME,DE,NI,BI,CO,AX,JE,GG,IM'),
	County__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Entitle_To_Address__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Identifying_Address__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Province__c string(240) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Sales_Account_Name__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Ship_To_Address__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Sold_To_Address__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	State_Province__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	State__c string(240) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Active,Inactive,Merged'),
	Zip_Postal_Code__c string(240) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Sales_Account__c FOREIGN KEY(Sales_Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Addresses__r'),
	CONSTRAINT FK_CDH_Party__c_CDH_Party__c FOREIGN KEY(CDH_Party__c) REFERENCES CDH_Party__c (Id) OPTIONS (NAMEINSOURCE 'Addresses__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Address__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Address_External_Id__c,Address_Line1__c,Address_Line2__c,Address_Line3__c,Address_Line4__c,Bill_To_Address__c,CDH_Party__c,CDH_Party_Site_Number__c,City__c,Country__c,County__c,created,CurrencyIsoCode,Entitle_To_Address__c,feedEvent,Identifying_Address__c,Name,ownerAccepted,ownerAssignment,Province__c,locked,RecordType,unlocked,Sales_Account__c,Ship_To_Address__c,Sold_To_Address__c,State__c,Status__c,Zip_Postal_Code__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Address__c_ParentId FOREIGN KEY(ParentId) REFERENCES Address__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Address__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Address__c_ItemId FOREIGN KEY(ItemId) REFERENCES Address__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AdminByPass__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsAdmin__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IsChannelLoad__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IsOppAdmin__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	AccountLockValidation__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IsBillToAdmin__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IsCaseAdmin__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IsSalesUser__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AdminByPass__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_AdminByPass__c_ItemId FOREIGN KEY(ItemId) REFERENCES AdminByPass__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AggregateResult (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'false', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'false', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Agreement__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	ActivationDate__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ActivationStatus__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ApprovalStatus__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Draft,Pending,Approved,Rejected,Declined,Archived'),
	Country__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ExpirationDate__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	IsSignatureRequired__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Number__c string(30) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	PartnerType__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Region__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'EMEA,LATAM,APAC,NA'),
	SubRegion__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ASEAN,ANZ,India,Hong Kong,Greater China,Japan,Korea,Taiwan,Northeast,Central,Southeast,Southwest,Canada,National,Fed Sled,High Volume,Distributor,Brazil,Mexico,CEE,UKI,SEMEA,NORDICS,NA,Northwest,North Central,South Central,Mid-Atlantic,SAC'),
	Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Partner,Partner & User,User'),
	Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Country_Count__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'English,Chinese,Chinese (Simplified),Korean,Japanese,Portuguese,French,Spanish'),
	Partner_Role__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Program__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Countries_Selected__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Is_Terms_Document__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Feature__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'rhel7demo-na,rhel7demo-latam,rhel7demo-apac,rhel7demo-emea'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Classification__c_PartnerType__c FOREIGN KEY(PartnerType__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'AgreementsByPartnerType__r'),
	CONSTRAINT FK_Classification__c_Partner_Role__c FOREIGN KEY(Partner_Role__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Agreements__r'),
	CONSTRAINT FK_Country__c_Country__c FOREIGN KEY(Country__c) REFERENCES Country__c (Id) OPTIONS (NAMEINSOURCE 'Agreements__r'),
	CONSTRAINT FK_Partner_Program_Definition__c_Partner_Program__c FOREIGN KEY(Partner_Program__c) REFERENCES Partner_Program_Definition__c (Id) OPTIONS (NAMEINSOURCE 'Agreements__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Agreement__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ActivationDate__c,ApprovalStatus__c,Country__c,created,CurrencyIsoCode,ExpirationDate__c,Feature__c,feedEvent,Is_Terms_Document__c,IsSignatureRequired__c,Language__c,Name,Owner,ownerAccepted,ownerAssignment,Partner_Program__c,Partner_Role__c,PartnerType__c,locked,unlocked,Region__c,SubRegion__c,Type__c,Version__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Agreement__c_ParentId FOREIGN KEY(ParentId) REFERENCES Agreement__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Agreement__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Agreement__c_ItemId FOREIGN KEY(ItemId) REFERENCES Agreement__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Agreement_Country__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Agreement__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Country__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Localization language for a specific country/agreement relationship, or null for the default language of the country'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Agreement__c_Agreement__c FOREIGN KEY(Agreement__c) REFERENCES Agreement__c (Id) OPTIONS (NAMEINSOURCE 'Agreement_Countries__r'),
	CONSTRAINT FK_Country__c_Country__c FOREIGN KEY(Country__c) REFERENCES Country__c (Id) OPTIONS (NAMEINSOURCE 'Agreement_Countries__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Agreement_Country__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Agreement_Country__c_ItemId FOREIGN KEY(ItemId) REFERENCES Agreement_Country__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Anti_corruption__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Anti_Corruption_Confirmed_By__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Anti_Corruption_Confirmed_Date_Time__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Approval_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Legal Type 1,Channel Ops Type 2,Legal Type 2,Legal Type 3,Rejection Type 1,Rejection Type 2 - Channel Ops,Rejection Type 2,Rejection Type 3'),
	DirectPurchasingAgreement__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Direct_Purchasing_Agreement__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Do_you_have_any_reason_to_believe_that_t__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Escalate_to_Level_3__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	EverConvicted__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Ever_Convicted__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	GovernmentPosition__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Government_Position__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Lead__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Needs_Level_2_Review__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Origin__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Onboarding,Requalification,Tier Upgrade'),
	Partner_Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Status__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	QuestionnaireCompletionDate_Time__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Recommended_by_government_official__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	RedFlagQuestionnaireAttached__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RedFlagQuestionnaireClear__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RedFlagQuestionnaireComplete__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Red_Flag_Confirmed_By__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Red_Flag_Confirmed_On__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Red_Flag_Status__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Rejection_Reason__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not Applicable,A,B,C,D,E,F,G'),
	Requested_Secret_Relationship__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Required_Certification_Hesitation__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Review_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'New,Legal Type 1 Review,Channel Ops Type 2 Review,Legal Type 2 Review,Legal Type 3 Review,Approved and Archived,Rejected'),
	ScreenshotAttached__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ScreenshotIAgree__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Screenshot_Attached__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Screenshot_Confirmed_By__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Screenshot_Confirmed_On__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Screenshot_I_Agree__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	TIIndex__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	TI_Indexed_Countries__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'None'),
	UnethicalBusiness__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Unusual_Payment_Terms__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	testform__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Red_Flag_Skip__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Account_Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Level_1_Bypass__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Underlying_Facts__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UnusualFinancialTerms__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'No or not applicable because new Partner,Yes'),
	RedFlagAnswersProvidedBy__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Onboarding_Channel_Ops_Addl_Concerns__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Onboarding__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Program_Approval__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	is_Onboarding_Lead__c boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Partner_Account__c FOREIGN KEY(Partner_Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption__r'),
	CONSTRAINT FK_Lead_Lead__c FOREIGN KEY(Lead__c) REFERENCES Lead (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption__r'),
	CONSTRAINT FK_PartnerStatus__c_Partner_Status__c FOREIGN KEY(Partner_Status__c) REFERENCES PartnerStatus__c (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption__r'),
	CONSTRAINT FK_Partner_Onboarding_Registration__c_Partner_Onboarding__c FOREIGN KEY(Partner_Onboarding__c) REFERENCES Partner_Onboarding_Registration__c (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption__r'),
	CONSTRAINT FK_Partner_Program_Approval__c_Partner_Program_Approval__c FOREIGN KEY(Partner_Program_Approval__c) REFERENCES Partner_Program_Approval__c (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption__r'),
	CONSTRAINT FK_User__Account_Owner__c FOREIGN KEY(Account_Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption__r'),
	CONSTRAINT FK_User__Anti_Corruption_Confirmed_By__c FOREIGN KEY(Anti_Corruption_Confirmed_By__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption2__r'),
	CONSTRAINT FK_User__RedFlagAnswersProvidedBy__c FOREIGN KEY(RedFlagAnswersProvidedBy__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption4__r'),
	CONSTRAINT FK_User__Red_Flag_Confirmed_By__c FOREIGN KEY(Red_Flag_Confirmed_By__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption1__r'),
	CONSTRAINT FK_User__Screenshot_Confirmed_By__c FOREIGN KEY(Screenshot_Confirmed_By__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Anti_Corruption3__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Anti_corruption__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account_Owner__c,Anti_Corruption_Confirmed_By__c,Anti_Corruption_Confirmed_Date_Time__c,Approval_Type__c,created,CurrencyIsoCode,Direct_Purchasing_Agreement__c,Do_you_have_any_reason_to_believe_that_t__c,Escalate_to_Level_3__c,Ever_Convicted__c,feedEvent,Government_Position__c,Lead__c,Level_1_Bypass__c,Name,Needs_Level_2_Review__c,Origin__c,Owner,ownerAccepted,ownerAssignment,Partner_Account__c,Partner_Onboarding__c,Partner_Program_Approval__c,Partner_Status__c,QuestionnaireCompletionDate_Time__c,Recommended_by_government_official__c,locked,unlocked,Red_Flag_Confirmed_By__c,Red_Flag_Confirmed_On__c,Red_Flag_Skip__c,RedFlagAnswersProvidedBy__c,RedFlagQuestionnaireComplete__c,Rejection_Reason__c,Requested_Secret_Relationship__c,Required_Certification_Hesitation__c,Review_Status__c,Screenshot_Attached__c,Screenshot_Confirmed_By__c,Screenshot_Confirmed_On__c,Screenshot_I_Agree__c,TI_Indexed_Countries__c,Underlying_Facts__c,UnethicalBusiness__c,Unusual_Payment_Terms__c,UnusualFinancialTerms__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Anti_corruption__c_ParentId FOREIGN KEY(ParentId) REFERENCES Anti_corruption__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Anti_corruption__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Anti_corruption__c_ItemId FOREIGN KEY(ItemId) REFERENCES Anti_corruption__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ApexClass (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	NamespacePrefix string(15) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Name string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ApiVersion double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Status string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Inactive,Active,Deleted'),
	IsValid boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	BodyCrc double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Body string(1000000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LengthWithoutComments integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE ApexComponent (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	NamespacePrefix string(15) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ApiVersion double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MasterLabel string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ControllerType string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '0,1,4,2,3,5'),
	ControllerKey string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Markup string(1048576) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE ApexPage (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	NamespacePrefix string(15) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ApiVersion double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MasterLabel string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ControllerType string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '0,1,4,2,3,5'),
	ControllerKey string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Markup string(1048576) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE ApexTrigger (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	NamespacePrefix string(15) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Name string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TableEnumOrId string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account,Asset,Attachment,Campaign,CampaignMember,Case,CaseComment,ChatterMessage,CollaborationGroup,CollaborationGroupMember,Contact,ContentDocument,ContentFolder,ContentVersion,Contract,DandBCompany,DuplicateRecordItem,DuplicateRecordSet,EmailMessage,Event,FeedComment,FeedItem,Idea,IdeaComment,Lead,Macro,NetworkMember,Note,Opportunity,OpportunityLineItem,OpportunitySplit,OpportunityTeamMember,Partner,Pricebook2,Product2,RecordOrigin,Solution,StreamingChannel,Task,Topic,TopicAssignment,User'),
	UsageBeforeInsert boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UsageAfterInsert boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UsageBeforeUpdate boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UsageAfterUpdate boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UsageBeforeDelete boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UsageAfterDelete boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UsageIsBulk boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UsageAfterUndelete boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ApiVersion double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Status string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Inactive,Active,Deleted'),
	IsValid boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	BodyCrc double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Body string(1000000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LengthWithoutComments integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_DGRP__Dynamic_Group__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	APPR_DGRP__Active__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APPR_DGRP__Apply_To_Portal__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Partner Portal,Customer Portal'),
	APPR_DGRP__Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_DGRP__Group_Id__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_DGRP__Group_Name__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_DGRP__Group__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_DGRP__ObjectName__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account'),
	APPR_DGRP__Role_Level__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Executive,Manager,User'),
	APPR_DGRP__Role_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Portal Role And Subordinates,Portal Role'),
	APPR_DGRP__group_members__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	External_ID__c string(50) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_DGRP__Dynamic_Group__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'APPR_DGRP__Active__c,APPR_DGRP__Apply_To_Portal__c,APPR_DGRP__Description__c,APPR_DGRP__Group_Id__c,APPR_DGRP__group_members__c,APPR_DGRP__Group_Name__c,APPR_DGRP__ObjectName__c,APPR_DGRP__Role_Level__c,APPR_DGRP__Role_Type__c,created,CurrencyIsoCode,External_ID__c,feedEvent,Name,Owner,ownerAccepted,ownerAssignment,locked,RecordType,unlocked'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_DGRP__Dynamic_Group__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_DGRP__Dynamic_Group__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_DGRP__Dynamic_Group__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_DGRP__Dynamic_Group__c_ItemId FOREIGN KEY(ItemId) REFERENCES APPR_DGRP__Dynamic_Group__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_DGRP__Group_Rule__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	APPR_DGRP__Dynamic_Group__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_DGRP__Operator__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'equals,not equals,greater than,greater or equals,less than,less or equals,contains'),
	APPR_DGRP__Record_Field__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_DGRP__Value__c string(100) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_DGRP__Dynamic_Group__c_APPR_DGRP__Dynamic_Group__c FOREIGN KEY(APPR_DGRP__Dynamic_Group__c) REFERENCES APPR_DGRP__Dynamic_Group__c (Id) OPTIONS (NAMEINSOURCE 'APPR_DGRP__Group_Rules__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_DGRP__Group_Rule__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_DGRP__Group_Rule__c_ItemId FOREIGN KEY(ItemId) REFERENCES APPR_DGRP__Group_Rule__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_PUB__Headline__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Active__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APPR_PUB__Description__c string(700) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Group_Header__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Image_Path__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Image_Url__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Link_Header__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__New_Row__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APPR_PUB__Sort_Order__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Tab__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Home,Lead,Opportunity,Documents,Cases,Tab1,Tab2,Tab3,Tab4,Tab5,Tab6,Tab7,Tab8,Certification'),
	APPR_PUB__Vertical_Stack__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APPR_PUB_XT__Language_Code__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'English,French,German,Spanish,Italian,Japanese,Swedish,Korean,Chinese (Traditional),Chinese (Simplified),Portugese (Brazilian),Dutch,Danish,Thai,Finnish,Russian'),
	APPR_PUB__Long_Description__c string OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Style_Class__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_PUB__Headline__Share (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UserOrGroupId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Read,Edit,All'),
	RowCause string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Owner,Manual,Rule,ImplicitChild,ImplicitParent,Team,Territory,TerritoryManual,TerritoryRule,Territory2Forecast'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_PUB__Headline__c (Id) OPTIONS (NAMEINSOURCE 'Shares')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_PUB__Headline__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline__c_ItemId FOREIGN KEY(ItemId) REFERENCES APPR_PUB__Headline__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_PUB__Headline_Link__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	APPR_PUB__Active__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APPR_PUB__Display_Name__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__End_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Headline_Link_Group__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Headline__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Newline__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APPR_PUB__Open_In_New_Window__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APPR_PUB__Publish__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Show_New__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APPR_PUB__Sort_Order__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Start_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__URL_Preview__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__URL__c string(120) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Language__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline_Link_Group__c_APPR_PUB__Headline_Link_Group__c FOREIGN KEY(APPR_PUB__Headline_Link_Group__c) REFERENCES APPR_PUB__Headline_Link_Group__c (Id) OPTIONS (NAMEINSOURCE 'APPR_PUB__Headline_Links__r'),
	CONSTRAINT FK_APPR_PUB__Headline__c_APPR_PUB__Headline__c FOREIGN KEY(APPR_PUB__Headline__c) REFERENCES APPR_PUB__Headline__c (Id) OPTIONS (NAMEINSOURCE 'APPR_PUB__Headline_Links__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_PUB__Headline_Link__Share (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UserOrGroupId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Read,Edit,All'),
	RowCause string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Owner,Manual,Rule,ImplicitChild,ImplicitParent,Team,Territory,TerritoryManual,TerritoryRule,Territory2Forecast'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline_Link__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_PUB__Headline_Link__c (Id) OPTIONS (NAMEINSOURCE 'Shares')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_PUB__Headline_Link__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline_Link__c_ItemId FOREIGN KEY(ItemId) REFERENCES APPR_PUB__Headline_Link__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_PUB__Headline_Link_Group__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	APPR_PUB__Headline__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Active__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APPR_PUB__Sort_Order__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Language__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Description__c string(500) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline__c_APPR_PUB__Headline__c FOREIGN KEY(APPR_PUB__Headline__c) REFERENCES APPR_PUB__Headline__c (Id) OPTIONS (NAMEINSOURCE 'APPR_PUB__Headline_Link_Groups__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_PUB__Headline_Link_Group__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline_Link_Group__c_ItemId FOREIGN KEY(ItemId) REFERENCES APPR_PUB__Headline_Link_Group__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_PUB__PortalPublisherSettings__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(38) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__LinkColor__c string(6) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__PrimaryColor__c string(6) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB__Resource_Location__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_PUB__PortalPublisherSettings__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__PortalPublisherSettings__c_ItemId FOREIGN KEY(ItemId) REFERENCES APPR_PUB__PortalPublisherSettings__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_PUB_XT__Headline_Link__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	APPR_PUB_XT__Headline_Link__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Language_Code__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'German,Spanish,English,French,Italian,Japanese,Swedish,Korean,Chinese (Traditional),Chinese (Simplified),Portugese (Brazilian),Dutch,Danish,Thai,Finnish,Russian'),
	APPR_PUB_XT__Link_Display_Name__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__URL__c string(120) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline_Link__c_APPR_PUB_XT__Headline_Link__c FOREIGN KEY(APPR_PUB_XT__Headline_Link__c) REFERENCES APPR_PUB__Headline_Link__c (Id) OPTIONS (NAMEINSOURCE 'APPR_PUB_XT__Headline_Link_Translations__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_PUB_XT__Headline_Link__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB_XT__Headline_Link__c_ItemId FOREIGN KEY(ItemId) REFERENCES APPR_PUB_XT__Headline_Link__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_PUB_XT__Headline_Link_Group_Translation__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	APPR_PUB_XT__Headline_Link_Group__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Language_Code__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'German,Spanish,English,French,Italian,Japanese,Swedish,Korean,Chinese (Traditional),Chinese (Simplified),Portugese (Brazilian),Dutch,Danish,Thai,Finnish,Russian'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline_Link_Group__c_APPR_PUB_XT__Headline_Link_Group__c FOREIGN KEY(APPR_PUB_XT__Headline_Link_Group__c) REFERENCES APPR_PUB__Headline_Link_Group__c (Id) OPTIONS (NAMEINSOURCE 'APPR_PUB_XT__Headline_Link_Group_Translations__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_PUB_XT__Headline_Link_Group_Translation__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB_XT__Headline_Link_Group_Translation__c_ItemId FOREIGN KEY(ItemId) REFERENCES APPR_PUB_XT__Headline_Link_Group_Translation__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE APPR_PUB_XT__Headline_Translation__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Headline__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Description__c string(700) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Group_Header__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Image_Path__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Image_Url__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Language_Code__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	APPR_PUB_XT__Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'German,Spanish,English,French,Italian,Japanese,Swedish,Korean,Chinese (Traditional),Chinese (Simplified),Portugese (Brazilian),Dutch,Danish,Thai,Finnish,Russian'),
	APPR_PUB_XT__Link_Header__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB__Headline__c_APPR_PUB_XT__Headline__c FOREIGN KEY(APPR_PUB_XT__Headline__c) REFERENCES APPR_PUB__Headline__c (Id) OPTIONS (NAMEINSOURCE 'APPR_PUB_XT__Headline_Translations__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE APPR_PUB_XT__Headline_Translation__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_PUB_XT__Headline_Translation__c_ItemId FOREIGN KEY(ItemId) REFERENCES APPR_PUB_XT__Headline_Translation__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Approval (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Status string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Pending,Approved,Rejected'),
	RequestComment string OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ApproveComment string OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contract_ParentId FOREIGN KEY(ParentId) REFERENCES Contract (Id) OPTIONS (NAMEINSOURCE 'Approvals')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ApprovalCustom__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Opportunity__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Quote__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	JustificationReason__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Structured/Priced to Beat/Replace Competition,Advanced Payment,Delayed Deployment of Software,New Market Penetration,Obtaining Initial Customer,Influencing Future Customers,Customer to Support Marketing Efforts,Customer to Support Development as an Alpha or Beta Site,Discount from Previous/Long Standing Agreement,Discount Based on Multi-Year Sales w/ No Contingencies,Large Quantities of Products Bundled w/ Professional Consulting and/or Training Services,Customer Instrumental w/ product Enhancement/Bug Fixes,Other'),
	JustificationReasonNotes__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ApprovalStatus__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'New,In Review,Approved,Denied,Submitted to BA,Negotiations Started,Signed,Closed - Lost'),
	AssignApprovalTo__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PaymentTermsRequested__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Credit Card,Due On Receipt,30 NET,45 NET,Special'),
	ApprovedBy__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ApprovedByOther__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ApprovalNotes__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PaymentTermsApproved__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '30 NET,IMMEDIATE,Credit Card,Due On Receipt,40 Net,35 NET,Prepayment Reqd,EOM +1,EOM +2,10 NET,15 NET,45 NET,50 NET,60 NET,EOM +60,EOM Next Month,90 NET,75 NET,EOM+30,EOM+40,EOM+45,EOM+60,EOM+120,EOM+90,CO10th+40,CO15th+60,CO20th+45,CO25th+40,105 NET,120 NET,160 NET,180 NET,215 NET,360 NET,68 NET,EOAP + 50'),
	BillingAccountNumberApprovedOn__c string(30) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BillingAccountNameApprovedOn__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DeniedReason__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DateMovedInReviewStatus__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DateMovedDecisionStatus__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaysinNewStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HoursinNewStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaysinInReviewStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HoursinInReviewStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DateMovedSubmittedBAStatus__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaysinApprovedStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HoursinApprovedStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DateMovedNegotiationsStatus__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaysinSubmittedtoBAStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HoursinSubmittedtoBAStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DateMovedOppDecisionStatus__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaysinNegotiationsStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HoursinNegotiationsStatus__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaystillDecision__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaystillSubmittedtoBA__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaystillNegotiationsStarted__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaystillOppDecision__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HourstillDecision__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HourstillSubmittedtoBA__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HourstillNegotiationsStarted__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HourstillOppDecision__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PricingDiscountRequested__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PricingDiscountApproved__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Quote__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BigMachines__Quote__c_BigMachines_Quote__c FOREIGN KEY(BigMachines_Quote__c) REFERENCES BigMachines__Quote__c (Id) OPTIONS (NAMEINSOURCE 'Approvals__r'),
	CONSTRAINT FK_Opportunity_Opportunity__c FOREIGN KEY(Opportunity__c) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'ApprovalCustom__r'),
	CONSTRAINT FK_Quote__c_Quote__c FOREIGN KEY(Quote__c) REFERENCES Quote__c (Id) OPTIONS (NAMEINSOURCE 'ApprovalCustom__r'),
	CONSTRAINT FK_User__ApprovedBy__c FOREIGN KEY(ApprovedBy__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'ApprovalCustom1__r'),
	CONSTRAINT FK_User__AssignApprovalTo__c FOREIGN KEY(AssignApprovalTo__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'ApprovalCustom__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE ApprovalCustom__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_ApprovalCustom__c_ItemId FOREIGN KEY(ItemId) REFERENCES ApprovalCustom__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Assessment_Summary__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account_Profile__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Assessment_Summary__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile__c_Account_Profile__c FOREIGN KEY(Account_Profile__c) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Account_Manager_Summary__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Assessment_Summary__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Assessment_Summary__c_ItemId FOREIGN KEY(ItemId) REFERENCES Assessment_Summary__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Asset (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContactId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccountId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Product2Id string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsCompetitorProduct boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Name string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SerialNumber string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	InstallDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	PurchaseDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UsageEndDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Status string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Shipped,Installed,Registered,Obsolete,Purchased'),
	Price double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Quantity double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_AccountId FOREIGN KEY(AccountId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Assets'),
	CONSTRAINT FK_Contact_ContactId FOREIGN KEY(ContactId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Assets'),
	CONSTRAINT FK_Product2_Product2Id FOREIGN KEY(Product2Id) REFERENCES Product2 (Id) OPTIONS (NAMEINSOURCE 'Assets')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AssetFeed (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeedPostId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'TrackedChange,UserStatus,TextPost,AdvancedTextPost,LinkPost,ContentPost,PollPost,RypplePost,ProfileSkillPost,DashboardComponentSnapshot,ApprovalPost,CaseCommentPost,ReplyPost,EmailMessageEvent,CallLogPost,ChangeStatusPost,AttachArticleEvent,MilestoneEvent,ActivityEvent,ChatTranscriptPost,CollaborationGroupCreated,CollaborationGroupUnarchived,SocialPost,QuestionPost,FacebookPost,BasicTemplateFeedItem,CreateRecordEvent,CanvasPost,AnnouncementPost'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Asset_ParentId FOREIGN KEY(ParentId) REFERENCES Asset (Id) OPTIONS (NAMEINSOURCE 'Feeds')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AssetHistory (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	AssetId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account,Contact,created,CurrencyIsoCode,Description,feedEvent,InstallDate,IsCompetitorProduct,Name,ownerAccepted,ownerAssignment,Price,Product2,PurchaseDate,Quantity,locked,unlocked,SerialNumber,Status,UsageEndDate'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Asset_AssetId FOREIGN KEY(AssetId) REFERENCES Asset (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AssetTag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Asset_ItemId FOREIGN KEY(ItemId) REFERENCES Asset (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE AssignmentRule (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(120) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SobjectType string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Case,Lead'),
	Active boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE AsyncApexJob (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	JobType string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Future,SharingRecalculation,ScheduledApex,BatchApex,BatchApexWorker,TestRequest,TestWorker,ApexToken,Queueable'),
	ApexClassId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Status string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Queued,Processing,Aborted,Completed,Failed,Preparing,Holding'),
	JobItemsProcessed integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TotalJobItems integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfErrors integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CompletedDate timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MethodName string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Attachment (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Name string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsPrivate boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContentType string(120) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BodyLength integer OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Body blob OPTIONS (NATIVE_TYPE 'base64', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Description string(500) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_APPR_DGRP__Dynamic_Group__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_DGRP__Dynamic_Group__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_APPR_DGRP__Group_Rule__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_DGRP__Group_Rule__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_APPR_PUB_XT__Headline_Link_Group_Translation__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_PUB_XT__Headline_Link_Group_Translation__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_APPR_PUB_XT__Headline_Link__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_PUB_XT__Headline_Link__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_APPR_PUB_XT__Headline_Translation__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_PUB_XT__Headline_Translation__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_APPR_PUB__Headline_Link_Group__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_PUB__Headline_Link_Group__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_APPR_PUB__Headline_Link__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_PUB__Headline_Link__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_APPR_PUB__Headline__c_ParentId FOREIGN KEY(ParentId) REFERENCES APPR_PUB__Headline__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Account_ParentId FOREIGN KEY(ParentId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_AccountCatalogRelationship__c_ParentId FOREIGN KEY(ParentId) REFERENCES AccountCatalogRelationship__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_AccountChangeRequestField__c_ParentId FOREIGN KEY(ParentId) REFERENCES AccountChangeRequestField__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_AccountChangeRequest__c_ParentId FOREIGN KEY(ParentId) REFERENCES AccountChangeRequest__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_AccountHierarchy__c_ParentId FOREIGN KEY(ParentId) REFERENCES AccountHierarchy__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_AccountProfile_PartnerStatus__c_ParentId FOREIGN KEY(ParentId) REFERENCES AccountProfile_PartnerStatus__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_AccountReadOnly__c_ParentId FOREIGN KEY(ParentId) REFERENCES AccountReadOnly__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_AccountTeamRule__c_ParentId FOREIGN KEY(ParentId) REFERENCES AccountTeamRule__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Account_Profile_Other_Partner__c_ParentId FOREIGN KEY(ParentId) REFERENCES Account_Profile_Other_Partner__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Account_Profile_Power_Map__c_ParentId FOREIGN KEY(ParentId) REFERENCES Account_Profile_Power_Map__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Account_Profile_SWOT__c_ParentId FOREIGN KEY(ParentId) REFERENCES Account_Profile_SWOT__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Account_Profile__c_ParentId FOREIGN KEY(ParentId) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Account_SWOT_Analysis__c_ParentId FOREIGN KEY(ParentId) REFERENCES Account_SWOT_Analysis__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Accounts_Special_Program__c_ParentId FOREIGN KEY(ParentId) REFERENCES Accounts_Special_Program__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_AcctPicklistSync__c_ParentId FOREIGN KEY(ParentId) REFERENCES AcctPicklistSync__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Action_Items__c_ParentId FOREIGN KEY(ParentId) REFERENCES Action_Items__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Address__c_ParentId FOREIGN KEY(ParentId) REFERENCES Address__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Agreement_Country__c_ParentId FOREIGN KEY(ParentId) REFERENCES Agreement_Country__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Agreement__c_ParentId FOREIGN KEY(ParentId) REFERENCES Agreement__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Anti_corruption__c_ParentId FOREIGN KEY(ParentId) REFERENCES Anti_corruption__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ApprovalCustom__c_ParentId FOREIGN KEY(ParentId) REFERENCES ApprovalCustom__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Assessment_Summary__c_ParentId FOREIGN KEY(ParentId) REFERENCES Assessment_Summary__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Asset_ParentId FOREIGN KEY(ParentId) REFERENCES Asset (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Audience_Account__c_ParentId FOREIGN KEY(ParentId) REFERENCES Audience_Account__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Audience__c_ParentId FOREIGN KEY(ParentId) REFERENCES Audience__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFAC_Shared_View__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFAC_Shared_View__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFCS_Carousel__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFCS_Carousel__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFCS_Slide__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFCS_Slide__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFDT_Action_Item__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFDT_Action_Item__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFDT_Discussion__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFDT_Discussion__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFDT_Highlight__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFDT_Highlight__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFDT_Issue__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFDT_Issue__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFDT_Linker__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFDT_Linker__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFDT_Project__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFDT_Project__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFDT_Resource__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFDT_Resource__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFDT_Task__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFDT_Task__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFFF_Form__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFFF_Form__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFFF_Page__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFFF_Page__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFTE_Expense__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFTE_Expense__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFTE_Time__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFTE_Time__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFTT_Document__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFTT_Document__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFTT_Entity_Info__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFTT_Entity_Info__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BLND_DFTT_Folder__c_ParentId FOREIGN KEY(ParentId) REFERENCES BLND_DFTT_Folder__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BigMachines__Configuration_Record__c_ParentId FOREIGN KEY(ParentId) REFERENCES BigMachines__Configuration_Record__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BigMachines__Field_Mapping__c_ParentId FOREIGN KEY(ParentId) REFERENCES BigMachines__Field_Mapping__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BigMachines__Quote_Product__c_ParentId FOREIGN KEY(ParentId) REFERENCES BigMachines__Quote_Product__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BigMachines__Quote__c_ParentId FOREIGN KEY(ParentId) REFERENCES BigMachines__Quote__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BillToAccount__c_ParentId FOREIGN KEY(ParentId) REFERENCES BillToAccount__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Busines_Plan_KPI__c_ParentId FOREIGN KEY(ParentId) REFERENCES Busines_Plan_KPI__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_BusinessPlan_MktResource__c_ParentId FOREIGN KEY(ParentId) REFERENCES BusinessPlan_MktResource__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Business_Plan_Customer__c_ParentId FOREIGN KEY(ParentId) REFERENCES Business_Plan_Customer__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Business_Problem__c_ParentId FOREIGN KEY(ParentId) REFERENCES Business_Problem__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CCB_Event__c_ParentId FOREIGN KEY(ParentId) REFERENCES CCB_Event__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CDH_Party__c_ParentId FOREIGN KEY(ParentId) REFERENCES CDH_Party__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CR_Components_Join__c_ParentId FOREIGN KEY(ParentId) REFERENCES CR_Components_Join__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CTSK_INSP__Field_Statistic__c_ParentId FOREIGN KEY(ParentId) REFERENCES CTSK_INSP__Field_Statistic__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CTSK_INSP__Object_Statistic__c_ParentId FOREIGN KEY(ParentId) REFERENCES CTSK_INSP__Object_Statistic__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Campaign_ParentId FOREIGN KEY(ParentId) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CampaignTag__c_ParentId FOREIGN KEY(ParentId) REFERENCES CampaignTag__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Campaign_Hierarchy_Details__c_ParentId FOREIGN KEY(ParentId) REFERENCES Campaign_Hierarchy_Details__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Campaign_Plan__c_ParentId FOREIGN KEY(ParentId) REFERENCES Campaign_Plan__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Case__ParentId FOREIGN KEY(ParentId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CaseCommentData__c_ParentId FOREIGN KEY(ParentId) REFERENCES CaseCommentData__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CasePriorityTotals__c_ParentId FOREIGN KEY(ParentId) REFERENCES CasePriorityTotals__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CasePriority__c_ParentId FOREIGN KEY(ParentId) REFERENCES CasePriority__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Change_Control_Board__c_ParentId FOREIGN KEY(ParentId) REFERENCES Change_Control_Board__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Change_Management__c_ParentId FOREIGN KEY(ParentId) REFERENCES Change_Management__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Change_Request_Members__c_ParentId FOREIGN KEY(ParentId) REFERENCES Change_Request_Members__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Change_Request__c_ParentId FOREIGN KEY(ParentId) REFERENCES Change_Request__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Change_Requests__c_ParentId FOREIGN KEY(ParentId) REFERENCES Change_Requests__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ClassificationTranslation__c_ParentId FOREIGN KEY(ParentId) REFERENCES ClassificationTranslation__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Classification__c_ParentId FOREIGN KEY(ParentId) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Communities_Featured_Headline_Label__c_ParentId FOREIGN KEY(ParentId) REFERENCES Communities_Featured_Headline_Label__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Communities_Featured_Headline__c_ParentId FOREIGN KEY(ParentId) REFERENCES Communities_Featured_Headline__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Communities_Navigation_Item_Label__c_ParentId FOREIGN KEY(ParentId) REFERENCES Communities_Navigation_Item_Label__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Communities_Navigation_Item__c_ParentId FOREIGN KEY(ParentId) REFERENCES Communities_Navigation_Item__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Communities_News_Item_Label__c_ParentId FOREIGN KEY(ParentId) REFERENCES Communities_News_Item_Label__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Communities_News_Item__c_ParentId FOREIGN KEY(ParentId) REFERENCES Communities_News_Item__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Communities_Tool_Shortcut_Label__c_ParentId FOREIGN KEY(ParentId) REFERENCES Communities_Tool_Shortcut_Label__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Communities_Tool_Shortcut__c_ParentId FOREIGN KEY(ParentId) REFERENCES Communities_Tool_Shortcut__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Competitor__c_ParentId FOREIGN KEY(ParentId) REFERENCES Competitor__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Component__c_ParentId FOREIGN KEY(ParentId) REFERENCES Component__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Configuration__c_ParentId FOREIGN KEY(ParentId) REFERENCES Configuration__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Contact_ParentId FOREIGN KEY(ParentId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Contact_Converter__c_ParentId FOREIGN KEY(ParentId) REFERENCES Contact_Converter__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Contact_Reference_Request__c_ParentId FOREIGN KEY(ParentId) REFERENCES Contact_Reference_Request__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Contact_Tool_Shortcut__c_ParentId FOREIGN KEY(ParentId) REFERENCES Contact_Tool_Shortcut__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Contact_Track__c_ParentId FOREIGN KEY(ParentId) REFERENCES Contact_Track__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Contract_ParentId FOREIGN KEY(ParentId) REFERENCES Contract (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_CountryTranslation__c_ParentId FOREIGN KEY(ParentId) REFERENCES CountryTranslation__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Country__c_ParentId FOREIGN KEY(ParentId) REFERENCES Country__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Credit__c_ParentId FOREIGN KEY(ParentId) REFERENCES Credit__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Customer_Reference_Product__c_ParentId FOREIGN KEY(ParentId) REFERENCES Customer_Reference_Product__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Customer_Reference__c_ParentId FOREIGN KEY(ParentId) REFERENCES Customer_Reference__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Defect_Requirement_Join__c_ParentId FOREIGN KEY(ParentId) REFERENCES Defect_Requirement_Join__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Defect__c_ParentId FOREIGN KEY(ParentId) REFERENCES Defect__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Deliverables__c_ParentId FOREIGN KEY(ParentId) REFERENCES Deliverables__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_EBS_Account__c_ParentId FOREIGN KEY(ParentId) REFERENCES EBS_Account__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ELOQUA__Campaign_s_Marketing_Asset__c_ParentId FOREIGN KEY(ParentId) REFERENCES ELOQUA__Campaign_s_Marketing_Asset__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ELOQUA__Marketing_Activity__c_ParentId FOREIGN KEY(ParentId) REFERENCES ELOQUA__Marketing_Activity__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ELOQUA__Marketing_Asset__c_ParentId FOREIGN KEY(ParentId) REFERENCES ELOQUA__Marketing_Asset__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_EmailMessage_ParentId FOREIGN KEY(ParentId) REFERENCES EmailMessage (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_EmailTemplate_ParentId FOREIGN KEY(ParentId) REFERENCES EmailTemplate (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Environment__c_ParentId FOREIGN KEY(ParentId) REFERENCES Environment__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Evaluation__c_ParentId FOREIGN KEY(ParentId) REFERENCES Evaluation__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Event_ParentId FOREIGN KEY(ParentId) REFERENCES Event (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Event_Log__c_ParentId FOREIGN KEY(ParentId) REFERENCES Event_Log__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Event__c_ParentId FOREIGN KEY(ParentId) REFERENCES Event__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Executive_Summary__c_ParentId FOREIGN KEY(ParentId) REFERENCES Executive_Summary__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Expiring_Product__c_ParentId FOREIGN KEY(ParentId) REFERENCES Expiring_Product__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Featured_Partner__c_ParentId FOREIGN KEY(ParentId) REFERENCES Featured_Partner__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_FiscalGoals__c_ParentId FOREIGN KEY(ParentId) REFERENCES FiscalGoals__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Hashes__c_ParentId FOREIGN KEY(ParentId) REFERENCES Hashes__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Inbound_Event__c_ParentId FOREIGN KEY(ParentId) REFERENCES Inbound_Event__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Key_Joint_Sales_Engagement__c_ParentId FOREIGN KEY(ParentId) REFERENCES Key_Joint_Sales_Engagement__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_LMS_Training_Request__c_ParentId FOREIGN KEY(ParentId) REFERENCES LMS_Training_Request__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Lead_ParentId FOREIGN KEY(ParentId) REFERENCES Lead (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_LeadAccountRules__c_ParentId FOREIGN KEY(ParentId) REFERENCES LeadAccountRules__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_LeadCountryMap__c_ParentId FOREIGN KEY(ParentId) REFERENCES LeadCountryMap__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_LeadCronRoutingRule__c_ParentId FOREIGN KEY(ParentId) REFERENCES LeadCronRoutingRule__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_LeadForReporting__c_ParentId FOREIGN KEY(ParentId) REFERENCES LeadForReporting__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_LeadManagementHistory__c_ParentId FOREIGN KEY(ParentId) REFERENCES LeadManagementHistory__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_LeadRules__c_ParentId FOREIGN KEY(ParentId) REFERENCES LeadRules__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_LeadShareStaging__c_ParentId FOREIGN KEY(ParentId) REFERENCES LeadShareStaging__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Lead_Source_Detail__c_ParentId FOREIGN KEY(ParentId) REFERENCES Lead_Source_Detail__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Lead_SuperRegion_Mapping__c_ParentId FOREIGN KEY(ParentId) REFERENCES Lead_SuperRegion_Mapping__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Link_to_Paid_Opportunity__c_ParentId FOREIGN KEY(ParentId) REFERENCES Link_to_Paid_Opportunity__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Marketing_Activity__c_ParentId FOREIGN KEY(ParentId) REFERENCES Marketing_Activity__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Marketing_Program__c_ParentId FOREIGN KEY(ParentId) REFERENCES Marketing_Program__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Match_and_Validation_Error__c_ParentId FOREIGN KEY(ParentId) REFERENCES Match_and_Validation_Error__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Messaging_Strategy__c_ParentId FOREIGN KEY(ParentId) REFERENCES Messaging_Strategy__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Milestone__c_ParentId FOREIGN KEY(ParentId) REFERENCES Milestone__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_MonitoredActivity__c_ParentId FOREIGN KEY(ParentId) REFERENCES MonitoredActivity__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_NFR_LI__c_ParentId FOREIGN KEY(ParentId) REFERENCES NFR_LI__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_NFR_Request__c_ParentId FOREIGN KEY(ParentId) REFERENCES NFR_Request__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_NFR_SKU_Matrix__c_ParentId FOREIGN KEY(ParentId) REFERENCES NFR_SKU_Matrix__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_NonPrimaryBillingAddress__c_ParentId FOREIGN KEY(ParentId) REFERENCES NonPrimaryBillingAddress__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_NonPrimaryShippingAddress__c_ParentId FOREIGN KEY(ParentId) REFERENCES NonPrimaryShippingAddress__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Opportunities_Special_Program__c_ParentId FOREIGN KEY(ParentId) REFERENCES Opportunities_Special_Program__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Opportunity_ParentId FOREIGN KEY(ParentId) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_OpportunityPartner__c_ParentId FOREIGN KEY(ParentId) REFERENCES OpportunityPartner__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_OpportunityProductSummary__c_ParentId FOREIGN KEY(ParentId) REFERENCES OpportunityProductSummary__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_OpportunitySnapshot__c_ParentId FOREIGN KEY(ParentId) REFERENCES OpportunitySnapshot__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_OpportunityTeamMemberClone__c_ParentId FOREIGN KEY(ParentId) REFERENCES OpportunityTeamMemberClone__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Opportunity_Header_Staging__c_ParentId FOREIGN KEY(ParentId) REFERENCES Opportunity_Header_Staging__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Opportunity_History__c_ParentId FOREIGN KEY(ParentId) REFERENCES Opportunity_History__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Opportunity_Line_Staging__c_ParentId FOREIGN KEY(ParentId) REFERENCES Opportunity_Line_Staging__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Opportunity_Match_Configuration__c_ParentId FOREIGN KEY(ParentId) REFERENCES Opportunity_Match_Configuration__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Opportunity_Partner_Staging__c_ParentId FOREIGN KEY(ParentId) REFERENCES Opportunity_Partner_Staging__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Opportunity_Partners__c_ParentId FOREIGN KEY(ParentId) REFERENCES Opportunity_Partners__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Opportunity_Split_Detail__c_ParentId FOREIGN KEY(ParentId) REFERENCES Opportunity_Split_Detail__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Order_Loader_Batch__c_ParentId FOREIGN KEY(ParentId) REFERENCES Order_Loader_Batch__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Order_Management_Profile__c_ParentId FOREIGN KEY(ParentId) REFERENCES Order_Management_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Order_Tracking__c_ParentId FOREIGN KEY(ParentId) REFERENCES Order_Tracking__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Outbound_Error__c_ParentId FOREIGN KEY(ParentId) REFERENCES Outbound_Error__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Outbound_Event__c_ParentId FOREIGN KEY(ParentId) REFERENCES Outbound_Event__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PCSearchForm__c_ParentId FOREIGN KEY(ParentId) REFERENCES PCSearchForm__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PFSearchForm__c_ParentId FOREIGN KEY(ParentId) REFERENCES PFSearchForm__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_Account_Points__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_Account_Points__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_Batch__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_Batch__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_Cap__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_Cap__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_Catalog__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_Catalog__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_ContentBatchStage__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_ContentBatchStage__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_ContentStage__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_ContentStage__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_Content_Workspace__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_Content_Workspace__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_Content__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_Content__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_InboundBatchItemStage__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_InboundBatchItemStage__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_InboundBatchStage__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_InboundBatchStage__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_ItemAudit__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_ItemAudit__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_LMS_Stage__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_LMS_Stage__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_Scores__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_Scores__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PP_User_Points__c_ParentId FOREIGN KEY(ParentId) REFERENCES PP_User_Points__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerAgreement__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerAgreement__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerClassification__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerClassification__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerLogo__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerLogo__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerProductClassification__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerProductClassification__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerProductLanguage__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerProductLanguage__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerProductLogo__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerProductLogo__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerProductScreenshot__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerProductScreenshot__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerProduct__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerProduct__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerRequalification__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerRequalification__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerStatus__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerStatus__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerTopCustomer__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerTopCustomer__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerTrack__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerTrack__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerTraining__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerTraining__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_PartnerUser_Email_Token__c_ParentId FOREIGN KEY(ParentId) REFERENCES PartnerUser_Email_Token__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Attachment__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Attachment__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_CCP_Form__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_CCP_Form__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Location__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Location__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Onboarding_Registration__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Onboarding_Registration__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Point_Requal_Limits__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Point_Requal_Limits__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Points_LMS_Catalog__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Points_LMS_Catalog__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Points_Requal_Req__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Points_Requal_Req__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Profile__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Program_Approval__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Program_Approval__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Program_Definition__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Program_Definition__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Program_Description__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Program_Description__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Program_Product__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Program_Product__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Program_Tier__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Program_Tier__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Program__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Program__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Registration_Line_Item__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Registration_Line_Item__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Registration__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Registration__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Requal_Points__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Requal_Points__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Requal_Setup__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Requal_Setup__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Requalification_Agreement__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Requalification_Agreement__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_Requalification_Log__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_Requalification_Log__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_User_Invitation__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_User_Invitation__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_s_Assessment_Summary__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_s_Assessment_Summary__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_s_Business_Problem__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_s_Business_Problem__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_s_Competitor__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_s_Competitor__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Partner_s_Messaging_Strategy__c_ParentId FOREIGN KEY(ParentId) REFERENCES Partner_s_Messaging_Strategy__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Potential_Matched_Opportunities__c_ParentId FOREIGN KEY(ParentId) REFERENCES Potential_Matched_Opportunities__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Priority__c_ParentId FOREIGN KEY(ParentId) REFERENCES Priority__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Product2_ParentId FOREIGN KEY(ParentId) REFERENCES Product2 (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Project_Item__c_ParentId FOREIGN KEY(ParentId) REFERENCES Project_Item__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Project_Status__c_ParentId FOREIGN KEY(ParentId) REFERENCES Project_Status__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Project_Tracker__c_ParentId FOREIGN KEY(ParentId) REFERENCES Project_Tracker__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Project__c_ParentId FOREIGN KEY(ParentId) REFERENCES Project__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_QuoteLineItemSchedule__c_ParentId FOREIGN KEY(ParentId) REFERENCES QuoteLineItemSchedule__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_QuoteLineItem__c_ParentId FOREIGN KEY(ParentId) REFERENCES QuoteLineItem__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_QuotePaymentSchedule__c_ParentId FOREIGN KEY(ParentId) REFERENCES QuotePaymentSchedule__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Quote__c_ParentId FOREIGN KEY(ParentId) REFERENCES Quote__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_RH_Content__c_ParentId FOREIGN KEY(ParentId) REFERENCES RH_Content__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_RH_Microsite_Page__c_ParentId FOREIGN KEY(ParentId) REFERENCES RH_Microsite_Page__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_RH_Microsite__c_ParentId FOREIGN KEY(ParentId) REFERENCES RH_Microsite__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Rally_User__c_ParentId FOREIGN KEY(ParentId) REFERENCES Rally_User__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_RecordLookup__c_ParentId FOREIGN KEY(ParentId) REFERENCES RecordLookup__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_RecordTypeAssignment__c_ParentId FOREIGN KEY(ParentId) REFERENCES RecordTypeAssignment__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Red_Hat_Attachment__c_ParentId FOREIGN KEY(ParentId) REFERENCES Red_Hat_Attachment__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ReferenceStor__Rs_Account_HistoryDetail__c_ParentId FOREIGN KEY(ParentId) REFERENCES ReferenceStor__Rs_Account_HistoryDetail__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ReferenceStor__Rs_Account_History__c_ParentId FOREIGN KEY(ParentId) REFERENCES ReferenceStor__Rs_Account_History__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ReferenceStor__Rs_Opportunity_HistoryDetail__c_ParentId FOREIGN KEY(ParentId) REFERENCES ReferenceStor__Rs_Opportunity_HistoryDetail__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ReferenceStor__Rs_Opportunity_History__c_ParentId FOREIGN KEY(ParentId) REFERENCES ReferenceStor__Rs_Opportunity_History__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Reference_Collateral__c_ParentId FOREIGN KEY(ParentId) REFERENCES Reference_Collateral__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Reference_Usage__c_ParentId FOREIGN KEY(ParentId) REFERENCES Reference_Usage__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Region_NA__c_ParentId FOREIGN KEY(ParentId) REFERENCES Region_NA__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Region__c_ParentId FOREIGN KEY(ParentId) REFERENCES Region__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Reject_Lead_Setup__c_ParentId FOREIGN KEY(ParentId) REFERENCES Reject_Lead_Setup__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Related_Case__c_ParentId FOREIGN KEY(ParentId) REFERENCES Related_Case__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Release__c_ParentId FOREIGN KEY(ParentId) REFERENCES Release__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_RemoteAccess__c_ParentId FOREIGN KEY(ParentId) REFERENCES RemoteAccess__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Request_Tracker__c_ParentId FOREIGN KEY(ParentId) REFERENCES Request_Tracker__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Requirement__c_ParentId FOREIGN KEY(ParentId) REFERENCES Requirement__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Reseller__c_ParentId FOREIGN KEY(ParentId) REFERENCES Reseller__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Resource__c_ParentId FOREIGN KEY(ParentId) REFERENCES Resource__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Role_Interest_Training_Matrix__c_ParentId FOREIGN KEY(ParentId) REFERENCES Role_Interest_Training_Matrix__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SFDC_Budget_Item__c_ParentId FOREIGN KEY(ParentId) REFERENCES SFDC_Budget_Item__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SFDC_Budget__c_ParentId FOREIGN KEY(ParentId) REFERENCES SFDC_Budget__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SFDC_Channel_Account_Plan__c_ParentId FOREIGN KEY(ParentId) REFERENCES SFDC_Channel_Account_Plan__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SFDC_MDF_Claim__c_ParentId FOREIGN KEY(ParentId) REFERENCES SFDC_MDF_Claim__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SFDC_MDF__c_ParentId FOREIGN KEY(ParentId) REFERENCES SFDC_MDF__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SFDC_Objective__c_ParentId FOREIGN KEY(ParentId) REFERENCES SFDC_Objective__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SFDC_Plan_Resource_Association__c_ParentId FOREIGN KEY(ParentId) REFERENCES SFDC_Plan_Resource_Association__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SalesPortalContent__c_ParentId FOREIGN KEY(ParentId) REFERENCES SalesPortalContent__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Sales_Comments__c_ParentId FOREIGN KEY(ParentId) REFERENCES Sales_Comments__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Schedule_Exports__c_ParentId FOREIGN KEY(ParentId) REFERENCES Schedule_Exports__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_ServicesAllocation__c_ParentId FOREIGN KEY(ParentId) REFERENCES ServicesAllocation__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Solution_ParentId FOREIGN KEY(ParentId) REFERENCES Solution (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SolutionProduct__c_ParentId FOREIGN KEY(ParentId) REFERENCES SolutionProduct__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Special_Program__c_ParentId FOREIGN KEY(ParentId) REFERENCES Special_Program__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StateProvinceTranslation__c_ParentId FOREIGN KEY(ParentId) REFERENCES StateProvinceTranslation__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_State__c_ParentId FOREIGN KEY(ParentId) REFERENCES State__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Status_Reports__c_ParentId FOREIGN KEY(ParentId) REFERENCES Status_Reports__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SteeringCommittee__c_ParentId FOREIGN KEY(ParentId) REFERENCES SteeringCommittee__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StoryBookLinkLabel__c_ParentId FOREIGN KEY(ParentId) REFERENCES StoryBookLinkLabel__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StoryBookLink__c_ParentId FOREIGN KEY(ParentId) REFERENCES StoryBookLink__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Storybook__c_ParentId FOREIGN KEY(ParentId) REFERENCES Storybook__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StrategicPlan_Action__c_ParentId FOREIGN KEY(ParentId) REFERENCES StrategicPlan_Action__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StrategicPlan_OppProdSummary__c_ParentId FOREIGN KEY(ParentId) REFERENCES StrategicPlan_OppProdSummary__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StrategicPlan_ReviewHistory__c_ParentId FOREIGN KEY(ParentId) REFERENCES StrategicPlan_ReviewHistory__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StrategicPlan_Review__c_ParentId FOREIGN KEY(ParentId) REFERENCES StrategicPlan_Review__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StrategicPlan_SolutionOpportunity__c_ParentId FOREIGN KEY(ParentId) REFERENCES StrategicPlan_SolutionOpportunity__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StrategicPlan_Solution__c_ParentId FOREIGN KEY(ParentId) REFERENCES StrategicPlan_Solution__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StrategicPlan_Strategy__c_ParentId FOREIGN KEY(ParentId) REFERENCES StrategicPlan_Strategy__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_StrategicPlan__c_ParentId FOREIGN KEY(ParentId) REFERENCES StrategicPlan__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SubscriptionBatch__c_ParentId FOREIGN KEY(ParentId) REFERENCES SubscriptionBatch__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SubscriptionError__c_ParentId FOREIGN KEY(ParentId) REFERENCES SubscriptionError__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SubscriptionLine__c_ParentId FOREIGN KEY(ParentId) REFERENCES SubscriptionLine__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SubscriptionPartnerRelationship__c_ParentId FOREIGN KEY(ParentId) REFERENCES SubscriptionPartnerRelationship__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SubscriptionPartner__c_ParentId FOREIGN KEY(ParentId) REFERENCES SubscriptionPartner__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SubscriptionReportCriteria__c_ParentId FOREIGN KEY(ParentId) REFERENCES SubscriptionReportCriteria__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Subscription__c_ParentId FOREIGN KEY(ParentId) REFERENCES Subscription__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SumTotal_Catalog__c_ParentId FOREIGN KEY(ParentId) REFERENCES SumTotal_Catalog__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SumTotal_Request__c_ParentId FOREIGN KEY(ParentId) REFERENCES SumTotal_Request__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SumTotal_Setting__c_ParentId FOREIGN KEY(ParentId) REFERENCES SumTotal_Setting__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_SumTotal_Training__c_ParentId FOREIGN KEY(ParentId) REFERENCES SumTotal_Training__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Super_Industry__c_ParentId FOREIGN KEY(ParentId) REFERENCES Super_Industry__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Task_ParentId FOREIGN KEY(ParentId) REFERENCES Task (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Teaming_Agreement__c_ParentId FOREIGN KEY(ParentId) REFERENCES Teaming_Agreement__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Temporal_Content__c_ParentId FOREIGN KEY(ParentId) REFERENCES Temporal_Content__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Test_Case_Result__c_ParentId FOREIGN KEY(ParentId) REFERENCES Test_Case_Result__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Test_Case_Step__c_ParentId FOREIGN KEY(ParentId) REFERENCES Test_Case_Step__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Test_Case__c_ParentId FOREIGN KEY(ParentId) REFERENCES Test_Case__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_TrackingEventLog__c_ParentId FOREIGN KEY(ParentId) REFERENCES TrackingEventLog__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_TrackingEventSummary__c_ParentId FOREIGN KEY(ParentId) REFERENCES TrackingEventSummary__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_TrackingEvent__c_ParentId FOREIGN KEY(ParentId) REFERENCES TrackingEvent__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_TrendData__c_ParentId FOREIGN KEY(ParentId) REFERENCES TrendData__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Use_Case_Step__c_ParentId FOREIGN KEY(ParentId) REFERENCES Use_Case_Step__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Use_Case__c_ParentId FOREIGN KEY(ParentId) REFERENCES Use_Case__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_User_Agreement__c_ParentId FOREIGN KEY(ParentId) REFERENCES User_Agreement__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_VendorCatalog__c_ParentId FOREIGN KEY(ParentId) REFERENCES VendorCatalog__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Verifiable_Outcome__c_ParentId FOREIGN KEY(ParentId) REFERENCES Verifiable_Outcome__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Work_Package__c_ParentId FOREIGN KEY(ParentId) REFERENCES Work_Package__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_Work_Plan__c_ParentId FOREIGN KEY(ParentId) REFERENCES Work_Plan__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_dupcerts__c_ParentId FOREIGN KEY(ParentId) REFERENCES dupcerts__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_hoopla__Hoopla_Error_Log__c_ParentId FOREIGN KEY(ParentId) REFERENCES hoopla__Hoopla_Error_Log__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_hoopla__Notification_Queue__c_ParentId FOREIGN KEY(ParentId) REFERENCES hoopla__Notification_Queue__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_hoopla__Player__c_ParentId FOREIGN KEY(ParentId) REFERENCES hoopla__Player__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_hoopla__Position_Role__c_ParentId FOREIGN KEY(ParentId) REFERENCES hoopla__Position_Role__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_hoopla__Position__c_ParentId FOREIGN KEY(ParentId) REFERENCES hoopla__Position__c (Id) OPTIONS (NAMEINSOURCE 'Attachments'),
	CONSTRAINT FK_hoopla__Scoreboard_Role__c_ParentId FOREIGN KEY(ParentId) REFERENCES hoopla__Scoreboard_Role__c (Id) OPTIONS (NAMEINSOURCE 'Attachments')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Audience__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Available_to_Unauthenticated_Users__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Partner_Program__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'All'),
	Partner_Region__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_SubRegion__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Tier__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Type__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Permission_Set_Id__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Permission_Set__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Profile_Id__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Profile__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Role__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Target_Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Country__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Specialization__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Target_Account__c FOREIGN KEY(Target_Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Audiences__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Audience__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Audience__c_ItemId FOREIGN KEY(ItemId) REFERENCES Audience__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Audience_Account__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Audience__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Account__c FOREIGN KEY(Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Audience_Accounts__r'),
	CONSTRAINT FK_Audience__c_Audience__c FOREIGN KEY(Audience__c) REFERENCES Audience__c (Id) OPTIONS (NAMEINSOURCE 'Audience_Accounts__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Audience_Account__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Audience_Account__c_ItemId FOREIGN KEY(ItemId) REFERENCES Audience_Account__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BigMachines__Commerce_Settings__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Administrator_Email__c string(80) OPTIONS (NATIVE_TYPE 'email', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Allow_Orphan_Creation__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Allow_Quotes_on_Accounts__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Display_Page_Header__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__First_Quote_Is_Primary__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Optimize_Synchronization__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Preserve_Ad_Hoc_Products__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Use_Opportunity_Currency__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Use_Opportunity_Pricebook__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Encrypt_API_Password__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Width_Adjustment__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BigMachines__Commerce_Settings__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BigMachines__Commerce_Settings__c_ItemId FOREIGN KEY(ItemId) REFERENCES BigMachines__Commerce_Settings__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BigMachines__Configuration_Record__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__API_Login__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__API_Password__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Is_Primary__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Uses_SSL__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__action_id_copy__c string(12) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__action_id_open__c string(12) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__bm_site__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__document_id__c string(12) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__process__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__process_id__c string(12) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__version_id__c string(12) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BigMachines__Configuration_Record__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BigMachines__Configuration_Record__c_ItemId FOREIGN KEY(ItemId) REFERENCES BigMachines__Configuration_Record__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BigMachines__Field_Mapping__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Configuration_Record__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Object_Mapping__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Quote -> Opportunity,Quote Product -> Opportunity Product'),
	BigMachines__Source_Field_Label__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Source_Field_Name__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Target_Field_Label__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Target_Field_Name__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BigMachines__Configuration_Record__c_BigMachines__Configuration_Record__c FOREIGN KEY(BigMachines__Configuration_Record__c) REFERENCES BigMachines__Configuration_Record__c (Id) OPTIONS (NAMEINSOURCE 'BigMachines__BigMachines_Field_Mappings__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BigMachines__Field_Mapping__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BigMachines__Field_Mapping__c_ItemId FOREIGN KEY(ItemId) REFERENCES BigMachines__Field_Mapping__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BigMachines__Quote__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Is_Forced_Sync__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Is_Primary__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Opportunity__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Prep_Sync__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Pricebook_Id__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Process_Sync__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Status__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Total_Amount__c double OPTIONS (UPDATABLE FALSE, CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Total__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Transaction_Id__c string(30) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Amount__c double OPTIONS (UPDATABLE FALSE, CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Line_Items__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Override_Yearly_Payments__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines_Pay_Now__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines_Year1_Payment_Amount__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Year2_Payment_Amount__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Year3_Payment_Amount__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Year4_Payment_Amount__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Year5_Payment_Amount__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Year6_Payment_Amount__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Contract_End_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Contract_Start_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PayNow__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'No,Yes'),
	Term_of_Contract__c string(5) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	QuoteUpdateInfo__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Price_Override_Reason__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'No Override Reason,Approved $0 Subsc,Customer Satisfaction Issue,Deal Reg,Distributor/Reseller,Govt or Edu discount,MSA,NAT,Other,Price Rounding,Special Bid,Special Product/Program Discount,New Pricing Structure,Buffer/True-up,Upgrade,Volume Discount,Multi-element Discount,Competitive,Multi-Payment Discount'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_BigMachines__Account__c FOREIGN KEY(BigMachines__Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'BigMachines__BigMachines_Quotes__r'),
	CONSTRAINT FK_Opportunity_BigMachines__Opportunity__c FOREIGN KEY(BigMachines__Opportunity__c) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'BigMachines__BigMachines_Quotes__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BigMachines__Quote__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'BigMachines__Account__c,BigMachines__Description__c,BigMachines__Is_Forced_Sync__c,BigMachines__Is_Primary__c,BigMachines__Opportunity__c,BigMachines__Prep_Sync__c,BigMachines__Pricebook_Id__c,BigMachines__Process_Sync__c,BigMachines__Status__c,BigMachines__Total__c,BigMachines__Transaction_Id__c,BigMachines_Override_Yearly_Payments__c,BigMachines_Pay_Now__c,BigMachines_Year1_Payment_Amount__c,BigMachines_Year2_Payment_Amount__c,BigMachines_Year3_Payment_Amount__c,BigMachines_Year4_Payment_Amount__c,BigMachines_Year5_Payment_Amount__c,BigMachines_Year6_Payment_Amount__c,Contract_End_Date__c,Contract_Start_Date__c,created,CurrencyIsoCode,feedEvent,Name,Owner,ownerAccepted,ownerAssignment,PayNow__c,Price_Override_Reason__c,QuoteUpdateInfo__c,locked,RecordType,unlocked,Term_of_Contract__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BigMachines__Quote__c_ParentId FOREIGN KEY(ParentId) REFERENCES BigMachines__Quote__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BigMachines__Quote__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BigMachines__Quote__c_ItemId FOREIGN KEY(ItemId) REFERENCES BigMachines__Quote__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BigMachines__Quote_Product__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Quote__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__External_Id__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Prep_Delete__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BigMachines__Product__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Quantity__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Sales_Price__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Synchronization_Id__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines__Total_Price__c double OPTIONS (UPDATABLE FALSE, CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Actual_End_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Actual_Start_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Configured_sku__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Contract_Number__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Scheduled_Locked__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	YearlySalesPrice__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	New_or_Renewal__c string(25) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Big_Machines_List_Price__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Adjusted_Price__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BigMachines_Line_ID__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Discretionary_Discount_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '$,%'),
	Discretionary_Discount__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Entitle_To_Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Entitle_To_Address__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Entitle_To_Contact__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Entitle_To_Sales_Account__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Install_Base_Number__c string(100) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Line_Item_Source__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'application/vnd.redhat.sforce.channelload.apac,application/vnd.redhat.sforce.channelload.emea,application/vnd.redhat.sforce.channelload.na,application/vnd.redhat.sforce.quotebuilder'),
	MSRP__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Price_Override_Reason__c string(50) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Pricing_Adjustments__c string(65536) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Product_1st_Year_Booking__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Product_2nd_Year_Booking__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Product_3rd_Year_Booking__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Product_4th_Year_Booking__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Product_5th_Year_Booking__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Product_6th_Year_Booking__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	oneTimeDiscountAmount__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	postDiscretionaryPreOneTimeTotal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	unitSellingPriceAfterDiscounts__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UpdateInfo__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Entitle_To_Sales_Account__c FOREIGN KEY(Entitle_To_Sales_Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'BigMachines_Quote_Products__r'),
	CONSTRAINT FK_Address__c_Entitle_To_Address__c FOREIGN KEY(Entitle_To_Address__c) REFERENCES Address__c (Id) OPTIONS (NAMEINSOURCE 'BigMachines_Quote_Products__r'),
	CONSTRAINT FK_BigMachines__Quote__c_BigMachines__Quote__c FOREIGN KEY(BigMachines__Quote__c) REFERENCES BigMachines__Quote__c (Id) OPTIONS (NAMEINSOURCE 'BigMachines__BigMachines_Quote_Products__r'),
	CONSTRAINT FK_Contact_Entitle_To_Contact__c FOREIGN KEY(Entitle_To_Contact__c) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'BigMachines_Quote_Products__r'),
	CONSTRAINT FK_EBS_Account__c_Entitle_To_Account__c FOREIGN KEY(Entitle_To_Account__c) REFERENCES EBS_Account__c (Id) OPTIONS (NAMEINSOURCE 'BigMachines_Quote_Products__r'),
	CONSTRAINT FK_Product2_BigMachines__Product__c FOREIGN KEY(BigMachines__Product__c) REFERENCES Product2 (Id) OPTIONS (NAMEINSOURCE 'BigMachines__BigMachines_Quote_Products__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BigMachines__Quote_Product__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BigMachines__Quote_Product__c_ItemId FOREIGN KEY(ItemId) REFERENCES BigMachines__Quote_Product__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BillToAccount__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Active_Flag__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Bill_To_Account_Number__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Channel_Code__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Direct - Carahsoft,Direct - DLT,Direct - End Customer,Direct - GTSI,Direct - immixGroup,Direct - OEM,Direct - VAR/VAD,Indirect - Internal Commissions Credit,Indirect - OEM Preload,Indirect - VAR/VAD,Indirect - Webstore'),
	Channel_Load_Tab__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Korea,India,Japan,ANZ,ASEAN,GCG,CPP,Public Sector,Comm,CCP,OEM-Tier2'),
	Channel__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Region__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'APAC,EMEA,LATAM,NA'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BillToAccount__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BillToAccount__c_ItemId FOREIGN KEY(ItemId) REFERENCES BillToAccount__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFAC_Shared_View__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Application__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Data__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Private__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_User__BLND_Owner__c FOREIGN KEY(BLND_Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxGuEAK__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFAC_Shared_View__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFAC_Shared_View__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFAC_Shared_View__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFCS_Carousel__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Bookmark__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Data__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Flag1__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag2__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag3__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag4__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Height__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Lastopen__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Locked__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Over1__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over2__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over3__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Private__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Presentation,Notebook,Address Book,Dashboard,To Do List,Report'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Width__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFCS_Slide__c_BLND_Bookmark__c FOREIGN KEY(BLND_Bookmark__c) REFERENCES BLND_DFCS_Slide__c (Id) OPTIONS (NAMEINSOURCE 'Carousels__r'),
	CONSTRAINT FK_BLND_DFCS_Slide__c_BLND_Lastopen__c FOREIGN KEY(BLND_Lastopen__c) REFERENCES BLND_DFCS_Slide__c (Id) OPTIONS (NAMEINSOURCE 'Carousels1__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFCS_Carousel__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFCS_Carousel__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFCS_Carousel__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFCS_Slide__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Carousel__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Data__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Flag1__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag2__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag3__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag4__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Index__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Keywords__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Locked__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Over1__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over2__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over3__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Private__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Introduction,Body,Conclusion'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFCS_Carousel__c_BLND_Carousel__c FOREIGN KEY(BLND_Carousel__c) REFERENCES BLND_DFCS_Carousel__c (Id) OPTIONS (NAMEINSOURCE 'Slides__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFCS_Slide__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFCS_Slide__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFCS_Slide__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFDT_Action_Item__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Action_Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Due__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Include_in_Report__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Issue_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Project_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not Started,In Progress,Completed'),
	BLND_Task_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Issue__c_BLND_Issue_Link__c FOREIGN KEY(BLND_Issue_Link__c) REFERENCES BLND_DFDT_Issue__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxEsEAK__r'),
	CONSTRAINT FK_BLND_DFDT_Project__c_BLND_Project_Link__c FOREIGN KEY(BLND_Project_Link__c) REFERENCES BLND_DFDT_Project__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxECEA0__r'),
	CONSTRAINT FK_BLND_DFDT_Task__c_BLND_Task_Link__c FOREIGN KEY(BLND_Task_Link__c) REFERENCES BLND_DFDT_Task__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxE6EAK__r'),
	CONSTRAINT FK_User__BLND_Action_Owner__c FOREIGN KEY(BLND_Action_Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxHDEA0__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFDT_Action_Item__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Action_Item__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFDT_Action_Item__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFDT_Discussion__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Attachment_Link__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Body__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Purpose__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFDT_Discussion__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Discussion__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFDT_Discussion__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFDT_Highlight__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Highlight_Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Include_in_Report__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Include_in_Weekly_Dashboard__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Priority__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Medium,Low,High'),
	BLND_Project_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Project__c_BLND_Project_Link__c FOREIGN KEY(BLND_Project_Link__c) REFERENCES BLND_DFDT_Project__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxFgEAK__r'),
	CONSTRAINT FK_User__BLND_Highlight_Owner__c FOREIGN KEY(BLND_Highlight_Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxE1EAK__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFDT_Highlight__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Highlight__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFDT_Highlight__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFDT_Issue__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Impact__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Include_in_Report__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Issue_Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Issue_Raised_On__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Priority__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Medium,High,Low'),
	BLND_Project_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Resolution__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Resolve_By__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Severity__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Medium,High,Low'),
	BLND_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not Started,In Progress,Resolved'),
	BLND_Task_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Issue,Risk'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Project__c_BLND_Project_Link__c FOREIGN KEY(BLND_Project_Link__c) REFERENCES BLND_DFDT_Project__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxDhEAK__r'),
	CONSTRAINT FK_BLND_DFDT_Task__c_BLND_Task_Link__c FOREIGN KEY(BLND_Task_Link__c) REFERENCES BLND_DFDT_Task__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxGTEA0__r'),
	CONSTRAINT FK_User__BLND_Issue_Owner__c FOREIGN KEY(BLND_Issue_Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxDJEA0__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFDT_Issue__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Issue__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFDT_Issue__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFDT_Linker__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Destination_Link__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Purpose__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Source_Link__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFDT_Linker__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Linker__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFDT_Linker__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFDT_Project__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Account_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Archive__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Complete_Tasks__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Complete__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Cost_Baseline__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Cost__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Duration_In_Business_Days__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Duration_In_Calendar_Days__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Finish_Baseline__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Finish__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Folder_Link__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Opportunity_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Priority__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Revenue_Baseline__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Revenue__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Schedule_Override__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Schedule__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Start_Baseline__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Start__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Professional Services,Product Development,Event Planning,Marketing Campaign,Sales Campaign,Technical Support,Customer Engagement,Sales Operations,Sales Infrastructure,Shared Infrastructure,Web Development,Customer Success Campaign'),
	BLND_Vacation_List__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Weight__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Work_In_Actual_Hours__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Work_In_Planned_Hours__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Workday_List__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_BLND_Account_Link__c FOREIGN KEY(BLND_Account_Link__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxGzEAK__r'),
	CONSTRAINT FK_Opportunity_BLND_Opportunity_Link__c FOREIGN KEY(BLND_Opportunity_Link__c) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxHGEA0__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFDT_Project__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Project__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFDT_Project__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFDT_Resource__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Approval__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Archive__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Attachment_Link__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Billing_Cost_Per_Day__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Billing_Cost_Per_Use__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Billing_Hourly_Rate__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Billing_Overtime_Rate__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Cost_Per_Day__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Cost_Per_Use__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Hourly_Rate__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Overtime_Rate__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Project_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Purpose__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Skill_Certification__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cisco Certified Internetwork Expert,Certified Lotus Professional,Certified Lotus Specialist,Certified Novell Administrator,Certified Novell Engineer,Certified Solaris Administrator,Microsoft Certified Database Administrator,Microsoft Certified Professional,Microsoft Certified Solutions Developer,Microsoft Certified Systems Engineer,Novell Certified Internet Professional,Oracle Certified Professional,Project Management Professional'),
	BLND_Skill_Level__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'None,Beginner,Intermediate,Advanced,Expert'),
	BLND_Skill_Set__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'None,Auditor,Business Analyst,Consultant,Customer Relations,Database Administrator,Developer,Lead Developer,Engineer,Lead Engineer,Network Administrator,Project Manager,Senior Consultant,Senior Database Administrator,Senior Developer,Task Manager,Technical Architect,Technical Lead,Web Master,Technical Writer,QA Engineer'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Project__c_BLND_Project_Link__c FOREIGN KEY(BLND_Project_Link__c) REFERENCES BLND_DFDT_Project__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxGaEAK__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFDT_Resource__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Resource__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFDT_Resource__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFDT_Task__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Approval__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Archive__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Billable_Task__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Complete__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Constraint_Date__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Constraint_Type__c string(160) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Cost_Baseline__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Cost__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Dependent__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Units,Work,Duration'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Duration_In_Business_Days__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Duration_In_Calendar_Days__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Duration__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Finish_Baseline__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Finish__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Index__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Link__c string(160) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Project_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Resources__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Revenue_Baseline__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Revenue__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Schedule__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Start_Baseline__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Start__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Subtask__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Tabs__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Low Priority,Standard,High Priority,Critical'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Work_In_Actual_Hours__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Work_In_Planned_Hours__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Work__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Project__c_BLND_Project_Link__c FOREIGN KEY(BLND_Project_Link__c) REFERENCES BLND_DFDT_Project__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxFBEA0__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFDT_Task__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFDT_Task__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFDT_Task__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFFF_Form__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Bookmark__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Data__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Flag1__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag2__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag3__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag4__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Height__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Lastopen__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Locked__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Over1__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over2__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over3__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Private__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Invoice,Order,Proposal,Contract,Worksheet'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Width__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFFF_Page__c_BLND_Bookmark__c FOREIGN KEY(BLND_Bookmark__c) REFERENCES BLND_DFFF_Page__c (Id) OPTIONS (NAMEINSOURCE 'Forms1__r'),
	CONSTRAINT FK_BLND_DFFF_Page__c_BLND_Lastopen__c FOREIGN KEY(BLND_Lastopen__c) REFERENCES BLND_DFFF_Page__c (Id) OPTIONS (NAMEINSOURCE 'Forms__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFFF_Form__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFFF_Form__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFFF_Form__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFFF_Page__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Data__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Flag1__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag2__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag3__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag4__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Form__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Index__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Keywords__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Locked__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Over1__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over2__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over3__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Private__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Introduction,Conclusion,Signatures,Content'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFFF_Form__c_BLND_Form__c FOREIGN KEY(BLND_Form__c) REFERENCES BLND_DFFF_Form__c (Id) OPTIONS (NAMEINSOURCE 'Pages__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFFF_Page__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFFF_Page__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFFF_Page__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFTE_Expense__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Account_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Amount__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Attachment_Link__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Billable__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Billed_Flag__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Case_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Contact_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Note__c string(1000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Opportunity_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Project_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Saved,Submitted,Approved,Rejected,Paid'),
	BLND_Submitted__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Task_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'No Expense Type,Transportation,Lodging,Meals,Equipment purchase'),
	BLND_User_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_BLND_Account_Link__c FOREIGN KEY(BLND_Account_Link__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxFWEA0__r'),
	CONSTRAINT FK_BLND_DFDT_Project__c_BLND_Project_Link__c FOREIGN KEY(BLND_Project_Link__c) REFERENCES BLND_DFDT_Project__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxEuEAK__r'),
	CONSTRAINT FK_BLND_DFDT_Task__c_BLND_Task_Link__c FOREIGN KEY(BLND_Task_Link__c) REFERENCES BLND_DFDT_Task__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxEAEA0__r'),
	CONSTRAINT FK_Case__BLND_Case_Link__c FOREIGN KEY(BLND_Case_Link__c) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxEFEA0__r'),
	CONSTRAINT FK_Contact_BLND_Contact_Link__c FOREIGN KEY(BLND_Contact_Link__c) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxDDEA0__r'),
	CONSTRAINT FK_Opportunity_BLND_Opportunity_Link__c FOREIGN KEY(BLND_Opportunity_Link__c) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxDaEAK__r'),
	CONSTRAINT FK_User__BLND_User_Link__c FOREIGN KEY(BLND_User_Link__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxGMEA0__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFTE_Expense__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFTE_Expense__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFTE_Expense__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFTE_Time__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Account_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Attachment_Link__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Billable__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Billed_Flag__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Case_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Contact_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Note__c string(1000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Opportunity_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Project_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Saved,Submitted,Approved,Rejected'),
	BLND_Submitted__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Task_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Time_Units__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Hours,Minutes'),
	BLND_Time__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'No Task Type,Project Task,Sales Support,Training & Education,Practice Development,Internal Meeting,Performance Management,Enterprise Account Support,General Administration,Paid Time Off,Recruiting and Interviewing,Instructing,Tom work'),
	BLND_User_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Version__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_BLND_Account_Link__c FOREIGN KEY(BLND_Account_Link__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxDWEA0__r'),
	CONSTRAINT FK_BLND_DFDT_Project__c_BLND_Project_Link__c FOREIGN KEY(BLND_Project_Link__c) REFERENCES BLND_DFDT_Project__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxGjEAK__r'),
	CONSTRAINT FK_BLND_DFDT_Task__c_BLND_Task_Link__c FOREIGN KEY(BLND_Task_Link__c) REFERENCES BLND_DFDT_Task__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxFtEAK__r'),
	CONSTRAINT FK_Case__BLND_Case_Link__c FOREIGN KEY(BLND_Case_Link__c) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxG1EAK__r'),
	CONSTRAINT FK_Contact_BLND_Contact_Link__c FOREIGN KEY(BLND_Contact_Link__c) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxFSEA0__r'),
	CONSTRAINT FK_Opportunity_BLND_Opportunity_Link__c FOREIGN KEY(BLND_Opportunity_Link__c) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxDbEAK__r'),
	CONSTRAINT FK_User__BLND_User_Link__c FOREIGN KEY(BLND_User_Link__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxFGEA0__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFTE_Time__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFTE_Time__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFTE_Time__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFTT_Document__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Data__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Flag1__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag2__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag3__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag4__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Folder_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over1__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over2__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Over3__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Filter,List,Snapshot,Webpage'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFTT_Folder__c_BLND_Folder_Link__c FOREIGN KEY(BLND_Folder_Link__c) REFERENCES BLND_DFTT_Folder__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxElEAK__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFTT_Document__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFTT_Document__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFTT_Document__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFTT_Entity_Info__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Data__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Flag1__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag2__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag3__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag4__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'RecentlyCreated,RecentlyModified,RecentlyViewed'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFTT_Entity_Info__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFTT_Entity_Info__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFTT_Entity_Info__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BLND_DFTT_Folder__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	BLND_Access_List__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Expansion__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Extra_Field__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLND_Flag1__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag2__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag3__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Flag4__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	BLND_Folder_Link__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFTT_Folder__c_BLND_Folder_Link__c FOREIGN KEY(BLND_Folder_Link__c) REFERENCES BLND_DFTT_Folder__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000002UxFjEAK__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BLND_DFTT_Folder__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BLND_DFTT_Folder__c_ItemId FOREIGN KEY(ItemId) REFERENCES BLND_DFTT_Folder__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BooleanSetting__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(38) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Value__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BooleanSetting__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BooleanSetting__c_ItemId FOREIGN KEY(ItemId) REFERENCES BooleanSetting__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BrandTemplate (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	DeveloperName string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsActive boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Description string(1000) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Value_ string(32000) OPTIONS (NAMEINSOURCE 'Value', SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NamespacePrefix string(15) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Budget_Status_Mapping__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(38) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Image_URL__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Budget_Status_Mapping__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Budget_Status_Mapping__c_ItemId FOREIGN KEY(ItemId) REFERENCES Budget_Status_Mapping__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Busines_Plan_KPI__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Business_Plan__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q1_Deal_Registration_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q1_Pipeline_Creation_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q1_Revenue_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q1_Sales_Certification_Attainment_Goal__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q1_Teaming_Agreement_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q1_Tech_Certification_Attainment_Goal__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q2_Deal_Registration_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q2_Pipeline_Creation_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q2_Revenue_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q2_Sales_Certification_Attainment_Goal__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q2_Teaming_Agreement_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q2_Tech_Certification_Attainment_Goal__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q3_Deal_Registration_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q3_Pipeline_Creation_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q3_Revenue_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q3_Sales_Certification_Attainment_Goal__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q3_Teaming_Agreement_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q3_Tech_Certification_Attainment_Goal__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q4_Deal_Registration_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q4_Pipeline_Creation_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q4_Revenue_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q4_Sales_Certification_Attainment_Goal__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q4_Teaming_Agreement_Goal__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Q4_Tech_Certification_Attainment_Goal__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_SFDC_Channel_Account_Plan__c_Business_Plan__c FOREIGN KEY(Business_Plan__c) REFERENCES SFDC_Channel_Account_Plan__c (Id) OPTIONS (NAMEINSOURCE 'Business_Plan_KPI__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Busines_Plan_KPI__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Busines_Plan_KPI__c_ItemId FOREIGN KEY(ItemId) REFERENCES Busines_Plan_KPI__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Business_Plan_Customer__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Business_Plan__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Customer_Name__c string(120) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Delivering_All_Tech__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Technology_Goal__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'OS,Middleware,Cloud,Virtualization,Storage'),
	Technology__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'OS,Middleware,Cloud,Virtualization,Storage'),
	Willing_to_Influence__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_SFDC_Channel_Account_Plan__c_Business_Plan__c FOREIGN KEY(Business_Plan__c) REFERENCES SFDC_Channel_Account_Plan__c (Id) OPTIONS (NAMEINSOURCE 'Business_Plan_Customers__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Business_Plan_Customer__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Business_Plan_Customer__c_ItemId FOREIGN KEY(ItemId) REFERENCES Business_Plan_Customer__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Business_Problem__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Proposed_Solution__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Competitive_Alternatives__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Does_this_Account_have_a_Proposal__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Decision_Makers__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Win_Loss_Analysis__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Is_this_part_of_an_RFP_Response__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Account_Profile__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Description_Business_Problem__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile__c_Account_Profile__c FOREIGN KEY(Account_Profile__c) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Potential_Opportunity__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Business_Problem__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Business_Problem__c_ItemId FOREIGN KEY(ItemId) REFERENCES Business_Problem__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BusinessHours (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsActive boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDefault boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	SundayStartTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SundayEndTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MondayStartTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MondayEndTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TuesdayStartTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TuesdayEndTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	WednesdayStartTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	WednesdayEndTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ThursdayStartTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ThursdayEndTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FridayStartTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FridayEndTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SaturdayStartTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SaturdayEndTime time OPTIONS (NATIVE_TYPE 'time', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TimeZoneSidKey string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Pacific/Kiritimati,Pacific/Chatham,Pacific/Auckland,Pacific/Enderbury,Pacific/Tongatapu,Asia/Kamchatka,Pacific/Fiji,Pacific/Norfolk,Australia/Lord_Howe,Australia/Sydney,Pacific/Guadalcanal,Australia/Adelaide,Australia/Brisbane,Australia/Darwin,Asia/Seoul,Asia/Tokyo,Asia/Hong_Kong,Asia/Kuala_Lumpur,Asia/Manila,Asia/Shanghai,Asia/Singapore,Asia/Taipei,Australia/Perth,Asia/Bangkok,Asia/Ho_Chi_Minh,Asia/Jakarta,Asia/Rangoon,Asia/Dhaka,Asia/Kathmandu,Asia/Colombo,Asia/Kolkata,Asia/Karachi,Asia/Tashkent,Asia/Yekaterinburg,Asia/Kabul,Asia/Dubai,Asia/Tbilisi,Asia/Tehran,Africa/Nairobi,Asia/Baghdad,Asia/Kuwait,Asia/Riyadh,Europe/Minsk,Europe/Moscow,Africa/Cairo,Africa/Johannesburg,Asia/Jerusalem,Europe/Athens,Europe/Bucharest,Europe/Helsinki,Europe/Istanbul,Africa/Algiers,Europe/Amsterdam,Europe/Berlin,Europe/Brussels,Europe/Paris,Europe/Prague,Europe/Rome,Europe/Dublin,Europe/Lisbon,Europe/London,GMT,Atlantic/Cape_Verde,Atlantic/South_Georgia,America/St_Johns,America/Argentina/Buenos_Aires,America/Halifax,America/Santiago,America/Sao_Paulo,Atlantic/Bermuda,America/Indiana/Indianapolis,America/New_York,America/Puerto_Rico,America/Caracas,America/Bogota,America/Chicago,America/Lima,America/Panama,America/Denver,America/El_Salvador,America/Mexico_City,America/Los_Angeles,America/Phoenix,America/Tijuana,America/Anchorage,Pacific/Honolulu,Pacific/Niue,Pacific/Pago_Pago'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BusinessPlan_MktResource__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Business_Plan__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Contact__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Contact__c FOREIGN KEY(Contact__c) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Business_Plan_Marketing_Resources__r'),
	CONSTRAINT FK_SFDC_Channel_Account_Plan__c_Business_Plan__c FOREIGN KEY(Business_Plan__c) REFERENCES SFDC_Channel_Account_Plan__c (Id) OPTIONS (NAMEINSOURCE 'Business_Plan_Marketing_Resources__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE BusinessPlan_MktResource__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_BusinessPlan_MktResource__c_ItemId FOREIGN KEY(ItemId) REFERENCES BusinessPlan_MktResource__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE BusinessProcess (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NamespacePrefix string(15) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TableEnumOrId string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Case,Lead,Opportunity,Solution'),
	IsActive boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CallCenter (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	InternalName string(240) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Version double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Campaign (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Advertisement,Advertising,Affiliate Link,Analyst Paper,Assessment,Awareness,Banner,Banner Ad,Billboard,Billboard Ad,Blog Ad,Blog Post / Web Page,Booth Visit,Brief,Brochure,Calculator,Case Study,Catalog,Contact Sales,Content Syndication,Conversation,Datasheet,Demand Creation,Demo,Direct Mail,Display Ad,Email,Email Link,Evaluation,Event,Executive Event,External List,FAQ,Google Adwords,Homepage Promo,In-person Event,Internal List,JBoss Web inquiry,Launch,Magazine Ad,Newsletter,Nurture,Offline,Onpage Promo,Onpage Widget,Onsite Promo,Other,Paid Search,Partner Content Syndication,Partner Event,Podcast,Pre-Qualification,Pricing Promotion,Print Ad,Regional Event,Reputation,Sales Enablement,Search,Site Registration,Social Media,Social Media Follow / Like,Sponsored Event,Sponsored Link,Sponsorship,Survey,Telemarketing,Text Link,Tradeshow,Trade Show,Training,Video,Virtual Event,Web,Web/Eval,Webcast,Webinar,Website Direct Entry,Website Natural Referrer,Whitepaper'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Status string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Aborted,Completed,In Progress,Planned'),
	StartDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	EndDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	ExpectedRevenue double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BudgetedCost double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ActualCost double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ExpectedResponse double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NumberSent double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsActive boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Description string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfLeads integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfConvertedLeads integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfContacts integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfResponses integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfOpportunities integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfWonOpportunities integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AmountAllOpportunities double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AmountWonOpportunities double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyNumberOfLeads integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyNumberOfConvertedLeads integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyNumberOfContacts integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyNumberOfResponses integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyNumberOfOpportunities integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyNumberOfWonOpportunities integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyAmountAllOpportunities double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyAmountWonOpportunities double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyNumberSent double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyExpectedRevenue double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyBudgetedCost double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyActualCost double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastActivityDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CampaignMemberRecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Campaign_Goal__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Lead Generation,Awareness,Immediate Purchase,Retention,Up-Sell,Cross-Sell'),
	Retire_List_Source__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '3rd Party,Eloqua,Evaluations,Event Attendee,Install Base,Nurture Database,Nurture Queue,Open Enrollment,Pre-assessment,Salesforce,Webcast,Whitepaper'),
	mkt_cl_cmp_product_group__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'All BUs,Amentra,Certificate Systems,Cluster Suite,Consulting,Cygwin,Developer Support,Development Tools,Embedded Solution,Extended Update Support for Red Hat Enterprise Linux,Global Professional Services,Global Support Services,GNUPro,Hosting Program,ISV Partner Program,JBoss Application Server (ISV/OEM embedded only),JBoss Communications Platform,JBoss Consulting Services,JBoss Developer Studio,JBoss Enterprise Application Platform,JBoss Enterprise Middleware,JBoss Enterprise Portal Platform,JBoss Enterprise SOA Platform,JBoss Hibernate Framework,JBoss jBPM Framework,JBoss MetaMatrix,JBoss Middleware,JBoss Operations Network,JBoss Rules Framework,JBoss Seam Framework,JBoss Services,JBoss SOA,JBoss SOA Consulting Services,JBoss Training,MetaMatrix Enterprise Data Services Platform,Multiple,OEM Partner Program,Partner Recruiting,Partner Training,Primary Product Focus,Red Hat Academy,Red Hat Application Server,Red Hat Application Stack,Red Hat Certificate System,Red Hat Cluster Suite,Red Hat Command Center,Red Hat Developer Subscription,Red Hat Developer Subscriptions,Red Hat Directory Server,Red Hat Enterprise IPA,Red Hat Enterprise Linux Academic,Red Hat Enterprise Linux Client Solutions,Red Hat Enterprise Linux for Desktop Computing,Red Hat Enterprise Linux for Developers,Red Hat Enterprise Linux for Education,Red Hat Enterprise Linux for High Performance Computing,Red Hat Enterprise Linux for Mainframes,Red Hat Enterprise Linux for Servers,Red Hat Enterprise Linux Server Solutions,Red Hat Enterprise MRG,Red Hat Enterprise Virtualization Manager for Desktops,Red Hat Enterprise Virtualization Manager for Servers,Red Hat Exchange,Red Hat GFS,Red Hat Global File System,Red Hat Global Learning Services,Red Hat Global Professional Services,Red Hat Network,Red Hat Network Proxy Server,Red Hat Network Satellite Server,Red Hat Proxy Server,Red Hat Satellite Server,Red Hat Training/Certification,Runtime Partner Program,Solid Ice,TAMs,Other'),
	Ad_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Online,Print,Direct Mail'),
	Publication__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Certification Magazine,CMP (unixreview.com),CNET,Computer User,FCW,GCN,GovExec.com,IT.com,Knowledgestorm,Linux Magazine,MCPmag.com/Redmond Magazine,Monster,Network World,OSTG (linux.com, slashdot, newsforge),SYS-CON (LinuxWorld Magazine),TechTarget (SearhEnterpriseLinux.com),VARGov,Viacom Outdoor (DC Metro),Ziff Davis'),
	mkt_cl_cmp_media_name__c string(150) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_ad_name__c string(150) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_ad_group__c string(150) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_cta__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '30 Day Eval,60 Day Eval,Activate Trial,Analyst Paper,Assessment,Awareness,Beta Download,Blog Post / Web Page,Brief,Brochure,Buy Now,Buy Training,Calculator (This differs from TCO Calculator),Case Study,Contact Partner,Contact Sales,Customer Survey,Datasheet,Demo,Download,Edit Profile,Evaluation,Event,External List,FAQ,Find a Partner,Information,Informational,In-person Event,IRC Chat,Join Mailing List,Knowledgebase,Newsletter,Nurture email,Other,Podcast,Pre-assess,Pre-assessment,Register,Register for Event,Register for Podcast,Register for Video,Register for Webinar,Register for Whitepaper,Renew,Renewal,Request Eval,Search Knowledgebase,Social Media Follow / Like,Subscribe,Survey,TCO Calculator,Tools,Tradeshow,Training Catalog,Training Pre-Assessment,Video,Virtual Event,Webinar,Webstore,Whitepaper'),
	Retire_Campaign_Partner__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AMD,Dell,HP,IBM,Intel'),
	mkt_cl_cmp_geo__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'APAC,Brazil,China,Czech Republic,EMEA,Europe,France,Germany,Global,Hong Kong,India,Italy,Japan,Korea,LATAM,Latin America,NA,Spain,United States'),
	mkt_cl_cmp_audience__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Analyst,Business Development,Buyer/Purchaser/Finance,CEO/President/Owner,Contractor/Consultant,Customer,CXO,Dept or Project Manager,Developer,Director,Educator,Engineer,IS or IT Associate,IT Architect,Marketing,Multiple,Offline,Online,Partner,Prospect,Sales,Student,System or Network Admin,VP,Other'),
	mkt_cl_cmp_campaigns__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_period__c string(150) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_owner__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_category__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Accelerate App Delivery w/ PaaS,Brand,Brandcomm,Build & Manage a Private Cloud,Cloud,Cloud Management,CloudVirt,Consulting,CorpComm,CrossBU,Customer,Customer Goal,EAP,EAP Goal,Enlightened Innovation,GLS,GSS,I.T. without Boundaries,Infrastructure,JBoss,Liberate Your Information,Mainstream,Management,Management & Security,Management Goal,Mgmt Other,Middleware,Middleware Goal,NonInit,Nurture,OpenHybridCloud,Open Hybrid Cloud,Operational,Operational Goal,Orphan,Other,Other Cmpgn,Partner,Partner Events,People Brand,People Brand Goal,Platform,Platform Goal,Platform without Boundaries,Promo,Red Hat Shared Value,RHEL,RHELF2F,Services,Services Other,Shared,SOA,Stack Simplified,Storage,Territory Marketing,Territory Mktg,Training,Transform,Value,Vertical Programs,Virt,Virtualization,Virtualization Goal'),
	mkt_cl_cmp_vertical__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Communications,Distribution,Education,Energy,Financial Services,Government,Healthcare,Industrial,Information Technology,Manufacturing,Media and Entertainment,Multiple,Oil and Gas,Online Media,Technology,Telecommunications,Other'),
	mkt_cl_cmp_is_internal__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	mkt_cl_cmp_impressions__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_email_opens__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_process_leads_omniture__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1=Do not Process,2=Ready for Processing,3=Processed'),
	mkt_cl_cmp_process_metrics__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1=Do not process,2=Ready for Processing,3=Processed'),
	Origin__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Marketing,MDF,Sales'),
	Media_Source__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '51CTO,Baidu,Bloomberg,Builder AU,CBS,CBSi,CEO,Certification Magazine,China Computer World,CIO,CMP (unixreview.com),CNET,CNN Money,Computer User,Computer World,CSDN,Dev Shed,DZone,Facebook,Fast Company,FCW,Forbes,GCN,gigaom.com,Google,GovExec.com,IDG Connect,IDG Enterprise,IDG Now,IDG TechNetwork,Impress,Information Management,Information Week,Info World,Integrate,IT.com,ITBriefcase,IT Media,IT Pro,IT Toolbox,Java Pro,Jupiter Media,Knowledgestorm,Lake Group Media,LinkedIn,Linux.com,Linux Magazine,luckland,Madison Logic,marketing matters,MCPmag.com/Redmond Magazine,Monster,MySpace,Naver,NetShelter,Network World,Nikkei,OSTG (linux.com, slashdot, newsforge),Other,Prelytix,QuinStreet,Red Hat,Redmond Developer News,Redmond magazine,Sina,Slashdot,SourceForge,Spiceworks,sys-con.com,SYS-CON (LinuxWorld Magazine),TechTarget,TechTarget (SearhEnterpriseLinux.com),Tek-Tips,TI Inside,Time Inc (Fortune),TMCNet,Twitter,UBM/Techweb,Valor Online,VARGov,Viacom Outdoor (DC Metro),virtualization magazine,vpm.com,WeChat,WeiBo,WindowsIPpro,Yahoo,YouTube,ZDNet,Ziff Davis,Zift Solutions'),
	Channel_Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_searchcenter_tc__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	mkt_cl_cmp_director__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Alejandro Raffaele,Brett Hunter,Daniel Ng,David Barzilay,Eileen Egan,Emma Battle,Frank Feldmann,Fran Wilson,Gordon Tillmore,Greg Lissy,Jane Circle,Jeff Mackanic,Jeff Oberbillig,Jimmy Guerrero,Joel Berman,Jon Atkins,Kimberly Payton,Leigh Day,Linda Cafferty,Margaret-Ann Bolton,Margaret Rimmler,Maria Moore,Mark Horne,Martin D''Elia,Merry Beekman,Michael Piech,Navin Thadani,Nick Dietsch,Paul Lyons,Robert Eiselt,Sarangan Rangachari,Teresa Wilkerson,Tracey Cramer'),
	List_Source__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '3rd Party,Eloqua,Nurture Queue,Salesforce'),
	Campaign_Partner__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AMD,Channel,Dell,Government,HP,IBM,Intel,ISV,OEM,RHX,SI,Non-applicable,Other'),
	Notes_for_Sales__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Landing_Page_URL__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Tracking_Campaign_ID_URL__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Naming_Convention__c string(1000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Note_on_Tracking_Campaign_ID_URL__c string(500) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	MDF_Amount__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Note_on_Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Note_on_Notes_for_Sales__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	mkt_cl_parent_campaign_name__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AAP CrossThemes,Accelerate,Accelerate App Delivery,Accelerate Business Agility,Agility,Anncmnt,Apps,Automate,Awareness,BAPC CrossThemes,BestRHEV,Big Data,Build / Manage Private / Hybrid Cloud,Cloud,CloudForms,CloudISV,CloudMgmt,CloudSem,Consulting,Content Cloud,Continuous IT Innovation,Control Unstructured Data,CrossBUEvents,Data Protection,DemandGen,DeskVirt,Developer,Direct Renewals,Economic,EcosystemSolutions,Efficiency,EI CrossThemes,Engage,EntCloud,Enterprise Cloud Storage,F2F,FuseSource,GeneralOHC,GlobalServices,GrowShare,IaaS,IIE,Improve Developer Productivity,Improve IT Efficiency,Increase IT Efficiency,Indirect Renewals,Influence,Inform,Innovation,Integrate,ITWOB CrossThemes,JBossPortfolio,JBossWay,LeadGen,Liberate CrossThemes,Make Data Actionable,Migrate,Modernize,Modernize Apps Using DevOps,Modernize - Microsoft,Modernize - U2L,Newsletter,NextGenIT,Nurture,OHC CrossThemes,OpenChoice,OpenShift,OpenShiftEnt,OpenShiftOnline,OpenStack,OTNN,PaaS,Parent,PartnerEnable,PrivateCloud,Protect Data,PublicCloud,PWOB CrossThemes,Realize,RedHatForum2011,Reduce App Delivery / Mgmt Ops Cost,Reduce TCO & Automate,RHCI,RHEL6,RHEV3,RHNSatellite,RHVE2011,RHVE2012,RiskValue,Satellite,Satellite Upsell,SeeingIsBelieving,SellRHEL,Services LeadGen,Services Nurture,Stack,Standardize,Standardize Cloud w/ Software Storage,StorageAwareness,StorageCommunity,StorageCrossSell,StorageIntro,Summit2010,Summit2011,Summit2012,Summit2013,Summit2014,Summit2015,TakeOut,Targeted,Training,Transformational,U2RH,VirtEvents,Virtualize,Website'),
	ELOQUA__Call_Center_Calls__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Campaign_Search_Visits__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Email_Bouncebacks__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Email_Click_Throughs__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Email_Unsubscribes__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Emails_Opened__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Emails_Sent__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Event_Registrations__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Faxes_Sent__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Forms_Submitted__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Hypersite_Visits__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Online_Referral_Visits__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Possible_Email_Forwards__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Print_Mail_Sends__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Surveys_Completed__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELOQUA__Unique_Email_Visitors__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Fiscal_Quarter__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'FY11Q4,FY12Q1,FY12Q2,FY12Q3,FY12Q4,FY13Q1,FY13Q2,FY13Q3,FY13Q4,FY14Q1,FY14Q2,FY14Q3,FY14Q4,FY15Q1,FY15Q2,FY15Q3,FY15Q4,FY16Q1,FY16Q2,FY16Q3,FY16Q4'),
	Offer_Name__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	SubRegion__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ANDINO,ANZ,ASEAN,Baltics,BeNeLux,Brazil,Canada,CEACA,Central,Commercial,DACH,Eastern Europe,France,GIT,Greater China,Hong Kong,Iberia,India,Italy,Japan,Korea,Mexico,Middle East,N-Africa,Nordics,North East,Public Sector,S-Africa,SOLA,South East,UK,West'),
	ELQ_USD_ActualCost__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ELQ_USD_BudgetedCost__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Profile__c string(1300) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Role__c string(1300) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Average_Deal_Size__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Average_Deal_Size_in_Hierarchy__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Buyer_Stage__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Inquiry,Prospect,Marketing Qualified,Sales Qualified,Early / Top,Middle,Late / Bottom'),
	Conversion_Rate__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Conversion_Rate_in_Hierarchy__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Cost_per_Inquiry__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Exclude_from_reporting__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Expected_Number_of_Converted_Leads__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Expected_Number_of_Responses__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Solution_Code__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'CORP,CROSS,JEWP,MRGG,MRGM,MRGR,REDHAT,RH,RHC,RHCERT,RHCF,RHCI,RHCLOUD,RHDS,RHEL,RHEL4,RHEL5,RHEL6,RHELOSP,RHEV,RHJAMQ,RHJBRMS,RHJDG,RHJDS,RHJDV,RHJEAP,RHJF,RHJFSW,RHJM,RHJON,RHJP,RHJWS,RHMRG,RHN,RHOS,RHOSE,RHOSO,RHPART,RHS,RHSAT,RHSS,RHT,RHJBPM,RHSTG,RHSTC,RHCONS,RHJMOB'),
	Target_Offer__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Target_Persona__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'All,Architect,Business,Business Analyst,CFO,CIO,Data Center Manager,Developer,IT Decisionmaker,IT Manager,Lead Developer,System Administrator,Systems Admin,Technical'),
	Title__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Ultimate_Parent_Campaign_Id__c string(1300) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Ultimate_Parent_Campaign_Name__c string(1300) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Expected_Responses_in_Hierarchy__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'DE,EN,ES,ES_AR,FR,IT,JA,KO,PT_BR,ZH'),
	ActiveCampaignMemberRateInHierarchy__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ActiveCampaignMemberRate__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Cost_per_Inquiry_in_Hierarchy__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyNumExpectedResponses__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyNumOfActiveLeads__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ChildNumExpectedResponses__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ChildNumOfActiveLeads__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NumberOfActiveLeads__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Asset_URL__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Media_Source_2PL__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Activate,ADT (Application Development Trends),Baidui,Bloomberg,BPM,BrightTALK,C4ISR & Networks,CBS,CBSi,CIO,ComputerWorld,DataXu,Defense News,Defense One,Developer.com,Developer Media,DZone,EdScoop,eMedia,Enterprise Innovation,eRepublic,Facebook,Federal Computer Week,Federal Times,FedInsider,FedScoop,FierecGovIT,FutureGov,gigaom.com,Google,Government Computer News (GCN),Government Executive,Government Technology,GovIT,GovLoop,GovPro,GRID,IDG Connect,IDG Enterprise,IDG TechNetwork,IDN (Integration Developer News),Impress,Information Management,Information Week,InformationWeek Government,InfoWorld,Integrate,ITBrief.com,ITBriefcase,IT Media,Knowledge Hub,Knowledge Hub News (KHN),Linkedin,Linux.com,Luckland,Madison Logic,Marketing Matters,Meritalk,Naver,Netline,Network World,NextGov,Nikkei,PMOD,Prelytix,PureB2B,QuinStreet,Redmond magazine,Rich Media,SD Times,Selling Simplified,SlashDot Media,Spiceworks,StateScoop,sys-con.com,TCI,TEC (Technology Evaluation Center),TechTarget,Tek-Tips,Telenet,Time Inc (Fortune),TMCNet,Twitter,UBM/Techweb,Vibrant,Virtualization Magazine,Virtualization Review,vpm.com,Washington Technology,WeChat,WeiBo,WindowsIPpro,WTOP,Yahoo,Ziff Davis'),
	Job__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Accelerate,Create,Enable,Nurture,Seed'),
	Objective__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cross-sell,New Logo,Retention,Up-sell'),
	Solution_Code_Family__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cloud,Consulting,Corporate,Middleware,Platform,Storage,Training,Virtualization'),
	Target_Persona_Family__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'All,Business,Technical'),
	Campaign_Tracking_Id__c string(1300) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Campaign_Name__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_ParentId FOREIGN KEY(ParentId) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'ChildCampaigns'),
	CONSTRAINT FK_Campaign_Target_Offer__c FOREIGN KEY(Target_Offer__c) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'Campaigns__r'),
	CONSTRAINT FK_User__Owner__c FOREIGN KEY(Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'CampaignsOwned__r')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Campaign_Hierarchy_Details__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Campaign__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Campaign_Detail__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Expected_Number_of_Responses__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	External_ID__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	IsCurrent__c boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	NumActiveLeadsFormula__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NumActiveLeads__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NumExpectedResponsesFormula__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_Campaign_Detail__c FOREIGN KEY(Campaign_Detail__c) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'Campaign_Hierarchy_Details1__r'),
	CONSTRAINT FK_Campaign_Campaign__c FOREIGN KEY(Campaign__c) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'Campaign_Hierarchy_Details__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Campaign_Hierarchy_Details__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_Hierarchy_Details__c_ItemId FOREIGN KEY(ItemId) REFERENCES Campaign_Hierarchy_Details__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Campaign_Plan__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Account__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Business_Plan__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Campaign_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Red Hat/Partner Joint Campaign,Partner Campaign'),
	Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Funding_Needed__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Lead_Results__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Lead_Results_currency__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Lead_Target__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Lead_Target_currency__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Title__c string(100) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Marketing_Program__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Dollar For Your Thoughts,JBoss 30 Day Challenge,Red Hat 2009 Road Shows,JBoss Virtual Road Shows,Carve Out Cost,JBoss Proliferation,Value of Support Through Subscription,4600 - Mainstream Adoption,4601 - Carve Out Costs,4602 - Server Virtualization,4603 – VDI,4604 – JON,4605 – RHN/Satellite,4606 – SOA,4607 – EAP,4608 - Trade Show/Event across BUs,4609 - Other Non-BU Program,4610 - Red Hat Generic,4611 - Primary Initiatives,4612 - Partner Training & Enablement,4613 – Other,4614 - Open Source Value'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Account__c FOREIGN KEY(Account__c) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'R00N60000001ezKqEAI'),
	CONSTRAINT FK_SFDC_Channel_Account_Plan__c_Business_Plan__c FOREIGN KEY(Business_Plan__c) REFERENCES SFDC_Channel_Account_Plan__c (Id) OPTIONS (NAMEINSOURCE 'Campaign_Plans__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Campaign_Plan__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account__c,Business_Plan__c,Campaign_Type__c,created,CurrencyIsoCode,Date__c,Description__c,feedEvent,Funding_Needed__c,Lead_Results__c,Lead_Results_currency__c,Lead_Target__c,Lead_Target_currency__c,Marketing_Program__c,Name,ownerAccepted,ownerAssignment,locked,RecordType,unlocked,Title__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_Plan__c_ParentId FOREIGN KEY(ParentId) REFERENCES Campaign_Plan__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Campaign_Plan__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_Plan__c_ItemId FOREIGN KEY(ItemId) REFERENCES Campaign_Plan__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CampaignFeed (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeedPostId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'TrackedChange,UserStatus,TextPost,AdvancedTextPost,LinkPost,ContentPost,PollPost,RypplePost,ProfileSkillPost,DashboardComponentSnapshot,ApprovalPost,CaseCommentPost,ReplyPost,EmailMessageEvent,CallLogPost,ChangeStatusPost,AttachArticleEvent,MilestoneEvent,ActivityEvent,ChatTranscriptPost,CollaborationGroupCreated,CollaborationGroupUnarchived,SocialPost,QuestionPost,FacebookPost,BasicTemplateFeedItem,CreateRecordEvent,CanvasPost,AnnouncementPost'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_ParentId FOREIGN KEY(ParentId) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'Feeds')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CampaignMember (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CampaignId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LeadId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ContactId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Status string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Attended,Captured Details,Contacted,Enviada,Enviado,Geantwortet,Gesendet,Interested,Invited,Not Attended,Not Contacted,Not Interested,Not reacheable,Registered,Registered, Attended,Registered, didn''t attend,Registered & Attended,Registered & Didn''t Attend,Registered and attended,Registered but didn''t attend,Registered didn''t attended,Rejected,Responded,Respondida,Respondido,Sent,Targeted,Unable to Contact,Will call again,Will Not Attend,レスポンスあり,実施,送信,응답됨,전송됨'),
	HasResponded boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	FirstRespondedDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RelatedCampaign__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	True_Responded_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	IsLeadActive__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	LFR__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_CampaignId FOREIGN KEY(CampaignId) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'CampaignMembers'),
	CONSTRAINT FK_Campaign_RelatedCampaign__c FOREIGN KEY(RelatedCampaign__c) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'Campaign_Member_Related__r'),
	CONSTRAINT FK_Contact_ContactId FOREIGN KEY(ContactId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'CampaignMembers'),
	CONSTRAINT FK_Lead_LeadId FOREIGN KEY(LeadId) REFERENCES Lead (Id) OPTIONS (NAMEINSOURCE 'CampaignMembers'),
	CONSTRAINT FK_LeadForReporting__c_LFR__c FOREIGN KEY(LFR__c) REFERENCES LeadForReporting__c (Id) OPTIONS (NAMEINSOURCE 'Campaign_Members__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CampaignMemberStatus (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CampaignId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Label string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SortOrder integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDefault boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	HasResponded boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CampaignShare (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CampaignId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UserOrGroupId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CampaignAccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Read,Edit,All'),
	RowCause string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Owner,Manual,Rule,ImplicitChild,ImplicitParent,Team,Territory,TerritoryManual,TerritoryRule,Territory2Forecast'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_CampaignId FOREIGN KEY(CampaignId) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'Shares')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CampaignTag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_ItemId FOREIGN KEY(ItemId) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CampaignTag__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Campaign_Tag_Id__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Campaign__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Campaign_Campaign__c FOREIGN KEY(Campaign__c) REFERENCES Campaign (Id) OPTIONS (NAMEINSOURCE 'Campaign_Tags__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CampaignTag__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CampaignTag__c_ItemId FOREIGN KEY(ItemId) REFERENCES CampaignTag__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Case_ (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CaseNumber string(30) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContactId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccountId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AssetId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BusinessHoursId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SuppliedName string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SuppliedEmail string(80) OPTIONS (NATIVE_TYPE 'email', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SuppliedPhone string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SuppliedCompany string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1 - Question/Training Need,2013 RHEL Pricing/Packaging,2 - Risk,3 - Issue,4 - Action,5 - Decision,6 - Defect,Account Merge,Accounts,Add User for Existing Partner,Approvals,Bug,BU Guidance,Campaign,Cannot Submit Order,Cases,Change Order,Channel Load,Channel Load Conflicts,Chatter,Contacts,Contract Admin,Contracts,Credit,Data Upload Request,Deactivate User,Deal Registration,EMEA SEAP,EMEA SE Process,Eval,Feature Request,Forecasting,GOSS Request,GSS Support Exception,Hock Access,Hoover''s Access/Issues,HP Renewals,Lead Distribution,Leads,Market to Lead,Media Kit,New User Access,Opportunities,Other,Other-High Priority,Other-Low Priority,Other-Medium Priority,Other-Urgent Priority,Partner,Partner Activation,Partner Deal Reg,Partner Functionality,Partner Portal,Price Books,Problem/Question,Products,Public Sector - Special Bids,QuoteBuilder,Reg Number Request,Renewal,Report/Dashboard Request,Reports/Dashboards,Role / Profile change,Sharing Rule,SKU Request,SSI Approval Process,SSI Requests,Submit Order Backout,Submit Order-Functionality is Down,SWAT,Territory Change,Third Party Tools,Training Request,Transfer Account Ownership,Unable to Save Records,Unable to View Records,User Access'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Status string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'New,Analyze,In Process,In Backlog,On Hold,Pending Close,Pending Priority,Pending Requirements,Closed,Approved,Build,Defer,Delayed,Deploy,Design,Duplicate,Escalated,Escalated - Helpdesk,Escalated - Premier Support,Existing Functionality,Failed,Fixed - Pending Resolution,Follow - up,Implemented,In Dev,In-Scope,Out-of-Scope,Passed,Pending,Process,Ready to Test,Rejected,Review,Story Needed,Submitted,Test,UAT,Waiting Response,Waiting UAT,01 - New,02 - In Progress,03 - In Development,04 - Deferred,05 - Stalled,06 - Ready for Migration,07 - Migration Complete,08 - Ready for Retest,09 - Rejected,10 - Closed'),
	Reason string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'General Admin,Bad Data,Coding Error / Bug,Lack of Training,Missing / Ambiguous Requirements,Requirement Dropped,Requirement Implemented,System Performance,No Response,Inconclusive,Frontline - Basic Administration,Resolved in AM Release,Resolved in Project Workstream,Requirement Dropped by the Business,Duplicate Issue - See Parent,Coding Error – Bug,Lack of User Training,Conflicting Business Requirements,No Response - Inconclusive,Network Issue,Bug,User Question,Record Access Issue,Approved by Submitter,Closed by PMO,Duplicate (specify linked case),Rejected,Transferred,Withdrawn by Submitter'),
	Origin string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'C360,Email,Email - EMEA Channel Operations,EMAIL - EMEA Partner Admin,EMAIL - EMEA Sales Admin,Email - EMEA SEAP,Email - EMEA Services Pilot,EMAIL-IT,Email NA Contracts Admin,EMAIL-Reporting,Email - SKU - Hock Access,Email - SKU - HP Renewals,Email - SKU - Media Kit,Email - SKU - Product Request,Email - SKU - Reg Numbers,Email - SKU - SKU Problems,Email - SKU - SKU Request,Email-to-case: EMEA Channel Operations,Email-to-case-APAC,Email-to-case-EMEA,Email-to-case-Inside-SA-Canada,Email-to-case-LATAM,Email-to-case-LMS,Email-to-case-NA,Email-to-case-Open Program,Email-to-case-RHPDS,EMEA SEAP Email,GOSS-Request,Phone,Portal,Public Sector - Special Bids,System,UAT,Web'),
	IsVisibleInSelfService boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Subject string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Priority string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Urgent,High,Medium,Low,1 - Low,2 - Medium,3 - High,4 - Critical'),
	Description string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsClosed boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ClosedDate timestamp OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsEscalated boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	HasCommentsUnreadByOwner boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	HasSelfServiceComments boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsClosedOnCreate boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsSelfServiceClosed boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Type_Detail__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '$0 PCF,Account Merge,Accounts,Account Validation,Add User to Existing Partner,Analytics Cloud Login Issues,Analytics Cloud Reports,Anticipated Seat Request,APAC,Application Configuration,Application Performance,Application Security and Permissions,Approval Process/Approver Change,Backdating approval,Backed Out,Bill of Materials,Business Plan,Business Process,Campaigns,Cannot Save Records,Cannot Submit Order,Cannot View Records,Cases,Channel Load,Channel Load Conflicts,Channel Load Issues,Chatter Mobile,Cloud9,Cloud Management,Commissions,Competitive Question,Conflicts,Conflicts and Mapping Error,Contacts,Content,Contract Issue,Contract Renegotiation,Contracts,Co-Term Wizard,Credit,Customer Data,Customer References,Custom Object,Dashboards,Data.com,Data Management,Data Transformation and Conversion,Data Validation,Deactivate User,Deal Registration,Decommissioning,EasyLink,Eloqua,Email Campaigns,Email Notification,EMEA,End User Email Campaign,Enhancement,Eval Request,External Vendor Ticket,General,GES,Get Signature,Global Business and Analytics (GBA),Global Partners Analytics (GPA),Global SE Process,Gold Masters,Harte-Hanks,Hoover’s,HP Renewals,Invoices,Issue,Jigsaw,LATAM,Lead Distribution,Leads,Locate Contracts,Manage Products,Manual Data Cleansing,Mapping Error,Market to Lead,MDF/Fund Claims/Requests,Middleware,Missed Migration Step,Missing or Incorrect Data,Mobile,NA,NAT,Network Connectivity,New Account,New Hock User,New Product Request,New Requirement/Change to Requirement,New User Access,NFR,Old/New Product Mapping JBoss,Old/New Product Mapping RHEL,Onboarding,Openshift,Opportunities,Order Management,Other,Over-deployment,Overdue Renewals,Partner,Partner Activation,Partner Center Name Changes,Partner Certification,Partner Deal Registration,Partner Email Campaign,Partner Locator,Partner Logos,Partner Portal,Partner Products,Partner Requalification,Partner Status,Platform,Portal,Price List Update,Price Update,Profile/Role/Permissions,Project Change Form,Public Group or Queue Change,Question/Problem,Question/Problem Relating to JBoss,Question/Problem Relating to RHEL,Question/Training Need,Quoting Tool,Redemption Form,Regional Operations Support (ROS),Reg Number Replacement,Reg Number Request,Remove Hock User,Renewals,Report,Reports,Sales Data Analyst,Sales Forecasting & Analytics (SFA),Sales Reporting Analyst,Services,Services Operations,SFDC Mobile Activation,SKU Inquiry,SKU Mappings,SKU Replacement,Sku Request,SKU Update,Storage,Submit Order,SumTotal,Technical Product Query JBoss,Technical Product Query RHEL,Termination,Territory Change,Testing Process/Scenario,Transfer Account Ownership,Transfer Opportunity,User Access,Virtualization,Zero Value Change Order'),
	Country__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Afghanistan,Albania,Algeria,Angola,Argentina,Armenia,Aruba,Australia,Austria,Azerbaijan,Bahamas,Bahrain,Bangladesh,Barbados,Belarus,Belgium,Benin,Bolivia,Bosnia and Herzegovina,Botswana,Brazil,Bulgaria,Burkina Faso,Cambodia,Cameroon,Canada,Central African Republic,Chad,Chile,Colombia,Costa Rica,Côte d''Ivoire,Croatia,Cyprus,Czech Republic,Democratic Republic of Congo,Denmark,Dominican Republic,Ecuador,Egypt,El Salvador,Equatorial Guinea,Estonia,Ethiopia,Fiji,Finland,France,Gabon,Georgia,Germany,Ghana,Greece,Guatemala,Guinea,Haiti,Honduras,Hong Kong, SAR, PRC,Hungary,Iceland,India,Indonesia,Iran,Israel,Italy,Jamaica,Japan,Jordan,Kazakhstan,Kenya,Kuwait,Kyrgyz Republic,Lao PDR,Latvia,Lebanon,Libya,Lithuania,Luxembourg,Macao, China,Madagascar,Malawi,Malaysia,Mali,Malta,Mauritius,Mexico,Moldova,Mongolia,Morocco,Mozambique,Namibia,Nepal,Netherlands,New Zealand,Nicaragua,Niger,Nigeria,Norway,Oman,Pakistan,Panama,Papua New Guinea,Paraguay,People''s Republic of China (Mainland),Peru,Philippines,Poland,Portugal,Qatar,Republic of Congo,Republic of Ireland,Republic of Macedonia,Romania,Russia,Rwanda,Saudi Arabia,Senegal,Serbia and Montenegro,Singapore,Slovakia,Slovenia,South Africa,South Korea,Spain,Sri Lanka,Sudan,Swaziland,Sweden,Switzerland,Syria,Tajikistan,Tanzania,Thailand,Togo,Trinidad and Tobago,Tunisia,Turkey,Turkmenistan,Uganda,Ukraine,United Arab Emirates,United Kingdom,United States,Uruguay,Uzbekistan,Venezuela,Vietnam,West Bank and Gaza,Yemen,Zambia,Zimbabwe'),
	Modules__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Accounts,Campaigns,Contacts,Contracts,Credit,Credit Check,Dashboards,Documents,Heirarchy,Home,Leads,MDF,Opportunities,PRM,Products,Profiles,Reports,Roles,Users'),
	Areas_Affected__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Credit,Development,Finance,HR,IT,Marketing,Order Entry,Sales,Senior Management,Services,Training'),
	System_Issue__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Process_Issue__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Number_of_Seats_Requested__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Momentum_SET_UP__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Department__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Business Affairs,Finance,GIS,JBoss - Sales,Marketing,Operations,Sales,Sales College,Sales Engineer,Services'),
	Steering_Committee_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not Presented to Steering Committee,Needs Esclation to Steering Committee,Approved by Steering Committee,Denied by Steering Committee'),
	Oracle_Updated__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	sfdc_Leads_Updated__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	sfdc_Accounts_Updated__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Routing_Sheet_Updated__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Finance_Notified__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X1_Recd_Partner_Activation_Template__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	EnterURLWhereProblemOccurs__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Rally_StoryPoints__c string(7) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Admin_Assessment__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Bug,Enhancement,Project,Non Technical,Support'),
	Theme__c string(50) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Comments__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BLOG_URL__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Global_Region__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Rally_Iteration__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Additional_Countries_of_Operation__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Afghanistan,Åland,Albania,Algeria,Antigua,Argentina,Aruba,Australia,Austria,Azerbaijan,Bahamas,Bahrain,Barbados,Barbuda,Belarus,Belgium,Belize,Benelux,Benin,Bermuda,Bolivia,Bosnia,Bosnia and Herzegovina,Botswana,Brazil,British Virgin Islands,Bulgaria,Burkina Faso,Burundi,Cameroon,Canada,Canary Islands,Cape Verde,Cayman Islands,Central African Republic,Central America,Chad,Chile,China,Colombia,Comoros,Congo,Costa Rica,Croatia,Cyprus,Czech Republic,Democratic Republic of Congo,Denmark,Djibouti,Dominica,Dominican Republic,Finland,France,French Guiana,Gabon,Gambia,Georgia,Germany,Ghana,Gibraltar,Greece,Grenada,Guadeloupe,Guam,Guatema,Guinea-Bissau,Guyana,Haiti,Honduras,Hong Kong,Hungary,Iceland,India,Indonesia,Ireland,Isle of Man,Israel,Italy,Jamaica,Japan,Jersey,Jordan,Kazakstan,Kenya,Kuwait,Kyrgyzstan,Laos,LATAM,Latvia,Lebanon,Liberia,Libya,Liechtenstein,Lithuania,Luxembourg,Macedonia,Madagascar,Madeira Islands,Mali,Malta,Mexico,Moldova,Monaco,Montenegro,Namibia,Netherlands,New Zealand,Nicaragua,Norway,Oman,Panama,Paraguay,Peru,Philippines,Poland,Portugal,Qatar,Romania,Russia,Rwanda,S-Africa,Sao Tome and Principe,Saudi Arabia,Senegal,Sierra Leone,Singapore,South Africa,South Korea,Spain,Sri Lanka,Suriname,Swaziland,Sweden,Switzerland,Togo,Trinidad,Tunisia,Turkey,Ukraine,United Arab Emirates,United Kingdom,United States,Venezuela,Virgin Islands,Western Sahara,Yemen,Zambia,Zimbabwe'),
	Case_Resolution__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	X2_Confirm_Partner_is_in_Partner_Center__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Current_Address__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Date_Opened__c date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Module__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account Profile,Approvals,Assigning Lead Routing Rules,Bug,Channel Management,Contracts,Credit,Data Access Setup,Enhancement,Hoover''s,Hot Topics,Lead Management,Manage Opportunity,Opportunity,Order Submitted,Performance & Insight,Question,Quote Builder,Route Lead,Search Before Create,Submit Order,Transformation,User Profile,Working Lead'),
	X3_Notify_Channel_Ops_Ready_for_Training__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Process_Area__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Administration,Analysis & Qualification,Building the Customer Case,Close Opportunity,Contract Management,Create Opportunity,Credit Management,Forecasting,Manage the Opportunity,Negotiating and Closing,Prospecting and Profiling,Sales Reporting,Working the Opportunity'),
	Requires_Follow_Up__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Resolution_Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Days_Open__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Source__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Back Office Training,Business Request,End User Training,GIT,Internal Review,Momentum,R1 Out of Scope,Requirements Gathering,Training Enhancement Request,TTT,UAG,UAT'),
	Information__c string(250) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Instructions__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Issue_Type_Classification__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'General Questions,Internal - EMEA Channel Ops,Module Issues,Open Program,PAM Support,Partner Onboarding,RHPDS User Request,Sales and Marketing,Training Request'),
	Targeted_Close_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Issue_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Aspire / Renewal Issue,BP (Business Plan),BU queries,Calculations,CCP/MSP,Certifications,Company Name/ Address Change,Content Feedback,Customer References,Deal Registration,EMEA SEAP,Eval request,General Questions,Global Queries,GLS on-site,GPS Special Bid,Ideas,Incorrect POC,Internal Approvals,ISV,LMS Access,Login to PRM,MDF (Market Development Funds),Migration Request,NFR (Not For Resale),Non Standard Requests,Non-Standard Special Bid,OEM,Old SKU,One Time Special Bid,Other,Out Of Territory,Partner Tier Upgrade Request,Partner Type Upgrade Request,PO Mandatory,Pre Sales Queries,Pricing Request,Product Queries,Quotes,Rebate,Renewal Info,Requalification Request,Request New User,RHEL 6 Release Request,Sales College/SABA,Sales Query,SEAP,Services,SI,SI orders,SKU /Pricing Request,SKU Request,Special Bid,User Activation Request,User Creation Request'),
	New_Address__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	New_Company_Name__c string(100) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Optional__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Release_Impacted__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'R1,R2,R3,R4,DR,M2L'),
	Partnership_Upgrade__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	NOTES_FROM_R2_GATHERING_MEETINGS__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Specializations__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cloud Infrastructure,Data Center Infrastructure,Middleware Solutions,Public Sector,Specialization D'),
	RedHatLoginName__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Opportunity_Name__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CaseLogo__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Country__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Spam_E_mail_to_Case__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CaseReopenedByPartner__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Ship_To_Info__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Mobile_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Blackberry,iPad,iPhone'),
	Mobile_Phone__c string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Blackberry_Model_Number__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Demo__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IT_Subject__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	IT_User_Story__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	DaysSinceLastComment__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	GCM_Comments__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Release_ID__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Target_Release__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '2013.01,2013.02,2013.03,2013.04,2013.05,2013.06,2013.07,2013.08,2013.09,2013.10,2013.11,2013.12'),
	Prioritized__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	GCM_Business_Analyst__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Organization__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Engineering Services, Product & Technology,Facilities,Finance,Global Services,Global Support Services,IT,Legal & Business Affairs,Operations,People,Sales,Strategy & Corporate Marketing'),
	Function__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'APAC Operations,APAC Sales,Billing,Brand,Business Reporting & Analytics,Channel Sales,Corporate Development,Corporate Marketing,Credit,EMEA Operations,EMEA Sales,Global Change Management,Global Operations: Renewals,Global Sales Business Development,Government Sales,Integrated Field Marketing,LATAM Operations,LATAM Sales,NA Operations,NA Sales,Online Marketing,Operational Data,Program Marketing,Strategy'),
	Related_Project__c string(50) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	User_Story__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	LastCommentDate__c timestamp OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Rally_Last_Sync__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Rally_Schedule_State__c string(50) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Rally_State__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Pending,Ready,Created'),
	Rally_Story_URL__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Profile__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Role__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Region__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'NA,APAC,EMEA,LATAM,GLOBAL'),
	Work_Module__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account Management,Back Office Enablement,Forecasting,General SFDC,Lead Management,Opportunity Management,Partner Management,Reporting,Systems Integration'),
	Required_for_Release__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1,2,3a,3,4,Out of Scope - SA,LD - Point Release'),
	Sub_Module__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Access,Alerts,Approval,Commissions,Contracts,Credit,Data,Discounts,Docs,Forecast,Forms,General,Hierarchy,Localization,Nutcase,Prioritize,Profiles,QB,Quotes,Renewals,Reports,SBC,Triage,Validation'),
	Production_Deployment_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Sign_Off_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Admin_Priority__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Low,Medium,High,Urgent'),
	Queue_Name__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	User_Persona__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Bid Desk,Billing,Business Affairs,Business Unit,Channel Account Manager,Consultant,Credit,Customer Data,Finance,Inside Lead Management,Inside Sales,IT,Marketing,Marketing Operations,Marketing Sales Development,Order Management,Outside Sales,Project Accounting,Reporting Operations,Sales Manager,Sales Operations,Solution Architect,System Operations'),
	Case_Notes__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Rx_High_Level_Requirements__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'R2 - Localized Forms,R2 - QB HW Upgrade,R2 - Supportable X Interim Pain Relief,R2 - Dashboard Visibility,R2 - Improved Contract Visibility at Account Level,R2 - Account Profile Updates,R2 - Pre-Sales Process for SA,R2 - Dashboards and Reports Cleanup,R2 - SFDC, SBC and QB enhancements to improve efficiency,R2 - Additional OM Process Improvements,R2 - Strategic Account Classification and Hierarchy,R2 - LATAM: Local Requirements Configuration,R2 - US/APAC: Channel Load Process,R2 - Finance: Addl. Order Submit Validation,R2 - Finance: Booking and Commission Team Claims,R2 - Business Affairs: Access, Visibility, and Update Capability,R4 - Lead Distribution,R4 - Non-Salesforce.com items (QB and SBC),R4 - Remaining H/M reqs from R1/R2 (~60 SFDC pain point reqs of 80),R4 - High Post R2 Go-Live Feature reqs (SFDC),R4 - High Priority Items from Reqs Gathering Sessions (SFDC),R4 - APAC Channel Load,R4 - SKU for Metamatrix (owned by Ops),R4 - New SFDC functionality available in Dec.,R4 - EMEA Credit,R4 - Complete Process Visibility,R4 - EMEA Channel Load,R4 - Forecasting,R4 - Localization,R4 - OM Improvements,R4 - Renewals,R4 - Reports and Dashboards,R4 - SFDC Enhancements,R4 - SKU Cleanup,R4 - Supportable X,R4 - NA Pre Sales,R4 - EMEA Pre Sales,R2 - NUTCASE Enhancements'),
	EMEA_Channel_Ops_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Communication,FYI,Post-fullfilment,Pre-Sales / Pre-Fulfilment,QE Support,Training,Triage,WIP'),
	Issue_Type_Detail__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Add-ons,Approvals,Backdating (SEAP),BU Query,Contract Number,Contract Questions,Co-Term,Deal Design,Discount,Downgrade,EU Details,EU Missing,General Questions,HP Related,Incorrect Quantity,Internal Use / MSP,Login / Account,NAT/Discount,Non Standard Terms,Normal,Old SKU,Other,Out of Disti Region,Out of EMEA,Out of EU,Partner Roles,Pricing,Pricing Query,Quantity,Quote,Renewal Data,Renewal Date,Reporting,Reseller Details,Reseller Missing,RH Address,Royalty,Royalty Information Missing,SKU,SKU Mapping Request,Standard,SWAT Case,Upgrade,Verification,Wrong Contract Number,Wrong Dates,Wrong Discount,Wrong NAT Used,Wrong Pricing,Wrong RH Address,Wrong SKU'),
	Owner_Design__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Jen Romano,Rebecca Loudermilk,Devon Kapler,John Herson,Kalidass,Anil,Paresh,Prasad,Brijesh,IDC - Test 1,IDC - Test 2,Earllette Frye,Timmy Boisvert,Will Larter,Phel Meyer,Sunil,Angela Daniels,Mary Chandra'),
	Owner_Build__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Jen Romano,Devon Kapler,John Herson,Kalidass,Anil,Paresh,Prasad,Brijesh,IDC - Test 1,IDC - Test 2,Rebecca Loudermilk,Antara,Gaurav,Sunil'),
	Owner_Test__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Jen Romano,Devon Kapler,John Herson,Kalidass,Anil,Paresh,Prasad,Brijesh,IDC - Test 1,IDC - Test 2'),
	Status_Design__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not Started,In Progress,In Review,Completed,Waiting on Someone Else'),
	Status_Build__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not Started,In Progress,In Review,Completed,Waiting on Someone Else,In QA'),
	Status_Test__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not Started,In Progress,In Review,Completed,Waiting on Someone Else'),
	Design_Document__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Build_Document__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Technical_Requirement__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UAT_Group__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Deployment_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Training_Module__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Post_as_a_Top_Issue__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Pass_to__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Business Team,Tech Team,Transformation,QB & SBC,Other - IT,SKU/Pricebook Cleanup,App Maintenance,Program Management,Lead Management,Partner Center,Training,Future Business Process,Future Release'),
	Requester__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	LD_Classification__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Lead Routing,Partner Facing'),
	Requirement_Traceability_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Met,Partially Met,Not Met'),
	Requirement_Traceability_Comments__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Reason__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Business Withdrew,Passed to Transformation,Training Issue,Passed to Application Maintenance,Technical Complexity,Further Clarification could not be determined,Departmental Limitation,Existing Functionality,Pending Business Follow-up'),
	Duplicate__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X4_Partner_Acct_Contact_exist_in_SFDC__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X5_Create_Acct_Contact_in_SFDC__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X6_Set_up_Inside_Sales_Rep_Access__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X7_Set_up_Lead_Distribution_Account__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X8_Set_up_Views_Queues__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X9_Set_up_Routing_Rules__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X10_Confirm_training_is_completed__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X11_Generate_user_ID_password__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X12_Notify_Channel_Ops_process_complete__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Related_to_SFA_Release__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X13_Participating_in_Deal_Registration__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X14_Participating_in_MDF__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	X15_Participating_in_Business_Planning__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Submit_to_RFC__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Approved_by_RFC__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	SLA_Actual_Delivery__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Assigned_BA__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Assigned_Developer__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Assigned_Tester__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Build_Document_Location__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	SLA_Target_Delivery__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Code_Location__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Test_Script_Location__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UAT_Script__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Target_Deployment_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Release_Notes_Location__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Contacts_Transferred__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	APAC_Approval__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	EMEA_Approval__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	LATAM_Approval__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NA_Approval__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	GCM_Documentation__c string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NA_Business_Unit__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Commercial,Public Sector,N/A'),
	Impacted_Regions__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'APAC,EMEA,Global,LATAM,NA'),
	Impacted_NA_Business_Units__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Commercial,Public Sector,Both'),
	CasePriority__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CostPercentage__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Countries_Sold_In__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'US,Canada,Argentina,Brazil,EMEA,Japan,Korea,China,Australia,Singapore,India'),
	NPR_EOL_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Entitlement_Quantity__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Information__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	NPR_Item_Description__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Launch_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_MSRP_USD__c double OPTIONS (CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_New_Product_Notes__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Primary_BU_Percent__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Primary_BU__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Platform,Middleware,Cloud,Storage'),
	NPR_Product_Hierarchy__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'GLS.Fees / Other.Command Center,GLS.Fees / Other.Other,GLS.Fees / Other.Partner Training Fee,GLS.Fees / Other.Program Fees,GLS.Merchandise.Cool Stuff,GLS.On-sites.On-Site Training,GLS.On-sites.On-site Cloud,GLS.On-sites.On-site Custom,GLS.On-sites.On-site JBoss,GLS.On-sites.On-site Red Hat,GLS.Open Enrollment.Open Enrollment Cloud,GLS.Open Enrollment.Open Enrollment JBoss,GLS.Open Enrollment.Open Enrollment Red Hat,GLS.Red Hat Academy.Red Hat Academy,GLS.Training Kits.Training Kits Cloud,GLS.Training Kits.Training Kits JBoss,GLS.Training Kits.Training Kits Red Hat,GLS.Training Units.Training Units,GLS.Virtual Training.Virtual Training Cloud,GLS.Virtual Training.Virtual Training JBoss,GLS.Virtual Training.Virtual Training Red Hat,GLS.e-Learning.e-Learning,GPS.Consulting Units.Consulting Units MW,GPS.Consulting Units.Consulting Units Red Hat,GPS.Consulting.Consulting Amentra,GPS.Consulting.Consulting Cloud,GPS.Consulting.Consulting JBoss,GPS.Consulting.Consulting Middleware,GPS.Consulting.Consulting Red Hat,GPS.Fees / Other.Command Center Fee,GPS.Fees / Other.Other,GPS.GES.Embedded NRE / Service,GPS.GES.Embedded Support,GSS.Cloud.L3 Support,GSS.Developer Support.Application Developer Support,GSS.Developer Support.Dev Support Enterprise (Legacy),GSS.Developer Support.Dev Support Professional (Legacy),GSS.Developer Support.Developer Support,GSS.Developer Support.JBDS,GSS.Developer Support.JBoss IDE,GSS.Developer Support.JBoss Partner,GSS.Developer Support.Other,GSS.Developer Support.Per Incident,GSS.Developer Support.Portfolio Developer Support,GSS.Developer Support.Standard Developer Support,GSS.Other.Other,GSS.TAM.Cloud TAM,GSS.TAM.JBoss TAM,GSS.TAM.Red Hat TAM,GSS.TAM.Storage TAM,GSS.TAM.Virtualization TAM,Subscriptions.Appliances.Console,Subscriptions.Appliances.Storage Software,Subscriptions.Appliances.Virtual Storage,Subscriptions.BRMS / Rules.BRMS Platform,Subscriptions.BRMS / Rules.Rules Framework,Subscriptions.Certificate Sys and Directory Serv.Certificate Sys,Subscriptions.Certificate Sys and Directory Serv.Directory Serv,Subscriptions.Certificate Sys and Directory Serv.IPA,Subscriptions.Certification.Hardware Certification,Subscriptions.Cloud Provider.Extended Update Support,Subscriptions.Cloud Provider.High Availability,Subscriptions.Cloud Provider.JBoss for Cloud Providers,Subscriptions.Cloud Provider.Load Balancer,Subscriptions.Cloud Provider.Management Tool for Cloud Providers,Subscriptions.Cloud Provider.Provision Tool for Cloud Providers,Subscriptions.Cloud Provider.RHEL Server,Subscriptions.Cloud Provider.RHEL for Cloud Providers,Subscriptions.Cloud Provider.Resilient Storage,Subscriptions.Cloud Provider.Scalable File System,Subscriptions.CloudForms.CloudForms,Subscriptions.CloudForms.CloudForms plus RHEL,Subscriptions.CloudForms.CloudForms plus RHEL and RHEV,Subscriptions.CloudForms.CloudForms plus RHEV,Subscriptions.Data Grid.Data Grid,Subscriptions.Data Services Platform.Enterprise Data Services Platform,Subscriptions.Data Services Platform.Metamatrix,Subscriptions.Enterprise Application Platform.Apache Tomcat,Subscriptions.Enterprise Application Platform.Apache Web Server,Subscriptions.Enterprise Application Platform.Application Server,Subscriptions.Enterprise Application Platform.Cache,Subscriptions.Enterprise Application Platform.Enterprise Application Platform,Subscriptions.Enterprise Application Platform.Enterprise Web Platform,Subscriptions.Enterprise Application Platform.Enterprise Web Server,Subscriptions.Enterprise Application Platform.Enterprise Web Server Plus,Subscriptions.Enterprise Application Platform.Enterprise Web Server with RHEL,Subscriptions.Enterprise Application Platform.Extended Lifecycle Support,Subscriptions.Enterprise Application Platform.Hibernate Framework,Subscriptions.Enterprise Application Platform.JBoss Messaging,Subscriptions.Enterprise Application Platform.JEMS Bundle,Subscriptions.Enterprise Application Platform.Transactions,Subscriptions.Enterprise Application Platform.Web Framework Kit,Subscriptions.Enterprise Portal Platform.Enterprise Portal Platform,Subscriptions.Enterprise Portal Platform.Site Publisher,Subscriptions.Enterprise Web Server.Enterprise Web Server Plus,Subscriptions.Fees / Other.Command Center,Subscriptions.Fees / Other.Freight Charge,Subscriptions.Fees / Other.Other,Subscriptions.Fees / Other.Partner Fees,Subscriptions.Fees / Other.Program Fees,Subscriptions.Fuse.Fuse Developer,Subscriptions.Fuse.Fuse Production,Subscriptions.GES.Embedded NRE / Service,Subscriptions.GES.Embedded Support,Subscriptions.Images.Amazon Machine,Subscriptions.JBoss Communications Platform.Communications Platform,Subscriptions.JON Monitoring.JON Monitoring for EAP,Subscriptions.JON Monitoring.JON Monitoring for EWS,Subscriptions.JON Monitoring.JON Monitoring for SOA,Subscriptions.JON.JON for BRMS,Subscriptions.JON.JON for DG,Subscriptions.JON.JON for EAP,Subscriptions.JON.JON for EDSP,Subscriptions.JON.JON for EPP,Subscriptions.JON.JON for EWP,Subscriptions.JON.JON for EWS,Subscriptions.JON.JON for EWS Plus,Subscriptions.JON.JON for SOA,Subscriptions.MRG.Grid,Subscriptions.MRG.Messaging,Subscriptions.MRG.Realtime,Subscriptions.Openstack.Openstack,Subscriptions.RHEA.CMS,Subscriptions.RHEA.Collaboration,Subscriptions.RHEA.Content Management,Subscriptions.RHEA.PostgreSQL,Subscriptions.RHEA.RH App Stack,Subscriptions.RHEA.RHEA Application Server,Subscriptions.RHEL.Academic,Subscriptions.RHEL.Advanced Mission Critical,Subscriptions.RHEL.Extended Lifecycle Support,Subscriptions.RHEL.EUS for Server,Subscriptions.RHEL.EUS for POWER,Subscriptions.RHEL.EUS for System Z,Subscriptions.RHEL.High Availability,Subscriptions.RHEL.High Performance Network,Subscriptions.RHEL.High-Availability,Subscriptions.RHEL.Load Balancer,Subscriptions.RHEL.Media Kit,Subscriptions.RHEL.Other,Subscriptions.RHEL.RHEL Desktop,Subscriptions.RHEL.RHEL Server,Subscriptions.RHEL.RHEL Workstation,Subscriptions.RHEL.RHEL Workstations,Subscriptions.RHEL.RHEL for Grid Node,Subscriptions.RHEL.RHEL for HPC,Subscriptions.RHEL.RHEL for HPC Compute Node,Subscriptions.RHEL.RHEL for HPC Head Node,Subscriptions.RHEL.RHEL for IBM Power,Subscriptions.RHEL.RHEL for IBM System z,Subscriptions.RHEL.RHEL for ITANIUM,Subscriptions.RHEL.RHEL for Mainframe,Subscriptions.RHEL.RHEL for Point of Sale,Subscriptions.RHEL.RHEL for Prem Architectures,Subscriptions.RHEL.RHEL for SAP,Subscriptions.RHEL.RHEL for SAP applications,Subscriptions.RHEL.RHEL for System Z,Subscriptions.RHEL.RHEL for Virtual Machines,Subscriptions.RHEL.Resilient Storage,Subscriptions.RHEL.Scalable File System,Subscriptions.RHEL.Shared Storage,Subscriptions.RHEL.Stronghold Web Server,Subscriptions.RHEV.RHEV for Desktops,Subscriptions.RHEV.RHEV for Servers,Subscriptions.RHN Satellite.Academic,Subscriptions.RHN Satellite.Management Modules,Subscriptions.RHN Satellite.Mgmt + Provisioning + Monitoring,Subscriptions.RHN Satellite.Monitoring,Subscriptions.RHN Satellite.Monitoring + Management Modules,Subscriptions.RHN Satellite.Monitoring + Provisioning,Subscriptions.RHN Satellite.Other,Subscriptions.RHN Satellite.Provisioning,Subscriptions.RHN Satellite.Provisioning + Management Modules,Subscriptions.RHN Satellite.Proxy,Subscriptions.RHN Satellite.Satellite Server,Subscriptions.RHN Satellite.Satellite Starter Pack,Subscriptions.RHX.Alfresco,Subscriptions.RHX.Amanda,Subscriptions.RHX.CentricCRM,Subscriptions.RHX.Compiere,Subscriptions.RHX.Enterprise DB,Subscriptions.RHX.Groundwork,Subscriptions.RHX.Jasper,Subscriptions.RHX.MySQL,Subscriptions.RHX.OpenFire,Subscriptions.RHX.Pentaho,Subscriptions.RHX.Sugar,Subscriptions.RHX.Zenoss,Subscriptions.RHX.Zimbra,Subscriptions.Runtime.Extended Lifecycle Support,Subscriptions.Runtime.GFS and Cluster Suite Preloads,Subscriptions.Runtime.L3 Support and Annual Fee,Subscriptions.Runtime.RHEL Field Updates,Subscriptions.Runtime.RHEL Preloads,Subscriptions.SOA-P / jBPM.Business Process Bundle,Subscriptions.SOA-P / jBPM.Enterprise SOA Platform,Subscriptions.SOA-P / jBPM.jBPM Framework,Subscriptions.Templates.GoGrid,Subscriptions.Templates.Rightscale Server,Subscriptions.OpenShift.OpenShift Enterprise,Subscriptions.OpenShift.Broker Infrastructure,Subscriptions.OpenShift.JBoss EAP'),
	NPR_RHN_Channel_Families__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Received_NPP_Approval__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	NPR_Secondary_BU_Percent__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Secondary_BU__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Platform,Middleware,Cloud,Storage'),
	NPR_Socket_Limit__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Support_Level__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'EMBEDDED L3,ISV L3 Partner Support,L1-L3,L3,L3 Support Partner,PSC,PSD,PSF,UNRESTRICTED L3,Other'),
	NPR_Support_Type__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AMC,AMC-ENHANCED,DEV-ENTERPRISE,DEV-PROFESSIONAL,Layered,PREMIUM,SELF-SUPPORT,STANDARD,None'),
	NPR_Term__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1 Year,3 Year,30 Day,60 Day,90 Day'),
	NPR_Tertiary_BU_Percent__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	NPR_Tertiary_BU__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Platform,Middleware,Cloud,Storage'),
	NPR_Virt_Limit__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Priority__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RelativeBenefit__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RelativeCost__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RelativePenalty__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ValuePercentage__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UAT_Results__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UAT__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Rank__c string(64) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Business_Justification__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UserStoryCustom__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Alternatives__c string(600) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Discussion_Mojo_URL__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Object_ID__c string(10) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Recommendation__c string(1000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Reproducible__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Severity__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1 - Low,2 - Medium,3 - High,4 - Critical'),
	Subteam__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Core Team,Marketing,Sales/Sales Ops,Order Management,Customer Data,Global Change Management,Global Business Analytics,Global Support Services,Enterprise Architecture,IT Biz Ops,SOA Services and ESB (SSE),Salesforce Automation (SFA)'),
	System_Environment__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Team__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'PMO,Process,Technology'),
	Test_Case_Number__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Test_Phase__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1 - Technical Unit Test,2 - Functional Unit Test,3 - Integration Test I,4 - Hardening,5 - Integration Test II,6 - User Acceptance Test,7 - Performance Test,8 - Regression Test'),
	Vendor_Request_Number__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Release_Decision_Reasoning__c string(200) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Category__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Access/Env Issues,APPX Tool,Big Machines,Commissions Extract,Conversion,Customer Management,Dataloader Error,Design Issue,Missing Data,Opportunity Enhancements,Opportunity Splits,Opportunity to Order,Oracle extract issues,Order to Opportunity,Other Report Issue,Partner Center,Product Enhancements,Report Data Issues,SFDC Account,SFDC issues,SKU,System Defects,User'),
	Subcategory__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Additional Parties/ PRL,Address Enhancement,BigMachines Quoting and Discounts,BM SFDC Integration,Business Logic Issue,Contact Enhancement,Contact Search-Before-Create,Conversion Data Testing,Credit Check,Data Issues,EBS Account Integration,EBS Accounts Extension,EBS Order Inbound,EBS Order Outbound,Enrollment,Forms,Login Issues,New Data Fields Not Available,Opportunities,Opportunity Enhancements,Opportunity Split,Opportunity Staging Table,Opportunity to Order Process,Order to Opportunity Process,Other Issue,Partner Accounts,Portal Access,Pricing Service,PRL,Product Enhancement,Quoting/Pricing,Report/Folder Access Issue,Report Template Issues,Report Types,Sales Account Enhancements,Sales Account – Party Integration,Sales Account Search-Before-Create,Universe Access,Updating/Creating Opportunities'),
	C360_Project__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'SFDC Integration,Opportunity Conversion,SKU Redesign,GBA Reporting,SFDC Reporting,Renewals,Sales Incentives'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_AccountId FOREIGN KEY(AccountId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Cases'),
	CONSTRAINT FK_Asset_AssetId FOREIGN KEY(AssetId) REFERENCES Asset (Id) OPTIONS (NAMEINSOURCE 'Cases'),
	CONSTRAINT FK_BusinessHours_BusinessHoursId FOREIGN KEY(BusinessHoursId) REFERENCES BusinessHours (Id) OPTIONS (NAMEINSOURCE 'Cases'),
	CONSTRAINT FK_Case__ParentId FOREIGN KEY(ParentId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'Cases'),
	CONSTRAINT FK_CasePriority__c_CasePriority__c FOREIGN KEY(CasePriority__c) REFERENCES CasePriority__c (Id) OPTIONS (NAMEINSOURCE 'Cases__r'),
	CONSTRAINT FK_Contact_ContactId FOREIGN KEY(ContactId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Cases'),
	CONSTRAINT FK_Opportunity_Opportunity_Name__c FOREIGN KEY(Opportunity_Name__c) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'Cases__r'),
	CONSTRAINT FK_User__Assigned_BA__c FOREIGN KEY(Assigned_BA__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Cases__r'),
	CONSTRAINT FK_User__Assigned_Developer__c FOREIGN KEY(Assigned_Developer__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Cases1__r'),
	CONSTRAINT FK_User__Assigned_Tester__c FOREIGN KEY(Assigned_Tester__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Cases2__r'),
	CONSTRAINT FK_User__GCM_Business_Analyst__c FOREIGN KEY(GCM_Business_Analyst__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Cases3__r'),
	CONSTRAINT FK_User__Owner__c FOREIGN KEY(Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'CasesOwned__r')
) OPTIONS (NAMEINSOURCE 'Case', UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CaseComment (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsPublished boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CommentBody string OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__ParentId FOREIGN KEY(ParentId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'CaseComments')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CaseCommentData__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Case__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CaseCommentId__c string(18) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CreatedBy__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CreatedDate__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	LastModifiedDate__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__Case__c FOREIGN KEY(Case__c) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'Case_Comments_Meta_Data__r'),
	CONSTRAINT FK_User__CreatedBy__c FOREIGN KEY(CreatedBy__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Case_Comments_Data__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CaseCommentData__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CaseCommentData__c_ItemId FOREIGN KEY(ItemId) REFERENCES CaseCommentData__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseContactRole (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CasesId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ContactId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Role string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Technical Contact,Business Contact,Decision Maker,Other'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__CasesId FOREIGN KEY(CasesId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'CaseContactRoles'),
	CONSTRAINT FK_Contact_ContactId FOREIGN KEY(ContactId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'CaseContactRoles')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseFeed (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeedPostId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'TrackedChange,UserStatus,TextPost,AdvancedTextPost,LinkPost,ContentPost,PollPost,RypplePost,ProfileSkillPost,DashboardComponentSnapshot,ApprovalPost,CaseCommentPost,ReplyPost,EmailMessageEvent,CallLogPost,ChangeStatusPost,AttachArticleEvent,MilestoneEvent,ActivityEvent,ChatTranscriptPost,CollaborationGroupCreated,CollaborationGroupUnarchived,SocialPost,QuestionPost,FacebookPost,BasicTemplateFeedItem,CreateRecordEvent,CanvasPost,AnnouncementPost'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__ParentId FOREIGN KEY(ParentId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'Feeds')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseHistory (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CaseId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account,Additional_Countries_of_Operation__c,Admin_Assessment__c,Admin_Priority__c,Alternatives__c,APAC_Approval__c,Approved_by_RFC__c,Areas_Affected__c,Asset,Assigned_BA__c,Assigned_Developer__c,Assigned_Tester__c,Blackberry_Model_Number__c,BLOG_URL__c,Build_Document__c,Build_Document_Location__c,Business_Justification__c,BusinessHours,C360_Project__c,Case_Notes__c,Case_Resolution__c,CasePriority__c,CaseReopenedByPartner__c,Category__c,closed,Code_Location__c,Comments__c,Contact,Contacts_Transferred__c,Country__c,created,CurrencyIsoCode,Demo__c,Department__c,Deployment_Date__c,Description,Design_Document__c,Discussion_Mojo_URL__c,Duplicate__c,EMEA_Approval__c,EMEA_Channel_Ops_Type__c,EnterURLWhereProblemOccurs__c,feedEvent,Finance_Notified__c,Function__c,GCM_Business_Analyst__c,GCM_Documentation__c,GCM_Documentation_Complete__c,Impacted_NA_Business_Units__c,Impacted_Regions__c,Information__c,Instructions__c,IsClosedOnCreate,IsEscalated,IsSelfServiceClosed,Issue_Type__c,Issue_Type_Classification__c,Issue_Type_Detail__c,IsVisibleInSelfService,IT_Subject__c,IT_User_Story__c,LATAM_Approval__c,LD_Classification__c,Mobile_Phone__c,Mobile_Type__c,Module__c,Modules__c,Momentum_SET_UP__c,NA_Approval__c,NA_Business_Unit__c,New_Address__c,New_Company_Name__c,NOTES_FROM_R2_GATHERING_MEETINGS__c,NPR_Countries_Sold_In__c,NPR_Entitlement_Quantity__c,NPR_EOL_Date__c,NPR_Information__c,NPR_Item_Description__c,NPR_Launch_Date__c,NPR_MSRP_USD__c,NPR_New_Product_Notes__c,NPR_Primary_BU__c,NPR_Primary_BU_Percent__c,NPR_Product_Hierarchy__c,NPR_Received_NPP_Approval__c,NPR_RHN_Channel_Families__c,NPR_Secondary_BU__c,NPR_Secondary_BU_Percent__c,NPR_Socket_Limit__c,NPR_Support_Level__c,NPR_Support_Type__c,NPR_Term__c,NPR_Tertiary_BU__c,NPR_Tertiary_BU_Percent__c,NPR_Virt_Limit__c,Number_of_Seats_Requested__c,Object_ID__c,Opportunity_Name__c,Optional__c,Oracle_Updated__c,Organization__c,Origin,Owner,Owner__c,Owner_Build__c,Owner_Design__c,Owner_Test__c,ownerAccepted,ownerAssignment,ownerEscalated,Parent,Partnership_Upgrade__c,Pass_to__c,Post_as_a_Top_Issue__c,Prioritized__c,Priority,Process_Area__c,Process_Issue__c,Production_Deployment_Date__c,Queue_Name__c,Rally_Iteration__c,Rally_Last_Sync__c,Rally_Schedule_State__c,Rally_State__c,Rally_Story_URL__c,Rally_StoryPoints__c,Rank__c,Reason,Reason__c,Recommendation__c,locked,RecordType,unlocked,RedHatLoginName__c,Region__c,Related_Project__c,Related_to_SFA_Release__c,RelativeBenefit__c,RelativeCost__c,RelativePenalty__c,Release_Decision_Reasoning__c,Release_ID__c,Release_Impacted__c,Release_Notes_Location__c,Release_Type__c,Reproducible__c,Requester__c,Required_for_Release__c,Requirement_Traceability_Comments__c,Requirement_Traceability_Status__c,Requires_Follow_Up__c,Resolution_Description__c,Routing_Sheet_Updated__c,Rx_High_Level_Requirements__c,Severity__c,sfdc_Accounts_Updated__c,sfdc_Leads_Updated__c,Ship_To_Info__c,Sign_Off_Date__c,SLA_Actual_Delivery__c,SLA_Target_Delivery__c,Source__c,Spam_E_mail_to_Case__c,Specializations__c,Status,Status_Build__c,Status_Design__c,Status_Test__c,Steering_Committee_Status__c,Sub_Module__c,Subcategory__c,Subject,Submit_to_RFC__c,Subteam__c,System_Environment__c,System_Issue__c,Target_Deployment_Date__c,Target_Release__c,Targeted_Close_Date__c,Team__c,Technical_Requirement__c,Test_Case_Number__c,Test_Phase__c,Test_Script_Location__c,Theme__c,Training_Module__c,Type,Type_Detail__c,UAT__c,UAT_Group__c,UAT_Results__c,UAT_Script__c,User_Persona__c,User_Story__c,UserStoryCustom__c,Vendor_Request_Number__c,Work_Module__c,X1_Recd_Partner_Activation_Template__c,X10_Confirm_training_is_completed__c,X11_Generate_user_ID_password__c,X12_Notify_Channel_Ops_process_complete__c,X13_Participating_in_Deal_Registration__c,X14_Participating_in_MDF__c,X15_Participating_in_Business_Planning__c,X2_Confirm_Partner_is_in_Partner_Center__c,X3_Notify_Channel_Ops_Ready_for_Training__c,X4_Partner_Acct_Contact_exist_in_SFDC__c,X5_Create_Acct_Contact_in_SFDC__c,X6_Set_up_Inside_Sales_Rep_Access__c,X7_Set_up_Lead_Distribution_Account__c,X8_Set_up_Views_Queues__c,X9_Set_up_Routing_Rules__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__CaseId FOREIGN KEY(CaseId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CasePriority__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Totals__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Case__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ExternalId__c string(36) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RelativeCostFormula__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RelativeCost__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RelativeValueFormula__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RelativeValue__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	TotalCost__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	TotalValue__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__Case__c FOREIGN KEY(Case__c) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'Case_Priorities__r'),
	CONSTRAINT FK_CasePriorityTotals__c_Totals__c FOREIGN KEY(Totals__c) REFERENCES CasePriorityTotals__c (Id) OPTIONS (NAMEINSOURCE 'Case_Priorities__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CasePriority__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CasePriority__c_ItemId FOREIGN KEY(ItemId) REFERENCES CasePriority__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CasePriorityTotals__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	TotalCost__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	TotalValue__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CasePriorityTotals__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CasePriorityTotals__c_ItemId FOREIGN KEY(ItemId) REFERENCES CasePriorityTotals__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseRecordType__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(38) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	RecordTypeId__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RecordTypeName__c string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CaseRecordType__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CaseRecordType__c_ItemId FOREIGN KEY(ItemId) REFERENCES CaseRecordType__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseShare (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CaseId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UserOrGroupId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CaseAccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Read,Edit,All'),
	RowCause string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Owner,Manual,Rule,ImplicitChild,ImplicitParent,Team,Territory,TerritoryManual,TerritoryRule,Territory2Forecast'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__CaseId FOREIGN KEY(CaseId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'Shares')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseSolution (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CaseId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SolutionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__CaseId FOREIGN KEY(CaseId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'CaseSolutions'),
	CONSTRAINT FK_Solution_SolutionId FOREIGN KEY(SolutionId) REFERENCES Solution (Id) OPTIONS (NAMEINSOURCE 'CaseSolutions')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseStatus (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	MasterLabel string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SortOrder integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDefault boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsClosed boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseTag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__ItemId FOREIGN KEY(ItemId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseTeamMember (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MemberId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TeamTemplateMemberId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TeamRoleId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__ParentId FOREIGN KEY(ParentId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'TeamMembers')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseTeamRole (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'None,Read,Edit'),
	PreferencesVisibleInCSP boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseTeamTemplate (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(300) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseTeamTemplateMember (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TeamTemplateId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MemberId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TeamRoleId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CaseTeamTemplateRecord (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TeamTemplateId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Case__ParentId FOREIGN KEY(ParentId) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'TeamTemplateRecords')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CategoryData (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CategoryNodeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	RelatedSobjectId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CategoryNode (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MasterLabel string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SortOrder integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SortStyle string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'custom,alphabetical'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CategoryNodeLocalization (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CategoryNodeId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Language_ string(40) OPTIONS (NAMEINSOURCE 'Language', UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'en_US,de,es,fr,it,ja,sv,ko,zh_TW,zh_CN,pt_BR,nl_NL,da,th,fi,ru,es_MX'),
	Value_ string(1000) OPTIONS (NAMEINSOURCE 'Value', NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NamespacePrefix string(15) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CategoryNode_CategoryNodeId FOREIGN KEY(CategoryNodeId) REFERENCES CategoryNode (Id) OPTIONS (NAMEINSOURCE 'Localization')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CCB_Event__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CCB_Date_Time__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Change_Control__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Management__c_Change_Control__c FOREIGN KEY(Change_Control__c) REFERENCES Change_Management__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000000xep2EAA')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CCB_Event__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CCB_Event__c_ItemId FOREIGN KEY(ItemId) REFERENCES CCB_Event__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CDH_Party__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	CDH_Party_Name__c string(240) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CDH_Party_Number_Ext__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CDH_Party_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Group,ORGANIZATION,Party Relationship,PERSON'),
	DUNS__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CDH_Party__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CDH_Party__c_ItemId FOREIGN KEY(ItemId) REFERENCES CDH_Party__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Change_Control_Board__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Approved_Changed__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	Member_Issue__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Attended_CCB__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CCBMember__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CCB_Event__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CCB_Event__c_CCB_Event__c FOREIGN KEY(CCB_Event__c) REFERENCES CCB_Event__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000000xesfEAA'),
	CONSTRAINT FK_User__CCBMember__c FOREIGN KEY(CCBMember__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000000xeo4EAA')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Change_Control_Board__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Control_Board__c_ItemId FOREIGN KEY(ItemId) REFERENCES Change_Control_Board__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Change_Management__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Business_Justification__c string(1000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Deployment_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Change_Management__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Management__c_ItemId FOREIGN KEY(ItemId) REFERENCES Change_Management__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Change_Request__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Age__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Approver__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Assigned_Developer__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Biz_Process_Process_Hours__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Bug_Deployment__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Bug_description__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Build_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Not Started,In Progress,Ready to Test,Ready to deploy,Completed'),
	Category__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Business,Technology,Adoption and Org Readiness'),
	Configuration_Hours__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Consensus_Meeting_Comments__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Date_Reviewed_in_Consensus_Meeting__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Date_for_Reassessment__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Deploying_from_environment__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Developer,Staging,Test (QA)'),
	Deploying_to_environment__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Test (QA),Staging,Production'),
	Deployment_Instructions__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Deployment_Type__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Code change,Configuration only,Configuration and code,Profiles and permissions,Data Migration'),
	Detailed_Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Development_Hours__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Development_Progress__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Estimated_End_Time__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Final_Approver__c string(50) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Fix_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Code change,Configuration only,Configuration and code,Profiles and permissions,Data Migration'),
	Flag_for_Escalation__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Implementation_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Implementation_Notes__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Planned_Completion_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Priority__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Low,Medium,High,Critical'),
	Production_fix__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Proposed_Start_Time__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Related_Release__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Related_Requirement__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Requirements_Hours__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Rollback_plan__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Pending,Submitted for approval,Approved,Denied,In Progress'),
	Sub_Category__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Adoption,Application,Application Design,Communications,Data Cleansing,Data Migration,Integration,Process,Requirements,Testing,Training,Timeline,Resources,Budget'),
	Summary__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Tech_Design_Hours__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_Level_of_Effort__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Work_Package__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Release__c_Related_Release__c FOREIGN KEY(Related_Release__c) REFERENCES Release__c (Id) OPTIONS (NAMEINSOURCE 'Change_Requests__r'),
	CONSTRAINT FK_Requirement__c_Related_Requirement__c FOREIGN KEY(Related_Requirement__c) REFERENCES Requirement__c (Id) OPTIONS (NAMEINSOURCE 'Change_Requests__r'),
	CONSTRAINT FK_User__Assigned_Developer__c FOREIGN KEY(Assigned_Developer__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Change_Requests__r'),
	CONSTRAINT FK_Work_Package__c_Work_Package__c FOREIGN KEY(Work_Package__c) REFERENCES Work_Package__c (Id) OPTIONS (NAMEINSOURCE 'Change_Requests__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Change_Request__Feed (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeedPostId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'TrackedChange,UserStatus,TextPost,AdvancedTextPost,LinkPost,ContentPost,PollPost,RypplePost,ProfileSkillPost,DashboardComponentSnapshot,ApprovalPost,CaseCommentPost,ReplyPost,EmailMessageEvent,CallLogPost,ChangeStatusPost,AttachArticleEvent,MilestoneEvent,ActivityEvent,ChatTranscriptPost,CollaborationGroupCreated,CollaborationGroupUnarchived,SocialPost,QuestionPost,FacebookPost,BasicTemplateFeedItem,CreateRecordEvent,CanvasPost,AnnouncementPost'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Request__c_ParentId FOREIGN KEY(ParentId) REFERENCES Change_Request__c (Id) OPTIONS (NAMEINSOURCE 'Feeds')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Change_Request__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Approver__c,Assigned_Developer__c,Biz_Process_Process_Hours__c,Bug_Deployment__c,Bug_description__c,Build_Status__c,Category__c,Configuration_Hours__c,Consensus_Meeting_Comments__c,created,CurrencyIsoCode,Date_for_Reassessment__c,Date_Reviewed_in_Consensus_Meeting__c,Deploying_from_environment__c,Deploying_to_environment__c,Deployment_Instructions__c,Deployment_Type__c,Detailed_Description__c,Development_Hours__c,Development_Progress__c,Estimated_End_Time__c,feedEvent,Final_Approver__c,Fix_Type__c,Flag_for_Escalation__c,Implementation_Date__c,Implementation_Notes__c,Name,Owner,ownerAccepted,ownerAssignment,Planned_Completion_Date__c,Priority__c,Production_fix__c,Proposed_Start_Time__c,locked,RecordType,unlocked,Related_Release__c,Related_Requirement__c,Requirements_Hours__c,Rollback_plan__c,Status__c,Sub_Category__c,Summary__c,Tech_Design_Hours__c,Work_Package__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Request__c_ParentId FOREIGN KEY(ParentId) REFERENCES Change_Request__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Change_Request__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Request__c_ItemId FOREIGN KEY(ItemId) REFERENCES Change_Request__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Change_Request_Members__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Role__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Approver,Subject Matter Expert,End-User'),
	Change_Objects__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ChangeRequestMember__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Requests__c_Change_Objects__c FOREIGN KEY(Change_Objects__c) REFERENCES Change_Requests__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000000xfY2EAI'),
	CONSTRAINT FK_User__ChangeRequestMember__c FOREIGN KEY(ChangeRequestMember__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000000xfYMEAY')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Change_Request_Members__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Request_Members__c_ItemId FOREIGN KEY(ItemId) REFERENCES Change_Request_Members__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Change_Requests__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Proposed_Solution__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Request_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Impact_Analysis__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Does_Change_Impact_Integration__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Impact_Analysis_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Integration_Impact_Analysis__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Module_Impacts__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Home,Campaigns,Leads,Accounts,Contacts,Opportunities,Products,Documents,Reports,Contracts,Cases,Solutions,Dashboards,Integration,Self-Service Portal'),
	Deployment_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Deployment_Documentation__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Training_Required__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Rollback_Plan__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Training_Plan__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Assumptions__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Changed_Completed__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Change_Completed_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CCB_Approved__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CCB_Approval_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Does_this_Request_Impact_Reporting__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Reporting_Impact_Analysis__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Benefits_Analysis__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RelatedCase__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Change_Control__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CCB_Event__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CCB_Event__c_CCB_Event__c FOREIGN KEY(CCB_Event__c) REFERENCES CCB_Event__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000000xfkmEAA'),
	CONSTRAINT FK_Case__RelatedCase__c FOREIGN KEY(RelatedCase__c) REFERENCES Case_ (Id) OPTIONS (NAMEINSOURCE 'R00N30000000xeXrEAI'),
	CONSTRAINT FK_Change_Management__c_Change_Control__c FOREIGN KEY(Change_Control__c) REFERENCES Change_Management__c (Id) OPTIONS (NAMEINSOURCE 'R00N30000000xfgfEAA')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Change_Requests__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Assumptions__c,Benefits_Analysis__c,CCB_Approval_Date__c,CCB_Approved__c,CCB_Event__c,Change_Completed_Date__c,Change_Control__c,Changed_Completed__c,created,CurrencyIsoCode,Deployment_Date__c,Deployment_Documentation__c,Does_Change_Impact_Integration__c,Does_this_Request_Impact_Reporting__c,feedEvent,Impact_Analysis__c,Impact_Analysis_Date__c,Integration_Impact_Analysis__c,Module_Impacts__c,Name,ownerAccepted,ownerAssignment,Proposed_Solution__c,locked,unlocked,RelatedCase__c,Reporting_Impact_Analysis__c,Request_Date__c,Rollback_Plan__c,Training_Plan__c,Training_Required__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Requests__c_ParentId FOREIGN KEY(ParentId) REFERENCES Change_Requests__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Change_Requests__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Change_Requests__c_ItemId FOREIGN KEY(ItemId) REFERENCES Change_Requests__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Chatter_Group_Name__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(38) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Chatter_Group_Id__c string(15) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Chatter_Group_Name__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Chatter_Group_Name__c_ItemId FOREIGN KEY(ItemId) REFERENCES Chatter_Group_Name__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Classification__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Descendents__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyDepth__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyKey__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyLinks__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyRootId__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyRootName__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Hierarchy__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	IsActive__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IsInlineEdit__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Parent__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ReferenceKey__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Translations__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Picklist_Value__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Picklist__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	AvailableForOnboarding__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Help_Text__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Classification__c_Parent__c FOREIGN KEY(Parent__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Subclassifications__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Classification__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AvailableForOnboarding__c,created,CurrencyIsoCode,Descendents__c,Description__c,feedEvent,Help_Text__c,IsActive__c,IsInlineEdit__c,Legacy_Picklist__c,Legacy_Picklist_Value__c,Name,Owner,ownerAccepted,ownerAssignment,Parent__c,locked,unlocked,ReferenceKey__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Classification__c_ParentId FOREIGN KEY(ParentId) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Classification__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Classification__c_ItemId FOREIGN KEY(ItemId) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ClassificationTranslation__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Classification__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ClassificationParentId__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	GoogleTranslation__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyDepth__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	HierarchyLinks__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Hierarchy__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'German,Spanish,French,Italian,Japanese,Swedish,Korean,Chinese (Traditional),Chinese (Simplified),Portuguese (Brazilian),Dutch,Danish,Thai,Finnish,Russian'),
	ManualTranslation__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Parent__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Status__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Translation__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	LanguageCode__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Help_Text__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_ClassificationTranslation__c_Parent__c FOREIGN KEY(Parent__c) REFERENCES ClassificationTranslation__c (Id) OPTIONS (NAMEINSOURCE 'Subtranslations__r'),
	CONSTRAINT FK_Classification__c_Classification__c FOREIGN KEY(Classification__c) REFERENCES Classification__c (Id) OPTIONS (NAMEINSOURCE 'Translations__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE ClassificationTranslation__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Classification__c,created,CurrencyIsoCode,feedEvent,GoogleTranslation__c,Help_Text__c,Language__c,ManualTranslation__c,Name,ownerAccepted,ownerAssignment,Parent__c,locked,unlocked'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_ClassificationTranslation__c_ParentId FOREIGN KEY(ParentId) REFERENCES ClassificationTranslation__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ClassificationTranslation__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_ClassificationTranslation__c_ItemId FOREIGN KEY(ItemId) REFERENCES ClassificationTranslation__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ClientBrowser (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	UsersId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FullUserAgent string(1024) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ProxyInfo string(1024) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastUpdate timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Communities_Featured_Headline__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Audience__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Button_URL__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	HTML_Value__c string(32768) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Headline__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Include_Button__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Publish_Date__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Rotator_Image_URL__c string(255) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Draft,Published,Archived'),
	Thumbnail_Image_URL__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Site_com_Page__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cloud,Dashboard,Homepage,Marketing_Resources,Marketing_Resources_2,Middleware,Platform,Resources,Sales_Resources,Storage,Technical_Resources,Virtualization'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Audience__c_Audience__c FOREIGN KEY(Audience__c) REFERENCES Audience__c (Id) OPTIONS (NAMEINSOURCE 'Communities_Featured_Headlines__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Communities_Featured_Headline__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Featured_Headline__c_ItemId FOREIGN KEY(ItemId) REFERENCES Communities_Featured_Headline__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Communities_Featured_Headline_Label__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Button_Label__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Communities_Featured_Headline__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Headline_Label__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language_Code__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'English,German,Spanish,French,Italian,Japanese,Korean,Chinese (Simplified),Portuguese (Brazilian)'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Featured_Headline__c_Communities_Featured_Headline__c FOREIGN KEY(Communities_Featured_Headline__c) REFERENCES Communities_Featured_Headline__c (Id) OPTIONS (NAMEINSOURCE 'Communities_Featured_Headline_Labels__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Communities_Featured_Headline_Label__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Featured_Headline_Label__c_ItemId FOREIGN KEY(ItemId) REFERENCES Communities_Featured_Headline_Label__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Communities_Navigation_Item__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Audience__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Content_Targeting__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Audience,Tab/Object Permissions'),
	English_Label__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Parent_Item__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Sequence__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Tab_Name__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	URL__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Main Navigation,Sidebar Navigation'),
	Navigation_Tree__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Audience__c_Audience__c FOREIGN KEY(Audience__c) REFERENCES Audience__c (Id) OPTIONS (NAMEINSOURCE 'Communities_Navigation_Items__r'),
	CONSTRAINT FK_Communities_Navigation_Item__c_Parent_Item__c FOREIGN KEY(Parent_Item__c) REFERENCES Communities_Navigation_Item__c (Id) OPTIONS (NAMEINSOURCE 'Communities_Navigation_Items__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Communities_Navigation_Item__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Navigation_Item__c_ItemId FOREIGN KEY(ItemId) REFERENCES Communities_Navigation_Item__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Communities_Navigation_Item_Label__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Communities_Navigation_Item__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Label__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language_Code__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'German,Spanish,English,French,Italian,Korean,Japanese,Chinese (Simplified),Portuguese (Brazilian)'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Navigation_Item__c_Communities_Navigation_Item__c FOREIGN KEY(Communities_Navigation_Item__c) REFERENCES Communities_Navigation_Item__c (Id) OPTIONS (NAMEINSOURCE 'Communities_Navigation_Item_Labels__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Communities_Navigation_Item_Label__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Navigation_Item_Label__c_ItemId FOREIGN KEY(ItemId) REFERENCES Communities_Navigation_Item_Label__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Communities_News_Item__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Audience__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Publish_Date__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Sorting_Weight__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Draft,Published,Archived'),
	URL__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	English_Label__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Audience__c_Audience__c FOREIGN KEY(Audience__c) REFERENCES Audience__c (Id) OPTIONS (NAMEINSOURCE 'Communities_News_Items__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Communities_News_Item__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_News_Item__c_ItemId FOREIGN KEY(ItemId) REFERENCES Communities_News_Item__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Communities_News_Item_Label__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Communities_News_Item__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Label__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language_Code__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'German,Spanish,English,French,Italian,Japanese,Swedish,Chinese (Traditional),Chinese (Simplified),Portuguese (Brazilian),Dutch,Danish,Thai,Finnish,Russian'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_News_Item__c_Communities_News_Item__c FOREIGN KEY(Communities_News_Item__c) REFERENCES Communities_News_Item__c (Id) OPTIONS (NAMEINSOURCE 'Communities_News_Item_Labels__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Communities_News_Item_Label__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_News_Item_Label__c_ItemId FOREIGN KEY(ItemId) REFERENCES Communities_News_Item_Label__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Communities_Tool_Shortcut__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Availability_Controlled_By__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Shortcut_URL__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Tool_Name__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Communities_Tool_Shortcut__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Tool_Shortcut__c_ItemId FOREIGN KEY(ItemId) REFERENCES Communities_Tool_Shortcut__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Communities_Tool_Shortcut_Label__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Communities_Tool_Shortcut__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language_Code__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Language__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'English,German,Spanish,French,Italian,Korean,Japanese,Chinese (Simplified),Portuguese (Brazilian)'),
	Link_Text__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Tooltip_Text__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Tool_Shortcut__c_Communities_Tool_Shortcut__c FOREIGN KEY(Communities_Tool_Shortcut__c) REFERENCES Communities_Tool_Shortcut__c (Id) OPTIONS (NAMEINSOURCE 'Communities_Tool_Shortcut_Labels__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Communities_Tool_Shortcut_Label__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Tool_Shortcut_Label__c_ItemId FOREIGN KEY(ItemId) REFERENCES Communities_Tool_Shortcut_Label__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Community (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(1000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsActive boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CommUtils__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(38) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	SetupOwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Last_Run__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CommunityURL__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CommUtils__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CommUtils__c_ItemId FOREIGN KEY(ItemId) REFERENCES CommUtils__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Competitor__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Area__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cloud,Operating System,Hardware,In-House Development,Middleware,Storage,Third Party Applications,Virtualization'),
	Weaknesses__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Competitor__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'IBM,Microsoft,Novell,Oracle,TIBCO,VMware,Other,BEA,Red Flag,Sun,TurboLinux'),
	Account_Profile__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Strengths__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_s_Perception_of_Competitor__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Relevant_Contract_Expiration_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Competitors_Strength__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '0,1,2,3,4,5'),
	Platform_Status_for_JBoss_RHEL__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '1 Not Approved,2 Approved Platform,3 Approved Platform - in use and a Strategic Platform,4 Default Strategic Platform,5 Default Strategic Platform plus Big Installed Base'),
	Other_Competitor__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_Profile__c_Account_Profile__c FOREIGN KEY(Account_Profile__c) REFERENCES Account_Profile__c (Id) OPTIONS (NAMEINSOURCE 'Competitor__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Competitor__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account_Profile__c,Account_s_Perception_of_Competitor__c,Area__c,Competitor__c,Competitors_Strength__c,created,CurrencyIsoCode,feedEvent,Name,Other_Competitor__c,Owner,ownerAccepted,ownerAssignment,Platform_Status_for_JBoss_RHEL__c,locked,unlocked,Relevant_Contract_Expiration_Date__c,Strengths__c,Weaknesses__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Competitor__c_ParentId FOREIGN KEY(ParentId) REFERENCES Competitor__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Competitor__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Competitor__c_ItemId FOREIGN KEY(ItemId) REFERENCES Competitor__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Component__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Dependency_Details__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Description__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Last_Migrated_On__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Last_Migrated_To__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Production,Dev01,Config01,Test01'),
	Related_Component__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Work_Package__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Component__c_Related_Component__c FOREIGN KEY(Related_Component__c) REFERENCES Component__c (Id) OPTIONS (NAMEINSOURCE 'Components__r'),
	CONSTRAINT FK_Work_Package__c_Work_Package__c FOREIGN KEY(Work_Package__c) REFERENCES Work_Package__c (Id) OPTIONS (NAMEINSOURCE 'Components__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Component__Feed (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeedPostId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'TrackedChange,UserStatus,TextPost,AdvancedTextPost,LinkPost,ContentPost,PollPost,RypplePost,ProfileSkillPost,DashboardComponentSnapshot,ApprovalPost,CaseCommentPost,ReplyPost,EmailMessageEvent,CallLogPost,ChangeStatusPost,AttachArticleEvent,MilestoneEvent,ActivityEvent,ChatTranscriptPost,CollaborationGroupCreated,CollaborationGroupUnarchived,SocialPost,QuestionPost,FacebookPost,BasicTemplateFeedItem,CreateRecordEvent,CanvasPost,AnnouncementPost'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Component__c_ParentId FOREIGN KEY(ParentId) REFERENCES Component__c (Id) OPTIONS (NAMEINSOURCE 'Feeds')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Component__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'created,CurrencyIsoCode,Dependency_Details__c,Description__c,feedEvent,Last_Migrated_On__c,Last_Migrated_To__c,Name,Owner,ownerAccepted,ownerAssignment,locked,unlocked,Related_Component__c,Work_Package__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Component__c_ParentId FOREIGN KEY(ParentId) REFERENCES Component__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Component__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Component__c_ItemId FOREIGN KEY(ItemId) REFERENCES Component__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Configuration__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Protected_Value__c string(175) OPTIONS (NATIVE_TYPE 'encryptedstring', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Value__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Configuration__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Configuration__c_ItemId FOREIGN KEY(ItemId) REFERENCES Configuration__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Contact (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	MasterRecordId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccountId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastName string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FirstName string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Salutation string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Mr.,Ms.,Mrs.,Dr.,Prof.,Miss,Sir'),
	Name string(121) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OtherStreet string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OtherCity string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OtherState string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OtherPostalCode string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OtherCountry string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MailingStreet string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MailingCity string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MailingState string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MailingPostalCode string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MailingCountry string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Phone string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Fax string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	MobilePhone string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	HomePhone string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OtherPhone string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AssistantPhone string(40) OPTIONS (NATIVE_TYPE 'phone', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ReportsToId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Email string(80) OPTIONS (NATIVE_TYPE 'email', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Title string(128) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Department string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AssistantName string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LeadSource string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Advertisement,Assessment Tool,Contact Sales,Deal Registration,Email Preferences,Employee Referral,Evaluation,Event Attendance,Event Registration,Existing Customer,External List,External Referral,FY08Q3_AU-057_007,Inbound Call,Inbound Email,Internal List,Misc. Marketing,Newsletter/Email,Offline Campaign,Other,Outbound Call,Partner,Podcast,Public Relations,Red Hat Referral,Referral,Seminar - Internal,Seminar - Partner,Survey,TCO Calculator,Tradeshow,Trade Show,Training,Training Attendee,Training Catalog,Training Pre-assessment,Video,Web Eval,Webinar Attendance,Webinar Registration,Website,Webstore,Whitepaper,Word of mouth'),
	Birthdate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	HasOptedOutOfEmail boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	HasOptedOutOfFax boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	DoNotCall boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastCURequestDate timestamp OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastCUUpdateDate timestamp OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	EmailBouncedReason string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	EmailBouncedDate timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LoginName__c string(200) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OracleAcctNo__c string(15) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	LeadSourceDescription__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	LoginId__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	LanguagePreference__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'English,French,German,Italian,Spanish,Japanese,Chinese,Russian,Other'),
	LanguagePreferenceOther__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PrimaryJobFunction__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Analyst,Business Development,Buyer/Purchaser/Finance,CEO/President/Owner,Contractor/Consultant,CxO,Dept or Project Manager,Developer,Director,Educator,Engineer,IS or IT Associate,IT Architect,Legal,Marketing,Operations,Other,Sales,Student,System or Network Admin,VP'),
	PreferredPurchasingMethod__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'CDW,Dell,DLT,Don’t Have One,Fujitsu,Gateway,GTSI,HP,IBM,Local Reseller,redhat.com,Red Hat Sales Rep,Sun,Toshiba,Other'),
	LocalResellerOther__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PurchasingMethodOther__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Level1OptInOptOut__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Opt In,Opt Out'),
	Level2OptInOptOut__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Opt In,Opt Out'),
	Level3OptInOptOut__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Opt In,Opt Out'),
	ContactPreferences__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Email,Phone,Mail,Fax,Web Meeting,Face to Face Meeting,Video Conference'),
	KeySellingContact__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Do_Not_Contact__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Interest_in_Training__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '<Unknown>,Yes,No'),
	Oracle_Linux_Feedback__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	JBoss_Contact_ID__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	EMEA_SE_Required__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Partner_Opt_In_Last_Modified_Date__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Opt_In_Last_Modified_By__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Opt_In_from_Lead__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	ISO_Country_Code__c string(10) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Super_Region__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'APAC,EMEA,LATAM,NA'),
	Account_Alias__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Level_of_Contact__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '0 - None,1 - Low,2 - Medium,3 - High'),
	Level_of_Support__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '0 - Adversary,1 - Low,2 - Medium,3 - High,? - Unsure'),
	ActivePartnerStatus__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Terms_and_Conditions_Accepted__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	JapaneseContactName__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Referenceable__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'No,Yes'),
	LanguageCode__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	PartnerUserActivationState__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'SSO_User_Created,User_Created'),
	Most_Recent_Lead_Source__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Advertisement,Deal Registration,Employee Referral,Existing Customer,External Referral,FY08Q3_AU-057_007,Inbound Call,Other,Outbound Call,Partner,Public Relations,Red Hat Referral,Seminar - Internal,Seminar - Partner,Trade Show,Training,Web Eval,Website,Word of mouth'),
	Most_Recent_Lead_Source_Detail_c__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Other'),
	Product_Interest__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Cloud,Middleware,Platform,Storage,Virtualization'),
	Product_Role__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Sales,Sales Engineering,Technical'),
	Record_Source__c string(45) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	OORID__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Origination_Name__c string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Origination_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'CSV Load,Partner'),
	Legacy_Profile__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Role__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Email_Confirmation_Date__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Email_Confirmation_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Sent,Expired,Confirmed,Send'),
	Onboarding_Country__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Point_Accrual_Start__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Dedication_to_Red_Hat__c double OPTIONS (NATIVE_TYPE 'percent', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Account_Name_conv__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Status_Conv__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CDH_Party_Number__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Contact_External_Id__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_AccountId FOREIGN KEY(AccountId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Contacts'),
	CONSTRAINT FK_Country__c_Onboarding_Country__c FOREIGN KEY(Onboarding_Country__c) REFERENCES Country__c (Id) OPTIONS (NAMEINSOURCE 'Contacts__r'),
	CONSTRAINT FK_PartnerStatus__c_ActivePartnerStatus__c FOREIGN KEY(ActivePartnerStatus__c) REFERENCES PartnerStatus__c (Id) OPTIONS (NAMEINSOURCE 'Contacts__r'),
	CONSTRAINT FK_User__Owner__c FOREIGN KEY(Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'ContactsOwned__r'),
	CONSTRAINT FK_User__Partner_Opt_In_Last_Modified_By__c FOREIGN KEY(Partner_Opt_In_Last_Modified_By__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Contacts__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'true', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Contact_Converter__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	ContactId__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UserActivationResult__c string(5000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	UserId__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_User__UserId__c FOREIGN KEY(UserId__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Contact_Converters__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Contact_Converter__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ContactId__c,created,CurrencyIsoCode,feedEvent,Name,Owner,ownerAccepted,ownerAssignment,locked,unlocked,UserActivationResult__c,UserId__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Converter__c_ParentId FOREIGN KEY(ParentId) REFERENCES Contact_Converter__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Contact_Converter__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Converter__c_ItemId FOREIGN KEY(ItemId) REFERENCES Contact_Converter__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Contact_Reference_Request__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Approval_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Draft,Submitted,Approved,Rejected'),
	Customer_Reference__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Reference_Account__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Requested_Contact_Account__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Requested_Contact__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Supported_Opportunity__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Requested_Contact__c FOREIGN KEY(Requested_Contact__c) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'R00N80000002lFCfEAM__r'),
	CONSTRAINT FK_Customer_Reference__c_Customer_Reference__c FOREIGN KEY(Customer_Reference__c) REFERENCES Customer_Reference__c (Id) OPTIONS (NAMEINSOURCE 'R00N80000002lFCcEAM__r'),
	CONSTRAINT FK_Opportunity_Supported_Opportunity__c FOREIGN KEY(Supported_Opportunity__c) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'R00N80000002lFCgEAM__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Contact_Reference_Request__Share (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UserOrGroupId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	AccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Read,Edit,All'),
	RowCause string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Owner,Manual,Rule,ImplicitChild,ImplicitParent,Team,Territory,TerritoryManual,TerritoryRule,Territory2Forecast'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Reference_Request__c_ParentId FOREIGN KEY(ParentId) REFERENCES Contact_Reference_Request__c (Id) OPTIONS (NAMEINSOURCE 'Shares')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Contact_Reference_Request__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Reference_Request__c_ItemId FOREIGN KEY(ItemId) REFERENCES Contact_Reference_Request__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Contact_Tool_Shortcut__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Contact__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Communities_Tool_Shortcut__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Communities_Tool_Shortcut__c_Communities_Tool_Shortcut__c FOREIGN KEY(Communities_Tool_Shortcut__c) REFERENCES Communities_Tool_Shortcut__c (Id) OPTIONS (NAMEINSOURCE 'Contact_Tool_Shortcuts__r'),
	CONSTRAINT FK_Contact_Contact__c FOREIGN KEY(Contact__c) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Contact_Tool_Shortcuts__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Contact_Tool_Shortcut__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Tool_Shortcut__c_ItemId FOREIGN KEY(ItemId) REFERENCES Contact_Tool_Shortcut__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Contact_Track__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Contact__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Partner_Track__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Primary__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Track__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Contact__c FOREIGN KEY(Contact__c) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Contact_Tracks__r'),
	CONSTRAINT FK_PartnerTrack__c_Partner_Track__c FOREIGN KEY(Partner_Track__c) REFERENCES PartnerTrack__c (Id) OPTIONS (NAMEINSOURCE 'Partner_Track__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Contact_Track__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Contact__c,created,CurrencyIsoCode,feedEvent,Name,Owner,ownerAccepted,ownerAssignment,Partner_Track__c,Primary__c,locked,unlocked'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Track__c_ParentId FOREIGN KEY(ParentId) REFERENCES Contact_Track__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Contact_Track__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_Track__c_ItemId FOREIGN KEY(ItemId) REFERENCES Contact_Track__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContactFeed (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeedPostId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'TrackedChange,UserStatus,TextPost,AdvancedTextPost,LinkPost,ContentPost,PollPost,RypplePost,ProfileSkillPost,DashboardComponentSnapshot,ApprovalPost,CaseCommentPost,ReplyPost,EmailMessageEvent,CallLogPost,ChangeStatusPost,AttachArticleEvent,MilestoneEvent,ActivityEvent,ChatTranscriptPost,CollaborationGroupCreated,CollaborationGroupUnarchived,SocialPost,QuestionPost,FacebookPost,BasicTemplateFeedItem,CreateRecordEvent,CanvasPost,AnnouncementPost'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_ParentId FOREIGN KEY(ParentId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Feeds')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContactHistory (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContactId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account,ActivePartnerStatus__c,AssistantName,AssistantPhone,Birthdate,CDH_Party__c,CleanStatus,Contact_External_Id__c,contactMerged,ContactPreferences__c,created,contactCreatedFromLead,CurrencyIsoCode,Dedication_to_Red_Hat__c,Department,Description,Do_Not_Contact__c,DoNotCall,Email,Email_Confirmation_Date__c,Email_Confirmation_Status__c,EmailBouncedDate,EmailBouncedReason,EMEA_SE_Required__c,Fax,feedEvent,FirstName,HasOptedOutOfEmail,HasOptedOutOfFax,HomePhone,Interest_in_Training__c,ISO_Country_Code__c,JBoss_Contact_ID__c,Jigsaw,KeySellingContact__c,LanguagePreference__c,LanguagePreferenceOther__c,LastName,contactUpdatedByLead,LeadSource,LeadSourceDescription__c,Level_of_Contact__c,Level_of_Support__c,Level1OptInOptOut__c,Level2OptInOptOut__c,Level3OptInOptOut__c,LocalResellerOther__c,LoginId__c,LoginName__c,MailingAddress,MailingCity,MailingCountry,MailingLatitude,MailingLongitude,MailingPostalCode,MailingState,MailingStreet,MobilePhone,Most_Recent_Lead_Source__c,Most_Recent_Lead_Source_Detail_c__c,Name,Onboarding_Country__c,OORID__c,Oracle_Linux_Feedback__c,OracleAcctNo__c,Origination_Name__c,Origination_Type__c,OtherAddress,OtherCity,OtherCountry,OtherLatitude,OtherLongitude,OtherPhone,OtherPostalCode,OtherState,OtherStreet,Owner,Owner__c,ownerAccepted,ownerAssignment,Partner_Opt_In_from_Lead__c,Partner_Opt_In_Last_Modified_By__c,Partner_Opt_In_Last_Modified_Date__c,PartnerUserActivationState__c,Phone,Point_Accrual_Start__c,PreferredPurchasingMethod__c,PrimaryJobFunction__c,Product_Interest__c,Product_Role__c,PurchasingMethodOther__c,Record_Source__c,locked,unlocked,Referenceable__c,ReportsTo,Salutation,Status__c,Super_Region__c,Terms_and_Conditions_Accepted__c,Title'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_ContactId FOREIGN KEY(ContactId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContactShare (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContactId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	UserOrGroupId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ContactAccessLevel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Read,Edit,All'),
	RowCause string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Owner,Manual,Rule,ImplicitChild,ImplicitParent,Team,Territory,TerritoryManual,TerritoryRule,Territory2Forecast'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_ContactId FOREIGN KEY(ContactId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Shares')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContactTag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_ItemId FOREIGN KEY(ItemId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContentDocument (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Title string(255) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	PublishStatus string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'U,P,R'),
	LatestPublishedVersionId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContentDocumentFeed (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeedPostId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'TrackedChange,UserStatus,TextPost,AdvancedTextPost,LinkPost,ContentPost,PollPost,RypplePost,ProfileSkillPost,DashboardComponentSnapshot,ApprovalPost,CaseCommentPost,ReplyPost,EmailMessageEvent,CallLogPost,ChangeStatusPost,AttachArticleEvent,MilestoneEvent,ActivityEvent,ChatTranscriptPost,CollaborationGroupCreated,CollaborationGroupUnarchived,SocialPost,QuestionPost,FacebookPost,BasicTemplateFeedItem,CreateRecordEvent,CanvasPost,AnnouncementPost'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_ContentDocument_ParentId FOREIGN KEY(ParentId) REFERENCES ContentDocument (Id) OPTIONS (NAMEINSOURCE 'Feeds')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContentDocumentHistory (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContentDocumentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ArchivedBy,ArchivedDate,created,DeletedBy,DeletedDate,contentDocPublished,contentDocFeatured,contentDocRepublished,contentDocUnpublished,contentDocSubscribed,contentDocUnsubscribed,feedEvent,IsArchived,Owner,ownerAccepted,ownerAssignment,Parent,PublishStatus,locked,unlocked,Title'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_ContentDocument_ContentDocumentId FOREIGN KEY(ContentDocumentId) REFERENCES ContentDocument (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContentVersion (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContentDocumentId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsLatest boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContentUrl string(1333) OPTIONS (NATIVE_TYPE 'url', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	VersionNumber string(20) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Title string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(1000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ReasonForChange string(1000) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	PathOnClient string(500) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	RatingCount integer OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContentModifiedDate timestamp OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ContentModifiedById string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Language_ string(40) OPTIONS (NAMEINSOURCE 'Language', NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'en_US,de,es,fr,it,ja,sv,ko,zh_TW,zh_CN,pt_BR,nl_NL,da,th,fi,ru,es_MX'),
	PositiveRatingCount integer OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NegativeRatingCount integer OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeaturedContentBoost integer OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeaturedContentDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagCsv string(2000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FileType string(20) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	PublishStatus string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'U,P,R'),
	VersionData blob OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'base64', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ContentSize integer OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FirstPublishLocationId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Document_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Call Scripts,Case Studies,Channel Newsletters,Compliance,FAQs,Graphics and Images,Marketing Collateral,News and Events,Presentations,Presentations for Customers,Pricing,Product Overviews,Quick Reference Guides,Sales Guides,Sales Training,Training and Certification,Videos and Animation,Webinars,White Papers,Analyst Reports,Briefs,Cheatsheets,Datasheets,Playbooks,Best practices,Cookbooks,Documents'),
	Sharing_Status__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'External,Red Hat & Partner,Red Hat Only'),
	Expiration_Date__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '2013-09,2014-01,2014-02,2014-03,2014-04,2014-05,2014-06,2014-07,2014-08,2014-09,2014-10,2014-11,2014-12,2015-01,2015-02,2015-03,2015-04,2015-05,2015-06,2015-07,2015-08,2015-09,2015-10,2015-11,2015-12,2016-01,2016-02,2016-03,2016-04,2016-05,2016-06,2016-07,2016-08,2016-09,2016-10,2016-11,2016-12'),
	Industry_Focus__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Aerospace,Construction,Consulting,Education,Financial Services,Government,Government Military,Healthcare,Information Technology,Insurance,Life Sciences,Manufacturing,Media and Entertainment,Non Profit Organization,Oil and Gas,Other,Product Distributor,Retail,Services,State/County/Local Government,Tech Online,Telecommunications,Transportation,Utilities,All'),
	Category__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Access Technical Resources,Build a Campaign,Cloud Training,Collateral & Whitepapers,Engage customers,Home,Presentations & Customer Successes,Resources,SA Training Sessions,Sell RHEL Partner Solutions,Train to sell,What''s Working'),
	Feedback__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Review_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Support_Topics__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Max,Mini'),
	Tech_Topics__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Getting Started,Getting Software,Tech Training,Tech Product Info,Win More Business'),
	Tech_Topics_in_Detail__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Where to Start,Partner Support,Internal Use/NFR Software,Evaluation Software,Cookbooks/Demo Scripts,Recorded Training,Recorded Webinars,Videos,Best Practices,Competitive,Reference Architectures,Technical Presentations,Whitepapers,Technical Videos,Open Source,Proposal Templates,Partnerships,Industry Info,ROI and TCO Calculators,Quick Reference Guides'),
	is_New__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Document_Date__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '2010-09,2010-10,2010-11,2010-12,2011-01,2011-02,2011-03,2011-04,2011-05,2011-06,2011-07,2011-08,2011-09,2011-10,2011-11,2011-12,2012-01,2012-02,2012-03,2012-04,2012-05,2012-06,2012-07,2012-08,2012-09,2012-10,2012-11,2012-12,2013-01,2013-02,2013-03,2013-04,2013-05,2013-06,2013-07,2013-08,2013-09,2013-10,2013-11,2013-12'),
	Latest_Version_View_Count__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Storybook__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_ContentDocument_ContentDocumentId FOREIGN KEY(ContentDocumentId) REFERENCES ContentDocument (Id) OPTIONS (NAMEINSOURCE 'ContentVersions'),
	CONSTRAINT FK_Storybook__c_Storybook__c FOREIGN KEY(Storybook__c) REFERENCES Storybook__c (Id) OPTIONS (NAMEINSOURCE 'Content__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE ContentVersionHistory (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContentVersionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AvgRating,Category__c,ContentModifiedBy,ContentModifiedDate,ContentUrl,created,CurrencyIsoCode,Description,Document_Date__c,Document_Type__c,Expiration_Date__c,ExternalDataSource,ExternalDocumentInfo1,ExternalDocumentInfo2,FeaturedContentBoost,FeaturedContentDate,feedEvent,FileType,FirstPublishLocation,Industry_Focus__c,IsMajorVersion,IsPublic,Language,Latest_Version_View_Count__c,MaxRating,MinRating,NegativeRatingCount,Owner,ownerAccepted,ownerAssignment,PositiveRatingCount,PublishStatus,RatingCount,ReasonForChange,locked,RecordType,unlocked,Reference,Review_Date__c,Sharing_Status__c,Storybook__c,SuggestedTags,Support_Topics__c,Tech_Topics__c,Tech_Topics_in_Detail__c,Title,contentVersionCommented,contentVersionCreated,contentVersionDataReplaced,contentVersionDeleted,contentVersionDownloaded,VersionNumber,contentVersionRated,contentVersionUpdated,contentVersionViewed'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_ContentVersion_ContentVersionId FOREIGN KEY(ContentVersionId) REFERENCES ContentVersion (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContentWorkspace (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Description string(500) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	TagModel string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'U,G,R'),
	DefaultRecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsRestrictContentTypes boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsRestrictLinkedContentTypes boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContentWorkspaceDoc (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContentWorkspaceId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ContentDocumentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsOwner boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Contract (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	AccountId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	OwnerExpirationNotice string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '15,30,45,60,90,120'),
	StartDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	EndDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingStreet string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingCity string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingState string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingPostalCode string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	BillingCountry string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ContractTerm integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Status string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'Deal Design Request Submitted,Completed,Draft,Crafted Deal sent to Sales'),
	CompanySignedId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CompanySignedDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CustomerSignedId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CustomerSignedTitle string(40) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CustomerSignedDate date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SpecialTerms string OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ActivatedById string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ActivatedDate timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	StatusCode string(40) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Draft,InApproval,Activated,Terminated,Expired'),
	Description string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	RecordTypeId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContractNumber string(30) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	LastApprovedDate timestamp OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	LastActivityDate date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Opportunity__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Contract_Effective_Date__c date OPTIONS (NATIVE_TYPE 'date', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Contract__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Red Hat Enterprise Agreement,Framework Agreement,Master Services Agreement,Addendum Certified Service Provider,Advanced Business Partner Agreement,Alliance Training Partner,Certified Training Partner Agreement,Customer''s Form of Agreement,Cygwin License Agreement,Distribution Partner Agreement,Engineering Services Agreement,Enterprise Agreement,Eval Agreement,GLS Amendment Distribution Agreement,Hardware Partner - Runtime,Independent Software Vendor Agreement,Independent Software Vendor Agreement JBoss,JBoss Reseller Agreement,Master Subcontract Agreement,Negotiated Subscription Agreement,Order Form,Other,Professional Services Agreement,Red Hat Academy,Red Hat Ready Business Partner Agreement,Reseller Agreement,Statement of Work,Subcontractor Agreement,Subcontractor Agreement (RH as Subcontractor),Subscription Agreement,Toolchain/GNUPro Services Agreement,Work Order'),
	Date_Contract_Assigned__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Parties_to_the_Agreement__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Certain_Non_Standard_Terms__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Note__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Agreement_Can_Be_Referred_by_Affiliate__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Yes,No'),
	BA__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Probability_to_Close_in_Quarter__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Very Low,Low,Medium,Unknown,High,Very High,Closed'),
	Deal_Background_and_Issues__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BA_Status_and_Open_Issues__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Next_Steps__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Latest_Updates__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	RH_Contract_Number__c string(30) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	of_Units_Used__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Total_of_Units_Sold__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	of_Units_Remaining__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Approximate_Time_to_Complete__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" '.5 hours or less,.5 - 2 hours,2 - 5 hours,5 - 8 hours,2 - 4 days,5 - 8 days,8 - 12 days,12 - 18 days,18 - 25 days,25 - 30 days,more than 30 days'),
	Approximate_Value__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Less than $50k,$50k - $250k,$250k - $500k,$500 - $1M,$1M - $3M,More than $3M'),
	Business_Unit__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Partner - OEM,Partner - ISV,Partner - VAR,Partner - Embedded,Partner - Runtime,Partner - Other,BU - Platform,BU - Middleware,BU - Management and Security,BU - Services,Industry - Financial Services,Industry - Healthcare,Industry - Telco,Telephony,IT,Operations,Marketing,Engineering,Finance,HC,Sales'),
	Channel_formula__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Completed_Date__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Level_of_Complexity__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'None,Low,Moderate,Difficult'),
	Matter_Description__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Acquisition language,Addendum Certified Service Provider,Additional products not on purchase summary,Advanced Business Partner,Advanced Business Partner Agreement,Alliance Training Partner,Annual payments for 3 Year deals <150K,Buffer language,Certified Training Partner Agreement,Channel Agreements,Channel Special Bids,Client/Partner Relationship Support,Customer''s Form of Agreement,Customized definitions of types of installed systems,Cygwin License Agreement,Develop Contract Form,Develop Program,Distribution Agreement,Distribution Partner Agreement,Engineering Services Agreement,Enterprise Agreement,EULA,Eval Agreement,Extended duration,Framework Agreement,GLS Amendment Distribution Agreement,Hardware Partner Agreement,Hardware Partner - Runtime,HPA Appendix,Independent Software Vendor Agreement,Independent Software Vendor Agreement JBoss,ISV Agreement,JBoss Reseller Agreement,Master Services Agreement,Master Subcontract Agreement,Negotiate Agreement,Negotiated Subscription Agreement,Non-standard product offering,Non-standard T&E language,No PO Required,Order Form,Other,Partner Agreement,Partner Agreement Track Appendix,Professional Services Agreement,Red Hat Academy,Red Hat Enterprise Agreement,Red Hat Ready Business Partner Agreement,Reseller Agreement,RHEA Appendix 1,RHEA Appendix 2,RHEA Appendix 3,RHEA Appendix 4,Statement of Work,Structure Transaction,Subcontractor Agreement,Subcontractor Agreement (RH as Subcontractor),Subscription Agreement,Subscription exchange/conversion,Toolchain/GNUPro Services Agreement,True-up,Upgrade language,Variation in renewal terms,Variations in support terms,Virtualization Special Terms,Volume discount table for custom pricing on additional subscriptions of products within purchase summary,Work Order'),
	Non_Standard_Elements__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Acquisition language,Products not ordered w/pricing,Annual payments 3yr deals<150K,Auditing/Reporting/Insepctions,Buffer language,Confidentiality,Customized Definitions,Definitions,Extended Contract duration,Insurance language,Invoice/Payment/Finance terms,Liability Limitation language,License and ownership,No PO Required,Non-standard product offering,Non-standard T&E language,Obligations of Parties,Representations and Warranties,Scope,Security language,Subscription exchange,Taxes language,Term and/or Termination,True-up,Upgrade language,Variation in renewal terms,Variations in support terms,Virtualization Special Terms,Volume Discount Table'),
	Notes_from_Sales__c string(32000) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Opportunity_Stage__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	SubRegion__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Argentina,ASEAN,Australia,Brazil,Canada,CE,DACH,Eastern Europe,FED/SLED,Greater China,India,Japan,Korea,Mexico,NE,Nordic,Other,SE,SEMEA,UK and SA,Verticals,WE'),
	Stage__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'New,In Progress,Completed'),
	Vertical__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Financial Services,Healthcare,Media & Technology,Other,Telco'),
	Account_Record_Type__c string(100) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Deal_Type__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Amentra,Channel,JBoss,Not Applicable,Red Hat,RHEL,RH GPS,Other'),
	Region__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ANZ,APAC,ASEAN,Brazil,Canada,CE,EMEA,GCG,Global,India,India/Pakistan,Japan,Korea,LATAM,Mexico,NA,NEE,SAC,SEMEA,US'),
	Opportunity_Amount__c double OPTIONS (UPDATABLE FALSE, CURRENCY TRUE, NATIVE_TYPE 'currency', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Opportunity_Close_Date__c date OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'date', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BA_BRC_Owner__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	ChannelTemp__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Country_of_Order__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Duration__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Internal_Customer__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'BA,Channel - OEM or SI,Channel - Other,Cloud BU,Facilities,GLS,IT,Legal Affairs,Middleware BU,People  & Brand,Platform BU,Sales,SEAP - Compliance,Services BU,Storage BU,Telecom,Other'),
	Paper_Source__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Customer / Vendor,Partner,Red Hat'),
	SubTerritory__c string(22) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Territory__c string(20) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	GPSDetails__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'DEE,Fuse,Migration,Other,Pathway - Cloud Readiness,Pathway - IT Consolidation,Pathway - IT Freedom,Pathway - Operation Efficiency,SOE,Trusted Advisor'),
	GPS_Other_Details__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	BA_Bid_Desk_Owner_2__c string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Contract_Type__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Amendment Agreement,Assignments,Business Unit Matter,BU Support (Business Affairs Use Only),Client/Partner Relationship Support,Cloud Deal (Appendix for CCP),Consulting - Complex,Consulting - Individual,Customer – Create Order Form,Customer – Deal Guidance,Customer – GPS SOW,Customer NDA,Customer – Negotiation Escalation,Customer – New Amentra MSA,Customer – New Contract on Customer Form,Customer – New Enterprise Agreement,Customer – Other,Customer – Review Order Form,Customer – RFP/RFI,Develop Contract Form,Develop Program,Direct Contract,Embedded Deal,Enterprise Agt - Subs Master Agt,Equipment Loan,Expense Contract,Facilities,Finance,GLS,HC,Inbound Licensing,Indirect Contract,Industry Vertical Matter,Infrastructure Consulting - Individual,ISV Support,Marketing - Events,Marketing - Public Relations,Marketing - Research,NDA,Negotiate Agreement,Opportunity Contract,Order Form or SOW,Other,Other Agreement,Other-Non Agreement,Partner Agreement,Partner – Certifications,Partner – CRADA,Partner – Embedded,Partner – ISV,Partner – Marketing Agreements,Partner NDA,Partner – OEM,Partner – Other,Partner Relationship Matter,Partner – Runtime,Partner – Special Bid,Partner – Teaming Agreements,Partner – VAR,Professional Services Master Agreement,Project (Business Affairs Use Only),Red Hat NDA,Regional Team Matter,RFP/RFI,Software Licenses,Special Bid for Partner,Sponsorship,Subcontracting,Telecommunications,Transformation,Vendor Forms,Vendor NDA'),
	Legacy_Profile__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Legacy_Role__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Approval_Status__c string(255) OPTIONS (SEARCHABLE 'Unsearchable', NATIVE_TYPE 'textarea', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CountryOfOrder__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Afghanistan,Albania,Algeria,Andorra,Angola,Anguilla,Antigua and Barbuda,Argentina,Armenia,Aruba,Australia,Austria,Azerbaijan,Bahamas,Bahrain,Bangladesh,Barbados,Belarus,Belgium,Belize,Benin,Bermuda,Bhutan,Bolivia,Bosnia and Herzegovina,Botswana,Bouvet Island,Brazil,Brunei Darussalam,Bulgaria,Burkina Faso,Burundi,Cambodia,Cameroon,Canada,Cape Verde,Cayman Islands,Central African Republic,Chad,Chile,China,Colombia,Comoros,Congo,Congo, The Democratic Republic of the,Costa Rica,Cote d''Ivoire,Croatia,Cyprus,Czech Republic,Denmark,Djibouti,Dominica,Dominican Republic,Ecuador,Egypt,El Salvador,Equatorial Guinea,Eritrea,Estonia,Ethiopia,Falkland Islands (Malvinas),Faroe Islands,Fiji,Finland,France,French Guiana,French Polynesia,Gabon,Gambia,Georgia,Germany,Ghana,Gibraltar,Greece,Greenland,Grenada,Guadeloupe,Guam,Guatemala,Guernsey,Guinea,Guinea-Bissau,Guyana,Haiti,Holy See (Vatican City State),Honduras,Hong Kong,Hungary,Iceland,India,Indonesia,Iraq,Ireland,Israel,Italy,Jamaica,Japan,Jordan,Kazakhstan,Kenya,Kiribati,Korea, Republic of,Kuwait,Kyrgyzstan,Lao People''s Democratic Republic,Latvia,Lebanon,Lesotho,Liberia,Libyan Arab Jamahiriya,Liechtenstein,Lithuania,Luxembourg,Macao,Macedonia, the Former Yugoslav Republic of,Madagascar,Malawi,Malaysia,Maldives,Mali,Malta,Martinique,Mauritania,Mauritius,Mayotte,Mexico,Moldova, Republic of,Monaco,Mongolia,Montserrat,Morocco,Mozambique,Myanmar,Namibia,Nauru,Nepal,Netherlands,New Zealand,Nicaragua,Niger,Nigeria,Norway,Oman,Pakistan,Palau,Panama,Papua New Guinea,Paraguay,Peru,Philippines,Poland,Portugal,Puerto Rico,Qatar,Reunion,Romania,Russian Federation,Rwanda,Saint Helena,Saint Kitts and Nevis,Saint Lucia,Saint Pierre and Miquelon,Saint Vincent and the Grenadines,Samoa,San Marino,Sao Tome and Principe,Saudi Arabia,Senegal,Serbia,Serbia and Montenegro,Seychelles,Sierra Leone,Singapore,Slovakia,Slovenia,Solomon Islands,Somalia,South Africa,Spain,Sri Lanka,Suriname,Svalbard and Jan Mayen,Swaziland,Sweden,Switzerland,Taiwan,Tajikistan,Tanzania, United Republic of,Thailand,Timor-Leste,Togo,Tonga,Trinidad and Tobago,Tunisia,Turkey,Turkmenistan,Turks and Caicos Islands,Tuvalu,Uganda,Ukraine,United Arab Emirates,United Kingdom,United States,United States Minor Outlying Islands,Uruguay,Uzbekistan,Vanuatu,Venezuela,Vietnam,Virgin Islands, British,Virgin Islands, U.S,Wallis and Futuna,Western Sahara,Yemen,Zambia,Zimbabwe'),
	Global__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Pending_Approval_By__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Pending_Approval_Date__c timestamp OPTIONS (NATIVE_TYPE 'datetime', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Pending_Approval_Duration__c double OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'double', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	SendBackToBidDesk__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Sub_Region__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Baltics,Benelux,CEE,CIS,DACH,France,Iberia,IGC,Italy,MET,N-Africa,Nordics,S-Africa,UK'),
	SubmitCount__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Super_Region__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'APAC,EMEA,LATAM,NA'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Account_AccountId FOREIGN KEY(AccountId) REFERENCES Account (Id) OPTIONS (NAMEINSOURCE 'Contracts'),
	CONSTRAINT FK_Contact_CustomerSignedId FOREIGN KEY(CustomerSignedId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'ContractsSigned'),
	CONSTRAINT FK_Opportunity_Opportunity__c FOREIGN KEY(Opportunity__c) REFERENCES Opportunity (Id) OPTIONS (NAMEINSOURCE 'Contract__r'),
	CONSTRAINT FK_User__BA_BRC_Owner__c FOREIGN KEY(BA_BRC_Owner__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Contracts1__r'),
	CONSTRAINT FK_User__BA_Bid_Desk_Owner_2__c FOREIGN KEY(BA_Bid_Desk_Owner_2__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Contracts2__r'),
	CONSTRAINT FK_User__BA__c FOREIGN KEY(BA__c) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'Contracts__r'),
	CONSTRAINT FK_User__CompanySignedId FOREIGN KEY(CompanySignedId) REFERENCES User_ (Id) OPTIONS (NAMEINSOURCE 'ContractsSigned')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE ContractContactRole (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContractId string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ContactId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Role string(40) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Business User,Decision Maker,Economic Buyer,Economic Decision Maker,Evaluator,Executive Sponsor,Influencer,Technical Buyer,Other'),
	IsPrimary boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contact_ContactId FOREIGN KEY(ContactId) REFERENCES Contact (Id) OPTIONS (NAMEINSOURCE 'ContractContactRoles'),
	CONSTRAINT FK_Contract_ContractId FOREIGN KEY(ContractId) REFERENCES Contract (Id) OPTIONS (NAMEINSOURCE 'ContractContactRoles')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContractFeed (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	FeedPostId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'TrackedChange,UserStatus,TextPost,AdvancedTextPost,LinkPost,ContentPost,PollPost,RypplePost,ProfileSkillPost,DashboardComponentSnapshot,ApprovalPost,CaseCommentPost,ReplyPost,EmailMessageEvent,CallLogPost,ChangeStatusPost,AttachArticleEvent,MilestoneEvent,ActivityEvent,ChatTranscriptPost,CollaborationGroupCreated,CollaborationGroupUnarchived,SocialPost,QuestionPost,FacebookPost,BasicTemplateFeedItem,CreateRecordEvent,CanvasPost,AnnouncementPost'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contract_ParentId FOREIGN KEY(ParentId) REFERENCES Contract (Id) OPTIONS (NAMEINSOURCE 'Feeds')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContractHistory (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ContractId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Account,Account_Record_Type__c,ActivatedBy,ActivatedDate,Agreement_Can_Be_Referred_by_Affiliate__c,Approval_Status__c,Approximate_Time_to_Complete__c,Approximate_Value__c,BA__c,BA_Bid_Desk_Owner_2__c,BA_BRC_Owner__c,BA_Status_and_Open_Issues__c,BillingAddress,BillingCity,BillingCountry,BillingLatitude,BillingLongitude,BillingPostalCode,BillingState,BillingStreet,Business_Unit__c,Certain_Non_Standard_Terms__c,CompanySigned,CompanySignedDate,Completed_Date__c,Contract__c,Contract_Effective_Date__c,Contract_Type__c,contractActivation,contractApproval,contractConversion,contractDraft,contractExpiration,ContractTerm,contractTermination,CountryOfOrder__c,created,CurrencyIsoCode,CustomerSigned,CustomerSignedDate,CustomerSignedTitle,Date_Contract_Assigned__c,Deal_Background_and_Issues__c,Deal_Type__c,Description,EndDate,feedEvent,Global__c,GPS_Other_Details__c,GPSDetails__c,Internal_Customer__c,Latest_Updates__c,Level_of_Complexity__c,Matter_Description__c,Name,Next_Steps__c,Non_Standard_Elements__c,Note__c,Notes_from_Sales__c,of_Units_Used__c,Opportunity__c,Owner,Owner__c,ownerAccepted,ownerAssignment,OwnerExpirationNotice,Paper_Source__c,Parties_to_the_Agreement__c,Pending_Approval_By__c,Pending_Approval_Date__c,Probability_to_Close_in_Quarter__c,locked,RecordType,unlocked,Region__c,SendBackToBidDesk__c,ShippingAddress,ShippingCity,ShippingCountry,ShippingLatitude,ShippingLongitude,ShippingPostalCode,ShippingState,ShippingStreet,SpecialTerms,Stage__c,StartDate,Status,Sub_Region__c,SubmitCount__c,SubRegion__c,SubTerritory__c,Super_Region__c,Territory__c,Total_of_Units_Sold__c,Vertical__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contract_ContractId FOREIGN KEY(ContractId) REFERENCES Contract (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContractStatus (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	MasterLabel string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	SortOrder integer OPTIONS (NATIVE_TYPE 'int', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDefault boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	StatusCode string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Draft,InApproval,Activated,Terminated,Expired'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE ContractTag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Contract_ItemId FOREIGN KEY(ItemId) REFERENCES Contract (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Country__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	OwnerId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Abbreviation__c string(1300) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'true', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Country_Name__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'AFGHANISTAN,ALAND ISLANDS,ALBANIA,ALGERIA,AMERICAN SAMOA,ANDORRA,ANGOLA,ANGUILLA,ANTARCTICA,ANTIGUA AND BARBUDA,ARGENTINA,ARMENIA,ARUBA,AUSTRALIA,Austria,AZERBAIJAN,BAHAMAS,BAHRAIN,BANGLADESH,BARBADOS,BELARUS,BELGIUM,BELIZE,BENIN,BERMUDA,BHUTAN,BOLIVIA PLURINATIONAL STATE OF,BOSNIA AND HERZEGOVINA,BOTSWANA,BOUVET ISLAND,BRAZIL,BRITISH INDIAN OCEAN TERRITORY,BRUNEI DARUSSALAM,BULGARIA,BURKINA FASO,BURUNDI,CAMBODIA,CANADA,CAPE VERDE,CAYMAN ISLANDS,CENTRAL AFRICAN REPUBLIC,CHAD,CHILE,CHINA,CHRISTMAS ISLAND,CLATAMOON,COCOS (KEELING) ISLANDS,COLOMBIA,COMOROS,CONGO,CONGO THE DEMOCRATIC REPUBLIC OF THE,COOK ISLANDS,COSTA RICA,COTE D''IVOIRE,CROATIA,CUBA,CYPRUS,CZECH REPUBLIC,DENMARK,DJIBOUTI,DOMINICA,DOMINICAN REPUBLIC,ECUADOR,EGYPT,EL SALVADOR,EQUATORIAL GUINEA,ERITREA,ESTONIA,ETHIOPIA,FAEROE ISLANDS (MALVINAS),FALKLAND ISLANDS (MALVINAS),FIJI,FINLAND,FRANCE,FRENCH GUIANA,FRENCH POLYNESIA,FRENCH SOUTHERN TERRITORIES,GABON,GAMBIA,GEORGIA,GERMANY,GHANA,GIBRALTAR,GREECE,GREENLAND,GRENADA,GUADELOUPE,GUAM,GUATEMALA,GUERNSEY,GUINEA,GUINEA-BISSAU,GUYANA,HAITI,HEARD ISLAND AND MCDONALD ISLANDS,HONDURAS,HONG KONG,HUNGARY,ICELAND,INDIA,INDONESIA,IRAN ISLAMIC REPUBLIC OF IRAN,IRAQ,IRELAND,ISLE OF MAN,ISRAEL,ITALY,JAMAICA,JAPAN,JERSEY,JORDAN (Hashemite Kingdom of Jordan),KAZAKHSTAN,KENYA,KIRIBATI,KOREA (Republic of [South] Korea),KOSOVO,KUWAIT,KYRGYZSTAN,LAO PEOPLE''S DEMOCRATIC REPUBLIC,LATVIA,LEBANON,LESOTHO,LIBERIA,LIBYA (Libyan Arab Jamahirya),LIECHTENSTEIN (Fürstentum Liechtenstein),LITHUANIA,LUXEMBOURG,MACAO (Special Administrative Region of China),MACEDONIA (Former Yugoslav Republic of Macedonia),MADAGASCAR,MALAWI,MALAYSIA,MALDIVES,MALI,MALTA,MARSHALL ISLANDS,MARTINIQUE,MAURITANIA,MAURITIUS,MAYOTTE,MEXICO,MICRONESIA (Federated States of Micronesia),MOLDOVA,MONACO,MONGOLIA,MONTENEGRO,MONTSERRAT,MOROCCO,MOZAMBIQUE (Moçambique),MYANMAR (formerly Burma),NAMIBIA,NAURU,NEPAL,NETHERLANDS,NETHERLANDS ANTILLES,NEW CALEDONIA,NEW ZEALAND,NICARAGUA,NIGER,NIGERIA,NIUE,NORFOLK ISLAND,NORTHERN MARIANA ISLANDS,NORWAY,OMAN,PAKISTAN,PALAU,PALESTINIAN TERRITORIES,PANAMA,PAPUA NEW GUINEA,PARAGUAY,PERU,PHILIPPINES,PITCAIRN,POLAND,PORTUGAL,PUERTO RICO,QATAR,RÉUNION,ROMANIA,RUSSIAN FEDERATION,RWANDA,SAINT BARTHÉLEMY,SAINT HELENA,SAINT KITTS AND NEVIS,SAINT LUCIA,SAINT MARTIN (French portion),SAINT PIERRE AND MIQUELON,SAINT VINCENT AND THE GRENADINES,SAMOA (formerly Western Samoa),SAN MARINO (Republic of),SAO TOME AND PRINCIPE,SAUDI ARABIA (Kingdom of Saudi Arabia),SENEGAL,SERBIA (Republic of Serbia),SEYCHELLES,SIERRA LEONE,SINGAPORE,SLOVAKIA (Slovak Republic),SLOVENIA,SOLOMON ISLANDS,SOMALIA,SOUTH AFRICA (Zuid Afrika),SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS,SPAIN (España),SRI LANKA (formerly Ceylon),SUDAN,SURINAME,SVALBARD AND JAN MAYEN,SWAZILAND,SWEDEN,SWITZERLAND (Confederation of Helvetia),SYRIAN ARAB REPUBLIC,TAIWAN ("Chinese Taipei" for IOC),TAJIKISTAN,TANZANIA,THAILAND,TIMOR-LESTE (formerly East Timor),TOGO,TOKELAU,TONGA,TRINIDAD AND TOBAGO,TUNISIA,TURKEY,TURKMENISTAN,TURKS AND CAICOS ISLANDS,TUVALU,UGANDA,UKRAINE,UNITED ARAB EMIRATES,UNITED KINGDOM,UNITED STATES,UNITED STATES MINOR OUTLYING ISLANDS,URUGUAY,UZBEKISTAN,VANUATU,VATICAN CITY (Holy See),VENEZUELA,VIET NAM,VIRGIN ISLANDS, BRITISH,VIRGIN ISLANDS, U.S.,WALLIS AND FUTUNA,WESTERN SAHARA (formerly Spanish Sahara),YEMEN (Yemen Arab Republic),ZAMBIA (formerly Northern Rhodesia),ZIMBABWE'),
	Country_of_Order__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Afghanistan,Albania,Algeria,Andorra,Angola,Anguilla,Antigua,Argentina,Armenia,Aruba,Australia,Austria,Azerbaijan,Bahamas,Bahrain,Bangladesh,Barbados,Belarus,Belgium,Belize,Benin,Bermuda,Bolivia,Bosnia and Herzegovina,Botswana,Brazil,British Virgin Islands,Bulgaria,Burkina Faso,Burundi,Cambodia,Cameroon,Canada,Canary Islands,Cape Verde,Cayman Islands,Central African Republic,Chad,Chile,China,Colombia,Comoros,Congo,Costa Rica,Cote d''Ivoire,Croatia,Cyprus,Czech Republic,Democratic Republic of Congo,Denmark,Djibouti,Dominica,Dominican Republic,Ecuador,Egypt,El Salvador,Equatorial Guinea,Eritrea,Estonia,Ethiopia,Falkland Islands,Finland,France,French Guiana,French Polynesia,Gabon,Gambia,Georgia,Germany,Ghana,Gibraltar,Greece,Grenada,Guadeloupe,Guam,Guatemala,Guinea,Guinea-Bissau,Guyana,Haiti,Honduras,Hong Kong,Hungary,Iceland,India,Indonesia,Iran,Iraq,Ireland,Israel,Italy,Jamaica,Japan,Jordan,Kazakhstan,Kenya,Korea, Republic of,Kosovo,Kuwait,Kyrgyzstan,Latvia,Lebanon,Lesotho,Liberia,Libya,Liechtenstein,Lithuania,Luxembourg,Macedonia,Madagascar,Malawi,Malaysia,Mali,Malta,Martinique,Mauritania,Mauritius,Mexico,Moldova,Monaco,Montenegro,Montserrat,Morocco,Mozambique,Namibia,Nepal,Netherlands,New Zealand,Nicaragua,Niger,Nigeria,Norway,Oman,Pakistan,Palestine,Panama,Paraguay,Peru,Philippines,Poland,Portugal,Qatar,Romania,Russia,Rwanda,Saint Kitts and Nevis,Saint Lucia,Saint Vincent and the Grenadines,San Marino,São Tomé and Príncipe,Saudi Arabia,Senegal,Serbia,Seychelles,Sierra Leone,Singapore,Slovakia,Slovenia,Somalia,South Africa,South Korea,Spain,Sri Lanka,Sudan,Suriname,Swaziland,Sweden,Switzerland,Syria,Taiwan,Tajikistan,Tanzania,Thailand,Togo,Trinidad,Tunisia,Turkey,Turkmenistan,Turks and Caicos Islands,U.S. - Puerto Rico,Uganda,Ukraine,United Arab Emirates,United Kingdom,United States,United States Minor Outlying Islands,Uruguay,Uzbekistan,Venezuela,Vietnam,Virgin Islands,Western Sahara,Yemen,Zambia,Zimbabwe'),
	Global_Region__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'NA,APAC,EMEA,LATAM'),
	IDDCallingCode__c string(10) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	IsAgreementSignatureRequired__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IsExportComplianceIndicated__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IsFCPAIndicated__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	IsMigrated__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	Iso3166Alpha2__c string(2) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Iso3166Alpha3__c string(3) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Iso3166Numeric3__c double OPTIONS (NATIVE_TYPE 'double', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	Subregion__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'ANZ,ASEAN,Brazil,Canada,CE,Central,Distributor,Fed Sled,Greater China,High Volume,Hong Kong,India,Japan,Korea,Mexico,Mid-Atlantic,NA,National,NEE,North Central,Northeast,SAC,SEMEA,South Central,Southeast,SWE,Taiwan,UKI,West'),
	Supported_Specialized_Partner_Types__c string(4099) OPTIONS (NATIVE_TYPE 'multipicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Corporate Reseller'),
	SearchByVAT__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	TI_Index__c boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'true'),
	CONSTRAINT Id_PK PRIMARY KEY(Id)
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE Country__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Country_Name__c,Country_of_Order__c,created,CurrencyIsoCode,feedEvent,Global_Region__c,IDDCallingCode__c,IsAgreementSignatureRequired__c,IsExportComplianceIndicated__c,IsFCPAIndicated__c,IsMigrated__c,Iso3166Alpha2__c,Iso3166Alpha3__c,Iso3166Numeric3__c,Name,Owner,ownerAccepted,ownerAssignment,locked,unlocked,SearchByVAT__c,Subregion__c,Supported_Specialized_Partner_Types__c,TI_Index__c'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Country__c_ParentId FOREIGN KEY(ParentId) REFERENCES Country__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE Country__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Country__c_ItemId FOREIGN KEY(ItemId) REFERENCES Country__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'false', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CountryTranslation__c (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(80) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	CurrencyIsoCode string(3) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true', "teiid_sf:Picklist Values" 'ARS,AUD,BRL,GBP,CAD,CNY,EUR,HKD,INR,IDR,JPY,KRW,MYR,MXN,NZD,PHP,SGD,THB,USD'),
	Country__c string(18) OPTIONS (UPDATABLE FALSE, NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	CountryName__c string(255) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false'),
	LanguageCode__c string(255) OPTIONS (NATIVE_TYPE 'picklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'true', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'de,en,es,fr,it,ja,pt_BR,ru,ko,zh_CN'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_Country__c_Country__c FOREIGN KEY(Country__c) REFERENCES Country__c (Id) OPTIONS (NAMEINSOURCE 'CountryTranslations__r')
) OPTIONS (UPDATABLE TRUE, "teiid_sf:Custom" 'true', "teiid_sf:Supports Create" 'true', "teiid_sf:Supports Delete" 'true', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'true');

CREATE FOREIGN TABLE CountryTranslation__History (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	ParentId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Field string(255) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Country__c,CountryName__c,created,CurrencyIsoCode,feedEvent,LanguageCode__c,Name,ownerAccepted,ownerAssignment,locked,unlocked'),
	OldValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	NewValue string(255) OPTIONS (NATIVE_TYPE 'anyType', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CountryTranslation__c_ParentId FOREIGN KEY(ParentId) REFERENCES CountryTranslation__c (Id) OPTIONS (NAMEINSOURCE 'Histories')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Create" 'false', "teiid_sf:Supports Delete" 'false', "teiid_sf:Supports Merge" 'false', "teiid_sf:Supports Query" 'true', "teiid_sf:Supports Replicate" 'true', "teiid_sf:Supports Retrieve" 'true', "teiid_sf:Supports Search" 'false');

CREATE FOREIGN TABLE CountryTranslation__Tag (
	Id string(18) NOT NULL AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'id', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	TagDefinitionId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	ItemId string(18) OPTIONS (NATIVE_TYPE 'reference', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	IsDeleted boolean OPTIONS (NATIVE_TYPE 'boolean', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'true'),
	Name string(765) OPTIONS (NATIVE_TYPE 'string', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false'),
	Type string(40) OPTIONS (NATIVE_TYPE 'restrictedpicklist', "teiid_sf:calculated" 'false', "teiid_sf:Custom" 'false', "teiid_sf:Defaulted on Create" 'false', "teiid_sf:Picklist Values" 'Public,Personal'),
	CONSTRAINT Id_PK PRIMARY KEY(Id),
	CONSTRAINT FK_CountryTranslation__c_ItemId FOREIGN KEY(ItemId) REFERENCES CountryTranslation__c (Id) OPTIONS (NAMEINSOURCE 'Tags')
) OPTIONS ("teiid_sf:Custom" 'false', "teiid_sf:Supports Creat