CREATE TABLE BB_TEST_GROUP
 (
   BB_TEST_GROUP_ID NUMBER DEFAULT 0 NOT NULL,
   TEST_GROUP_DISPLAY CHAR(15 BYTE) DEFAULT ' ' NOT NULL,
   TEST_GROUP_DESCRIPTION  VARCHAR2(50 BYTE),
   ACTIVE_IND NUMBER DEFAULT 0 NOT NULL,
   ACTIVE_STATUS_CD NUMBER DEFAULT 0 NOT NULL,
   ACTIVE_STATUS_PRSNL_ID NUMBER DEFAULT 0 NOT NULL,
   UPDT_CNT NUMBER DEFAULT 0 NOT NULL,
   UPDT_DT_TM DATE DEFAULT SYSDATE NOT NULL,
   UPDT_ID NUMBER DEFAULT 0 NOT NULL,
   UPDT_TASK NUMBER DEFAULT 0 NOT NULL,
   UPDT_APPLCTX NUMBER DEFAULT 0 NOT NULL
 )
 LOGGING 
 NOCOMPRESS 
 NOCACHE
 NOPARALLEL
 MONITORING;
 
 CREATE UNIQUE INDEX XAK1BB_TEST_GROUP ON BB_TEST_GROUP
 (
   TEST_GROUP_DISPLAY ASC,
   UPDT_CNT DESC
 )
 LOGGING
 COMPRESS 4
 NOPARALLEL
 UNUSABLE;
 
 CREATE TABLE CUST_MPAGE
 (
   MPAGE_ID INTEGER,
   NAME VARCHAR2(50 BYTE),
   DESCRIPTION VARCHAR2(200 BYTE)
 )
 LOGGING
 NOCOMPRESS
 NOCACHE
 NOPARALLEL
 MONITORING;
 
 CREATE INDEX CUST_MPAGE_PK ON CUST_MPAGE
 (
   MPAGE_ID
 )
 LOGGING
 NOPARALLEL;
 
 CREATE TABLE Weatherdata_tab
 (
   Maxtemp INTEGER,
   Mintemp INTEGER
 );
 
 CREATE BITMAP INDEX Compare_index
 ON Weatherdata_tab ((Maxtemp - Mintemp) DESC, Maxtemp);
 
 CREATE INDEX idx_personnel ON CLUSTER personnel;
 
 CREATE TABLE sales
 (
   cust_id INTEGER,
   cust_name VARCHAR2(50 BYTE)
 );
 
 CREATE TABLE customers
 (
   cust_id INTEGER,
   cust_name VARCHAR2(50 BYTE)
 );
 
 CREATE BITMAP INDEX sales_cust_gender_bjix
 ON sales(customers.cust_gender)
 FROM sales, customers
 WHERE sales.cust_id = customers.cust_id
 LOCAL;
