/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.widgets;

import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PlanNode {
    private List<Property> properties = new LinkedList<Property>();
    private List<PlanNode> childNodes = new LinkedList<PlanNode>();
    private PlanNode parent;
    private String name;

    public PlanNode() {
    }

    public PlanNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void setParent(PlanNode parent) {
        this.parent = parent;
    }

    public PlanNode getParent() {
        return this.parent;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addChildNode(PlanNode value) {
        this.childNodes.add(value);
    }

    public List<PlanNode> getChildNodes() {
        return this.childNodes;
    }

    public void addProperty(String pname, List<String> value) {
        Property p = new Property(pname);
        if (value == null) {
            value = Collections.emptyList();
        }
        p.setValues(value);
        this.properties.add(p);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.visitNode(this, 0, builder);
        return builder.toString();
    }

    protected void visitNode(PlanNode node, int nodeLevel, StringBuilder text) {
        for (int i = 0; i < nodeLevel; ++i) {
            text.append("  ");
        }
        text.append(node.getName());
        text.append("\n");
        int propTabs = nodeLevel + 1;
        for (Property property : node.getProperties()) {
            for (int t = 0; t < propTabs; ++t) {
                text.append("  ");
            }
            this.printProperty(nodeLevel, property, text);
        }
        for (PlanNode node1 : node.getChildNodes()) {
            this.visitNode(node1, nodeLevel + 1, text);
        }
    }

    private void printProperty(int nodeLevel, Property p, StringBuilder text) {
        text.append("+ ");
        text.append(p.getName());
        if (p.getValues().size() > 1) {
            text.append(":\n");
            for (int i = 0; i < p.getValues().size(); ++i) {
                for (int t = 0; t < nodeLevel + 2; ++t) {
                    text.append("  ");
                }
                text.append(i);
                text.append(": ");
                text.append(p.getValues().get(i));
                text.append("\n");
            }
        } else if (p.getValues().size() == 1) {
            text.append(":");
            text.append(p.getValues().get(0));
            text.append("\n");
        } else {
            text.append("\n");
        }
    }

    public static PlanNode fromXml(String planString) {
        Document messageDom = XMLParser.parse((String)planString);
        NodeList nodes = messageDom.getElementsByTagName("node");
        Node node = nodes.item(0);
        String nodeName = node.getAttributes().getNamedItem("name").getNodeValue();
        PlanNode root = new PlanNode("QueryPlan");
        PlanNode planNode = new PlanNode(nodeName);
        planNode.setParent(root);
        root.addChildNode(planNode);
        PlanNode.buildNode(node, planNode);
        return planNode;
    }

    private static PlanNode buildNode(Node parentXMLNode, PlanNode node) {
        NodeList childNodes = parentXMLNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childXMLNode = childNodes.item(i);
            ArrayList<String> values = new ArrayList<String>();
            if (!childXMLNode.getNodeName().equals("property")) continue;
            String propertyName = childXMLNode.getAttributes().getNamedItem("name").getNodeValue();
            NodeList valueXMLNodes = childXMLNode.getChildNodes();
            for (int valueIdx = 0; valueIdx < valueXMLNodes.getLength(); ++valueIdx) {
                Node valueXMLNode = valueXMLNodes.item(valueIdx);
                if (valueXMLNode.getNodeName().equals("value")) {
                    String v = valueXMLNode.getChildNodes().item(0).getNodeValue();
                    System.out.println(propertyName + ":" + v);
                    values.add(v);
                    continue;
                }
                if (!valueXMLNode.getNodeName().equals("node")) continue;
                String name = valueXMLNode.getAttributes().getNamedItem("name").getNodeValue();
                PlanNode childNode = new PlanNode(name);
                node.addChildNode(PlanNode.buildNode(valueXMLNode, childNode));
            }
            if (values.isEmpty()) continue;
            node.addProperty(propertyName, values);
        }
        return node;
    }

    public static class Property {
        private String name;
        private List<String> values;

        public Property() {
        }

        public Property(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getValues() {
            return this.values;
        }

        public String getValuesAsCSV() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.values.size(); ++i) {
                sb.append(this.values.get(i));
                if (i >= this.values.size()) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        public void setValues(List<String> values) {
            this.values = values;
        }
    }
}

