/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.repository.util.SessionFactory;
import org.jboss.dna.spi.graph.NamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrNamespaceRegistry
implements NamespaceRegistry {
    private final String repositoryWorkspaceName;
    private final SessionFactory sessionFactory;

    public JcrNamespaceRegistry(SessionFactory sessionFactory, String repositoryWorkspaceName) {
        ArgCheck.isNotNull((Object)sessionFactory, (String)"sessionFactory");
        ArgCheck.isNotNull((Object)repositoryWorkspaceName, (String)"repositoryWorkspaceName");
        this.repositoryWorkspaceName = repositoryWorkspaceName;
        this.sessionFactory = sessionFactory;
    }

    public String getDefaultNamespaceUri() {
        Session session = null;
        try {
            session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
            String string = session.getNamespaceURI("");
            return string;
        }
        catch (RepositoryException e) {
            throw new org.jboss.dna.spi.graph.NamespaceException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String getNamespaceForPrefix(String prefix) {
        Session session = null;
        try {
            session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
            String string = session.getNamespaceURI(prefix);
            return string;
        }
        catch (RepositoryException e) {
            throw new org.jboss.dna.spi.graph.NamespaceException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        Session session = null;
        try {
            session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
            String string = session.getNamespacePrefix(namespaceUri);
            return string;
        }
        catch (RepositoryException e) {
            throw new org.jboss.dna.spi.graph.NamespaceException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        Session session = null;
        try {
            session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
            session.getNamespacePrefix(namespaceUri);
            boolean bl = true;
            return bl;
        }
        catch (NamespaceException e) {
            boolean bl = false;
            return bl;
        }
        catch (RepositoryException e) {
            throw new org.jboss.dna.spi.graph.NamespaceException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public String register(String prefix, String namespaceUri) {
        String previousNamespaceUriForPrefix = null;
        Session session = null;
        try {
            session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
            previousNamespaceUriForPrefix = session.getNamespacePrefix(namespaceUri);
            javax.jcr.NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
            registry.registerNamespace(prefix, namespaceUri);
        }
        catch (RepositoryException e) {
            throw new org.jboss.dna.spi.graph.NamespaceException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return previousNamespaceUriForPrefix;
    }

    public Set<String> getRegisteredNamespaceUris() {
        Session session = null;
        try {
            session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
            javax.jcr.NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
            HashSet<String> result = new HashSet<String>();
            for (String uri : registry.getURIs()) {
                result.add(uri);
            }
            Set<String> set = Collections.unmodifiableSet(result);
            return set;
        }
        catch (RepositoryException e) {
            throw new org.jboss.dna.spi.graph.NamespaceException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

