/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.observation;

import java.util.Collections;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.HashCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class NodeChange {
    private final String repositoryWorkspaceName;
    private final String absolutePath;
    private final int eventTypes;
    private final Set<String> modifiedProperties;
    private final Set<String> removedProperties;
    private final int hc;

    public NodeChange(String repositoryWorkspaceName, String absolutePath, int eventTypes, Set<String> modifiedProperties, Set<String> removedProperties) {
        assert (repositoryWorkspaceName != null);
        assert (absolutePath != null);
        this.repositoryWorkspaceName = repositoryWorkspaceName;
        this.absolutePath = absolutePath.trim();
        this.hc = HashCode.compute((Object[])new Object[]{this.repositoryWorkspaceName, this.absolutePath});
        this.eventTypes = eventTypes;
        if (modifiedProperties == null) {
            modifiedProperties = Collections.emptySet();
        }
        if (removedProperties == null) {
            removedProperties = Collections.emptySet();
        }
        this.modifiedProperties = Collections.unmodifiableSet(modifiedProperties);
        this.removedProperties = Collections.unmodifiableSet(removedProperties);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getRepositoryWorkspaceName() {
        return this.repositoryWorkspaceName;
    }

    public Set<String> getModifiedProperties() {
        return this.modifiedProperties;
    }

    public Set<String> getRemovedProperties() {
        return this.removedProperties;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean includesAllEventTypes(int ... jcrEventTypes) {
        for (int jcrEventType : jcrEventTypes) {
            if ((this.eventTypes & jcrEventType) != 0) continue;
            return false;
        }
        return true;
    }

    public boolean includesEventTypes(int ... jcrEventTypes) {
        for (int jcrEventType : jcrEventTypes) {
            if ((this.eventTypes & jcrEventType) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean isSameNode(NodeChange that) {
        if (that == this) {
            return true;
        }
        if (this.hc != that.hc) {
            return false;
        }
        if (!this.repositoryWorkspaceName.equals(that.repositoryWorkspaceName)) {
            return false;
        }
        return this.absolutePath.equals(that.absolutePath);
    }

    public boolean isOnPath(String absolutePath) {
        if (absolutePath == null) {
            return false;
        }
        return this.getAbsolutePath().startsWith(absolutePath);
    }

    public boolean isNotOnPath(String absolutePath) {
        return !this.isOnPath(absolutePath);
    }

    public boolean isPropertyModified(String property) {
        return this.modifiedProperties.contains(property);
    }

    public boolean isPropertyRemoved(String property) {
        return this.removedProperties.contains(property);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeChange) {
            NodeChange that = (NodeChange)obj;
            if (!this.isSameNode(that)) {
                return false;
            }
            return this.eventTypes == that.eventTypes;
        }
        return false;
    }

    public String toString() {
        return this.repositoryWorkspaceName + "=>" + this.absolutePath;
    }
}

