/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.StringCharacterIterator;
import org.modeshape.common.annotation.Immutable;

@Immutable
public final class ClassUtil {
    private static void addObjectString(Object object, int includeInheritedFieldDepth, Class<?> clazz, StringBuffer text) {
        text.append(ClassUtil.nonPackageQualifiedName(clazz));
        text.append('(');
        Field[] flds = clazz.getDeclaredFields();
        boolean separatorNeeded = false;
        for (Field fld : flds) {
            try {
                String name;
                ClassUtil.makeAccessible(fld);
                Object val = fld.get(object);
                if ((fld.getModifiers() & 8) != 0 || (name = fld.getName()).indexOf(36) >= 0) continue;
                separatorNeeded = ClassUtil.addSeparator(separatorNeeded, text);
                text.append(fld.getName());
                text.append('=');
                text.append(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (includeInheritedFieldDepth > 0) {
            separatorNeeded = ClassUtil.addSeparator(separatorNeeded, text);
            ClassUtil.addObjectString(object, includeInheritedFieldDepth - 1, clazz.getSuperclass(), text);
        }
        text.append(')');
    }

    private static boolean addSeparator(boolean separatorNeeded, StringBuffer text) {
        if (separatorNeeded) {
            text.append(", ");
        }
        return true;
    }

    public static void makeAccessible(final AccessibleObject object) {
        if (!object.isAccessible()) {
            if (System.getSecurityManager() == null) {
                object.setAccessible(true);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        object.setAccessible(true);
                        return null;
                    }
                });
            }
        }
    }

    public static String nonPackageQualifiedName(Class<?> clazz) {
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static String nonPackageQualifiedName(Object object) {
        return ClassUtil.nonPackageQualifiedName(object.getClass());
    }

    public static String toString(Object object, int includeInheritedFieldDepth) {
        StringBuffer text = new StringBuffer();
        ClassUtil.addObjectString(object, includeInheritedFieldDepth, object.getClass(), text);
        return text.toString();
    }

    public static boolean isFullyQualifiedClassname(String classname) {
        if (classname == null) {
            return false;
        }
        String[] parts = classname.split("[\\.]");
        if (parts.length == 0) {
            return false;
        }
        for (String part : parts) {
            StringCharacterIterator iter = new StringCharacterIterator(part);
            char c = iter.first();
            if (c == '\uffff') {
                return false;
            }
            if (!Character.isJavaIdentifierStart(c) && !Character.isIdentifierIgnorable(c)) {
                return false;
            }
            c = iter.next();
            while (c != '\uffff') {
                if (!Character.isJavaIdentifierPart(c) && !Character.isIdentifierIgnorable(c)) {
                    return false;
                }
                c = iter.next();
            }
        }
        return true;
    }

    private ClassUtil() {
    }
}

