/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Bson;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.document.Timestamp;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.CompactJsonWriter;
import org.infinispan.schematic.internal.document.JsonWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactJsonWriterTest {
    protected JsonWriter writer;
    protected boolean print;

    @Before
    public void beforeTest() {
        this.writer = new CompactJsonWriter();
        this.print = false;
    }

    @After
    public void afterTest() {
        this.writer = null;
    }

    @Test
    public void shouldCorrectlyWriteNullValue() {
        this.assertSame("null", this.writer.write(null));
    }

    @Test
    public void shouldCorrectlyWriteBooleanValues() {
        this.assertSame("true", this.writer.write((Object)Boolean.TRUE));
        this.assertSame("false", this.writer.write((Object)Boolean.FALSE));
    }

    @Test
    public void shouldCorrectlyWriteIntegerValues() {
        this.assertSame("10", this.writer.write((Object)10));
        this.assertSame("0", this.writer.write((Object)0));
        this.assertSame("-1", this.writer.write((Object)-1));
        this.assertSame(Integer.toString(Integer.MAX_VALUE), this.writer.write((Object)Integer.MAX_VALUE));
        this.assertSame(Integer.toString(Integer.MIN_VALUE), this.writer.write((Object)Integer.MIN_VALUE));
    }

    @Test
    public void shouldCorrectlyWriteLongValues() {
        this.assertSame("10", this.writer.write((Object)10L));
        this.assertSame("0", this.writer.write((Object)0L));
        this.assertSame("-1", this.writer.write((Object)-1L));
        this.assertSame(Long.toString(0x80000009L), this.writer.write((Object)0x80000009L));
        this.assertSame(Long.toString(-2147483658L), this.writer.write((Object)-2147483658L));
        this.assertSame(Long.toString(Long.MAX_VALUE), this.writer.write((Object)Long.MAX_VALUE));
        this.assertSame(Long.toString(Long.MIN_VALUE), this.writer.write((Object)Long.MIN_VALUE));
    }

    @Test
    public void shouldCorrectlyWriteFloatValues() {
        this.assertSame("10.01", this.writer.write((Object)10.01));
        this.assertSame("0.0", this.writer.write((Object)0.0));
        this.assertSame("-1.0135", this.writer.write((Object)-1.0135));
        this.assertSame(Float.toString(Float.MAX_VALUE), this.writer.write((Object)Float.valueOf(Float.MAX_VALUE)));
        this.assertSame(Float.toString(Float.MIN_VALUE), this.writer.write((Object)Float.valueOf(Float.MIN_VALUE)));
    }

    @Test
    public void shouldCorrectlyWriteDoubleValues() {
        this.assertSame("10.01", this.writer.write((Object)10.01));
        this.assertSame("0.0", this.writer.write((Object)0.0));
        this.assertSame("-1.0135", this.writer.write((Object)-1.0135));
        this.assertSame(Double.toString(Double.MAX_VALUE), this.writer.write((Object)Double.MAX_VALUE));
        this.assertSame(Double.toString(Double.MIN_VALUE), this.writer.write((Object)Double.MIN_VALUE));
    }

    @Test
    public void shouldCorrectlyWriteStringValues() {
        this.assertSame("\"\"", this.writer.write((Object)""));
        this.assertSame("\"10.01\"", this.writer.write((Object)"10.01"));
        this.assertSame("\"10.01d\"", this.writer.write((Object)"10.01d"));
        this.assertSame("\"null\"", this.writer.write((Object)"null"));
        this.assertSame("\"abcdefghijklmnopqrstuvwxyz\"", this.writer.write((Object)"abcdefghijklmnopqrstuvwxyz"));
    }

    @Test
    public void shouldCorrectlyWriteSymbolValues() {
        this.assertSame("\"\"", this.writer.write((Object)new Symbol("")));
        this.assertSame("\"10.01\"", this.writer.write((Object)new Symbol("10.01")));
        this.assertSame("\"10.01d\"", this.writer.write((Object)new Symbol("10.01d")));
        this.assertSame("\"null\"", this.writer.write((Object)new Symbol("null")));
        this.assertSame("\"abcdefghijklmnopqrstuvwxyz\"", this.writer.write((Object)new Symbol("abcdefghijklmnopqrstuvwxyz")));
    }

    @Test
    public void shouldCorrectlyWriteUuid() {
        UUID id = UUID.randomUUID();
        String expected = "{ \"$uuid\" : \"" + id + "\" }";
        String actual = this.writer.write((Object)id);
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteObjectId() {
        ObjectId id = new ObjectId(300, 200, 9, 15);
        String expected = "{ \"$oid\" : \"0000012c0000c8000900000f\" }";
        String actual = this.writer.write((Object)id);
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteDate() {
        Date now = new Date();
        String dateStr = Bson.getDateFormatter().format(now);
        String expected = "{ \"$date\" : \"" + dateStr + "\" }";
        String actual = this.writer.write((Object)now);
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteTimestamp() {
        Timestamp now = new Timestamp(new Date());
        String expected = "{ \"$ts\" : " + now.getTime() + " , \"$inc\" : " + now.getInc() + " }";
        String actual = this.writer.write((Object)now);
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteMinKeyValue() {
        this.assertSame("\"MinKey\"", this.writer.write((Object)MinKey.getInstance()));
    }

    @Test
    public void shouldCorrectlyWriteMaxKeyValue() {
        this.assertSame("\"MaxKey\"", this.writer.write((Object)MaxKey.getInstance()));
    }

    @Test
    public void shouldCorrectlyWriteBinaryValue() {
        byte[] data = new byte[]{0, 1, 2, 3, 4, 5};
        Binary binary = new Binary(2, data);
        String expected = "{ \"$type\" : 2 , \"$base64\" : \"AAECAwQF\" }";
        String actual = this.writer.write((Object)binary);
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWritePattern() {
        Pattern pattern = Pattern.compile("[CH]at\\s+in", 10);
        String expected = "{ \"$regex\" : \"[CH]at\\\\s+in\" , \"$options\" : \"im\" }";
        String actual = this.writer.write((Object)pattern);
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteSimpleBsonObject() {
        BasicDocument top = new BasicDocument();
        top.put((Object)"firstName", (Object)"Jack");
        top.put((Object)"lastName", (Object)"Riley");
        top.put((Object)"age", (Object)31);
        String actual = this.writer.write((Object)top);
        String expected = "{ \"firstName\" : \"Jack\" , \"lastName\" : \"Riley\" , \"age\" : 31 }";
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteSimpleBsonObjectWithNullValue() {
        BasicDocument top = new BasicDocument();
        top.put((Object)"firstName", (Object)"Jack");
        top.put((Object)"lastName", null);
        top.put((Object)"age", (Object)31);
        String actual = this.writer.write((Object)top);
        String expected = "{ \"firstName\" : \"Jack\" , \"lastName\" : null , \"age\" : 31 }";
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteBsonObjectWithNestedObjectValue() {
        BasicDocument address = new BasicDocument();
        address.put((Object)"street", (Object)"100 Main St.");
        address.put((Object)"city", (Object)"Springfield");
        BasicDocument top = new BasicDocument();
        top.put((Object)"firstName", (Object)"Jack");
        top.put((Object)"lastName", (Object)"Riley");
        top.put((Object)"address", (Object)address);
        String actual = this.writer.write((Object)top);
        String expected = "{ \"firstName\" : \"Jack\" , \"lastName\" : \"Riley\" , \"address\" : { \"street\" : \"100 Main St.\" , \"city\" : \"Springfield\" } }";
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteListValue() {
        this.testWritingList("[ ]", new Object[0]);
        this.testWritingList("[ \"value1\" ]", "value1");
        this.testWritingList("[ \"value1\" , null , \"value3\" ]", "value1", null, "value3");
        this.testWritingList("[ \"value1\" , \"value2\" , \"value3\" ]", "value1", "value2", "value3");
        this.testWritingList("[ \"value1\" , \"value2\" , 4 ]", "value1", "value2", 4L);
    }

    protected void testWritingList(String expected, Object ... values) {
        List<Object> list = Arrays.asList(values);
        String actual = this.writer.write(list);
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteCode() {
        Code code = new Code("name");
        String expected = "{ \"$code\" : \"name\" }";
        String actual = this.writer.write((Object)code);
        this.assertSame(expected, actual);
    }

    @Test
    public void shouldCorrectlyWriteCodeWithScope() {
        BasicDocument scope = new BasicDocument();
        scope.put((Object)"firstName", (Object)"Jack");
        scope.put((Object)"lastName", (Object)"Riley");
        CodeWithScope code = new CodeWithScope("name", (Document)scope);
        String actual = this.writer.write((Object)code);
        String expected = "{ \"$code\" : \"name\" , \"$scope\" : { \"firstName\" : \"Jack\" , \"lastName\" : \"Riley\" } }";
        this.assertSame(expected, actual);
    }

    protected void assertSame(String expected, String actual) {
        if (this.print) {
            System.out.println("************************************************************");
            System.out.println(actual);
            System.out.println(expected);
        }
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }
}

