/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.modeshape.common.collection.UnmodifiableProperties;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.lexicon.ModelExtensionDefinitionLexicon;
import org.modeshape.sequencer.teiid.model.ModelNodeWriter;
import org.modeshape.sequencer.teiid.model.ModelObjectHandler;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;
import org.modeshape.sequencer.teiid.xmi.XmiElement;

public class ModelExtensionDefinitionHelper {
    private static final Logger LOGGER = Logger.getLogger(ModelExtensionDefinitionHelper.class);
    private static final Map<String, Integer> TYPE_MAPPINGS;
    private static final Properties METACLASS_MAPPINGS;
    private final ModelNodeWriter writer;
    private final Map<String, String> medPrefixMap = new HashMap<String, String>();
    private final Map<String, Set<String>> medMetaclassMap = new HashMap<String, Set<String>>();
    private final Map<String, NodeTypeTemplate> mixinMap = new HashMap<String, NodeTypeTemplate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadMetaclassMappings() {
        InputStream stream = null;
        String fileName = "org/modeshape/sequencer/teiid/model/medNameMappings.properties";
        try {
            stream = ModelExtensionDefinitionHelper.class.getClassLoader().getResourceAsStream("org/modeshape/sequencer/teiid/model/medNameMappings.properties");
            Properties props = new Properties();
            props.load(stream);
            UnmodifiableProperties unmodifiableProperties = new UnmodifiableProperties(props);
            return unmodifiableProperties;
        }
        catch (IOException e) {
            throw new IllegalStateException(TeiidI18n.errorReadingMedMetaclassMappings.text(new Object[]{"org/modeshape/sequencer/teiid/model/medNameMappings.properties", e.getLocalizedMessage()}), e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    stream = null;
                }
            }
        }
    }

    ModelExtensionDefinitionHelper(ModelNodeWriter writer) {
        CheckArg.isNotNull((Object)writer, (String)"writer");
        this.writer = writer;
    }

    private void addMixin(Node node, String medPrefix, String metaclass, Session session) throws Exception {
        String[] parts = metaclass.split("\\.", 2);
        String mappedPrefix = this.medPrefixMap.get(medPrefix);
        String mixinName = mappedPrefix + ':' + parts[1];
        NodeTypeTemplate mixin = this.mixinMap.get(mixinName);
        if (mixin == null) {
            NodeTypeManager ntMgr = session.getWorkspace().getNodeTypeManager();
            mixin = ntMgr.createNodeTypeTemplate();
            mixin.setMixin(true);
            mixin.setName(mixinName);
            List propDefns = mixin.getPropertyDefinitionTemplates();
            Node medGroupNode = this.writer.getModelNode().getNode("mmcore:modelExtensionDefinitions");
            Node medNode = medGroupNode.getNode(medPrefix);
            NodeIterator itr = medNode.getNodes();
            while (itr.hasNext()) {
                Node medChild = itr.nextNode();
                if (!medChild.isNodeType("modelExtensionDefinition:extendedMetaclass")) continue;
                NodeIterator pitr = medChild.getNodes();
                while (pitr.hasNext()) {
                    String type;
                    Integer msType;
                    Node metaclassChild = pitr.nextNode();
                    if (!metaclassChild.isNodeType("modelExtensionDefinition:propertyDefinition")) continue;
                    PropertyDefinitionTemplate propDefn = ntMgr.createPropertyDefinitionTemplate();
                    propDefn.setName(metaclassChild.getName());
                    if (metaclassChild.hasProperty("modelExtensionDefinition:defaultValue")) {
                        String defaultValue = metaclassChild.getProperty("modelExtensionDefinition:defaultValue").getString();
                        Value value = this.writer.getContext().valueFactory().createValue(defaultValue);
                        propDefn.setDefaultValues(new Value[]{value});
                        propDefn.setAutoCreated(true);
                    }
                    if (metaclassChild.hasProperty("modelExtensionDefinition:required")) {
                        boolean mandatory = metaclassChild.getProperty("modelExtensionDefinition:required").getBoolean();
                        propDefn.setMandatory(mandatory);
                    }
                    if ((msType = TYPE_MAPPINGS.get(type = metaclassChild.getProperty("modelExtensionDefinition:runtimeType").getString())) == null) {
                        msType = 1;
                    }
                    propDefn.setRequiredType(msType.intValue());
                    propDefns.add(propDefn);
                    LOGGER.debug("added property '{0}' to mixin '{1}'", new Object[]{propDefn.getName(), mixinName});
                }
            }
            ntMgr.registerNodeType((NodeTypeDefinition)mixin, true);
            this.mixinMap.put(mixinName, mixin);
            LOGGER.debug("added mixin '{0}' to registry", new Object[]{mixinName});
        }
        node.addMixin(mixinName);
        LOGGER.debug("added mixin '{0}' to node '{1}'", new Object[]{mixinName, node.getName()});
    }

    private boolean hasMetaclassMapping(String jcrType, String metaclassName) {
        String value = METACLASS_MAPPINGS.getProperty(jcrType);
        if (StringUtil.isBlank((String)value)) {
            return false;
        }
        for (String name : value.split(",")) {
            if (!name.equals(metaclassName)) continue;
            return true;
        }
        return false;
    }

    private void assignMedMixins(Node node) throws Exception {
        String jcrType = node.getProperty("jcr:primaryType").getString().replaceFirst(":", ".");
        if (METACLASS_MAPPINGS.containsKey(jcrType)) {
            for (String medPrefix : this.medPrefixMap.keySet()) {
                Set<String> extendedMetaclasses = this.medMetaclassMap.get(medPrefix);
                if (extendedMetaclasses == null) continue;
                for (String metaclass : extendedMetaclasses) {
                    if (!this.hasMetaclassMapping(jcrType, metaclass)) continue;
                    this.addMixin(node, medPrefix, jcrType, node.getSession());
                }
            }
        }
        NodeIterator itr = node.getNodes();
        while (itr.hasNext()) {
            Node kid = itr.nextNode();
            this.assignMedMixins(kid);
        }
    }

    void assignModelNodeChildrenMedMixins(Node modelNode) throws Exception {
        LOGGER.debug("==== ModelExtensionDefinitionHelper:assignModelNodeChildrenMedMixins", new Object[0]);
        NodeIterator itr = modelNode.getNodes();
        while (itr.hasNext()) {
            Node kid = itr.nextNode();
            this.assignMedMixins(kid);
        }
    }

    private String createMedPrefix(NamespaceRegistry registry, String nsPrefix, long suffix) throws Exception {
        assert (registry != null);
        assert (!StringUtil.isBlank((String)nsPrefix));
        String newPrefix = nsPrefix + suffix;
        if (registry.isRegisteredPrefix(newPrefix)) {
            return this.createMedPrefix(registry, nsPrefix, ++suffix);
        }
        LOGGER.debug("created new namespace prefix '{0}'", new Object[]{newPrefix});
        return newPrefix;
    }

    private ModelObjectHandler getHandler() throws Exception {
        return this.writer.getHandler("http://www.metamatrix.com/metamodels/Core");
    }

    String getMappedPropertyName(String propertyName) {
        String registeredPrefix;
        CheckArg.isNotEmpty((String)propertyName, (String)"propertyName");
        String mappedName = propertyName;
        String[] propNameParts = propertyName.split(":", 2);
        if (propNameParts.length == 2 && this.hasMed(propNameParts[0]) && !propNameParts[0].equals(registeredPrefix = this.getRegisteredMedPrefix(propNameParts[0]))) {
            mappedName = registeredPrefix + ':' + propNameParts[1];
        }
        return mappedName;
    }

    String getRegisteredMedPrefix(String medPrefix) {
        CheckArg.isNotEmpty((String)medPrefix, (String)"medPrefix");
        return this.medPrefixMap.get(medPrefix);
    }

    boolean hasMed(String medNamespacePrefix) {
        CheckArg.isNotEmpty((String)medNamespacePrefix, (String)"medNamespacePrefix");
        return this.medPrefixMap.containsKey(medNamespacePrefix);
    }

    private boolean isMedMetaclassNode(Node node) throws Exception {
        return node != null && "modelExtensionDefinition:extendedMetaclass".equals(node.getPrimaryNodeType().getName());
    }

    private boolean isMedNode(Node node) throws Exception {
        return node != null && "modelExtensionDefinition:modelExtensionDefinition".equals(node.getPrimaryNodeType().getName());
    }

    private boolean isMedPropertyDefinitionNode(Node node) throws Exception {
        return node != null && "modelExtensionDefinition:propertyDefinition".equals(node.getPrimaryNodeType().getName());
    }

    private boolean isModelMedTag(XmiElement tag, Node annotatedObjectNode) throws Exception {
        String key = tag.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core");
        if (ModelExtensionDefinitionLexicon.Utils.isModelMedTagKey(key) && tag.getParent() != null) {
            return annotatedObjectNode != null && annotatedObjectNode.isNodeType("mmcore:model");
        }
        return false;
    }

    private boolean medModelTypeProcessed(XmiElement tagElement, String newModelType) throws Exception {
        assert ("tags".equals(tagElement.getName())) : "XMI element is not a tag element";
        String uuid = tagElement.getParent().getAttributeValue("annotatedObject", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)uuid)) {
            return false;
        }
        uuid = this.writer.getResolver().resolveInternalReference(uuid);
        XmiElement referencedElement = this.writer.getResolver().getUuidMappings().get(uuid);
        if (referencedElement != null && "tags".equals(referencedElement.getName()) && "modelTypes".equals(referencedElement.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core"))) {
            String medUuid = referencedElement.getParent().getAttributeValue("annotatedObject", "http://www.metamatrix.com/metamodels/Core");
            medUuid = this.writer.getResolver().resolveInternalReference(medUuid);
            Node medNode = this.writer.getResolver().getNode(medUuid);
            if (medNode != null) {
                Value newValue = this.writer.getContext().valueFactory().createValue(newModelType);
                Value[] modelTypes = null;
                if (medNode.hasProperty("modelExtensionDefinition:modelTypes")) {
                    Property property = medNode.getProperty("modelExtensionDefinition:modelTypes");
                    Value[] currentValues = property.getValues();
                    modelTypes = new Value[currentValues.length + 1];
                    System.arraycopy(currentValues, 0, modelTypes, 0, currentValues.length);
                    modelTypes[currentValues.length] = newValue;
                } else {
                    modelTypes = new Value[]{newValue};
                }
                medNode.setProperty("modelExtensionDefinition:modelTypes", modelTypes);
                LOGGER.debug("added MED model type '{0}' to MED '{1}'", new Object[]{newModelType, medNode.getName()});
                return true;
            }
        }
        return false;
    }

    private boolean medPropertyDefinitionDescriptionProcessed(XmiElement tagElement, String newModelType) throws Exception {
        assert ("tags".equals(tagElement.getName())) : "XMI element is not a tag element";
        String uuid = tagElement.getParent().getAttributeValue("annotatedObject", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)uuid)) {
            return false;
        }
        uuid = this.writer.getResolver().resolveInternalReference(uuid);
        XmiElement referencedElement = this.writer.getResolver().getUuidMappings().get(uuid);
        if (referencedElement != null && "tags".equals(referencedElement.getName()) && "description".equals(referencedElement.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core"))) {
            String propDefUuid = referencedElement.getParent().getAttributeValue("annotatedObject", "http://www.metamatrix.com/metamodels/Core");
            propDefUuid = this.writer.getResolver().resolveInternalReference(propDefUuid);
            Node propDefNode = this.writer.getResolver().getNode(propDefUuid);
            if (propDefNode != null) {
                Node descriptionNode = this.getHandler().addNode(propDefNode, "modelExtensionDefinition:description", tagElement.getUuid(), "modelExtensionDefinition:localizedDescription");
                descriptionNode.setProperty("modelExtensionDefinition:locale", tagElement.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core"));
                descriptionNode.setProperty("modelExtensionDefinition:translation", tagElement.getAttributeValue("value", "http://www.metamatrix.com/metamodels/Core"));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("set property definition description locale to '{0}' and translation to '{1}'", new Object[]{tagElement.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core"), tagElement.getAttributeValue("value", "http://www.metamatrix.com/metamodels/Core")});
                }
                return true;
            }
        }
        return false;
    }

    private boolean medPropertyDefinitionDisplayNameProcessed(XmiElement tagElement, String newModelType) throws Exception {
        assert ("tags".equals(tagElement.getName())) : "XMI element is not a tag element";
        String uuid = tagElement.getParent().getAttributeValue("annotatedObject", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)uuid)) {
            return false;
        }
        uuid = this.writer.getResolver().resolveInternalReference(uuid);
        XmiElement referencedElement = this.writer.getResolver().getUuidMappings().get(uuid);
        if (referencedElement != null && "tags".equals(referencedElement.getName()) && "displayName".equals(referencedElement.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core"))) {
            String propDefUuid = referencedElement.getParent().getAttributeValue("annotatedObject", "http://www.metamatrix.com/metamodels/Core");
            propDefUuid = this.writer.getResolver().resolveInternalReference(propDefUuid);
            Node propDefNode = this.writer.getResolver().getNode(propDefUuid);
            if (propDefNode != null) {
                Node displayNameNode = this.getHandler().addNode(propDefNode, "modelExtensionDefinition:displayName", tagElement.getUuid(), "modelExtensionDefinition:localizedName");
                displayNameNode.setProperty("modelExtensionDefinition:locale", tagElement.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core"));
                displayNameNode.setProperty("modelExtensionDefinition:translation", tagElement.getAttributeValue("value", "http://www.metamatrix.com/metamodels/Core"));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("set property definition display name locale to '{0}' and translation to '{1}'", new Object[]{tagElement.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core"), tagElement.getAttributeValue("value", "http://www.metamatrix.com/metamodels/Core")});
                }
                return true;
            }
        }
        return false;
    }

    boolean process(Node modelNode, Node annotatedObjectNode, ReferenceResolver.UnresolvedReference unresolved, XmiElement annotationTagElement) throws Exception {
        String key = annotationTagElement.getAttributeValue("key", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)key)) {
            return false;
        }
        String value = annotationTagElement.getAttributeValue("value", "http://www.metamatrix.com/metamodels/Core");
        String[] parts = key.split(":", 2);
        if (this.isModelMedTag(annotationTagElement, annotatedObjectNode)) {
            Node medGroupNode = null;
            medGroupNode = modelNode.hasNode("mmcore:modelExtensionDefinitions") ? modelNode.getNode("mmcore:modelExtensionDefinitions") : this.getHandler().addNode(modelNode, "mmcore:modelExtensionDefinitions", null, "mmcore:modelExtensionDefinitions");
            assert (medGroupNode != null) : "MED group node is null";
            this.getHandler().addNode(medGroupNode, parts[1], annotationTagElement.getUuid(), "modelExtensionDefinition:modelExtensionDefinition");
            return true;
        }
        if (this.isMedNode(annotatedObjectNode) && annotatedObjectNode != null) {
            if (ModelExtensionDefinitionLexicon.Utils.isModelMedMetaclassTagKey(key)) {
                String medPrefix = annotatedObjectNode.getName();
                String metaclass = parts[1];
                this.getHandler().addNode(annotatedObjectNode, metaclass, annotationTagElement.getUuid(), "modelExtensionDefinition:extendedMetaclass");
                Set<String> extendedMetaclasses = this.medMetaclassMap.get(medPrefix);
                if (extendedMetaclasses == null) {
                    extendedMetaclasses = new HashSet<String>();
                    this.medMetaclassMap.put(medPrefix, extendedMetaclasses);
                }
                extendedMetaclasses.add(metaclass);
                LOGGER.debug("added metaclass node '{0}' to MED '{1}'", new Object[]{metaclass, medPrefix});
            } else if (!ModelExtensionDefinitionLexicon.Utils.isModelMedModelTypesTagKey(key)) {
                String nsPrefix;
                annotatedObjectNode.setProperty(ModelExtensionDefinitionLexicon.Utils.constructJcrName(key), value);
                LOGGER.debug("set MED property '{0}' to value '{1}' for MED '{2}'", new Object[]{ModelExtensionDefinitionLexicon.Utils.constructJcrName(key), value, annotatedObjectNode.getName()});
                if (annotatedObjectNode.hasProperty("modelExtensionDefinition:namespacePrefix") && annotatedObjectNode.hasProperty("modelExtensionDefinition:namespaceUri") && annotatedObjectNode.hasProperty("modelExtensionDefinition:version") && !this.medPrefixMap.containsKey(nsPrefix = annotatedObjectNode.getProperty("modelExtensionDefinition:namespacePrefix").getString())) {
                    this.registerNamespace(annotatedObjectNode.getSession(), (NamespaceRegistry)annotatedObjectNode.getSession().getWorkspace().getNamespaceRegistry(), nsPrefix, annotatedObjectNode.getProperty("modelExtensionDefinition:namespaceUri").getString(), annotatedObjectNode.getProperty("modelExtensionDefinition:version").getLong());
                }
            }
            return true;
        }
        if (this.isMedMetaclassNode(annotatedObjectNode) && annotatedObjectNode != null) {
            if (ModelExtensionDefinitionLexicon.Utils.isModelMedPropertyDefinitionTagKey(key)) {
                String medPrefix = annotatedObjectNode.getParent().getName();
                String mappedPrefix = this.medPrefixMap.get(medPrefix);
                this.getHandler().addNode(annotatedObjectNode, mappedPrefix + ':' + parts[1], annotationTagElement.getUuid(), "modelExtensionDefinition:propertyDefinition");
                LOGGER.debug("added MED property definition node '{0}' to metaclass '{1}' in MED '{2}'", new Object[]{mappedPrefix + ':' + parts[1], annotatedObjectNode.getName(), medPrefix});
            } else {
                annotatedObjectNode.setProperty(ModelExtensionDefinitionLexicon.Utils.constructJcrName(key), value);
                LOGGER.debug("set MED metaclass property '{0}' to value '{1}' for metaclass '{2}'", new Object[]{ModelExtensionDefinitionLexicon.Utils.constructJcrName(key), value, annotatedObjectNode.getName()});
            }
            return true;
        }
        if (this.isMedPropertyDefinitionNode(annotatedObjectNode) && annotatedObjectNode != null) {
            if (!ModelExtensionDefinitionLexicon.Utils.isModelMedPropertyDefinitionDescriptionTagKey(key) && !ModelExtensionDefinitionLexicon.Utils.isModelMedPropertyDefinitionDisplayNameTagKey(key)) {
                String propName = ModelExtensionDefinitionLexicon.Utils.constructJcrName(key);
                annotatedObjectNode.setProperty(propName, value);
                LOGGER.debug("set MED property definition property '{0}' to value '{1}' for property '{2}'", new Object[]{propName, value, annotatedObjectNode.getName()});
            }
            return true;
        }
        if (annotatedObjectNode == null && this.medModelTypeProcessed(annotationTagElement, key)) {
            return true;
        }
        if (annotatedObjectNode == null && this.medPropertyDefinitionDescriptionProcessed(annotationTagElement, key)) {
            return true;
        }
        if (annotatedObjectNode == null && this.medPropertyDefinitionDisplayNameProcessed(annotationTagElement, key)) {
            return true;
        }
        if (this.hasMed(parts[0])) {
            String mappedPrefix = this.medPrefixMap.get(parts[0]);
            if (annotatedObjectNode != null) {
                this.getHandler().setProperty(annotatedObjectNode, mappedPrefix + ':' + parts[1], value);
            } else {
                unresolved.addProperty(mappedPrefix + ':' + parts[1], value, false);
            }
            return true;
        }
        return false;
    }

    private void registerNamespace(Session session, NamespaceRegistry registry, String medPrefix, String medUri, long medVersion) throws Exception {
        assert (session != null && registry != null && !StringUtil.isBlank((String)medPrefix) && !StringUtil.isBlank((String)medUri));
        if (this.medPrefixMap.containsKey(medPrefix)) {
            return;
        }
        String medUriSuffix = "/" + medVersion;
        if (!medUri.endsWith(medUriSuffix)) {
            medUri = medUri.endsWith("/") ? medUri + Long.toString(medVersion) : medUri + medUriSuffix;
        }
        String registeredPrefix = null;
        String registeredUri = null;
        if (registry.isRegisteredUri(medUri)) {
            registeredPrefix = registry.getPrefix(medUri);
        }
        if (registry.isRegisteredPrefix(medPrefix)) {
            registeredUri = registry.getURI(medPrefix);
        }
        if (StringUtil.isBlank(registeredUri) && StringUtil.isBlank((String)registeredPrefix)) {
            registry.registerNamespace(medPrefix, medUri);
            this.medPrefixMap.put(medPrefix, medPrefix);
            LOGGER.debug("registering MED namespace '{0}':'{1}'", new Object[]{medPrefix, medUri});
        } else if (!StringUtil.isBlank((String)registeredPrefix)) {
            this.medPrefixMap.put(medPrefix, registeredPrefix);
            LOGGER.debug("using registered prefix '{0}' for MED prefix '{1}'", new Object[]{registeredPrefix, medPrefix});
        } else {
            String newPrefix = this.createMedPrefix(registry, medPrefix, medVersion);
            registry.registerNamespace(newPrefix, medUri);
            this.medPrefixMap.put(medPrefix, newPrefix);
            LOGGER.debug("registered MED namespace '{0}':'{1}' for MED prefix '{2}'", new Object[]{newPrefix, medUri, medPrefix});
        }
    }

    static {
        METACLASS_MAPPINGS = ModelExtensionDefinitionHelper.loadMetaclassMappings();
        TYPE_MAPPINGS = new HashMap<String, Integer>();
        TYPE_MAPPINGS.put("biginteger", 3);
        TYPE_MAPPINGS.put("bigdecimal", 4);
        TYPE_MAPPINGS.put("blob", 2);
        TYPE_MAPPINGS.put("boolean", 6);
        TYPE_MAPPINGS.put("byte", 3);
        TYPE_MAPPINGS.put("char", 1);
        TYPE_MAPPINGS.put("clob", 2);
        TYPE_MAPPINGS.put("date", 5);
        TYPE_MAPPINGS.put("double", 4);
        TYPE_MAPPINGS.put("float", 4);
        TYPE_MAPPINGS.put("integer", 3);
        TYPE_MAPPINGS.put("long", 3);
        TYPE_MAPPINGS.put("object", 2);
        TYPE_MAPPINGS.put("short", 3);
        TYPE_MAPPINGS.put("string", 1);
        TYPE_MAPPINGS.put("time", 5);
        TYPE_MAPPINGS.put("timestamp", 5);
        TYPE_MAPPINGS.put("xml", 1);
    }
}

