/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import javax.jcr.Node;
import org.modeshape.common.util.CheckArg;
import org.modeshape.sequencer.teiid.model.ModelObjectHandler;
import org.modeshape.sequencer.teiid.xmi.XmiElement;
import org.modeshape.sequencer.teiid.xmi.XmiPart;

public final class JdbcModelObjectHandler
extends ModelObjectHandler {
    @Override
    protected String getQName(XmiPart xmiPart) {
        return "jdbcs:" + xmiPart.getName();
    }

    @Override
    protected void process(XmiElement element, Node parentNode) throws Exception {
        CheckArg.isNotNull((Object)element, (String)"element");
        CheckArg.isNotNull((Object)parentNode, (String)"outputNode");
        CheckArg.isEquals((Object)element.getNamespaceUri(), (String)"namespace URI", (Object)"http://www.metamatrix.com/metamodels/JDBC", (String)"JDBC URI");
        LOGGER.debug("==== JdbcModelObjectHandler:process:element={0}", new Object[]{element.getName()});
        String type = element.getName();
        if ("JdbcSource".equals(type)) {
            Node sourceNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/JDBC", "jdbcs:source");
            this.processSource(element, sourceNode);
            for (XmiElement childElement : element.getChildren()) {
                if ("importSettings".equals(childElement.getName())) {
                    this.process(childElement, parentNode);
                    break;
                }
                LOGGER.debug("**** JDBC Source child element type of '{0}' was not processed", new Object[]{childElement.getName()});
            }
        } else if ("importSettings".equals(type)) {
            Node importSettingNode = this.addNode(parentNode, element, "http://www.metamatrix.com/metamodels/JDBC", "jdbcs:imported");
            this.processImportSetting(element, importSettingNode);
            for (XmiElement childElement : element.getChildren()) {
                String childType = childElement.getName();
                if ("excludedObjectPaths".equals(childType)) {
                    this.addPropertyValue(importSettingNode, "jdbcs:excludedObjectPaths", childElement.getValue());
                    continue;
                }
                if ("includedCatalogPaths".equals(childType)) {
                    this.addPropertyValue(importSettingNode, "jdbcs:includedCatalogPaths", childElement.getValue());
                    continue;
                }
                if ("includedSchemaPaths".equals(childType)) {
                    this.addPropertyValue(importSettingNode, "jdbcs:includedSchemaPaths", childElement.getValue());
                    continue;
                }
                if ("includedTableTypes".equals(childType)) {
                    this.addPropertyValue(importSettingNode, "jdbcs:includedTableTypes", childElement.getValue());
                    continue;
                }
                LOGGER.debug("**** JDBC Import Settings child element type of '{0}' was not processed", new Object[]{childElement.getName()});
            }
        } else {
            LOGGER.debug("**** JDBC type of '{0}' was not processed", new Object[]{type});
        }
    }

    private void processImportSetting(XmiElement importSettingElement, Node importSettingNode) throws Exception {
        this.setBooleanProperty(importSettingNode, "jdbcs:createCatalogsInModel", importSettingElement.getAttributeValue("createCatalogsInModel", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setBooleanProperty(importSettingNode, "jdbcs:createSchemasInModel", importSettingElement.getAttributeValue("createSchemasInModel", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setProperty(importSettingNode, "jdbcs:convertCaseInModel", importSettingElement.getAttributeValue("convertCaseInModel", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setProperty(importSettingNode, "jdbcs:generateSourceNamesInModel", importSettingElement.getAttributeValue("generateSourceNamesInModel", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setBooleanProperty(importSettingNode, "jdbcs:includeForeignKeys", importSettingElement.getAttributeValue("includeForeignKeys", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setBooleanProperty(importSettingNode, "jdbcs:includeIndexes", importSettingElement.getAttributeValue("includeIndexes", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setBooleanProperty(importSettingNode, "jdbcs:includeProcedures", importSettingElement.getAttributeValue("includeProcedures", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setBooleanProperty(importSettingNode, "jdbcs:includeApproximateIndexes", importSettingElement.getAttributeValue("includeApproximateIndexes", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setBooleanProperty(importSettingNode, "jdbcs:includeUniqueIndexes", importSettingElement.getAttributeValue("includeUniqueIndexes", "http://www.metamatrix.com/metamodels/JDBC"));
    }

    private void processSource(XmiElement sourceElement, Node sourceNode) throws Exception {
        this.setProperty(sourceNode, "jdbcs:driverName", sourceElement.getAttributeValue("driverName", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setProperty(sourceNode, "jdbcs:driverClass", sourceElement.getAttributeValue("driverClass", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setProperty(sourceNode, "jdbcs:username", sourceElement.getAttributeValue("username", "http://www.metamatrix.com/metamodels/JDBC"));
        this.setProperty(sourceNode, "jdbcs:url", sourceElement.getAttributeValue("url", "http://www.metamatrix.com/metamodels/JDBC"));
    }
}

