/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.api.monitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ValueMetric {
    SESSION_COUNT("session-count", true, "Active sessions", "The number of sessions that are active during the window."),
    QUERY_COUNT("query-count", true, "Active queries", "The number of queries that are executing during the window"),
    WORKSPACE_COUNT("workspace-count", true, "Workspace count", "The number of workspaces that exist during the window"),
    LISTENER_COUNT("listener-count", true, "Active listeners", "The number of listeners registered during the window."),
    EVENT_QUEUE_SIZE("event-queue-size", true, "Event queue size", "The number of events at the end of the window that have yet to be processed and sent to listeners"),
    EVENT_COUNT("event-count", false, "Event count", "The number of events that have been sent to at least one listener during the window."),
    SESSION_SCOPED_LOCK_COUNT("session-scoped-lock-count", true, "Session-scoped locks", "The number of session-scoped locks that were held by clients during the window. The values go up or down from one window to the next as clients lock and unlock nodes."),
    OPEN_SCOPED_LOCK_COUNT("open-scoped-lock-count", true, "Open-scoped locks", "The number of locks that were held by clients during the window. The values go up or down from one window to the next as clients lock and unlock nodes."),
    SESSION_SAVES("session-saves", false, "Saves", "The number of save operations called on sessions during the window."),
    NODE_CHANGES("node-changes", false, "Changed nodes", "The number of nodes that were created, updated or deleted during the window due to session saves, workspace imports, or version checkin calls."),
    SEQUENCER_QUEUE_SIZE("sequenced-queue-size", true, "Sequencer queue size", "The number of nodes at the end of the window that have yet to be sequenced."),
    SEQUENCED_COUNT("sequenced-count", false, "Sequenced nodes", "The number of nodes that were sequenced during the window.");

    private static final Map<String, ValueMetric> BY_LITERAL;
    private static final Map<String, ValueMetric> BY_NAME;
    private final String literal;
    private final String label;
    private final String description;
    private final boolean continuous;

    private ValueMetric(String literal, boolean continuous, String label, String description) {
        this.literal = literal;
        this.label = label;
        this.description = description;
        this.continuous = continuous;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public static ValueMetric fromLiteral(String literal) {
        if (literal == null) {
            return null;
        }
        ValueMetric metric = BY_LITERAL.get(literal = literal.toLowerCase());
        if (metric == null) {
            BY_NAME.get(literal);
        }
        return metric;
    }

    static {
        HashMap<String, ValueMetric> byName = new HashMap<String, ValueMetric>();
        HashMap<String, ValueMetric> byLiteral = new HashMap<String, ValueMetric>();
        for (ValueMetric metric : ValueMetric.values()) {
            byLiteral.put(metric.getLiteral().toLowerCase(), metric);
            byName.put(metric.name().toLowerCase(), metric);
        }
        BY_LITERAL = Collections.unmodifiableMap(byLiteral);
        BY_NAME = Collections.unmodifiableMap(byName);
    }
}

