/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.util.regex.Pattern;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.ObjectId;

public class BsonUtils {
    public static int regexFlagsFrom(String flags) {
        if (flags == null) {
            return 0;
        }
        flags = flags.toLowerCase();
        int value = 0;
        block11: for (int i = 0; i < flags.length(); ++i) {
            char c = flags.charAt(i);
            switch (c) {
                case 'i': {
                    value |= 2;
                    continue block11;
                }
                case 'm': {
                    value |= 8;
                    continue block11;
                }
                case 'd': {
                    value |= 1;
                    continue block11;
                }
                case 'c': {
                    value |= 0x80;
                    continue block11;
                }
                case 's': {
                    value |= 0x20;
                    continue block11;
                }
                case 't': {
                    value |= 0x10;
                    continue block11;
                }
                case 'u': {
                    value |= 0x40;
                    continue block11;
                }
                case 'x': {
                    value |= 4;
                    continue block11;
                }
                case 'g': {
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("unrecognized regex flag '" + c + "'");
                }
            }
        }
        return value;
    }

    public static String regexFlagsFor(Pattern pattern) {
        return BsonUtils.regexFlagsFor(pattern.flags());
    }

    public static String regexFlagsFor(int flags) {
        if (flags == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if ((flags & 0x80) == 128) {
            sb.append('c');
        }
        if ((flags & 1) == 1) {
            sb.append('d');
        }
        if ((flags & 2) == 2) {
            sb.append('i');
        }
        if ((flags & 8) == 8) {
            sb.append('m');
        }
        if ((flags & 0x20) == 32) {
            sb.append('s');
        }
        if ((flags & 0x10) == 16) {
            sb.append('t');
        }
        if ((flags & 0x40) == 64) {
            sb.append('u');
        }
        if ((flags & 4) == 4) {
            sb.append('x');
        }
        return sb.toString();
    }

    public static ObjectId readObjectId(byte[] bytes) {
        int time = ((bytes[0] & 0xFF) << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + ((bytes[3] & 0xFF) << 0);
        int machine = ((bytes[4] & 0xFF) << 16) + ((bytes[5] & 0xFF) << 8) + ((bytes[6] & 0xFF) << 0);
        int process = ((bytes[7] & 0xFF) << 8) + ((bytes[8] & 0xFF) << 0);
        int inc = ((bytes[9] & 0xFF) << 16) + ((bytes[10] & 0xFF) << 8) + ((bytes[11] & 0xFF) << 0);
        return new ObjectId(time, machine, process, inc);
    }

    public static ObjectId readObjectId(String bytesInHex) {
        byte[] bytes = new byte[12];
        assert (bytesInHex.length() == 24);
        int index = 0;
        for (int i = 0; i != 12; ++i) {
            String hexChar = bytesInHex.substring(index, index += 2);
            bytes[i] = (byte)Integer.parseInt(hexChar, 16);
        }
        return BsonUtils.readObjectId(bytes);
    }

    public static void writeObjectId(ObjectId id, byte[] b) {
        int time = id.getTime();
        int machine = id.getMachine();
        int process = id.getProcess();
        int inc = id.getInc();
        b[0] = (byte)(time >>> 24 & 0xFF);
        b[1] = (byte)(time >>> 16 & 0xFF);
        b[2] = (byte)(time >>> 8 & 0xFF);
        b[3] = (byte)(time >>> 0 & 0xFF);
        b[4] = (byte)(machine >>> 16 & 0xFF);
        b[5] = (byte)(machine >>> 8 & 0xFF);
        b[6] = (byte)(machine >>> 0 & 0xFF);
        b[7] = (byte)(process >>> 8 & 0xFF);
        b[8] = (byte)(process >>> 0 & 0xFF);
        b[9] = (byte)(inc >>> 16 & 0xFF);
        b[10] = (byte)(inc >>> 8 & 0xFF);
        b[11] = (byte)(inc >>> 0 & 0xFF);
    }

    public static boolean valuesAreEqual(Object thisValue, Object thatValue) {
        if (thisValue == thatValue) {
            return true;
        }
        if (thisValue == null || thisValue instanceof Null) {
            return Null.matches(thatValue);
        }
        if (thisValue instanceof Number && thatValue instanceof Number) {
            Number thisNumber = (Number)thisValue;
            Number thatNumber = (Number)thatValue;
            return thisNumber.doubleValue() == thatNumber.doubleValue();
        }
        if (thisValue instanceof Pattern && thatValue instanceof Pattern) {
            Pattern thisPattern = (Pattern)thisValue;
            Pattern thatPattern = (Pattern)thatValue;
            return thisPattern.pattern().equals(thatPattern.pattern()) && thisPattern.flags() == thatPattern.flags();
        }
        return thisValue.equals(thatValue);
    }
}

