/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.AddValueOperation;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;

@SerializeWith(value=Externalizer.class)
public class AddValueIfAbsentOperation
extends AddValueOperation {
    protected transient boolean added;

    public AddValueIfAbsentOperation(Path path, Object value) {
        super(path, value);
    }

    public boolean isAdded() {
        return this.added;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.added) {
            MutableArray array = this.mutableParent(delegate);
            array.remove(this.index);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.added = array.addValueIfAbsent(this.value);
    }

    @Override
    public String toString() {
        return super.toString() + " if absent";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AddValueIfAbsentOperation) {
            AddValueIfAbsentOperation other = (AddValueIfAbsentOperation)obj;
            return this.equalsIfNotNull(this.value, other.value) && this.index == other.index && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }

    public static final class Externalizer
    extends SchematicExternalizer<AddValueIfAbsentOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, AddValueIfAbsentOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeObject(put.value);
        }

        public AddValueIfAbsentOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            Object value = input.readObject();
            return new AddValueIfAbsentOperation(path, value);
        }

        @Override
        public Integer getId() {
            return 1606;
        }

        @Override
        public Set<Class<? extends AddValueIfAbsentOperation>> getTypeClasses() {
            return Collections.singleton(AddValueIfAbsentOperation.class);
        }
    }
}

