/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.SecureHash;

public class SecureHashTest {
    @Test
    public void shouldCorrectlyComputeSecureHashUsingMD2() throws Exception {
        this.assertCorrectlyComputeSecureHashUsing(SecureHash.Algorithm.MD2);
    }

    @Test
    public void shouldCorrectlyComputeSecureHashUsingMD5() throws Exception {
        this.assertCorrectlyComputeSecureHashUsing(SecureHash.Algorithm.MD5);
    }

    @Test
    public void shouldCorrectlyComputeSecureHashUsingSHA1() throws Exception {
        this.assertCorrectlyComputeSecureHashUsing(SecureHash.Algorithm.SHA_1);
    }

    @Test
    public void shouldCorrectlyComputeSecureHashUsingSHA256() throws Exception {
        this.assertCorrectlyComputeSecureHashUsing(SecureHash.Algorithm.SHA_256);
    }

    @Test
    public void shouldCorrectlyComputeSecureHashUsingSHA384() throws Exception {
        this.assertCorrectlyComputeSecureHashUsing(SecureHash.Algorithm.SHA_384);
    }

    protected void assertCorrectlyComputeSecureHashUsing(SecureHash.Algorithm algorithm) throws Exception {
        this.assertSecureHashStreamWorks(algorithm, "/org/modeshape/common/i18n/I18nTest$TestI18n_en.properties");
        this.assertSecureHashStreamWorks(algorithm, "/org/modeshape/common/i18n/I18nTest$TestI18n_fr.properties");
        this.assertSecureHashStreamWorks(algorithm, "/org/modeshape/common/i18n/MockI18n.properties");
        this.assertSecureHashStreamWorks(algorithm, "/org/modeshape/common/util/additionalmime.types");
        this.assertSecureHashStreamWorks(algorithm, "/org/modeshape/common/logging/LoggerTest.properties");
        this.assertSecureHashStreamWorks(algorithm, "/log4j.properties");
        this.assertSecureHashStreamWorks(algorithm, "/maven-metadata-repository.jboss.org.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSecureHashStreamWorks(SecureHash.Algorithm algorithm, String resourceName) throws IOException, NoSuchAlgorithmException {
        InputStream stream = this.getClass().getResourceAsStream(resourceName);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        byte[] bytesThruStream = IoUtil.readBytes((InputStream)stream);
        stream = this.getClass().getResourceAsStream(resourceName);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        byte[] hashThruStream = null;
        try {
            hashThruStream = SecureHash.getHash((SecureHash.Algorithm)algorithm, (InputStream)stream);
        }
        finally {
            stream.close();
        }
        stream = this.getClass().getResourceAsStream(resourceName);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        SecureHash.HashingInputStream hashingStream = SecureHash.createHashingStream((SecureHash.Algorithm)algorithm, (InputStream)stream);
        byte[] bytesThruHashingStream = IoUtil.readBytes((InputStream)hashingStream);
        byte[] hashThruHashingStream = hashingStream.getHash();
        Assert.assertThat((Object)bytesThruHashingStream, (Matcher)Is.is((Object)bytesThruStream));
        Assert.assertThat((Object)hashThruHashingStream, (Matcher)Is.is((Object)hashThruStream));
    }
}

