/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.SecureHashTextEncoder;
import org.modeshape.common.util.SecureHash;

public class SecureHashTextEncoderTest {
    private SecureHashTextEncoder encoder = new SecureHashTextEncoder(SecureHash.Algorithm.SHA_1);
    private SecureHashTextEncoder shortEncoder = new SecureHashTextEncoder(SecureHash.Algorithm.SHA_1, 4);
    private SecureHashTextEncoder md5Encoder = new SecureHashTextEncoder(SecureHash.Algorithm.MD5);
    private Set<String> alreadyEncoded = new HashSet<String>();
    private Set<String> alreadyEncodedShort = new HashSet<String>();
    private Set<String> alreadyEncodedMd5 = new HashSet<String>();

    @Before
    public void beforeEach() {
    }

    protected void checkEncoding(String input) {
        Assert.assertThat((Object)this.alreadyEncoded.add(this.checkEncoding(this.encoder, input)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.alreadyEncodedShort.add(this.checkEncoding(this.shortEncoder, input)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.alreadyEncodedMd5.add(this.checkEncoding(this.md5Encoder, input)), (Matcher)Is.is((Object)true));
    }

    protected String checkEncoding(SecureHashTextEncoder encoder, String input) {
        String output = encoder.encode(input);
        Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)(output.length() <= encoder.getMaxLength() ? 1 : 0), (Matcher)Is.is((Object)true));
        return output;
    }

    @Test
    public void shouldEncodeAlphabeticCharacters() {
        this.checkEncoding("abcdefghijklmnopqrstuvwxyz");
        this.checkEncoding("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    @Test
    public void shouldEncodeNumericCharacters() {
        this.checkEncoding("0123456789");
    }

    @Test
    public void shouldEncodePunctuationCharacters() {
        this.checkEncoding("~`!@#$%^&()-_+={}\\;\"'<,>.?");
    }

    @Test
    public void shouldEncodeUrlsAndHaveNoDuplicates() {
        this.checkEncoding("http://www.jboss.org");
        this.checkEncoding("http://www.jboss.org/");
        this.checkEncoding("http://www.modeshape.org");
        this.checkEncoding("http://www.modeshape.org/1.0");
        this.checkEncoding("http://www.modeshape.org/internal/1.0");
        this.checkEncoding("http://www.jcp.org/jcr/1.0");
        this.checkEncoding("http://www.jcp.org/jcr/nt/1.0");
        this.checkEncoding("http://www.jcp.org/jcr/mix/1.0");
        this.checkEncoding("http://www.jcp.org/jcr/sv/1.0");
        this.checkEncoding("http://www.acme.com/this/is/a/really/long/url/this/is/a/really/long/url/this/is/a/really/long/url/this/is/a/really/long/url/21?x=1&z=2");
        this.checkEncoding("http://www.acme.com/this/is/a/really/long/url/this/is/a/really/long/url/this/is/a/really/long/url/this/is/a/really/long/url/21?x=1&z=3");
    }
}

