/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.HashMap;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.dialect.teiid.StatementParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParsingException;
import org.modeshape.sequencer.ddl.node.AstNode;

final class CreateProcedureParser
extends StatementParser {
    CreateProcedureParser(TeiidDdlParser teiidDdlParser) {
        super(teiidDdlParser);
    }

    @Override
    boolean matches(DdlTokenStream tokens) {
        return tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_VIRTUAL_FUNCTION.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_VIRTUAL_PROCEDURE.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_FOREIGN_FUNCTION.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_FOREIGN_PROCEDURE.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_FUNCTION.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_PROCEDURE.tokens());
    }

    @Override
    AstNode parse(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        boolean procedure = true;
        TeiidDdlConstants.DdlStatement stmt = null;
        TeiidDdlConstants.SchemaElementType schemaElementType = null;
        if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_VIRTUAL_FUNCTION.tokens())) {
            stmt = TeiidDdlConstants.DdlStatement.CREATE_VIRTUAL_FUNCTION;
            schemaElementType = TeiidDdlConstants.SchemaElementType.VIRTUAL;
            procedure = false;
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_VIRTUAL_PROCEDURE.tokens())) {
            stmt = TeiidDdlConstants.DdlStatement.CREATE_VIRTUAL_PROCEDURE;
            schemaElementType = TeiidDdlConstants.SchemaElementType.VIRTUAL;
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_FOREIGN_FUNCTION.tokens())) {
            stmt = TeiidDdlConstants.DdlStatement.CREATE_FOREIGN_FUNCTION;
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
            procedure = false;
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_FOREIGN_PROCEDURE.tokens())) {
            stmt = TeiidDdlConstants.DdlStatement.CREATE_FOREIGN_PROCEDURE;
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_FUNCTION.tokens())) {
            stmt = TeiidDdlConstants.DdlStatement.CREATE_FUNCTION;
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
            procedure = false;
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_PROCEDURE.tokens())) {
            stmt = TeiidDdlConstants.DdlStatement.CREATE_PROCEDURE;
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
        } else {
            throw new TeiidDdlParsingException(tokens, "Unparsable create procedure statement");
        }
        assert (stmt != null) : "Create procedure statement is null";
        assert (schemaElementType != null) : "Create procedure schema element type is null";
        String id = this.parseIdentifier(tokens);
        AstNode procedureNode = this.getNodeFactory().node(id, parentNode, procedure ? "teiidddl:createProcedure" : "teiidddl:createFunction");
        procedureNode.setProperty("teiidddl:schemaElementType", (Object)schemaElementType.toDdl());
        this.parseProcedureParameters(tokens, procedureNode);
        this.parseReturnsClause(tokens, procedureNode);
        this.parseOptionsClause(tokens, procedureNode);
        this.parseAsClause(tokens, procedureNode);
        return procedureNode;
    }

    boolean parseAsClause(DdlTokenStream tokens, AstNode procedureNode) {
        if (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.AS.toDdl())) {
            String statement = this.parseStatement(tokens, 0, "", tokens.nextPosition(), "");
            if (StringUtil.isBlank((String)statement)) {
                throw new TeiidDdlParsingException(tokens, "Unparsable AS clause (no statement found)");
            }
            procedureNode.setProperty("teiidddl:statement", (Object)statement);
            return true;
        }
        return false;
    }

    void parseProcedureParameter(DdlTokenStream tokens, AstNode procedureNode) {
        String paramType = TeiidDdlConstants.TeiidReservedWord.IN.toDdl();
        if (tokens.matches(TeiidDdlConstants.TeiidReservedWord.IN.toDdl()) || tokens.matches(TeiidDdlConstants.TeiidReservedWord.OUT.toDdl()) || tokens.matches(TeiidDdlConstants.TeiidReservedWord.INOUT.toDdl()) || tokens.matches(TeiidDdlConstants.TeiidNonReservedWord.VARIADIC.toDdl())) {
            paramType = tokens.consume();
        }
        String id = this.parseIdentifier(tokens);
        AstNode parameterNode = this.getNodeFactory().node(id, procedureNode, "teiidddl:procedureParameter");
        parameterNode.setProperty("teiidddl:parameterType", (Object)paramType);
        DataType dataType = this.getDataTypeParser().parse(tokens);
        this.getDataTypeParser().setPropertiesOnNode(parameterNode, dataType);
        boolean foundNotNull = false;
        boolean foundResult = false;
        boolean foundDefault = false;
        boolean foundOptions = false;
        boolean keepParsing = true;
        while (!(!keepParsing || foundNotNull && foundResult && foundDefault && !foundOptions)) {
            if (tokens.canConsume(NOT_NULL)) {
                foundNotNull = true;
                continue;
            }
            if (tokens.canConsume(TeiidDdlConstants.TeiidNonReservedWord.RESULT.toDdl())) {
                foundResult = true;
                continue;
            }
            if (this.parseDefaultClause(tokens, parameterNode)) {
                foundDefault = true;
                continue;
            }
            if (this.parseOptionsClause(tokens, parameterNode)) {
                foundOptions = true;
                continue;
            }
            keepParsing = false;
        }
        parameterNode.setProperty("ddl:nullable", (Object)(foundNotNull ? "NOT NULL" : "NULL"));
        parameterNode.setProperty("teiidddl:result", (Object)foundResult);
    }

    void parseProcedureParameters(DdlTokenStream tokens, AstNode procedureNode) {
        if (tokens.canConsume("(")) {
            if (!tokens.matches(")")) {
                this.parseProcedureParameter(tokens, procedureNode);
                while (tokens.canConsume(",")) {
                    this.parseProcedureParameter(tokens, procedureNode);
                }
            }
            if (!tokens.canConsume(")")) {
                throw new TeiidDdlParsingException(tokens, "Unparsable procedure parameters (right paren not found)");
            }
        } else {
            throw new TeiidDdlParsingException(tokens, "Unparsable procedure parameters (left paren not found)");
        }
    }

    void parseProcedureResultColumn(DdlTokenStream tokens, AstNode resultSetNode) {
        String id = this.parseIdentifier(tokens);
        DataType dataType = this.getDataTypeParser().parse(tokens);
        boolean notNull = tokens.canConsume(NOT_NULL);
        AstNode resultColumnNode = this.getNodeFactory().node(id, resultSetNode, "teiidddl:resultColumn");
        resultColumnNode.setProperty("ddl:nullable", (Object)(notNull ? "NOT NULL" : "NULL"));
        this.getDataTypeParser().setPropertiesOnNode(resultColumnNode, dataType);
        this.parseOptionsClause(tokens, resultColumnNode);
    }

    AstNode parseProcedureResultColumns(DdlTokenStream tokens, AstNode procedureNode) throws ParsingException {
        if (tokens.matches("TABLE", new String[]{"("}) || tokens.matches("(")) {
            boolean table = tokens.canConsume("TABLE");
            if (tokens.canConsume("(")) {
                AstNode resultSetNode = this.getNodeFactory().node("resultSet", procedureNode, "teiidddl:resultColumns");
                resultSetNode.setProperty("teiidddl:table", (Object)table);
                this.parseProcedureResultColumn(tokens, resultSetNode);
                while (tokens.canConsume(",")) {
                    this.parseProcedureResultColumn(tokens, resultSetNode);
                }
                if (!tokens.canConsume(")")) {
                    throw new TeiidDdlParsingException(tokens, "Unparsable procedure result columns (right paren not found)");
                }
                return resultSetNode;
            }
            throw new TeiidDdlParsingException(tokens, "Unparsable procedure result columns (left paren not found)");
        }
        return null;
    }

    boolean parseReturnsClause(DdlTokenStream tokens, AstNode procedureNode) {
        if (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.RETURNS.toDdl())) {
            HashMap<String, String> options = new HashMap<String, String>();
            boolean optionsExist = this.parseOptionsClause(tokens, options);
            AstNode resultNode = this.parseProcedureResultColumns(tokens, procedureNode);
            if (resultNode == null) {
                DataType dataType = this.getDataTypeParser().parse(tokens);
                resultNode = this.getNodeFactory().node("resultSet", procedureNode, "teiidddl:resultDataType");
                resultNode.setProperty("ddl:datatypeName", (Object)dataType.getName());
                if (dataType.getLength() != -1L) {
                    resultNode.setProperty("ddl:datatypeLength", (Object)dataType.getLength());
                }
                if (dataType.getPrecision() != -1) {
                    resultNode.setProperty("ddl:datatypePrecision", (Object)dataType.getPrecision());
                }
                if (dataType.getScale() != -1) {
                    resultNode.setProperty("ddl:datatypeScale", (Object)dataType.getScale());
                }
                if (dataType.getArrayDimensions() != 0) {
                    resultNode.setProperty("ddl:datatypeArrayDimensions", (Object)dataType.getArrayDimensions());
                }
            }
            assert (resultNode != null);
            if (optionsExist) {
                this.createOptionNodes(options, resultNode);
            }
            return true;
        }
        return false;
    }

    private String parseStatement(DdlTokenStream tokens, int numBegins, String statement, Position prevPosition, String prevValue) throws ParsingException {
        StringBuilder text = new StringBuilder(statement);
        while (tokens.hasNext()) {
            Position currPosition = tokens.nextPosition();
            String value = tokens.consume();
            if (TeiidDdlConstants.TeiidReservedWord.BEGIN.toDdl().equals(value)) {
                text.append(this.getWhitespace(currPosition, prevPosition, prevValue));
                text.append(TeiidDdlConstants.TeiidReservedWord.BEGIN.toDdl());
                return this.parseStatement(tokens, ++numBegins, text.toString(), currPosition, value);
            }
            if (TeiidDdlConstants.TeiidReservedWord.END.toDdl().equals(value)) {
                text.append(this.getWhitespace(currPosition, prevPosition, prevValue));
                text.append(TeiidDdlConstants.TeiidReservedWord.END.toDdl());
                return this.parseStatement(tokens, --numBegins, text.toString(), currPosition, value);
            }
            if (";".equals(value)) {
                if (numBegins > 0) {
                    text.append(this.getWhitespace(currPosition, prevPosition, prevValue));
                    text.append(";");
                    return this.parseStatement(tokens, numBegins, text.toString(), currPosition, value);
                }
                text.append(";");
                break;
            }
            text.append(this.getWhitespace(currPosition, prevPosition, prevValue));
            text.append(value);
            prevValue = value;
            prevPosition = currPosition;
        }
        return text.toString();
    }

    @Override
    protected void postProcess(AstNode rootNode) {
    }
}

