/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NamedLocks {
    private final Lock masterLock = new ReentrantLock();
    private final Map<String, NamedLock> locks = new HashMap<String, NamedLock>();

    public Lock writeLock(String name) {
        return this.lock(name, true);
    }

    public Lock readLock(String name) {
        return this.lock(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Lock lock(String name, boolean writeLock) {
        NamedLock lock = null;
        try {
            this.masterLock.lock();
            lock = this.locks.get(name);
            if (lock == null) {
                lock = new NamedLock(name);
                this.locks.put(name, lock);
                Lock lock2 = lock.lock(writeLock);
                return lock2;
            }
            lock.incrementReferenceCount();
        }
        finally {
            this.masterLock.unlock();
        }
        return lock.lock(writeLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock(NamedLock namedLock, Lock rawLock) {
        try {
            this.masterLock.lock();
            try {
                if (namedLock.decrementReferenceCount() == 0) {
                    this.locks.remove(namedLock.name);
                }
            }
            finally {
                rawLock.unlock();
            }
        }
        finally {
            this.masterLock.unlock();
        }
    }

    public int size() {
        try {
            this.masterLock.lock();
            int n = this.locks.size();
            return n;
        }
        finally {
            this.masterLock.unlock();
        }
    }

    protected final class NamedLock {
        protected final String name;
        protected final Lock readLock;
        protected final Lock writeLock;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final AtomicInteger referenceCount = new AtomicInteger(1);

        protected NamedLock(String name) {
            this.name = name;
            this.readLock = new WrappedLock(this, this.lock.readLock());
            this.writeLock = new WrappedLock(this, this.lock.writeLock());
        }

        protected void incrementReferenceCount() {
            this.referenceCount.incrementAndGet();
        }

        protected int decrementReferenceCount() {
            return this.referenceCount.decrementAndGet();
        }

        protected Lock lock(boolean write) {
            if (write) {
                this.lock.writeLock().lock();
                return this.writeLock;
            }
            this.lock.readLock().lock();
            return this.readLock;
        }

        protected void unlock(Lock lock) {
            NamedLocks.this.unlock(this, lock);
        }

        public String toString() {
            return "NamedLock \"" + this.name + "\" (" + this.referenceCount.get() + " referrers)";
        }
    }

    protected static class WrappedLock
    implements Lock {
        protected final NamedLock namedLock;
        protected final Lock actualLock;

        protected WrappedLock(NamedLock namedLock, Lock lock) {
            this.namedLock = namedLock;
            this.actualLock = lock;
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public Condition newCondition() {
            return this.actualLock.newCondition();
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            return true;
        }

        @Override
        public void unlock() {
            this.namedLock.unlock(this.actualLock);
        }
    }
}

