/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.LinkedList;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.Between;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.NodeDepth;
import org.modeshape.jcr.query.model.NodeLocalName;
import org.modeshape.jcr.query.model.NodeName;
import org.modeshape.jcr.query.model.NodePath;
import org.modeshape.jcr.query.model.Not;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;

@Immutable
public class RewritePathAndNameCriteria
implements OptimizerRule {
    public static final RewritePathAndNameCriteria INSTANCE = new RewritePathAndNameCriteria();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode node : plan.findAllAtOrBelow(PlanNode.Type.SELECT)) {
            Constraint newConstraint;
            Constraint constraint = node.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
            if (constraint == (newConstraint = this.rewriteCriteria(context, constraint))) continue;
            node.getSelectors().clear();
            node.addSelectors(Visitors.getSelectorsReferencedBy(newConstraint));
            node.setProperty(PlanNode.Property.SELECT_CRITERIA, newConstraint);
        }
        return plan;
    }

    protected Constraint rewriteCriteria(QueryContext context, Constraint constraint) {
        if (constraint instanceof And) {
            And and = (And)constraint;
            Constraint oldLeft = and.left();
            Constraint oldRight = and.right();
            Constraint newLeft = this.rewriteCriteria(context, oldLeft);
            Constraint newRight = this.rewriteCriteria(context, oldRight);
            if (newRight != oldRight) {
                if (newLeft != oldLeft) {
                    return new And(newLeft, newRight);
                }
                return new And(newRight, newLeft);
            }
            return and;
        }
        if (constraint instanceof Or) {
            Or or = (Or)constraint;
            Constraint oldLeft = or.left();
            Constraint oldRight = or.right();
            Constraint newLeft = this.rewriteCriteria(context, oldLeft);
            Constraint newRight = this.rewriteCriteria(context, oldRight);
            if (newRight != oldRight) {
                if (newLeft != oldLeft) {
                    return new Or(newLeft, newRight);
                }
                return new Or(newRight, newLeft);
            }
            return or;
        }
        if (constraint instanceof Not) {
            Not not = (Not)constraint;
            Constraint oldWrapped = not.getConstraint();
            Constraint newWrapped = this.rewriteCriteria(context, oldWrapped);
            if (newWrapped != oldWrapped) {
                return new Not(newWrapped);
            }
            return not;
        }
        if (constraint instanceof ChildNode) {
            ChildNode childNode = (ChildNode)constraint;
            return new ChildNode(childNode.selectorName(), childNode.getParentPath());
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode descNode = (DescendantNode)constraint;
            return new DescendantNode(descNode.selectorName(), descNode.getAncestorPath());
        }
        if (constraint instanceof PropertyExistence) {
            return constraint;
        }
        if (constraint instanceof FullTextSearch) {
            return constraint;
        }
        if (constraint instanceof Between) {
            Between between = (Between)constraint;
            DynamicOperand operand = between.getOperand();
            if (this.isPathOriented(operand)) {
                return new Between(operand, between.getLowerBound(), between.getUpperBound(), between.isLowerBoundIncluded(), between.isUpperBoundIncluded());
            }
            return between;
        }
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            DynamicOperand operand = comparison.getOperand1();
            if (this.isPathOriented(operand)) {
                return new Comparison(operand, comparison.operator(), comparison.getOperand2());
            }
            return comparison;
        }
        if (constraint instanceof SetCriteria) {
            SetCriteria criteria = (SetCriteria)constraint;
            DynamicOperand operand = criteria.getOperand();
            if (this.isPathOriented(operand)) {
                return new SetCriteria(operand, criteria.rightOperands());
            }
            return criteria;
        }
        return constraint;
    }

    protected boolean isPathOriented(DynamicOperand op) {
        return op instanceof NodeDepth || op instanceof NodeLocalName || op instanceof NodeName || op instanceof NodePath;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

