/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.modeshape.jcr.query.lucene.LuceneQueryEngine;

public class ExistsTupleCollector
extends LuceneQueryEngine.TupleCollector {
    private final LuceneQueryEngine.TupleCollector collector;
    private boolean found = false;

    public ExistsTupleCollector(LuceneQueryEngine.TupleCollector collector) {
        this.collector = collector;
    }

    @Override
    public float doCollect(int doc) throws IOException {
        if (this.found) {
            throw new CompletedException();
        }
        float score = this.collector.doCollect(doc);
        if (score >= 0.0f) {
            this.found = true;
        }
        return score;
    }

    @Override
    public List<Object[]> getTuples() {
        return this.collector.getTuples();
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.collector.setNextReader(reader, docBase);
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.collector.acceptsDocsOutOfOrder();
    }

    public static class CompletedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private CompletedException() {
            super("Exists collector completed with 1 found tuple");
        }
    }
}

