/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.ToStringUtils;

public class RelikeQuery
extends MultiTermQuery {
    private static final long serialVersionUID = 1L;
    private final String relikeValue;
    private final Term term;

    public RelikeQuery(String fieldName, String relikeValue) {
        assert (relikeValue != null);
        this.term = new Term(fieldName);
        this.relikeValue = relikeValue;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new RelikeTermEnum(reader, this.getTerm(), this.relikeValue);
    }

    public Term getTerm() {
        return this.term;
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelikeQuery that = (RelikeQuery)((Object)o);
        return this.relikeValue.equals(that.relikeValue);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.relikeValue.hashCode();
        return result;
    }

    public static boolean like(String value, String pattern) {
        CompareType cmpType = RelikeQuery.getCompareType(pattern);
        switch (cmpType) {
            case EQ: {
                return value.equals(pattern);
            }
            case ENDS_WITH: {
                return value.endsWith(pattern.substring(1));
            }
            case STARTS_WITH: {
                return value.startsWith(pattern.substring(0, pattern.length() - 1));
            }
        }
        Pattern p = Pattern.compile(RelikeQuery.toRegularExpression(pattern));
        return p.matcher(value).matches();
    }

    private static CompareType getCompareType(String expression) {
        CompareType result = CompareType.EQ;
        StringCharacterIterator iter = new StringCharacterIterator(expression);
        boolean fistIndex = false;
        int lastIndex = expression.length() - 1;
        boolean skipNext = false;
        char c = iter.first();
        while (c != '\uffff') {
            if (skipNext) {
                skipNext = false;
            } else {
                if (c == '_') {
                    return CompareType.REGEXP;
                }
                if (c == '%') {
                    if (result != CompareType.EQ) {
                        return CompareType.REGEXP;
                    }
                    int index = iter.getIndex();
                    if (index == 0) {
                        result = CompareType.ENDS_WITH;
                    } else if (index == lastIndex) {
                        result = CompareType.STARTS_WITH;
                    } else {
                        return CompareType.REGEXP;
                    }
                }
                if (c == '\\') {
                    skipNext = true;
                }
            }
            c = iter.next();
        }
        return result;
    }

    private static String toRegularExpression(String likeExpression) {
        String result = likeExpression.replaceAll("\\\\(.)", "$1");
        result = result.replaceAll("([$.|+()\\*\\?\\[\\\\^\\\\\\\\])", "\\\\$1");
        result = result.replace("%", ".*").replace("_", ".");
        return result;
    }

    private static enum CompareType {
        EQ,
        STARTS_WITH,
        ENDS_WITH,
        REGEXP;

    }

    private class RelikeTermEnum
    extends FilteredTermEnum {
        private String field;
        private boolean endEnum = false;
        private final String relikeValue;

        public RelikeTermEnum(IndexReader reader, Term term, String relikeValue) throws IOException {
            this.field = term.field();
            this.relikeValue = relikeValue;
            this.setEnum(reader.terms(term));
        }

        protected final boolean termCompare(Term term) {
            if (this.field == term.field()) {
                return RelikeQuery.like(this.relikeValue, term.text());
            }
            this.endEnum = true;
            return false;
        }

        public final float difference() {
            return 1.0f;
        }

        public final boolean endEnum() {
            return this.endEnum;
        }

        public void close() throws IOException {
            super.close();
            this.field = null;
        }
    }
}

