/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.math.BigDecimal;
import java.math.BigInteger;

public class FieldUtil {
    public static String decimalToString(BigDecimal value) {
        StringBuilder sb = new StringBuilder();
        boolean negate = false;
        switch (value.signum()) {
            case -1: {
                sb.append('-');
                negate = true;
                break;
            }
            case 1: {
                sb.append('1');
                break;
            }
            default: {
                return "0";
            }
        }
        long exponent = value.precision() - value.scale() - 1;
        if (exponent == 0L) {
            sb.append('0');
        } else {
            char sign;
            if (negate) {
                exponent = -exponent;
            }
            String exponentField = String.valueOf(Math.abs(exponent));
            int length = exponentField.length();
            char c = sign = exponent > 0L ? (char)'1' : '-';
            if (exponent < 0L) {
                exponentField = FieldUtil.negate(exponentField);
            }
            String lengthField = String.valueOf(length);
            if (negate || exponent < 0L) {
                lengthField = FieldUtil.negate(lengthField);
            }
            sb.append(sign).append(lengthField).append(' ').append(exponentField);
        }
        if (negate) {
            value = value.negate();
        }
        StringBuilder significand = new StringBuilder(value.unscaledValue().toString());
        FieldUtil.removeTralingZeros(significand);
        sb.append((CharSequence)(negate ? FieldUtil.negate(significand).append('A') : significand));
        return sb.toString();
    }

    public static BigDecimal stringToDecimal(String value) {
        assert (value != null);
        assert (value.length() != 0);
        if ("0".equals(value)) {
            return BigDecimal.ZERO;
        }
        boolean negate = false;
        if (value.charAt(0) == '-') {
            assert (value.charAt(value.length() - 1) == 'A');
            value = value.substring(0, value.length() - 1);
            negate = true;
        }
        long exponent = 0L;
        boolean negateExponent = false;
        int endIndex = 0;
        switch (value.charAt(1)) {
            case '0': {
                value = value.substring(2);
                break;
            }
            case '-': {
                negateExponent = true;
            }
            default: {
                int indexOfSpace = value.indexOf(32, 2);
                String expLengthField = value.substring(2, indexOfSpace);
                if (negate || negateExponent) {
                    expLengthField = FieldUtil.negate(expLengthField);
                }
                int lengthOfExponent = Integer.parseInt(expLengthField);
                int startIndex = indexOfSpace + 1;
                endIndex = startIndex + lengthOfExponent;
                String exponentField = value.substring(startIndex, endIndex);
                exponent = Long.parseLong(negateExponent ? FieldUtil.negate(exponentField) : exponentField);
                if (negate) {
                    boolean bl = negateExponent = !negateExponent;
                }
                if (negateExponent) {
                    exponent = -exponent;
                }
                value = value.substring(endIndex);
            }
        }
        if (negate) {
            value = FieldUtil.negate(value);
        }
        BigInteger significand = new BigInteger(value);
        int scale = (int)((long)value.length() - exponent - 1L);
        return new BigDecimal(negate ? significand.negate() : significand, scale);
    }

    protected static String negate(String value) {
        return FieldUtil.negate(new StringBuilder(value)).toString();
    }

    protected static StringBuilder negate(StringBuilder value) {
        int len = value.length();
        for (int i = 0; i != len; ++i) {
            char c = value.charAt(i);
            if (c == ' ' || c == '-') continue;
            value.setCharAt(i, (char)(57 - c + 48));
        }
        return value;
    }

    protected static void removeTralingZeros(StringBuilder sb) {
        int endIndex = sb.length();
        if (endIndex > 0) {
            int index = --endIndex;
            while (sb.charAt(index) == '0') {
                --index;
            }
            if (index < endIndex) {
                sb.delete(index + 1, endIndex + 1);
            }
        }
    }

    private FieldUtil() {
    }
}

