/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.schematic.internal.HashCode;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.NamespaceRegistry;

@ThreadSafe
public class QueryContext {
    private final ExecutionContext context;
    private final RepositoryCache repositoryCache;
    private final TypeSystem typeSystem;
    private final PlanHints hints;
    private final Schemata schemata;
    private final Problems problems;
    private final Map<String, Object> variables;
    private final Set<String> workspaceNames;
    private final Map<String, NodeCache> overriddenNodeCachesByWorkspaceName;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    public QueryContext(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, Schemata schemata, PlanHints hints, Problems problems, Map<String, Object> variables) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull(workspaceNames, (String)"workspaceNames");
        CheckArg.isNotNull((Object)schemata, (String)"schemata");
        this.context = context;
        this.repositoryCache = repositoryCache;
        this.workspaceNames = workspaceNames;
        this.typeSystem = context.getValueFactories().getTypeSystem();
        this.hints = hints != null ? hints : new PlanHints();
        this.schemata = schemata;
        this.problems = problems != null ? problems : new SimpleProblems();
        this.variables = variables != null ? new HashMap<String, Object>(variables) : new HashMap();
        Map<String, NodeCache> map = this.overriddenNodeCachesByWorkspaceName = overriddenNodeCachesByWorkspaceName != null ? overriddenNodeCachesByWorkspaceName : Collections.emptyMap();
        assert (this.typeSystem != null);
        assert (this.hints != null);
        assert (this.schemata != null);
        assert (this.problems != null);
        assert (this.variables != null);
        assert (this.workspaceNames != null);
    }

    public QueryContext(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Schemata schemata, PlanHints hints, Problems problems) {
        this(context, repositoryCache, workspaceNames, null, schemata, hints, problems, null);
    }

    public QueryContext(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Schemata schemata) {
        this(context, repositoryCache, workspaceNames, null, schemata, null, null, null);
    }

    protected QueryContext(QueryContext original) {
        this(original.context, original.repositoryCache, original.workspaceNames, original.overriddenNodeCachesByWorkspaceName, original.schemata, original.hints, original.problems, original.variables);
    }

    public final boolean cancel() {
        return this.cancelled.compareAndSet(false, true);
    }

    public final boolean isCancelled() {
        return this.cancelled.get();
    }

    public NodeCache getNodeCache(String workspaceName) throws WorkspaceNotFoundException {
        NodeCache cache = this.overriddenNodeCachesByWorkspaceName.get(workspaceName);
        if (cache == null) {
            cache = this.repositoryCache.getWorkspaceCache(workspaceName);
        }
        return cache;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.context.getNamespaceRegistry();
    }

    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public Set<String> getWorkspaceNames() {
        return this.workspaceNames;
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public final PlanHints getHints() {
        return this.hints;
    }

    public final Problems getProblems() {
        return this.problems;
    }

    public Schemata getSchemata() {
        return this.schemata;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.typeSystem, this.schemata, this.variables});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryContext) {
            QueryContext that = (QueryContext)obj;
            if (!this.typeSystem.equals(that.getTypeSystem())) {
                return false;
            }
            if (!this.schemata.equals(that.getSchemata())) {
                return false;
            }
            return this.variables.equals(that.getVariables());
        }
        return false;
    }

    public QueryContext with(Schemata schemata) {
        CheckArg.isNotNull((Object)schemata, (String)"schemata");
        return new QueryContext(this.context, this.repositoryCache, this.workspaceNames, this.overriddenNodeCachesByWorkspaceName, schemata, this.hints, this.problems, this.variables);
    }

    public QueryContext with(PlanHints hints) {
        CheckArg.isNotNull((Object)hints, (String)"hints");
        return new QueryContext(this.context, this.repositoryCache, this.workspaceNames, this.overriddenNodeCachesByWorkspaceName, this.schemata, hints, this.problems, this.variables);
    }

    public QueryContext with(Problems problems) {
        return new QueryContext(this.context, this.repositoryCache, this.workspaceNames, this.overriddenNodeCachesByWorkspaceName, this.schemata, this.hints, problems, this.variables);
    }

    public QueryContext with(Map<String, Object> variables) {
        return new QueryContext(this.context, this.repositoryCache, this.workspaceNames, this.overriddenNodeCachesByWorkspaceName, this.schemata, this.hints, this.problems, variables);
    }
}

