/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.jcr.query.CancellableQuery;
import org.modeshape.jcr.query.JcrAbstractQuery;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.JcrQueryResult;
import org.modeshape.jcr.query.JcrSqlQueryResult;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.XPathQueryResult;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.LiteralValue;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.model.Subquery;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Path;

@NotThreadSafe
public class JcrQuery
extends JcrAbstractQuery {
    private QueryCommand query;
    private final PlanHints hints;
    private final Map<String, Object> variables;
    private volatile Set<String> variableNames;
    private final AtomicReference<CancellableQuery> executingQuery = new AtomicReference();

    public JcrQuery(JcrQueryContext context, String statement, String language, QueryCommand query, PlanHints hints, Path storedAtPath) {
        super(context, statement, language, storedAtPath);
        assert (query != null);
        this.query = query;
        this.hints = hints;
        this.variables = new HashMap<String, Object>();
    }

    protected QueryCommand query() {
        return this.query;
    }

    public QueryCommand getAbstractQueryModel() {
        return this.query;
    }

    public String getAbstractQueryModelRepresentation() {
        return this.query.toString();
    }

    public QueryResult execute() throws RepositoryException {
        this.context.isLive();
        long start = System.nanoTime();
        Schemata schemata = this.context.getSchemata();
        CancellableQuery newExecutable = this.context.createExecutableQuery(this.query, this.hints, this.variables);
        CancellableQuery executable = this.executingQuery.getAndSet(newExecutable);
        if (executable == null) {
            executable = newExecutable;
        }
        QueryResults result = executable.getResults();
        this.executingQuery.compareAndSet(executable, null);
        this.checkForProblems(result.getProblems());
        this.context.recordDuration(Math.abs(System.nanoTime() - start), TimeUnit.NANOSECONDS, this.statement, this.language);
        if ("xpath".equals(this.language)) {
            return new XPathQueryResult(this.context, this.statement, result, schemata);
        }
        if ("sql".equals(this.language)) {
            return new JcrSqlQueryResult(this.context, this.statement, result, schemata);
        }
        return new JcrQueryResult(this.context, this.statement, result, schemata);
    }

    public QueryResult explain() throws RepositoryException {
        this.context.isLive();
        PlanHints hints = this.hints.clone();
        hints.planOnly = true;
        CancellableQuery planOnlyExecutable = this.context.createExecutableQuery(this.query, hints, this.variables);
        QueryResults result = planOnlyExecutable.getResults();
        this.checkForProblems(result.getProblems());
        Schemata schemata = this.context.getSchemata();
        if ("xpath".equals(this.language)) {
            return new XPathQueryResult(this.context, this.statement, result, schemata);
        }
        if ("sql".equals(this.language)) {
            return new JcrSqlQueryResult(this.context, this.statement, result, schemata);
        }
        return new JcrQueryResult(this.context, this.statement, result, schemata);
    }

    public boolean cancel() {
        CancellableQuery executing = this.executingQuery.get();
        if (executing != null) {
            boolean cancelled = executing.cancel();
            this.executingQuery.compareAndSet(executing, null);
            return cancelled;
        }
        return false;
    }

    public String toString() {
        return this.language + " -> " + this.statement + "\n" + StringUtil.createString((char)' ', (int)Math.min(this.language.length() - 3, 0)) + "AQM -> " + this.query;
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        CheckArg.isNotNull((Object)varName, (String)"varName");
        CheckArg.isNotNull((Object)value, (String)"value");
        if (!this.variableNames().contains(varName) && !Subquery.isSubqueryVariableName(varName)) {
            throw new IllegalArgumentException(JcrI18n.noSuchVariableInQuery.text(new Object[]{varName, this.statement}));
        }
        this.variables.put(varName, LiteralValue.rawValue(value));
    }

    public String[] getBindVariableNames() {
        Set<String> names = this.variableNames();
        return names.toArray(new String[names.size()]);
    }

    protected final Set<String> variableNames() {
        if (this.variableNames == null) {
            final HashSet<String> names = new HashSet<String>();
            Visitors.visitAll(this.query, new Visitors.AbstractVisitor(){

                @Override
                public void visit(BindVariableName obj) {
                    names.add(obj.getBindVariableName());
                }
            });
            this.variableNames = names;
        }
        return this.variableNames;
    }

    public void setLimit(long limit) {
        if (limit > Integer.MAX_VALUE) {
            limit = Integer.MAX_VALUE;
        }
        this.query = this.query.withLimit((int)limit);
    }

    public void setOffset(long offset) {
        if (offset > Integer.MAX_VALUE) {
            offset = Integer.MAX_VALUE;
        }
        this.query = this.query.withOffset((int)offset);
    }
}

