/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.node;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.modeshape.sequencer.ddl.node.AstNodeFactory;

public class AstNodeFactoryTest {
    private AstNodeFactory nodeFactory;
    private AstNode rootNode;

    @Before
    public void beforeEach() {
        this.nodeFactory = new AstNodeFactory();
        this.rootNode = this.nodeFactory.node("testRootNode");
        this.rootNode.setProperty("jcr:mixinTypes", (Object)"ddl:statements");
        this.rootNode.setProperty("jcr:primaryType", (Object)"nt:unstructured");
    }

    @Test
    public void shouldCreateChildNode() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, "ddl:createTableStatement");
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertEquals((Object)this.rootNode.getProperty("jcr:mixinTypes"), (Object)"ddl:statements");
        Assert.assertEquals((Object)this.rootNode.getChild(0).getProperty("jcr:mixinTypes"), (Object)"ddl:createTableStatement");
        Assert.assertThat((Object)this.rootNode.getChild(0).getName(), (Matcher)Is.is((Object)name));
    }

    @Test
    public void shouldHaveMixinTypeForNode() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, "ddl:createTableStatement");
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(this.rootNode, "ddl:statements"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(this.rootNode.getChild(0), "ddl:createTableStatement"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldFindChildForNameAndType() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, "ddl:createTableStatement");
        AstNode node = this.nodeFactory.getChildforNameAndType(this.rootNode, name, "ddl:createTableStatement");
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(this.rootNode, "ddl:statements"), (Matcher)Is.is((Object)true));
        Assert.assertNotNull((Object)node);
    }

    @Test
    public void shouldNotFindChildForRightNameWrongType() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, "ddl:createTableStatement");
        AstNode node = this.nodeFactory.getChildforNameAndType(this.rootNode, name, "ddl:createViewStatement");
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(this.rootNode, "ddl:statements"), (Matcher)Is.is((Object)true));
        Assert.assertNull((Object)node);
    }

    @Test
    public void shouldNotFindChildForWrongNameRightType() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, "ddl:createTableStatement");
        AstNode node = this.nodeFactory.getChildforNameAndType(this.rootNode, "wrongName", "ddl:createTableStatement");
        Assert.assertNull((Object)node);
    }

    @Test
    public void shouldSetTypeOnNode() {
        String name = "myNodeName";
        AstNode node = this.nodeFactory.node(name);
        Assert.assertNotNull((Object)node);
        this.nodeFactory.setType(node, "ddl:createTableStatement");
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(node, "ddl:createTableStatement"), (Matcher)Is.is((Object)true));
    }
}

