/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.loopback;

import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.api.TypeFacility;
import com.metamatrix.data.api.UpdateExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IBulkInsert;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class LoopbackExecution
implements SynchQueryExecution,
UpdateExecution,
ProcedureExecution {
    private static final String ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private ConnectorEnvironment env;
    private ICommand command;
    private int maxBatchSize;
    private int rowsNeeded = 1;
    private int waitTime = 0;
    private boolean error = false;
    private Random randomNumber = new Random(System.currentTimeMillis());
    private List row;
    private boolean waited = false;
    private int rowsReturned = 0;
    private static final Integer INTEGER_VAL = new Integer(0);
    private static final Long LONG_VAL = new Long(0L);
    private static final Float FLOAT_VAL = new Float(0.0);
    private static final Short SHORT_VAL = new Short(0);
    private static final Double DOUBLE_VAL = new Double(0.0);
    private static final Character CHAR_VAL = new Character('c');
    private static final Byte BYTE_VAL = new Byte(0);
    private static final Boolean BOOLEAN_VAL = Boolean.FALSE;
    private static final BigInteger BIG_INTEGER_VAL = new BigInteger("0");
    private static final BigDecimal BIG_DECIMAL_VAL = new BigDecimal(0.0);
    private static final Date SQL_DATE_VAL = new Date(0L);
    private static final Time TIME_VAL = new Time(0L);
    private static final Timestamp TIMESTAMP_VAL = new Timestamp(0L);
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public LoopbackExecution(ConnectorEnvironment env, RuntimeMetadata metadata) {
        this.env = env;
    }

    public Batch nextBatch() throws ConnectorException {
        if (this.waitTime > 0 && !this.waited) {
            try {
                Thread.sleep(this.randomNumber.nextInt(this.waitTime));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.waited = true;
        }
        BasicBatch batch = new BasicBatch();
        while (this.rowsReturned < this.rowsNeeded && batch.getRowCount() < this.maxBatchSize) {
            batch.addRow(this.row);
            ++this.rowsReturned;
        }
        if (this.rowsReturned >= this.rowsNeeded) {
            batch.setLast();
        }
        return batch;
    }

    public void execute(IQuery query, int maxBatchSize) throws ConnectorException {
        this.command = query;
        this.maxBatchSize = maxBatchSize;
        this.env.getLogger().logTrace("Loopback executing command: " + query);
        String errorString = this.env.getProperties().getProperty("Error", "false");
        this.error = errorString.equalsIgnoreCase("true");
        if (this.error) {
            throw new ConnectorException("Failing because Error=true");
        }
        String waitTimeString = this.env.getProperties().getProperty("WaitTime", "0");
        try {
            this.waitTime = Integer.parseInt(waitTimeString);
        }
        catch (Exception e) {
            throw new ConnectorException("Invalid WaitTime=" + waitTimeString);
        }
        String rowCountString = this.env.getProperties().getProperty("RowCount", "1");
        try {
            this.rowsNeeded = Integer.parseInt(rowCountString);
        }
        catch (Exception e) {
            throw new ConnectorException("Invalid RowCount=" + rowCountString);
        }
        List types = this.determineOutputTypes(this.command);
        this.row = this.createDummyRow(types);
    }

    public int execute(ICommand command) throws ConnectorException {
        this.env.getLogger().logTrace("Loopback executing command: " + command);
        return 0;
    }

    public int execute(IBulkInsert command) throws ConnectorException {
        this.env.getLogger().logTrace("Loopback executing command: " + command);
        return 0;
    }

    public void execute(IProcedure procedure, int maxBatchSize) throws ConnectorException {
        this.command = procedure;
        this.maxBatchSize = maxBatchSize;
        this.env.getLogger().logTrace("Loopback executing command: " + procedure);
        List types = this.determineOutputTypes(this.command);
        this.row = this.createDummyRow(types);
    }

    public Object getOutputValue(IParameter parameter) throws ConnectorException {
        return null;
    }

    public void close() throws ConnectorException {
    }

    public void cancel() throws ConnectorException {
    }

    private List determineOutputTypes(ICommand command) throws ConnectorException {
        ArrayList<Class> types = new ArrayList<Class>();
        if (command instanceof IQuery) {
            IQuery query = (IQuery)command;
            List selectSymbols = query.getSelect().getSelectSymbols();
            Iterator iter = selectSymbols.iterator();
            while (iter.hasNext()) {
                ISelectSymbol symbol = (ISelectSymbol)iter.next();
                types.add(symbol.getExpression().getType());
            }
        } else {
            types.add(class$java$lang$Integer == null ? (class$java$lang$Integer = LoopbackExecution.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
        return types;
    }

    private List createDummyRow(List types) throws ConnectorException {
        ArrayList<Object> row = new ArrayList<Object>(types.size());
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            Class type = (Class)iter.next();
            row.add(this.getValue(type));
        }
        return row;
    }

    private String getVariableString(int size) {
        int multiplier = size / ALPHA.length();
        int remainder = size % ALPHA.length();
        String value = "";
        for (int k = 0; k < multiplier; ++k) {
            value = value + ALPHA;
        }
        value = value + ALPHA.substring(0, remainder);
        return value;
    }

    private Object getValue(Class type) {
        if (type.equals(class$java$lang$String == null ? (class$java$lang$String = LoopbackExecution.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getVariableString(10);
        }
        if (type.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = LoopbackExecution.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return INTEGER_VAL;
        }
        if (type.equals(class$java$lang$Short == null ? (class$java$lang$Short = LoopbackExecution.class$("java.lang.Short")) : class$java$lang$Short)) {
            return SHORT_VAL;
        }
        if (type.equals(class$java$lang$Long == null ? (class$java$lang$Long = LoopbackExecution.class$("java.lang.Long")) : class$java$lang$Long)) {
            return LONG_VAL;
        }
        if (type.equals(class$java$lang$Float == null ? (class$java$lang$Float = LoopbackExecution.class$("java.lang.Float")) : class$java$lang$Float)) {
            return FLOAT_VAL;
        }
        if (type.equals(class$java$lang$Double == null ? (class$java$lang$Double = LoopbackExecution.class$("java.lang.Double")) : class$java$lang$Double)) {
            return DOUBLE_VAL;
        }
        if (type.equals(class$java$lang$Character == null ? (class$java$lang$Character = LoopbackExecution.class$("java.lang.Character")) : class$java$lang$Character)) {
            return CHAR_VAL;
        }
        if (type.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = LoopbackExecution.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return BYTE_VAL;
        }
        if (type.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = LoopbackExecution.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return BOOLEAN_VAL;
        }
        if (type.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = LoopbackExecution.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return BIG_INTEGER_VAL;
        }
        if (type.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = LoopbackExecution.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return BIG_DECIMAL_VAL;
        }
        if (type.equals(class$java$sql$Date == null ? (class$java$sql$Date = LoopbackExecution.class$("java.sql.Date")) : class$java$sql$Date)) {
            return SQL_DATE_VAL;
        }
        if (type.equals(class$java$sql$Time == null ? (class$java$sql$Time = LoopbackExecution.class$("java.sql.Time")) : class$java$sql$Time)) {
            return TIME_VAL;
        }
        if (type.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = LoopbackExecution.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return TIMESTAMP_VAL;
        }
        if (type.equals(TypeFacility.RUNTIME_TYPES.CLOB)) {
            return null;
        }
        if (type.equals(TypeFacility.RUNTIME_TYPES.BLOB)) {
            return null;
        }
        return this.getVariableString(10);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

