/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.jboss.dna.common.collection.Problem;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.util.IoUtil;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.repository.RepositoryI18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrTools {
    public Map<String, Object> loadProperties(Node propertyContainer, Problems problems) {
        return this.loadProperties(propertyContainer, null, problems);
    }

    public Map<String, Object> loadProperties(Node propertyContainer, Map<String, Object> properties, Problems problems) {
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        if (propertyContainer != null) {
            try {
                NodeIterator iter = propertyContainer.getNodes();
                while (iter.hasNext()) {
                    Node propertyNode = iter.nextNode();
                    if (propertyNode == null || !propertyNode.getPrimaryNodeType().isNodeType("dna:property")) continue;
                    String propertyName = propertyNode.getName();
                    Object propertyValue = this.getPropertyValue(propertyNode, "dna:propertyValue", true, problems);
                    properties.put(propertyName, propertyValue);
                }
            }
            catch (RepositoryException e) {
                problems.addError((Throwable)e, RepositoryI18n.errorReadingPropertiesFromContainerNode, new Object[]{this.getReadable(propertyContainer)});
            }
        }
        return properties;
    }

    public boolean removeProblems(Node parent) throws RepositoryException {
        Node problemsNode = null;
        if (parent.hasNode("dna:problems")) {
            problemsNode = parent.getNode("dna:problems");
            problemsNode.remove();
            return true;
        }
        return false;
    }

    public boolean storeProblems(Node parent, Problems problems) throws RepositoryException {
        Node problemsNode = null;
        if (parent.hasNode("dna:problems")) {
            problemsNode = parent.getNode("dna:problems");
            this.removeAllChildren(problemsNode);
        }
        if (problems.isEmpty()) {
            return false;
        }
        if (problemsNode == null) {
            problemsNode = parent.addNode("dna:problems");
        }
        for (Problem problem : problems) {
            Throwable t;
            String location;
            String resource;
            Node problemNode = problemsNode.addNode("problem", "dna:problem");
            problemNode.setProperty("dna:status", problem.getStatus().name());
            problemNode.setProperty("dna:message", problem.getMessageString());
            if (problem.getCode() != 0) {
                problemNode.setProperty("dna:code", Integer.toString(problem.getCode()));
            }
            if ((resource = problem.getResource()) != null) {
                problemNode.setProperty("dna:resource", resource);
            }
            if ((location = problem.getLocation()) != null) {
                problemNode.setProperty("dna:location", location);
            }
            if ((t = problem.getThrowable()) == null) continue;
            String trace = StringUtil.getStackTrace((Throwable)t);
            problemNode.setProperty("dna:trace", trace);
        }
        return true;
    }

    public int removeAllChildren(Node node) throws RepositoryException {
        int childrenRemoved = 0;
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            child.remove();
            ++childrenRemoved;
        }
        return childrenRemoved;
    }

    public String getPropertyAsString(Node node, String propertyName, boolean required, Problems problems) {
        return this.getPropertyAsString(node, propertyName, required, null);
    }

    public String getPropertyAsString(Node node, String propertyName, boolean required, String defaultValue, Problems problems) {
        try {
            Property property = node.getProperty(propertyName);
            return property.getString();
        }
        catch (ValueFormatException e) {
            if (required) {
                problems.addError((Throwable)e, RepositoryI18n.requiredPropertyOnNodeWasExpectedToBeStringValue, propertyName, this.getReadable(node), new Object[0]);
            } else {
                problems.addError((Throwable)e, RepositoryI18n.optionalPropertyOnNodeWasExpectedToBeStringValue, propertyName, this.getReadable(node), new Object[0]);
            }
        }
        catch (PathNotFoundException e) {
            if (required) {
                problems.addError((Throwable)e, RepositoryI18n.requiredPropertyIsMissingFromNode, propertyName, this.getReadable(node), new Object[0]);
            }
            if (!required) {
                return defaultValue;
            }
        }
        catch (RepositoryException err) {
            if (required) {
                problems.addError((Throwable)err, RepositoryI18n.errorGettingRequiredPropertyFromNode, propertyName, this.getReadable(node), new Object[0]);
            }
            problems.addError((Throwable)err, RepositoryI18n.errorGettingOptionalPropertyFromNode, propertyName, this.getReadable(node), new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getPropertyValue(Node node, String propertyName, boolean required, Problems problems) {
        try {
            Property property = node.getProperty(propertyName);
            switch (property.getType()) {
                case 2: {
                    byte[] byArray;
                    InputStream stream = property.getStream();
                    try {
                        stream = property.getStream();
                        byArray = IoUtil.readBytes((InputStream)stream);
                        if (stream == null) return byArray;
                    }
                    catch (Throwable throwable) {
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass()).error((Throwable)e, RepositoryI18n.errorClosingBinaryStreamForPropertyFromNode, new Object[]{propertyName, node.getPath()});
                        }
                        throw throwable;
                    }
                    try {
                        stream.close();
                        return byArray;
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass()).error((Throwable)e, RepositoryI18n.errorClosingBinaryStreamForPropertyFromNode, new Object[]{propertyName, node.getPath()});
                    }
                    return byArray;
                }
            }
            return property.getString();
        }
        catch (IOException e) {
            if (required) {
                problems.addError((Throwable)e, RepositoryI18n.requiredPropertyOnNodeCouldNotBeRead, propertyName, this.getReadable(node), new Object[0]);
                return null;
            }
            problems.addError((Throwable)e, RepositoryI18n.optionalPropertyOnNodeCouldNotBeRead, propertyName, this.getReadable(node), new Object[0]);
            return null;
        }
        catch (PathNotFoundException e) {
            if (!required) return null;
            problems.addError((Throwable)e, RepositoryI18n.requiredPropertyIsMissingFromNode, propertyName, this.getReadable(node), new Object[0]);
            return null;
        }
        catch (RepositoryException err) {
            if (required) {
                problems.addError((Throwable)err, RepositoryI18n.errorGettingRequiredPropertyFromNode, propertyName, this.getReadable(node), new Object[0]);
                return null;
            }
            problems.addError((Throwable)err, RepositoryI18n.errorGettingOptionalPropertyFromNode, propertyName, this.getReadable(node), new Object[0]);
        }
        return null;
    }

    public String[] getPropertyAsStringArray(Node node, String propertyName, boolean required, Problems problems, String ... defaultValues) {
        String[] result = defaultValues;
        try {
            Property property = node.getProperty(propertyName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                result = new String[values.length];
                int i = 0;
                for (Value value : values) {
                    result[i++] = value.getString();
                }
            } else {
                result = new String[]{property.getString()};
            }
        }
        catch (ValueFormatException e) {
            if (required) {
                problems.addError((Throwable)e, RepositoryI18n.requiredPropertyOnNodeWasExpectedToBeStringArrayValue, propertyName, this.getReadable(node), new Object[0]);
            } else {
                problems.addError((Throwable)e, RepositoryI18n.optionalPropertyOnNodeWasExpectedToBeStringArrayValue, propertyName, this.getReadable(node), new Object[0]);
            }
        }
        catch (PathNotFoundException e) {
            if (required) {
                problems.addError((Throwable)e, RepositoryI18n.requiredPropertyIsMissingFromNode, propertyName, this.getReadable(node), new Object[0]);
            }
        }
        catch (RepositoryException err) {
            if (required) {
                problems.addError((Throwable)err, RepositoryI18n.errorGettingRequiredPropertyFromNode, propertyName, this.getReadable(node), new Object[0]);
            }
            problems.addError((Throwable)err, RepositoryI18n.errorGettingOptionalPropertyFromNode, propertyName, this.getReadable(node), new Object[0]);
        }
        return result;
    }

    public Node getNode(Node node, String relativePath, boolean required, Problems problems) {
        Node result = null;
        try {
            result = node.getNode(relativePath);
        }
        catch (PathNotFoundException e) {
            if (required) {
                problems.addError((Throwable)e, RepositoryI18n.requiredNodeDoesNotExistRelativeToNode, relativePath, this.getReadable(node), new Object[0]);
            }
        }
        catch (RepositoryException err) {
            problems.addError((Throwable)err, RepositoryI18n.errorGettingNodeRelativeToNode, relativePath, this.getReadable(node), new Object[0]);
        }
        return result;
    }

    public String getReadable(Node node) {
        if (node == null) {
            return "";
        }
        try {
            return node.getPath();
        }
        catch (RepositoryException err) {
            return node.toString();
        }
    }

    public Node findOrCreateNode(Session session, String path) throws RepositoryException {
        return this.findOrCreateNode(session, path, null, null);
    }

    public Node findOrCreateNode(Session session, String path, String nodeType) throws RepositoryException {
        return this.findOrCreateNode(session, path, nodeType, nodeType);
    }

    public Node findOrCreateNode(Session session, String path, String defaultNodeType, String finalNodeType) throws RepositoryException {
        Node root = session.getRootNode();
        return this.findOrCreateNode(session, root, path, defaultNodeType, finalNodeType);
    }

    public Node findOrCreateNode(Session session, Node parentNode, String path, String defaultNodeType, String finalNodeType) throws RepositoryException {
        String relPath = path.replaceAll("^/+", "").replaceAll("/+$", "");
        try {
            return parentNode.getNode(relPath);
        }
        catch (PathNotFoundException e) {
            String[] pathSegments = relPath.split("/");
            Node node = parentNode;
            int len = pathSegments.length;
            for (int i = 0; i != len; ++i) {
                String pathSegment = pathSegments[i];
                if ((pathSegment = pathSegment.trim()).length() == 0) continue;
                if (node.hasNode(pathSegment)) {
                    node = node.getNode(pathSegment);
                    continue;
                }
                String pathSegmentWithNoIndex = pathSegment.replaceAll("(\\[\\d+\\])+$", "");
                String nodeType = defaultNodeType;
                if (i == len - 1 && finalNodeType != null) {
                    nodeType = finalNodeType;
                }
                node = nodeType != null ? node.addNode(pathSegmentWithNoIndex, nodeType) : node.addNode(pathSegmentWithNoIndex);
            }
            return node;
        }
    }

    public Node findOrCreateChild(Session session, Node parent, String name) throws RepositoryException {
        return this.findOrCreateChild(session, parent, name, null);
    }

    public Node findOrCreateChild(Session session, Node parent, String name, String nodeType) throws RepositoryException {
        return this.findOrCreateNode(session, parent, name, nodeType, nodeType);
    }
}

