/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.text;

import java.text.StringCharacterIterator;
import java.util.BitSet;
import org.jboss.dna.common.text.TextDecoder;
import org.jboss.dna.common.text.TextEncoder;

public class XmlNameEncoder
implements TextDecoder,
TextEncoder {
    private static final BitSet XML_NAME_ALLOWED_CHARACTERS = new BitSet(18);

    public String decode(String encodedText) {
        if (encodedText == null) {
            return null;
        }
        if (encodedText.length() < 7) {
            return encodedText;
        }
        StringBuilder sb = new StringBuilder();
        char[] digits = new char[4];
        StringCharacterIterator iter = new StringCharacterIterator(encodedText);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '_') {
                char next = iter.next();
                if (next == '\uffff') {
                    sb.append(c);
                    break;
                }
                if (next != 'x') {
                    sb.append(c).append(next);
                } else {
                    digits[0] = iter.next();
                    if (digits[0] == '\uffff') {
                        sb.append(c).append(next);
                        break;
                    }
                    digits[1] = iter.next();
                    if (digits[1] == '\uffff') {
                        sb.append(c).append(next).append(digits, 0, 1);
                        break;
                    }
                    digits[2] = iter.next();
                    if (digits[2] == '\uffff') {
                        sb.append(c).append(next).append(digits, 0, 2);
                        break;
                    }
                    digits[3] = iter.next();
                    if (digits[3] == '\uffff') {
                        sb.append(c).append(next).append(digits, 0, 3);
                        break;
                    }
                    char underscore = iter.next();
                    if (underscore != '_') {
                        sb.append(c).append(next).append(digits, 0, 4);
                        if (underscore == '\uffff') break;
                        sb.append(underscore);
                    } else {
                        try {
                            sb.appendCodePoint(Integer.parseInt(new String(digits), 16));
                        }
                        catch (NumberFormatException e) {
                            sb.append(c).append(next).append(digits).append(underscore);
                        }
                    }
                }
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        return sb.toString();
    }

    public String encode(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        String hex = null;
        StringCharacterIterator iter = new StringCharacterIterator(text);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '_') {
                char next = iter.next();
                if (next == '\uffff') {
                    sb.append(c);
                    break;
                }
                if (next != 'x') {
                    sb.append(c).append(next);
                } else {
                    sb.append("_x005f_");
                    sb.append(next);
                }
            } else if (XML_NAME_ALLOWED_CHARACTERS.get(c)) {
                sb.append(c);
            } else {
                hex = Integer.toHexString(c);
                if (c >= '\u0000' && c <= '\u000f') {
                    sb.append("_x000").append(hex);
                } else if (c >= '\u0010' && c <= '\u00ff') {
                    sb.append("_x00").append(hex);
                } else if (c >= '\u0100' && c <= '\u0fff') {
                    sb.append("_x0").append(hex);
                } else {
                    sb.append("_x").append(hex);
                }
                sb.append('_');
            }
            c = iter.next();
        }
        return sb.toString();
    }

    static {
        XML_NAME_ALLOWED_CHARACTERS.set(46);
        XML_NAME_ALLOWED_CHARACTERS.set(45);
        XML_NAME_ALLOWED_CHARACTERS.set(95);
        XML_NAME_ALLOWED_CHARACTERS.set(58);
        XML_NAME_ALLOWED_CHARACTERS.set(65, 91);
        XML_NAME_ALLOWED_CHARACTERS.set(97, 123);
        XML_NAME_ALLOWED_CHARACTERS.set(192, 215);
        XML_NAME_ALLOWED_CHARACTERS.set(216, 247);
        XML_NAME_ALLOWED_CHARACTERS.set(248, 256);
        XML_NAME_ALLOWED_CHARACTERS.set(256, 306);
        XML_NAME_ALLOWED_CHARACTERS.set(308, 319);
        XML_NAME_ALLOWED_CHARACTERS.set(321, 329);
        XML_NAME_ALLOWED_CHARACTERS.set(330, 383);
        XML_NAME_ALLOWED_CHARACTERS.set(384, 452);
        XML_NAME_ALLOWED_CHARACTERS.set(461, 497);
        XML_NAME_ALLOWED_CHARACTERS.set(500, 502);
        XML_NAME_ALLOWED_CHARACTERS.set(506, 536);
        XML_NAME_ALLOWED_CHARACTERS.set(592, 681);
        XML_NAME_ALLOWED_CHARACTERS.set(699, 706);
        XML_NAME_ALLOWED_CHARACTERS.set(902);
        XML_NAME_ALLOWED_CHARACTERS.set(904, 907);
        XML_NAME_ALLOWED_CHARACTERS.set(908);
        XML_NAME_ALLOWED_CHARACTERS.set(910, 930);
        XML_NAME_ALLOWED_CHARACTERS.set(931, 975);
        XML_NAME_ALLOWED_CHARACTERS.set(976, 983);
        XML_NAME_ALLOWED_CHARACTERS.set(986);
        XML_NAME_ALLOWED_CHARACTERS.set(988);
        XML_NAME_ALLOWED_CHARACTERS.set(990);
        XML_NAME_ALLOWED_CHARACTERS.set(992);
        XML_NAME_ALLOWED_CHARACTERS.set(994, 1012);
        XML_NAME_ALLOWED_CHARACTERS.set(1025, 1037);
        XML_NAME_ALLOWED_CHARACTERS.set(1038, 1104);
        XML_NAME_ALLOWED_CHARACTERS.set(1105, 1117);
        XML_NAME_ALLOWED_CHARACTERS.set(1118, 1154);
        XML_NAME_ALLOWED_CHARACTERS.set(1168, 1221);
        XML_NAME_ALLOWED_CHARACTERS.set(1223, 1225);
        XML_NAME_ALLOWED_CHARACTERS.set(1227, 1229);
        XML_NAME_ALLOWED_CHARACTERS.set(1232, 1260);
        XML_NAME_ALLOWED_CHARACTERS.set(1262, 1270);
        XML_NAME_ALLOWED_CHARACTERS.set(1272, 1274);
        XML_NAME_ALLOWED_CHARACTERS.set(1329, 1367);
        XML_NAME_ALLOWED_CHARACTERS.set(1369);
        XML_NAME_ALLOWED_CHARACTERS.set(1377, 1415);
        XML_NAME_ALLOWED_CHARACTERS.set(1488, 1515);
        XML_NAME_ALLOWED_CHARACTERS.set(1520, 1523);
        XML_NAME_ALLOWED_CHARACTERS.set(1569, 1595);
        XML_NAME_ALLOWED_CHARACTERS.set(1601, 1611);
        XML_NAME_ALLOWED_CHARACTERS.set(1649, 1720);
        XML_NAME_ALLOWED_CHARACTERS.set(1722, 1727);
        XML_NAME_ALLOWED_CHARACTERS.set(1728, 1743);
        XML_NAME_ALLOWED_CHARACTERS.set(1744, 1748);
        XML_NAME_ALLOWED_CHARACTERS.set(1749);
        XML_NAME_ALLOWED_CHARACTERS.set(1765, 1767);
        XML_NAME_ALLOWED_CHARACTERS.set(2309, 2362);
        XML_NAME_ALLOWED_CHARACTERS.set(2365);
        XML_NAME_ALLOWED_CHARACTERS.set(2392, 2402);
        XML_NAME_ALLOWED_CHARACTERS.set(2437, 2445);
        XML_NAME_ALLOWED_CHARACTERS.set(2447, 2449);
        XML_NAME_ALLOWED_CHARACTERS.set(2451, 2473);
        XML_NAME_ALLOWED_CHARACTERS.set(2474, 2481);
        XML_NAME_ALLOWED_CHARACTERS.set(2482);
        XML_NAME_ALLOWED_CHARACTERS.set(2486, 2490);
        XML_NAME_ALLOWED_CHARACTERS.set(2524, 2526);
        XML_NAME_ALLOWED_CHARACTERS.set(2527, 2530);
        XML_NAME_ALLOWED_CHARACTERS.set(2544, 2546);
        XML_NAME_ALLOWED_CHARACTERS.set(2565, 2571);
        XML_NAME_ALLOWED_CHARACTERS.set(2575, 2577);
        XML_NAME_ALLOWED_CHARACTERS.set(2579, 2601);
        XML_NAME_ALLOWED_CHARACTERS.set(2602, 2609);
        XML_NAME_ALLOWED_CHARACTERS.set(2610, 2612);
        XML_NAME_ALLOWED_CHARACTERS.set(2613, 2615);
        XML_NAME_ALLOWED_CHARACTERS.set(2616, 2618);
        XML_NAME_ALLOWED_CHARACTERS.set(2649, 2653);
        XML_NAME_ALLOWED_CHARACTERS.set(2654);
        XML_NAME_ALLOWED_CHARACTERS.set(2674, 2677);
        XML_NAME_ALLOWED_CHARACTERS.set(2693, 2700);
        XML_NAME_ALLOWED_CHARACTERS.set(2701);
        XML_NAME_ALLOWED_CHARACTERS.set(2703, 2706);
        XML_NAME_ALLOWED_CHARACTERS.set(2707, 2729);
        XML_NAME_ALLOWED_CHARACTERS.set(2730, 2737);
        XML_NAME_ALLOWED_CHARACTERS.set(2738, 2740);
        XML_NAME_ALLOWED_CHARACTERS.set(2741, 2746);
        XML_NAME_ALLOWED_CHARACTERS.set(2749);
        XML_NAME_ALLOWED_CHARACTERS.set(2784);
        XML_NAME_ALLOWED_CHARACTERS.set(2821, 2829);
        XML_NAME_ALLOWED_CHARACTERS.set(2831, 2833);
        XML_NAME_ALLOWED_CHARACTERS.set(2835, 2857);
        XML_NAME_ALLOWED_CHARACTERS.set(2858, 2865);
        XML_NAME_ALLOWED_CHARACTERS.set(2866, 2868);
        XML_NAME_ALLOWED_CHARACTERS.set(2870, 2874);
        XML_NAME_ALLOWED_CHARACTERS.set(2877);
        XML_NAME_ALLOWED_CHARACTERS.set(2908, 2910);
        XML_NAME_ALLOWED_CHARACTERS.set(2911, 2914);
        XML_NAME_ALLOWED_CHARACTERS.set(2949, 2955);
        XML_NAME_ALLOWED_CHARACTERS.set(2958, 2961);
        XML_NAME_ALLOWED_CHARACTERS.set(2962, 2966);
        XML_NAME_ALLOWED_CHARACTERS.set(2969, 2971);
        XML_NAME_ALLOWED_CHARACTERS.set(2972);
        XML_NAME_ALLOWED_CHARACTERS.set(2974, 2976);
        XML_NAME_ALLOWED_CHARACTERS.set(2979, 2981);
        XML_NAME_ALLOWED_CHARACTERS.set(2984, 2987);
        XML_NAME_ALLOWED_CHARACTERS.set(2990, 2998);
        XML_NAME_ALLOWED_CHARACTERS.set(2999, 3002);
        XML_NAME_ALLOWED_CHARACTERS.set(3077, 3085);
        XML_NAME_ALLOWED_CHARACTERS.set(3086, 3089);
        XML_NAME_ALLOWED_CHARACTERS.set(3090, 3113);
        XML_NAME_ALLOWED_CHARACTERS.set(3114, 3124);
        XML_NAME_ALLOWED_CHARACTERS.set(3125, 3130);
        XML_NAME_ALLOWED_CHARACTERS.set(3168, 3170);
        XML_NAME_ALLOWED_CHARACTERS.set(3205, 3213);
        XML_NAME_ALLOWED_CHARACTERS.set(3214, 3217);
        XML_NAME_ALLOWED_CHARACTERS.set(3218, 3241);
        XML_NAME_ALLOWED_CHARACTERS.set(3242, 3252);
        XML_NAME_ALLOWED_CHARACTERS.set(3253, 3258);
        XML_NAME_ALLOWED_CHARACTERS.set(3294);
        XML_NAME_ALLOWED_CHARACTERS.set(3296, 3298);
        XML_NAME_ALLOWED_CHARACTERS.set(3333, 3341);
        XML_NAME_ALLOWED_CHARACTERS.set(3342, 3345);
        XML_NAME_ALLOWED_CHARACTERS.set(3346, 3369);
        XML_NAME_ALLOWED_CHARACTERS.set(3370, 3386);
        XML_NAME_ALLOWED_CHARACTERS.set(3424, 3426);
        XML_NAME_ALLOWED_CHARACTERS.set(3585, 3631);
        XML_NAME_ALLOWED_CHARACTERS.set(3632);
        XML_NAME_ALLOWED_CHARACTERS.set(3634, 3636);
        XML_NAME_ALLOWED_CHARACTERS.set(3648, 3654);
        XML_NAME_ALLOWED_CHARACTERS.set(3713, 3715);
        XML_NAME_ALLOWED_CHARACTERS.set(3716);
        XML_NAME_ALLOWED_CHARACTERS.set(3719, 3721);
        XML_NAME_ALLOWED_CHARACTERS.set(3722);
        XML_NAME_ALLOWED_CHARACTERS.set(3725);
        XML_NAME_ALLOWED_CHARACTERS.set(3732, 3736);
        XML_NAME_ALLOWED_CHARACTERS.set(3737, 3744);
        XML_NAME_ALLOWED_CHARACTERS.set(3745, 3748);
        XML_NAME_ALLOWED_CHARACTERS.set(3749);
        XML_NAME_ALLOWED_CHARACTERS.set(3751);
        XML_NAME_ALLOWED_CHARACTERS.set(3754, 3756);
        XML_NAME_ALLOWED_CHARACTERS.set(3757, 3759);
        XML_NAME_ALLOWED_CHARACTERS.set(3760);
        XML_NAME_ALLOWED_CHARACTERS.set(3762, 3764);
        XML_NAME_ALLOWED_CHARACTERS.set(3773);
        XML_NAME_ALLOWED_CHARACTERS.set(3776, 3781);
        XML_NAME_ALLOWED_CHARACTERS.set(3904, 3912);
        XML_NAME_ALLOWED_CHARACTERS.set(3913, 3946);
        XML_NAME_ALLOWED_CHARACTERS.set(4256, 4294);
        XML_NAME_ALLOWED_CHARACTERS.set(4304, 4343);
        XML_NAME_ALLOWED_CHARACTERS.set(4352);
        XML_NAME_ALLOWED_CHARACTERS.set(4354, 4356);
        XML_NAME_ALLOWED_CHARACTERS.set(4357, 4360);
        XML_NAME_ALLOWED_CHARACTERS.set(4361);
        XML_NAME_ALLOWED_CHARACTERS.set(4363, 4365);
        XML_NAME_ALLOWED_CHARACTERS.set(4366, 4371);
        XML_NAME_ALLOWED_CHARACTERS.set(4412);
        XML_NAME_ALLOWED_CHARACTERS.set(4414);
        XML_NAME_ALLOWED_CHARACTERS.set(4416);
        XML_NAME_ALLOWED_CHARACTERS.set(4428);
        XML_NAME_ALLOWED_CHARACTERS.set(4430);
        XML_NAME_ALLOWED_CHARACTERS.set(4432);
        XML_NAME_ALLOWED_CHARACTERS.set(4436, 4438);
        XML_NAME_ALLOWED_CHARACTERS.set(4441);
        XML_NAME_ALLOWED_CHARACTERS.set(4447, 4450);
        XML_NAME_ALLOWED_CHARACTERS.set(4451);
        XML_NAME_ALLOWED_CHARACTERS.set(4453);
        XML_NAME_ALLOWED_CHARACTERS.set(4455);
        XML_NAME_ALLOWED_CHARACTERS.set(4457);
        XML_NAME_ALLOWED_CHARACTERS.set(4461, 4463);
        XML_NAME_ALLOWED_CHARACTERS.set(4466, 4468);
        XML_NAME_ALLOWED_CHARACTERS.set(4469);
        XML_NAME_ALLOWED_CHARACTERS.set(4510);
        XML_NAME_ALLOWED_CHARACTERS.set(4520);
        XML_NAME_ALLOWED_CHARACTERS.set(4523);
        XML_NAME_ALLOWED_CHARACTERS.set(4526, 4528);
        XML_NAME_ALLOWED_CHARACTERS.set(4535, 4537);
        XML_NAME_ALLOWED_CHARACTERS.set(4538);
        XML_NAME_ALLOWED_CHARACTERS.set(4540, 4547);
        XML_NAME_ALLOWED_CHARACTERS.set(4587);
        XML_NAME_ALLOWED_CHARACTERS.set(4592);
        XML_NAME_ALLOWED_CHARACTERS.set(4601);
        XML_NAME_ALLOWED_CHARACTERS.set(7680, 7836);
        XML_NAME_ALLOWED_CHARACTERS.set(7840, 7930);
        XML_NAME_ALLOWED_CHARACTERS.set(7936, 7958);
        XML_NAME_ALLOWED_CHARACTERS.set(7960, 7966);
        XML_NAME_ALLOWED_CHARACTERS.set(7968, 8006);
        XML_NAME_ALLOWED_CHARACTERS.set(8008, 8014);
        XML_NAME_ALLOWED_CHARACTERS.set(8016, 8024);
        XML_NAME_ALLOWED_CHARACTERS.set(8025);
        XML_NAME_ALLOWED_CHARACTERS.set(8027);
        XML_NAME_ALLOWED_CHARACTERS.set(8029);
        XML_NAME_ALLOWED_CHARACTERS.set(8031, 8062);
        XML_NAME_ALLOWED_CHARACTERS.set(8064, 8117);
        XML_NAME_ALLOWED_CHARACTERS.set(8118, 8125);
        XML_NAME_ALLOWED_CHARACTERS.set(8126);
        XML_NAME_ALLOWED_CHARACTERS.set(8130, 8133);
        XML_NAME_ALLOWED_CHARACTERS.set(8134, 8141);
        XML_NAME_ALLOWED_CHARACTERS.set(8144, 8148);
        XML_NAME_ALLOWED_CHARACTERS.set(8150, 8156);
        XML_NAME_ALLOWED_CHARACTERS.set(8160, 8173);
        XML_NAME_ALLOWED_CHARACTERS.set(8178, 8181);
        XML_NAME_ALLOWED_CHARACTERS.set(8182, 8189);
        XML_NAME_ALLOWED_CHARACTERS.set(8486);
        XML_NAME_ALLOWED_CHARACTERS.set(8490, 8492);
        XML_NAME_ALLOWED_CHARACTERS.set(8494);
        XML_NAME_ALLOWED_CHARACTERS.set(8576, 8579);
        XML_NAME_ALLOWED_CHARACTERS.set(12353, 12437);
        XML_NAME_ALLOWED_CHARACTERS.set(12449, 12539);
        XML_NAME_ALLOWED_CHARACTERS.set(12549, 12589);
        XML_NAME_ALLOWED_CHARACTERS.set(44032, 55204);
        XML_NAME_ALLOWED_CHARACTERS.set(19968, 40870);
        XML_NAME_ALLOWED_CHARACTERS.set(12295);
        XML_NAME_ALLOWED_CHARACTERS.set(12321, 12330);
        XML_NAME_ALLOWED_CHARACTERS.set(768, 838);
        XML_NAME_ALLOWED_CHARACTERS.set(864, 866);
        XML_NAME_ALLOWED_CHARACTERS.set(1155, 1159);
        XML_NAME_ALLOWED_CHARACTERS.set(1425, 1442);
        XML_NAME_ALLOWED_CHARACTERS.set(1443, 1466);
        XML_NAME_ALLOWED_CHARACTERS.set(1467, 1470);
        XML_NAME_ALLOWED_CHARACTERS.set(1471);
        XML_NAME_ALLOWED_CHARACTERS.set(1473, 1475);
        XML_NAME_ALLOWED_CHARACTERS.set(1476);
        XML_NAME_ALLOWED_CHARACTERS.set(1611, 1619);
        XML_NAME_ALLOWED_CHARACTERS.set(1648);
        XML_NAME_ALLOWED_CHARACTERS.set(1750, 1757);
        XML_NAME_ALLOWED_CHARACTERS.set(1757, 1760);
        XML_NAME_ALLOWED_CHARACTERS.set(1760, 1765);
        XML_NAME_ALLOWED_CHARACTERS.set(1767, 1769);
        XML_NAME_ALLOWED_CHARACTERS.set(1770, 1774);
        XML_NAME_ALLOWED_CHARACTERS.set(2305, 2308);
        XML_NAME_ALLOWED_CHARACTERS.set(2364);
        XML_NAME_ALLOWED_CHARACTERS.set(2366, 2381);
        XML_NAME_ALLOWED_CHARACTERS.set(2381);
        XML_NAME_ALLOWED_CHARACTERS.set(2385, 2389);
        XML_NAME_ALLOWED_CHARACTERS.set(2402, 2404);
        XML_NAME_ALLOWED_CHARACTERS.set(2433, 2436);
        XML_NAME_ALLOWED_CHARACTERS.set(2492);
        XML_NAME_ALLOWED_CHARACTERS.set(2494);
        XML_NAME_ALLOWED_CHARACTERS.set(2495);
        XML_NAME_ALLOWED_CHARACTERS.set(2496, 2501);
        XML_NAME_ALLOWED_CHARACTERS.set(2503, 2505);
        XML_NAME_ALLOWED_CHARACTERS.set(2507, 2510);
        XML_NAME_ALLOWED_CHARACTERS.set(2519);
        XML_NAME_ALLOWED_CHARACTERS.set(2530, 2532);
        XML_NAME_ALLOWED_CHARACTERS.set(2562);
        XML_NAME_ALLOWED_CHARACTERS.set(2620);
        XML_NAME_ALLOWED_CHARACTERS.set(2622);
        XML_NAME_ALLOWED_CHARACTERS.set(2623);
        XML_NAME_ALLOWED_CHARACTERS.set(2624, 2627);
        XML_NAME_ALLOWED_CHARACTERS.set(2631, 2633);
        XML_NAME_ALLOWED_CHARACTERS.set(2635, 2638);
        XML_NAME_ALLOWED_CHARACTERS.set(2672, 2674);
        XML_NAME_ALLOWED_CHARACTERS.set(2689, 2692);
        XML_NAME_ALLOWED_CHARACTERS.set(2748);
        XML_NAME_ALLOWED_CHARACTERS.set(2750, 2758);
        XML_NAME_ALLOWED_CHARACTERS.set(2759, 2762);
        XML_NAME_ALLOWED_CHARACTERS.set(2763, 2766);
        XML_NAME_ALLOWED_CHARACTERS.set(2817, 2820);
        XML_NAME_ALLOWED_CHARACTERS.set(2876);
        XML_NAME_ALLOWED_CHARACTERS.set(2878, 2884);
        XML_NAME_ALLOWED_CHARACTERS.set(2887, 2889);
        XML_NAME_ALLOWED_CHARACTERS.set(2891, 2894);
        XML_NAME_ALLOWED_CHARACTERS.set(2902, 2904);
        XML_NAME_ALLOWED_CHARACTERS.set(2946, 2948);
        XML_NAME_ALLOWED_CHARACTERS.set(3006, 3011);
        XML_NAME_ALLOWED_CHARACTERS.set(3014, 3017);
        XML_NAME_ALLOWED_CHARACTERS.set(3018, 3022);
        XML_NAME_ALLOWED_CHARACTERS.set(3031);
        XML_NAME_ALLOWED_CHARACTERS.set(3073, 3076);
        XML_NAME_ALLOWED_CHARACTERS.set(3134, 3141);
        XML_NAME_ALLOWED_CHARACTERS.set(3142, 3145);
        XML_NAME_ALLOWED_CHARACTERS.set(3146, 3150);
        XML_NAME_ALLOWED_CHARACTERS.set(3157, 3159);
        XML_NAME_ALLOWED_CHARACTERS.set(3202, 3204);
        XML_NAME_ALLOWED_CHARACTERS.set(3262, 3269);
        XML_NAME_ALLOWED_CHARACTERS.set(3270, 3273);
        XML_NAME_ALLOWED_CHARACTERS.set(3274, 3278);
        XML_NAME_ALLOWED_CHARACTERS.set(3285, 3287);
        XML_NAME_ALLOWED_CHARACTERS.set(3330, 3332);
        XML_NAME_ALLOWED_CHARACTERS.set(3390, 3396);
        XML_NAME_ALLOWED_CHARACTERS.set(3398, 3401);
        XML_NAME_ALLOWED_CHARACTERS.set(3402, 3406);
        XML_NAME_ALLOWED_CHARACTERS.set(3415);
        XML_NAME_ALLOWED_CHARACTERS.set(3633);
        XML_NAME_ALLOWED_CHARACTERS.set(3636, 3643);
        XML_NAME_ALLOWED_CHARACTERS.set(3655, 3663);
        XML_NAME_ALLOWED_CHARACTERS.set(3761);
        XML_NAME_ALLOWED_CHARACTERS.set(3764, 3770);
        XML_NAME_ALLOWED_CHARACTERS.set(3771, 3773);
        XML_NAME_ALLOWED_CHARACTERS.set(3784, 3790);
        XML_NAME_ALLOWED_CHARACTERS.set(3864, 3866);
        XML_NAME_ALLOWED_CHARACTERS.set(3893);
        XML_NAME_ALLOWED_CHARACTERS.set(3895);
        XML_NAME_ALLOWED_CHARACTERS.set(3897);
        XML_NAME_ALLOWED_CHARACTERS.set(3902);
        XML_NAME_ALLOWED_CHARACTERS.set(3903);
        XML_NAME_ALLOWED_CHARACTERS.set(3953, 3973);
        XML_NAME_ALLOWED_CHARACTERS.set(3974, 3980);
        XML_NAME_ALLOWED_CHARACTERS.set(3984, 3990);
        XML_NAME_ALLOWED_CHARACTERS.set(3991);
        XML_NAME_ALLOWED_CHARACTERS.set(3993, 4014);
        XML_NAME_ALLOWED_CHARACTERS.set(4017, 4024);
        XML_NAME_ALLOWED_CHARACTERS.set(4025);
        XML_NAME_ALLOWED_CHARACTERS.set(8400, 8413);
        XML_NAME_ALLOWED_CHARACTERS.set(8417);
        XML_NAME_ALLOWED_CHARACTERS.set(12330, 12336);
        XML_NAME_ALLOWED_CHARACTERS.set(12441);
        XML_NAME_ALLOWED_CHARACTERS.set(12442);
        XML_NAME_ALLOWED_CHARACTERS.set(48, 58);
        XML_NAME_ALLOWED_CHARACTERS.set(1632, 1642);
        XML_NAME_ALLOWED_CHARACTERS.set(1776, 1786);
        XML_NAME_ALLOWED_CHARACTERS.set(2406, 2416);
        XML_NAME_ALLOWED_CHARACTERS.set(2534, 2544);
        XML_NAME_ALLOWED_CHARACTERS.set(2662, 2672);
        XML_NAME_ALLOWED_CHARACTERS.set(2790, 2800);
        XML_NAME_ALLOWED_CHARACTERS.set(2918, 2928);
        XML_NAME_ALLOWED_CHARACTERS.set(3047, 3056);
        XML_NAME_ALLOWED_CHARACTERS.set(3174, 3184);
        XML_NAME_ALLOWED_CHARACTERS.set(3302, 3312);
        XML_NAME_ALLOWED_CHARACTERS.set(3430, 3440);
        XML_NAME_ALLOWED_CHARACTERS.set(3664, 3674);
        XML_NAME_ALLOWED_CHARACTERS.set(3792, 3802);
        XML_NAME_ALLOWED_CHARACTERS.set(3872, 3882);
        XML_NAME_ALLOWED_CHARACTERS.set(183);
        XML_NAME_ALLOWED_CHARACTERS.set(720);
        XML_NAME_ALLOWED_CHARACTERS.set(721);
        XML_NAME_ALLOWED_CHARACTERS.set(903);
        XML_NAME_ALLOWED_CHARACTERS.set(1600);
        XML_NAME_ALLOWED_CHARACTERS.set(3654);
        XML_NAME_ALLOWED_CHARACTERS.set(3782);
        XML_NAME_ALLOWED_CHARACTERS.set(12293);
        XML_NAME_ALLOWED_CHARACTERS.set(12337, 12342);
        XML_NAME_ALLOWED_CHARACTERS.set(12445, 12447);
        XML_NAME_ALLOWED_CHARACTERS.set(12540, 12543);
    }
}

