/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.core4j.Enumerable;
import org.core4j.Predicate1;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OExtension;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OLink;
import org.odata4j.core.OProperty;
import org.odata4j.core.ORelatedEntitiesLinkInline;
import org.odata4j.core.ORelatedEntityLink;
import org.odata4j.core.ORelatedEntityLinkInline;
import org.odata4j.core.Throwables;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDecorator;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.exceptions.BadRequestException;
import org.odata4j.exceptions.NotImplementedException;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.internal.TypeConverter;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityIdResponse;
import org.odata4j.producer.EntityQueryInfo;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.ODataContext;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.Responses;
import org.odata4j.producer.edm.MetadataProducer;
import org.odata4j.producer.jpa.BeginTransactionCommand;
import org.odata4j.producer.jpa.Chain;
import org.odata4j.producer.jpa.Command;
import org.odata4j.producer.jpa.CommitTransactionCommand;
import org.odata4j.producer.jpa.CreateAndLinkCommand;
import org.odata4j.producer.jpa.DeleteEntityCommand;
import org.odata4j.producer.jpa.EntityManagerCommand;
import org.odata4j.producer.jpa.ExecuteCountQueryCommand;
import org.odata4j.producer.jpa.ExecuteJPQLQueryCommand;
import org.odata4j.producer.jpa.GenerateJPQLCommand;
import org.odata4j.producer.jpa.GetEntityCommand;
import org.odata4j.producer.jpa.JPAContext;
import org.odata4j.producer.jpa.JPAEdmGenerator;
import org.odata4j.producer.jpa.JPAMember;
import org.odata4j.producer.jpa.JPAProducerBehavior;
import org.odata4j.producer.jpa.MergeEntityCommand;
import org.odata4j.producer.jpa.OEntityToJPAEntityCommand;
import org.odata4j.producer.jpa.PersistJPAEntityCommand;
import org.odata4j.producer.jpa.ReReadJPAEntityCommand;
import org.odata4j.producer.jpa.SetResponseCommand;
import org.odata4j.producer.jpa.UpdateEntityCommand;
import org.odata4j.producer.jpa.ValidateCountRequestProcessor;

public class JPAProducer
implements ODataProducer {
    private final EntityManagerFactory emf;
    private final EdmDataServices metadata;
    private final int maxResults;
    private final MetadataProducer metadataProducer;
    private Command createEntityCommand;
    private Command createAndLinkCommand;
    private Command getEntitiesCommand;
    private Command getEntityCommand;
    private Command deleteEntityCommand;
    private Command mergeEntityCommand;
    private Command updateEntityCommand;
    private Command getLinksCommand;
    private Command getCountCommand;
    private JPAProducerBehavior producerBehavior;

    public JPAProducer(EntityManagerFactory emf, String namespace, int maxResults) {
        this(emf, new JPAEdmGenerator(emf, namespace).generateEdm(null).build(), maxResults, null, null);
    }

    public JPAProducer(EntityManagerFactory emf, EdmDataServices metadata, int maxResults) {
        this(emf, metadata, maxResults, null, null);
    }

    public JPAProducer(EntityManagerFactory emf, EdmDataServices metadata, int maxResults, EdmDecorator metadataDecorator) {
        this(emf, metadata, maxResults, metadataDecorator, null);
    }

    public JPAProducer(EntityManagerFactory emf, EdmDataServices metadata, int maxResults, EdmDecorator metadataDecorator, JPAProducerBehavior producerBehavior) {
        this.emf = emf;
        this.maxResults = maxResults;
        this.metadata = metadata;
        this.metadataProducer = new MetadataProducer(this, metadataDecorator);
        this.producerBehavior = producerBehavior;
        this.initCommandChains();
    }

    protected void initCommandChains() {
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(new EntityManagerCommand(this.emf));
        commands.add(new GenerateJPQLCommand());
        commands.add(new ExecuteJPQLQueryCommand(this.maxResults));
        commands.add(new SetResponseCommand());
        this.getEntitiesCommand = this.createChain(CommandType.GetEntities, commands);
        commands = new ArrayList();
        commands.add(new EntityManagerCommand(this.emf));
        commands.add(new BeginTransactionCommand());
        commands.add(new OEntityToJPAEntityCommand(true));
        commands.add(new PersistJPAEntityCommand());
        commands.add(new CommitTransactionCommand());
        commands.add(new ReReadJPAEntityCommand());
        commands.add(new SetResponseCommand());
        this.createEntityCommand = this.createChain(CommandType.CreateEntity, commands);
        commands = new ArrayList();
        commands.add(new EntityManagerCommand(this.emf));
        commands.add(new BeginTransactionCommand());
        commands.add(new GetEntityCommand());
        commands.add(new OEntityToJPAEntityCommand(JPAContext.EntityAccessor.OTHER, true));
        commands.add(new CreateAndLinkCommand());
        commands.add(new CommitTransactionCommand());
        commands.add(new SetResponseCommand(JPAContext.EntityAccessor.OTHER));
        this.createAndLinkCommand = this.createChain(CommandType.CreateAndLink, commands);
        commands = new ArrayList();
        commands.add(new EntityManagerCommand(this.emf));
        commands.add(new GetEntityCommand());
        commands.add(new SetResponseCommand());
        this.getEntityCommand = this.createChain(CommandType.GetEntity, commands);
        commands = new ArrayList();
        commands.add(new EntityManagerCommand(this.emf));
        commands.add(new BeginTransactionCommand());
        commands.add(new GetEntityCommand());
        commands.add(new DeleteEntityCommand());
        commands.add(new CommitTransactionCommand());
        this.deleteEntityCommand = this.createChain(CommandType.DeleteEntity, commands);
        commands = new ArrayList();
        commands.add(new EntityManagerCommand(this.emf));
        commands.add(new BeginTransactionCommand());
        commands.add(new GetEntityCommand());
        commands.add(new MergeEntityCommand());
        commands.add(new CommitTransactionCommand());
        this.mergeEntityCommand = this.createChain(CommandType.MergeEntity, commands);
        commands = new ArrayList();
        commands.add(new EntityManagerCommand(this.emf));
        commands.add(new BeginTransactionCommand());
        commands.add(new OEntityToJPAEntityCommand(true));
        commands.add(new UpdateEntityCommand());
        commands.add(new CommitTransactionCommand());
        this.updateEntityCommand = this.createChain(CommandType.UpdateEntity, commands);
        commands = new ArrayList();
        commands.add(new EntityManagerCommand(this.emf));
        commands.add(new GenerateJPQLCommand());
        commands.add(new ExecuteJPQLQueryCommand(this.maxResults));
        commands.add(new SetResponseCommand());
        this.getLinksCommand = this.createChain(CommandType.GetLinks, commands);
        commands = new ArrayList();
        commands.add(new ValidateCountRequestProcessor());
        commands.add(new EntityManagerCommand(this.emf));
        commands.add(new GenerateJPQLCommand(true));
        commands.add(new ExecuteCountQueryCommand());
        commands.add(new SetResponseCommand());
        this.getCountCommand = this.createChain(CommandType.GetCount, commands);
    }

    private Command createChain(CommandType type, List<Command> commands) {
        if (this.producerBehavior != null) {
            return new Chain(this.producerBehavior.modify(type, commands));
        }
        return new Chain(commands);
    }

    @Override
    public EdmDataServices getMetadata() {
        return this.metadata;
    }

    @Override
    public MetadataProducer getMetadataProducer() {
        return this.metadataProducer;
    }

    @Override
    public EntitiesResponse getEntities(ODataContext context, String entitySetName, QueryInfo queryInfo) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, queryInfo);
        this.getEntitiesCommand.execute(jpaContext);
        return (EntitiesResponse)jpaContext.getResponse();
    }

    @Override
    public EntityResponse getEntity(ODataContext context, String entitySetName, OEntityKey entityKey, EntityQueryInfo queryInfo) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, entityKey, null, queryInfo);
        this.getEntityCommand.execute(jpaContext);
        return (EntityResponse)jpaContext.getResponse();
    }

    @Override
    public BaseResponse getNavProperty(ODataContext context, String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, entityKey, navProp, queryInfo);
        this.getEntitiesCommand.execute(jpaContext);
        return jpaContext.getResponse();
    }

    @Override
    public void close() {
    }

    @Override
    public EntityResponse createEntity(ODataContext context, String entitySetName, OEntity entity) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, null, entity);
        this.createEntityCommand.execute(jpaContext);
        return (EntityResponse)jpaContext.getResponse();
    }

    @Override
    public EntityResponse createEntity(ODataContext context, String entitySetName, OEntityKey entityKey, String navProp, OEntity entity) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, entityKey, navProp, entity);
        this.createAndLinkCommand.execute(jpaContext);
        return (EntityResponse)jpaContext.getResponse();
    }

    @Override
    public void deleteEntity(ODataContext context, String entitySetName, OEntityKey entityKey) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, entityKey, null);
        this.deleteEntityCommand.execute(jpaContext);
    }

    @Override
    public void mergeEntity(ODataContext context, String entitySetName, OEntity entity) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, entity.getEntityKey(), entity);
        this.mergeEntityCommand.execute(jpaContext);
    }

    @Override
    public void updateEntity(ODataContext context, String entitySetName, OEntity entity) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, entity.getEntityKey(), entity);
        this.updateEntityCommand.execute(jpaContext);
    }

    @Override
    public EntityIdResponse getLinks(ODataContext context, OEntityId sourceEntity, String targetNavProp) {
        JPAContext jpaContext = new JPAContext(this.metadata, sourceEntity.getEntitySetName(), sourceEntity.getEntityKey(), targetNavProp, (QueryInfo)null);
        this.getLinksCommand.execute(jpaContext);
        BaseResponse r = jpaContext.getResponse();
        if (r instanceof EntitiesResponse) {
            EntitiesResponse er = (EntitiesResponse)r;
            return Responses.multipleIds(er.getEntities());
        }
        if (r instanceof EntityResponse) {
            EntityResponse er = (EntityResponse)r;
            return Responses.singleId(er.getEntity());
        }
        if (r instanceof EntitiesResponse) {
            EntitiesResponse er = (EntitiesResponse)r;
            return Responses.multipleIds(er.getEntities());
        }
        if (r instanceof EntityResponse) {
            EntityResponse er = (EntityResponse)r;
            return Responses.singleId(er.getEntity());
        }
        throw new NotImplementedException(sourceEntity + " " + targetNavProp);
    }

    @Override
    public void createLink(ODataContext context, OEntityId sourceEntity, String targetNavProp, OEntityId targetEntity) {
        throw new NotImplementedException();
    }

    @Override
    public void updateLink(ODataContext context, OEntityId sourceEntity, String targetNavProp, OEntityKey oldTargetEntityKey, OEntityId newTargetEntity) {
        throw new NotImplementedException();
    }

    @Override
    public void deleteLink(ODataContext context, OEntityId sourceEntity, String targetNavProp, OEntityKey targetEntityKey) {
        throw new NotImplementedException();
    }

    @Override
    public BaseResponse callFunction(ODataContext context, EdmFunctionImport name, Map<String, OFunctionParameter> params, QueryInfo queryInfo) {
        return null;
    }

    @Override
    public CountResponse getEntitiesCount(ODataContext context, String entitySetName, QueryInfo queryInfo) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, queryInfo);
        this.getCountCommand.execute(jpaContext);
        return (CountResponse)jpaContext.getResponse();
    }

    @Override
    public CountResponse getNavPropertyCount(ODataContext context, String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        JPAContext jpaContext = new JPAContext(this.metadata, entitySetName, entityKey, navProp, queryInfo);
        this.getCountCommand.execute(jpaContext);
        return (CountResponse)jpaContext.getResponse();
    }

    @Override
    public <TExtension extends OExtension<ODataProducer>> TExtension findExtension(Class<TExtension> clazz) {
        return null;
    }

    static void applyOProperties(EntityManager em, ManagedType<?> jpaManagedType, Collection<OProperty<?>> properties, Object jpaEntity) {
        for (OProperty<?> prop : properties) {
            EntityType jpaEntityType;
            boolean found = false;
            if (jpaManagedType instanceof EntityType && (jpaEntityType = (EntityType)jpaManagedType).getIdType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
                EmbeddableType et = (EmbeddableType)jpaEntityType.getIdType();
                for (Attribute idAtt : et.getAttributes()) {
                    if (!idAtt.getName().equals(prop.getName())) continue;
                    Object idValue = JPAMember.create(jpaEntityType.getId(et.getJavaType()), jpaEntity).get();
                    JPAProducer.setAttribute(idAtt, prop, idValue);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            Attribute att = jpaManagedType.getAttribute(prop.getName());
            JPAProducer.setAttribute(att, prop, jpaEntity);
        }
    }

    static Object coercePropertyValue(OProperty<?> prop, Class<?> javaType) {
        Object value = prop.getValue();
        try {
            return TypeConverter.convert(value, javaType);
        }
        catch (UnsupportedOperationException ex) {
            return value;
        }
    }

    static EntityType<?> getJPAEntityType(EntityManager em, String jpaEntityTypeName) {
        for (EntityType et : em.getMetamodel().getEntities()) {
            if (!JPAEdmGenerator.getEntitySetName(et).equals(jpaEntityTypeName)) continue;
            return et;
        }
        throw new RuntimeException("JPA Entity type " + jpaEntityTypeName + " not found");
    }

    static <T> T newInstance(Class<?> javaType) {
        try {
            if (javaType.equals(Collection.class)) {
                javaType = HashSet.class;
            }
            Constructor<?> ctor = javaType.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return (T)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    static void setAttribute(Attribute<?, ?> att, OProperty<?> prop, Object target) {
        JPAMember attMember = JPAMember.create(att, target);
        Object value = JPAProducer.coercePropertyValue(prop, attMember.getJavaType());
        attMember.set(value);
    }

    static Object typeSafeEntityKey(EntityManager em, EntityType<?> jpaEntityType, OEntityKey entityKey) {
        if (entityKey != null && jpaEntityType.getIdType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            Object id = JPAProducer.newInstance(jpaEntityType.getIdType().getJavaType());
            JPAProducer.applyOProperties(em, em.getMetamodel().embeddable(jpaEntityType.getIdType().getJavaType()), entityKey.asComplexProperties(), id);
            return id;
        }
        Class javaType = jpaEntityType.getIdType().getJavaType();
        try {
            return TypeConverter.convert(entityKey == null ? null : entityKey.asSingleValue(), javaType);
        }
        catch (UnsupportedOperationException e) {
            throw new BadRequestException("Invalid key type", e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid key value", e);
        }
    }

    static void applyOLinks(EntityManager em, EntityType<?> jpaEntityType, List<OLink> links, Object jpaEntity) {
        if (links == null) {
            return;
        }
        for (OLink link : links) {
            JPAMember member;
            PluralAttribute att;
            String[] propNameSplit = link.getRelation().split("/");
            String propName = propNameSplit[propNameSplit.length - 1];
            if (link instanceof ORelatedEntitiesLinkInline) {
                att = (PluralAttribute)jpaEntityType.getAttribute(propName);
                member = JPAMember.create(att, jpaEntity);
                EntityType collJpaEntityType = (EntityType)att.getElementType();
                OneToMany oneToMany = member.getAnnotation(OneToMany.class);
                boolean hasSingularBackRef = oneToMany != null && oneToMany.mappedBy() != null && !oneToMany.mappedBy().isEmpty();
                boolean cascade = oneToMany != null && oneToMany.cascade() != null ? Enumerable.create((Object[])oneToMany.cascade()).any((Predicate1)new Predicate1<CascadeType>(){

                    public boolean apply(CascadeType input) {
                        return input == CascadeType.ALL || input == CascadeType.PERSIST;
                    }
                }) : false;
                ManyToMany manyToMany = member.getAnnotation(ManyToMany.class);
                Collection coll = (Collection)member.get();
                if (coll == null) {
                    coll = (Collection)JPAProducer.newInstance(member.getJavaType());
                    member.set(coll);
                }
                for (OEntity oentity : ((ORelatedEntitiesLinkInline)link).getRelatedEntities()) {
                    Object collJpaEntity = JPAProducer.createNewJPAEntity(em, collJpaEntityType, oentity, true);
                    if (hasSingularBackRef) {
                        JPAMember backRef = JPAMember.create(collJpaEntityType.getAttribute(oneToMany.mappedBy()), collJpaEntity);
                        backRef.set(jpaEntity);
                    }
                    if (manyToMany != null) {
                        Attribute other = null;
                        if (manyToMany.mappedBy() != null && !manyToMany.mappedBy().isEmpty()) {
                            other = collJpaEntityType.getAttribute(manyToMany.mappedBy());
                        } else {
                            for (Attribute att2 : collJpaEntityType.getAttributes()) {
                                CollectionAttribute ca;
                                if (!att2.isCollection() || JPAMember.create(att2, null).getAnnotation(ManyToMany.class) == null || !(ca = (CollectionAttribute)att2).getElementType().equals(jpaEntityType)) continue;
                                other = ca;
                                break;
                            }
                        }
                        if (other == null) {
                            throw new RuntimeException("Could not find other side of many-to-many relationship");
                        }
                        JPAMember backRef = JPAMember.create(other, collJpaEntity);
                        Collection coll2 = (Collection)backRef.get();
                        if (coll2 == null) {
                            coll2 = (Collection)JPAProducer.newInstance(backRef.getJavaType());
                            backRef.set(coll2);
                        }
                        coll2.add(jpaEntity);
                    }
                    if (!cascade) {
                        em.persist(collJpaEntity);
                    }
                    coll.add(collJpaEntity);
                }
                continue;
            }
            if (link instanceof ORelatedEntityLinkInline) {
                att = jpaEntityType.getSingularAttribute(propName);
                member = JPAMember.create(att, jpaEntity);
                OneToOne oneToOne = member.getAnnotation(OneToOne.class);
                boolean cascade = oneToOne != null && oneToOne.cascade() != null ? Enumerable.create((Object[])oneToOne.cascade()).any((Predicate1)new Predicate1<CascadeType>(){

                    public boolean apply(CascadeType input) {
                        return input == CascadeType.ALL || input == CascadeType.PERSIST;
                    }
                }) : false;
                EntityType relJpaEntityType = (EntityType)att.getType();
                Object relJpaEntity = JPAProducer.createNewJPAEntity(em, relJpaEntityType, ((ORelatedEntityLinkInline)link).getRelatedEntity(), true);
                if (!cascade) {
                    em.persist(relJpaEntity);
                }
                member.set(relJpaEntity);
                continue;
            }
            if (link instanceof ORelatedEntityLink) {
                String columnName;
                JPAMember m;
                att = jpaEntityType.getSingularAttribute(propName);
                member = JPAMember.create(att, jpaEntity);
                EntityType relJpaEntityType = (EntityType)att.getType();
                Object key = JPAProducer.typeSafeEntityKey(em, relJpaEntityType, OEntityKey.parse(link.getHref().substring(link.getHref().indexOf(40))));
                Object relEntity = em.find(relJpaEntityType.getJavaType(), key);
                member.set(relEntity);
                JoinColumn joinColumn = member.getAnnotation(JoinColumn.class);
                ManyToOne manyToOne = member.getAnnotation(ManyToOne.class);
                if (joinColumn == null || manyToOne == null || (m = JPAMember.findByColumn(jpaEntityType, columnName = joinColumn.name(), jpaEntity)) == null) continue;
                m.set(key);
                continue;
            }
            throw new UnsupportedOperationException("binding the new entity to many entities is not supported");
        }
    }

    static Object createNewJPAEntity(EntityManager em, EntityType<?> jpaEntityType, OEntity oEntity, boolean withLinks) {
        Object jpaEntity = JPAProducer.newInstance(jpaEntityType.getJavaType());
        if (jpaEntityType.getIdType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            EmbeddableType et = (EmbeddableType)jpaEntityType.getIdType();
            JPAMember idMember = JPAMember.create(jpaEntityType.getId(et.getJavaType()), jpaEntity);
            Object idValue = JPAProducer.newInstance(et.getJavaType());
            idMember.set(idValue);
        }
        JPAProducer.applyOProperties(em, jpaEntityType, oEntity.getProperties(), jpaEntity);
        if (withLinks) {
            JPAProducer.applyOLinks(em, jpaEntityType, oEntity.getLinks(), jpaEntity);
        }
        return jpaEntity;
    }

    static boolean isSelected(String name, List<EntitySimpleProperty> select) {
        if (select != null && !select.isEmpty()) {
            for (EntitySimpleProperty prop : select) {
                String sname = prop.getPropertyName();
                if (!name.equals(sname)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static enum CommandType {
        CreateEntity,
        GetEntities,
        GetEntity,
        CreateAndLink,
        DeleteEntity,
        MergeEntity,
        UpdateEntity,
        GetLinks,
        GetCount;

    }
}

