/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.metamodel.EntityType;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmPropertyBase;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.jpa.Context;
import org.odata4j.producer.jpa.JPAEdmGenerator;
import org.odata4j.producer.jpa.JPAProducer;
import org.odata4j.producer.jpa.JPAResult;

public class JPAContext
implements Context {
    private EdmDataServices metadata;
    private EntityManager em;
    private EntityTransaction tx;
    private ContextEntity entity;
    private ContextEntity otherEntity;
    private String navProperty;
    private QueryInfo queryInfo;
    private String jpqlQuery;
    private EdmPropertyBase edmPropertyBase;
    private JPAResult result;
    private BaseResponse response;

    protected JPAContext(EdmDataServices metadata, String entitySetName, OEntityKey oEntityKey, OEntity oEntity) {
        this.metadata = metadata;
        this.entity = new ContextEntity(entitySetName, oEntityKey, oEntity);
    }

    public JPAContext(EdmDataServices metadata, String entitySetName, OEntityKey oEntityKey, String navProperty, OEntity oEntity) {
        this.metadata = metadata;
        this.entity = new ContextEntity(entitySetName, oEntityKey, null);
        this.navProperty = navProperty;
        this.otherEntity = new ContextEntity(oEntity.getEntitySetName(), oEntity.getEntityKey(), oEntity);
    }

    public JPAContext(EdmDataServices metadata, String entitySetName, QueryInfo queryInfo) {
        this.metadata = metadata;
        this.entity = new ContextEntity(entitySetName, null, null);
        this.queryInfo = queryInfo;
    }

    public JPAContext(EdmDataServices metadata, String entitySetName, OEntityKey oEntityKey, String navProperty, QueryInfo queryInfo) {
        this.metadata = metadata;
        this.entity = new ContextEntity(entitySetName, oEntityKey, null);
        this.navProperty = navProperty;
        this.queryInfo = queryInfo;
    }

    public EdmDataServices getMetadata() {
        return this.metadata;
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    public EntityTransaction getEntityTransaction() {
        return this.tx;
    }

    public void setEntityTransaction(EntityTransaction tx) {
        this.tx = tx;
    }

    public ContextEntity getEntity() {
        return this.entity;
    }

    public ContextEntity getOtherEntity() {
        return this.otherEntity;
    }

    public String getNavProperty() {
        return this.navProperty;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public String getJPQLQuery() {
        return this.jpqlQuery;
    }

    public void setJPQLQuery(String jpqlQuery) {
        this.jpqlQuery = jpqlQuery;
    }

    public EdmPropertyBase getEdmPropertyBase() {
        return this.edmPropertyBase;
    }

    public void setEdmPropertyBase(EdmPropertyBase edmPropertyBase) {
        this.edmPropertyBase = edmPropertyBase;
    }

    public JPAResult getResult() {
        return this.result;
    }

    public void setResult(JPAResult result) {
        this.result = result;
    }

    public BaseResponse getResponse() {
        return this.response;
    }

    public void setResponse(BaseResponse response) {
        this.response = response;
    }

    public static abstract class EntityAccessor {
        public static final EntityAccessor ENTITY = new EntityAccessor(){

            @Override
            public ContextEntity getEntity(JPAContext context) {
                return context.getEntity();
            }

            @Override
            public void setJPAEntity(JPAContext context, Object jpaEntity) {
                context.getEntity().setJpaEntity(jpaEntity);
            }
        };
        public static final EntityAccessor OTHER = new EntityAccessor(){

            @Override
            public ContextEntity getEntity(JPAContext context) {
                return context.getOtherEntity();
            }

            @Override
            public void setJPAEntity(JPAContext context, Object jpaEntity) {
                context.getOtherEntity().setJpaEntity(jpaEntity);
            }
        };

        public abstract ContextEntity getEntity(JPAContext var1);

        public abstract void setJPAEntity(JPAContext var1, Object var2);
    }

    public class ContextEntity {
        private String entitySetName;
        private OEntityKey oEntityKey;
        private OEntity oEntity;
        private EdmEntitySet ees;
        private EntityType<?> jpaEntityType;
        private String keyAttributeName;
        private Object jpaEntity;

        public ContextEntity(String entitySetName, OEntityKey oEntityKey, OEntity oEntity) {
            this.entitySetName = entitySetName;
            this.oEntityKey = oEntityKey;
            this.oEntity = oEntity;
        }

        public String getEntitySetName() {
            return this.entitySetName;
        }

        public void setEntitySetName(String entitySetName) {
            this.entitySetName = entitySetName;
            this.jpaEntityType = null;
            this.ees = null;
            this.keyAttributeName = null;
            this.oEntityKey = null;
        }

        public void setOEntityKey(OEntityKey oEntityKey) {
            this.oEntityKey = oEntityKey;
        }

        public EntityType<?> getJPAEntityType() {
            if (this.jpaEntityType == null) {
                this.jpaEntityType = JPAProducer.getJPAEntityType(JPAContext.this.em, this.getEdmEntitySet().getType().getName());
            }
            return this.jpaEntityType;
        }

        public EdmEntitySet getEdmEntitySet() {
            if (this.ees == null) {
                this.ees = JPAContext.this.getMetadata().getEdmEntitySet(this.getEntitySetName());
            }
            return this.ees;
        }

        public String getKeyAttributeName() {
            if (this.keyAttributeName == null) {
                this.keyAttributeName = JPAEdmGenerator.getIdAttribute(this.getJPAEntityType()).getName();
            }
            return this.keyAttributeName;
        }

        public Object getTypeSafeEntityKey() {
            return JPAProducer.typeSafeEntityKey(JPAContext.this.getEntityManager(), this.getJPAEntityType(), this.oEntityKey);
        }

        public Object getJpaEntity() {
            return this.jpaEntity;
        }

        public void setJpaEntity(Object jpaEntity) {
            this.jpaEntity = jpaEntity;
        }

        public OEntity getOEntity() {
            return this.oEntity;
        }

        public void setOEntity(OEntity oEntity) {
            this.oEntity = oEntity;
            this.setEntitySetName(oEntity.getEntitySetName());
            this.oEntityKey = oEntity != null ? oEntity.getEntityKey() : null;
        }
    }
}

