/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.odata4j.command.ChainCommand;
import org.odata4j.command.Command;
import org.odata4j.command.CommandContext;
import org.odata4j.command.CommandExecution;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.Throwables;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.producer.EntityQueryInfo;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.command.CallFunctionCommandContext;
import org.odata4j.producer.command.CloseCommandContext;
import org.odata4j.producer.command.CommandProducerBackend;
import org.odata4j.producer.command.CreateEntityAtPropertyCommandContext;
import org.odata4j.producer.command.CreateEntityCommandContext;
import org.odata4j.producer.command.CreateLinkCommandContext;
import org.odata4j.producer.command.DeleteEntityCommandContext;
import org.odata4j.producer.command.DeleteLinkCommandContext;
import org.odata4j.producer.command.GetEntitiesCommandContext;
import org.odata4j.producer.command.GetEntitiesCountCommandContext;
import org.odata4j.producer.command.GetEntityCommandContext;
import org.odata4j.producer.command.GetLinksCommandContext;
import org.odata4j.producer.command.GetMetadataCommandContext;
import org.odata4j.producer.command.GetMetadataProducerCommandContext;
import org.odata4j.producer.command.GetNavPropertyCommandContext;
import org.odata4j.producer.command.GetNavPropertyCountCommandContext;
import org.odata4j.producer.command.MergeEntityCommandContext;
import org.odata4j.producer.command.ProducerCommandContext;
import org.odata4j.producer.command.UpdateEntityCommandContext;
import org.odata4j.producer.command.UpdateLinkCommandContext;
import org.odata4j.producer.jdbc.Jdbc;
import org.odata4j.producer.jdbc.JdbcCreateEntityCommand;
import org.odata4j.producer.jdbc.JdbcDeleteEntityCommand;
import org.odata4j.producer.jdbc.JdbcGetEntitiesCommand;
import org.odata4j.producer.jdbc.JdbcGetEntityCommand;
import org.odata4j.producer.jdbc.JdbcGetMetadataCommand;
import org.odata4j.producer.jdbc.JdbcMetadataMapping;
import org.odata4j.producer.jdbc.JdbcProducerBackendInvocationHandler;
import org.odata4j.producer.jdbc.JdbcProducerCommandContext;

public abstract class JdbcProducerBackend
implements CommandProducerBackend {
    @Override
    public abstract CommandExecution getCommandExecution();

    public abstract Jdbc getJdbc();

    protected abstract <TContext extends CommandContext> List<Command<?>> getPreCommands(Class<TContext> var1);

    protected abstract <TContext extends CommandContext> List<Command<?>> getPostCommands(Class<TContext> var1);

    protected abstract <T> T get(Class<T> var1);

    public JdbcMetadataMapping getMetadataMapping() {
        GetMetadataCommandContext context = this.newGetMetadataCommandContext();
        try {
            this.getCommand(GetMetadataCommandContext.class).execute(context);
            return (JdbcMetadataMapping)context.getResult();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public JdbcProducerCommandContext newJdbcCommandContext() {
        return new JdbcProducerCommandContext(){

            @Override
            public Jdbc getJdbc() {
                return JdbcProducerBackend.this.getJdbc();
            }

            @Override
            public JdbcProducerBackend getBackend() {
                return JdbcProducerBackend.this;
            }

            @Override
            public <T> T get(Class<T> instanceType) {
                return JdbcProducerBackend.this.get(instanceType);
            }
        };
    }

    @Override
    public <TContext extends CommandContext> Command<TContext> getCommand(Class<TContext> contextType) {
        ChainCommand.Builder chain = ChainCommand.newBuilder();
        chain.addAll(this.getPreCommands(ProducerCommandContext.class));
        if (CloseCommandContext.class.isAssignableFrom(contextType)) {
            chain.addAll(this.getPreCommands(CloseCommandContext.class));
            chain.addAll(this.getPostCommands(CloseCommandContext.class));
        } else if (GetMetadataCommandContext.class.isAssignableFrom(contextType)) {
            chain.addAll(this.getPreCommands(GetMetadataCommandContext.class));
            chain.add(new JdbcGetMetadataCommand());
            chain.addAll(this.getPostCommands(GetMetadataCommandContext.class));
        } else if (GetEntitiesCommandContext.class.isAssignableFrom(contextType)) {
            chain.addAll(this.getPreCommands(GetEntitiesCommandContext.class));
            chain.add(new JdbcGetEntitiesCommand());
            chain.addAll(this.getPostCommands(GetEntitiesCommandContext.class));
        } else if (GetEntityCommandContext.class.isAssignableFrom(contextType)) {
            chain.addAll(this.getPreCommands(GetEntityCommandContext.class));
            chain.add(new JdbcGetEntityCommand());
            chain.addAll(this.getPostCommands(GetEntityCommandContext.class));
        } else if (CreateEntityCommandContext.class.isAssignableFrom(contextType)) {
            chain.addAll(this.getPreCommands(CreateEntityCommandContext.class));
            chain.add(new JdbcCreateEntityCommand());
            chain.addAll(this.getPostCommands(CreateEntityCommandContext.class));
        } else if (DeleteEntityCommandContext.class.isAssignableFrom(contextType)) {
            chain.addAll(this.getPreCommands(DeleteEntityCommandContext.class));
            chain.add(new JdbcDeleteEntityCommand());
            chain.addAll(this.getPostCommands(DeleteEntityCommandContext.class));
        } else {
            throw new UnsupportedOperationException("TODO implement: " + contextType.getSimpleName());
        }
        chain.addAll(this.getPostCommands(ProducerCommandContext.class));
        return chain.build();
    }

    private <T> T newContext(Class<?> contextType, Object ... args) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{contextType, JdbcProducerCommandContext.class}, (InvocationHandler)new JdbcProducerBackendInvocationHandler(this, contextType, args));
    }

    @Override
    public CloseCommandContext newCloseCommandContext() {
        return (CloseCommandContext)this.newContext(CloseCommandContext.class, new Object[0]);
    }

    @Override
    public GetMetadataCommandContext newGetMetadataCommandContext() {
        return (GetMetadataCommandContext)this.newContext(GetMetadataCommandContext.class, new Object[0]);
    }

    @Override
    public GetEntitiesCommandContext newGetEntitiesCommandContext(String entitySetName, QueryInfo queryInfo) {
        return (GetEntitiesCommandContext)this.newContext(GetEntitiesCommandContext.class, "entitySetName", entitySetName, "queryInfo", queryInfo);
    }

    @Override
    public GetEntityCommandContext newGetEntityCommandContext(String entitySetName, OEntityKey entityKey, EntityQueryInfo queryInfo) {
        return (GetEntityCommandContext)this.newContext(GetEntityCommandContext.class, "entitySetName", entitySetName, "entityKey", entityKey, "queryInfo", queryInfo);
    }

    @Override
    public GetMetadataProducerCommandContext newGetMetadataProducerCommandContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GetEntitiesCountCommandContext newGetEntitiesCountCommandContext(String entitySetName, QueryInfo queryInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GetNavPropertyCommandContext newGetNavPropertyCommandContext(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GetNavPropertyCountCommandContext newGetNavPropertyCountCommandContext(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CreateEntityCommandContext newCreateEntityCommandContext(String entitySetName, OEntity entity) {
        return (CreateEntityCommandContext)this.newContext(CreateEntityCommandContext.class, "entitySetName", entitySetName, "entity", entity);
    }

    @Override
    public CreateEntityAtPropertyCommandContext newCreateEntityAtPropertyCommandContext(String entitySetName, OEntityKey entityKey, String navProp, OEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DeleteEntityCommandContext newDeleteEntityCommandContext(String entitySetName, OEntityKey entityKey) {
        return (DeleteEntityCommandContext)this.newContext(DeleteEntityCommandContext.class, "entitySetName", entitySetName, "entityKey", entityKey);
    }

    @Override
    public MergeEntityCommandContext newMergeEntityCommandContext(String entitySetName, OEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UpdateEntityCommandContext newUpdateEntityCommandContext(String entitySetName, OEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GetLinksCommandContext newGetLinksCommandContext(OEntityId sourceEntity, String targetNavProp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CreateLinkCommandContext newCreateLinkCommandContext(OEntityId sourceEntity, String targetNavProp, OEntityId targetEntity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UpdateLinkCommandContext newUpdateLinkCommandContext(OEntityId sourceEntity, String targetNavProp, OEntityKey oldTargetEntityKey, OEntityId newTargetEntity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DeleteLinkCommandContext newDeleteLinkCommandContext(OEntityId sourceEntity, String targetNavProp, OEntityKey targetEntityKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallFunctionCommandContext newCallFunctionCommandContext(EdmFunctionImport name, Map<String, OFunctionParameter> params, QueryInfo queryInfo) {
        throw new UnsupportedOperationException();
    }
}

