/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.core4j.Enumerable;
import org.core4j.Predicate1;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDecorator;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmGenerator;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.producer.inmemory.BeanBasedPropertyModel;
import org.odata4j.producer.inmemory.EnumsAsStringsPropertyModelDelegate;
import org.odata4j.producer.inmemory.InMemoryComplexTypeInfo;
import org.odata4j.producer.inmemory.InMemoryEntityInfo;
import org.odata4j.producer.inmemory.InMemoryTypeMapping;
import org.odata4j.producer.inmemory.PropertyModel;

public class InMemoryEdmGenerator
implements EdmGenerator {
    private static final boolean DUMP = false;
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final String namespace;
    private final String containerName;
    protected final InMemoryTypeMapping typeMapping;
    protected final Map<String, InMemoryEntityInfo<?>> eis;
    protected final Map<String, InMemoryComplexTypeInfo<?>> complexTypeInfo;
    protected final List<EdmComplexType.Builder> edmComplexTypes = new ArrayList<EdmComplexType.Builder>();
    protected final Map<Class<?>, String> entitySetNameByClass = new HashMap();
    protected Map<String, EdmEntityType.Builder> entityTypesByName = new HashMap<String, EdmEntityType.Builder>();
    protected Map<String, EdmEntitySet.Builder> entitySetsByName = new HashMap<String, EdmEntitySet.Builder>();
    protected final boolean flatten;
    private Map<Class<?>, InMemoryEntityInfo<?>> unregisteredEntityInfo = new HashMap();

    private static void dump(String msg) {
    }

    public InMemoryEdmGenerator(String namespace, String containerName, InMemoryTypeMapping typeMapping, String idPropertyName, Map<String, InMemoryEntityInfo<?>> eis, Map<String, InMemoryComplexTypeInfo<?>> complexTypes) {
        this(namespace, containerName, typeMapping, idPropertyName, eis, complexTypes, true);
    }

    public InMemoryEdmGenerator(String namespace, String containerName, InMemoryTypeMapping typeMapping, String idPropertyName, Map<String, InMemoryEntityInfo<?>> eis, Map<String, InMemoryComplexTypeInfo<?>> complexTypes, boolean flatten) {
        this.namespace = namespace;
        this.containerName = containerName;
        this.typeMapping = typeMapping;
        this.eis = eis;
        this.complexTypeInfo = complexTypes;
        for (Map.Entry<String, InMemoryEntityInfo<?>> e : eis.entrySet()) {
            this.entitySetNameByClass.put(e.getValue().entityClass, e.getKey());
        }
        this.flatten = flatten;
    }

    @Override
    public EdmDataServices.Builder generateEdm(EdmDecorator decorator) {
        ArrayList<EdmSchema.Builder> schemas = new ArrayList<EdmSchema.Builder>();
        ArrayList<EdmEntityContainer.Builder> containers = new ArrayList<EdmEntityContainer.Builder>();
        ArrayList<EdmAssociation.Builder> associations = new ArrayList<EdmAssociation.Builder>();
        ArrayList<EdmAssociationSet.Builder> associationSets = new ArrayList<EdmAssociationSet.Builder>();
        this.createComplexTypes(decorator, this.edmComplexTypes);
        this.createStructuralEntities(decorator);
        this.createNavigationProperties(associations, associationSets, this.entityTypesByName, this.entitySetsByName, this.entitySetNameByClass);
        EdmEntityContainer.Builder container = EdmEntityContainer.newBuilder().setName(this.containerName).setIsDefault(true).addEntitySets(this.entitySetsByName.values()).addAssociationSets(associationSets);
        containers.add(container);
        EdmSchema.Builder schema = EdmSchema.newBuilder().setNamespace(this.namespace).addEntityTypes(this.entityTypesByName.values()).addAssociations(associations).addEntityContainers(containers).addComplexTypes(this.edmComplexTypes);
        this.addFunctions(schema, container);
        if (decorator != null) {
            schema.setDocumentation(decorator.getDocumentationForSchema(this.namespace));
            schema.setAnnotations(decorator.getAnnotationsForSchema(this.namespace));
        }
        schemas.add(schema);
        EdmDataServices.Builder rt = EdmDataServices.newBuilder().addSchemas(schemas);
        if (decorator != null) {
            rt.addNamespaces(decorator.getNamespaces());
        }
        return rt;
    }

    private void createComplexTypes(EdmDecorator decorator, List<EdmComplexType.Builder> complexTypes) {
        for (String complexTypeName : this.complexTypeInfo.keySet()) {
            InMemoryEdmGenerator.dump("edm complexType: " + complexTypeName);
            InMemoryComplexTypeInfo<?> typeInfo = this.complexTypeInfo.get(complexTypeName);
            ArrayList<EdmProperty.Builder> properties = new ArrayList<EdmProperty.Builder>();
            properties.addAll(this.toEdmProperties(decorator, typeInfo.propertyModel, new String[0], complexTypeName));
            EdmComplexType.Builder typeBuilder = (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace(this.namespace)).setName(typeInfo.typeName)).addProperties(properties);
            if (decorator != null) {
                typeBuilder.setDocumentation(decorator.getDocumentationForEntityType(this.namespace, complexTypeName));
                typeBuilder.setAnnotations(decorator.getAnnotationsForEntityType(this.namespace, complexTypeName));
            }
            complexTypes.add(typeBuilder);
        }
    }

    private void createStructuralEntities(EdmDecorator decorator) {
        for (String entitySetName : this.eis.keySet()) {
            InMemoryEntityInfo<?> entityInfo = this.eis.get(entitySetName);
            EdmEntityType.Builder eet = this.entityTypesByName.get(entityInfo.entityTypeName);
            if (eet == null) {
                eet = this.createStructuralType(decorator, entityInfo);
            }
            EdmEntitySet.Builder ees = EdmEntitySet.newBuilder().setName(entitySetName).setEntityType(eet);
            this.entitySetsByName.put(ees.getName(), ees);
        }
    }

    protected InMemoryEntityInfo<?> findEntityInfoForClass(Class<?> clazz) {
        for (InMemoryEntityInfo<?> typeInfo : this.eis.values()) {
            if (!typeInfo.entityClass.equals(clazz)) continue;
            return typeInfo;
        }
        return null;
    }

    protected InMemoryEntityInfo<?> getUnregisteredEntityInfo(Class<?> clazz, InMemoryEntityInfo<?> subclass) {
        InMemoryEntityInfo<Object> ei = this.unregisteredEntityInfo.get(clazz);
        if (ei == null) {
            ei = new InMemoryEntityInfo();
            ei.entityTypeName = clazz.getSimpleName();
            ei.keys = subclass.keys;
            ei.entityClass = clazz;
            ei.properties = new EnumsAsStringsPropertyModelDelegate(new BeanBasedPropertyModel(ei.entityClass, this.flatten));
        }
        return ei;
    }

    protected EdmEntityType.Builder createStructuralType(EdmDecorator decorator, InMemoryEntityInfo<?> entityInfo) {
        ArrayList<EdmProperty.Builder> properties = new ArrayList<EdmProperty.Builder>();
        Class<?> superClass = this.flatten ? null : entityInfo.getSuperClass();
        properties.addAll(this.toEdmProperties(decorator, entityInfo.properties, entityInfo.keys, entityInfo.entityTypeName));
        EdmEntityType.Builder eet = (EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace(this.namespace)).setName(entityInfo.entityTypeName)).setHasStream(entityInfo.hasStream).addProperties(properties);
        if (superClass == null) {
            eet.addKeys(entityInfo.keys);
        }
        if (decorator != null) {
            eet.setDocumentation(decorator.getDocumentationForEntityType(this.namespace, entityInfo.entityTypeName));
            eet.setAnnotations(decorator.getAnnotationsForEntityType(this.namespace, entityInfo.entityTypeName));
        }
        this.entityTypesByName.put(eet.getName(), eet);
        EdmEntityType.Builder superType = null;
        if (!this.flatten && entityInfo.entityClass.getSuperclass() != null && !entityInfo.entityClass.getSuperclass().equals(Object.class)) {
            InMemoryEntityInfo<?> entityInfoSuper = this.findEntityInfoForClass(entityInfo.entityClass.getSuperclass());
            if (entityInfoSuper == null) {
                entityInfoSuper = this.getUnregisteredEntityInfo(entityInfo.entityClass.getSuperclass(), entityInfo);
            }
            if ((superType = this.entityTypesByName.get(entityInfoSuper.entityTypeName)) == null) {
                superType = this.createStructuralType(decorator, entityInfoSuper);
            }
        }
        eet.setBaseType(superType);
        return eet;
    }

    protected void createNavigationProperties(List<EdmAssociation.Builder> associations, List<EdmAssociationSet.Builder> associationSets, Map<String, EdmEntityType.Builder> entityTypesByName, Map<String, EdmEntitySet.Builder> entitySetByName, Map<Class<?>, String> entityNameByClass) {
        for (String entitySetName : this.eis.keySet()) {
            InMemoryEntityInfo<?> ei = this.eis.get(entitySetName);
            Class clazz1 = ei.entityClass;
            this.generateToOneNavProperties(associations, associationSets, entityTypesByName, entitySetByName, entityNameByClass, ei.entityTypeName, ei);
            this.generateToManyNavProperties(associations, associationSets, entityTypesByName, entitySetByName, entityNameByClass, ei.entityTypeName, ei, clazz1);
        }
    }

    protected void generateToOneNavProperties(List<EdmAssociation.Builder> associations, List<EdmAssociationSet.Builder> associationSets, Map<String, EdmEntityType.Builder> entityTypesByName, Map<String, EdmEntitySet.Builder> entitySetByName, Map<Class<?>, String> entityNameByClass, String entityTypeName, InMemoryEntityInfo<?> ei) {
        Iterable<String> propertyNames = this.flatten ? ei.properties.getPropertyNames() : ei.properties.getDeclaredPropertyNames();
        for (String assocProp : propertyNames) {
            InMemoryEntityInfo<?> ei2;
            EdmEntityType.Builder eet1 = entityTypesByName.get(entityTypeName);
            Class<?> clazz2 = ei.properties.getPropertyType(assocProp);
            String entitySetName2 = entityNameByClass.get(clazz2);
            InMemoryEntityInfo<?> inMemoryEntityInfo = ei2 = entitySetName2 == null ? null : this.eis.get(entitySetName2);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "genToOnNavProp {0} - {1}({2}) eetName2: {3}", new Object[]{entityTypeName, assocProp, clazz2, entitySetName2});
            }
            if (eet1.findProperty(assocProp) != null || ei2 == null) continue;
            EdmEntityType.Builder eet2 = entityTypesByName.get(ei2.entityTypeName);
            EdmMultiplicity m1 = EdmMultiplicity.MANY;
            EdmMultiplicity m2 = EdmMultiplicity.ONE;
            String assocName = String.format("FK_%s_%s", eet1.getName(), eet2.getName());
            EdmAssociationEnd.Builder assocEnd1 = EdmAssociationEnd.newBuilder().setRole(eet1.getName()).setType(eet1).setMultiplicity(m1);
            String assocEnd2Name = eet2.getName();
            if (assocEnd2Name.equals(eet1.getName())) {
                assocEnd2Name = assocEnd2Name + "1";
            }
            EdmAssociationEnd.Builder assocEnd2 = EdmAssociationEnd.newBuilder().setRole(assocEnd2Name).setType(eet2).setMultiplicity(m2);
            EdmAssociation.Builder assoc = EdmAssociation.newBuilder().setNamespace(this.namespace).setName(assocName).setEnds(assocEnd1, assocEnd2);
            associations.add(assoc);
            EdmEntitySet.Builder ees1 = entitySetByName.get(eet1.getName());
            EdmEntitySet.Builder ees2 = entitySetByName.get(eet2.getName());
            if (ees1 == null) {
                ees1 = this.getEntitySetForEntityTypeName(eet1.getName());
            }
            if (ees2 == null) {
                ees2 = this.getEntitySetForEntityTypeName(eet2.getName());
            }
            EdmAssociationSet.Builder eas = EdmAssociationSet.newBuilder().setName(assocName).setAssociation(assoc).setEnds(EdmAssociationSetEnd.newBuilder().setRole(assocEnd1).setEntitySet(ees1), EdmAssociationSetEnd.newBuilder().setRole(assocEnd2).setEntitySet(ees2));
            associationSets.add(eas);
            EdmNavigationProperty.Builder np = EdmNavigationProperty.newBuilder(assocProp).setRelationship(assoc).setFromTo(assoc.getEnd1(), assoc.getEnd2());
            eet1.addNavigationProperties(np);
        }
    }

    protected EdmEntitySet.Builder getEntitySetForEntityTypeName(String entityTypeName) {
        for (InMemoryEntityInfo<?> ti : this.eis.values()) {
            if (!ti.entityTypeName.equals(entityTypeName)) continue;
            return this.entitySetsByName.get(ti.entitySetName);
        }
        return null;
    }

    protected void generateToManyNavProperties(List<EdmAssociation.Builder> associations, List<EdmAssociationSet.Builder> associationSets, Map<String, EdmEntityType.Builder> entityTypesByName, Map<String, EdmEntitySet.Builder> entitySetByName, Map<Class<?>, String> entityNameByClass, String entityTypeName, InMemoryEntityInfo<?> ei, Class<?> clazz1) {
        Iterable<String> collectionNames = this.flatten ? ei.properties.getCollectionNames() : ei.properties.getDeclaredCollectionNames();
        for (String assocProp : collectionNames) {
            InMemoryEntityInfo<?> class2eiInfo;
            final EdmEntityType.Builder eet1 = entityTypesByName.get(entityTypeName);
            Class<?> clazz2 = ei.properties.getCollectionElementType(assocProp);
            String entitySetName2 = entityNameByClass.get(clazz2);
            InMemoryEntityInfo<?> inMemoryEntityInfo = class2eiInfo = entitySetName2 == null ? null : this.eis.get(entitySetName2);
            if (class2eiInfo == null) continue;
            final EdmEntityType.Builder eet2 = entityTypesByName.get(class2eiInfo.entityTypeName);
            try {
                EdmAssociationEnd.Builder toRole;
                EdmAssociationEnd.Builder fromRole;
                EdmAssociation.Builder assoc = (EdmAssociation.Builder)Enumerable.create(associations).firstOrNull((Predicate1)new Predicate1<EdmAssociation.Builder>(){

                    public boolean apply(EdmAssociation.Builder input) {
                        return input.getEnd1().getType().equals(eet2) && input.getEnd2().getType().equals(eet1);
                    }
                });
                if (assoc == null) {
                    EdmMultiplicity m1 = EdmMultiplicity.ZERO_TO_ONE;
                    EdmMultiplicity m2 = EdmMultiplicity.MANY;
                    for (String tmp : class2eiInfo.properties.getCollectionNames()) {
                        if (clazz1 != class2eiInfo.properties.getCollectionElementType(tmp)) continue;
                        m1 = EdmMultiplicity.MANY;
                        m2 = EdmMultiplicity.MANY;
                        break;
                    }
                    String assocName = String.format("FK_%s_%s", eet1.getName(), eet2.getName());
                    EdmAssociationEnd.Builder assocEnd1 = EdmAssociationEnd.newBuilder().setRole(eet1.getName()).setType(eet1).setMultiplicity(m1);
                    String assocEnd2Name = eet2.getName();
                    if (assocEnd2Name.equals(eet1.getName())) {
                        assocEnd2Name = assocEnd2Name + "1";
                    }
                    EdmAssociationEnd.Builder assocEnd2 = EdmAssociationEnd.newBuilder().setRole(assocEnd2Name).setType(eet2).setMultiplicity(m2);
                    assoc = EdmAssociation.newBuilder().setNamespace(this.namespace).setName(assocName).setEnds(assocEnd1, assocEnd2);
                    associations.add(assoc);
                    EdmEntitySet.Builder ees1 = entitySetByName.get(eet1.getName());
                    EdmEntitySet.Builder ees2 = entitySetByName.get(eet2.getName());
                    if (ees1 == null) {
                        ees1 = this.getEntitySetForEntityTypeName(eet1.getName());
                    }
                    if (ees2 == null) {
                        ees2 = this.getEntitySetForEntityTypeName(eet2.getName());
                    }
                    EdmAssociationSet.Builder eas = EdmAssociationSet.newBuilder().setName(assocName).setAssociation(assoc).setEnds(EdmAssociationSetEnd.newBuilder().setRole(assocEnd1).setEntitySet(ees1), EdmAssociationSetEnd.newBuilder().setRole(assocEnd2).setEntitySet(ees2));
                    associationSets.add(eas);
                    fromRole = assoc.getEnd1();
                    toRole = assoc.getEnd2();
                } else {
                    fromRole = assoc.getEnd2();
                    toRole = assoc.getEnd1();
                }
                EdmNavigationProperty.Builder np = EdmNavigationProperty.newBuilder(assocProp).setRelationship(assoc).setFromTo(fromRole, toRole);
                eet1.addNavigationProperties(np);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Exception building Edm associations: " + entityTypeName + "," + clazz1 + " set: " + ei.entitySetName + " -> " + assocProp, e);
            }
        }
    }

    protected EdmComplexType.Builder findComplexTypeBuilder(String typeName) {
        String fqName = this.namespace + "." + typeName;
        for (EdmComplexType.Builder builder : this.edmComplexTypes) {
            if (!builder.getFullyQualifiedTypeName().equals(fqName)) continue;
            return builder;
        }
        return null;
    }

    protected EdmComplexType.Builder findComplexTypeForClass(Class<?> clazz) {
        for (InMemoryComplexTypeInfo<?> typeInfo : this.complexTypeInfo.values()) {
            if (!typeInfo.entityClass.equals(clazz)) continue;
            return this.findComplexTypeBuilder(typeInfo.typeName);
        }
        return null;
    }

    private Collection<EdmProperty.Builder> toEdmProperties(EdmDecorator decorator, PropertyModel model, String[] keys, String structuralTypename) {
        EdmProperty.Builder ep;
        EdmType.Builder typeBuilder;
        EdmSimpleType<?> type;
        ArrayList<EdmProperty.Builder> rt = new ArrayList<EdmProperty.Builder>();
        Set keySet = Enumerable.create((Object[])keys).toSet();
        Iterable<String> propertyNames = this.flatten ? model.getPropertyNames() : model.getDeclaredPropertyNames();
        for (String propName : propertyNames) {
            InMemoryEdmGenerator.dump("edm property: " + propName);
            Class<?> propType = model.getPropertyType(propName);
            type = this.typeMapping.findEdmType(propType);
            typeBuilder = null;
            if (type == null) {
                typeBuilder = this.findComplexTypeForClass(propType);
            }
            InMemoryEdmGenerator.dump("edm property: " + propName + " type: " + type + " builder: " + typeBuilder);
            if (type == null && typeBuilder == null) continue;
            ep = EdmProperty.newBuilder(propName).setNullable(!keySet.contains(propName));
            if (type != null) {
                ep.setType(type);
            } else {
                ep.setType(typeBuilder);
            }
            if (decorator != null) {
                ep.setDocumentation(decorator.getDocumentationForProperty(this.namespace, structuralTypename, propName));
                ep.setAnnotations(decorator.getAnnotationsForProperty(this.namespace, structuralTypename, propName));
            }
            rt.add(ep);
        }
        propertyNames = this.flatten ? model.getCollectionNames() : model.getDeclaredCollectionNames();
        for (String collectionPropName : propertyNames) {
            Class<?> collectionElementType = model.getCollectionElementType(collectionPropName);
            if (this.entitySetNameByClass.get(collectionElementType) != null) continue;
            type = this.typeMapping.findEdmType(collectionElementType);
            typeBuilder = null;
            typeBuilder = type == null ? this.findComplexTypeForClass(collectionElementType) : EdmSimpleType.newBuilder(type);
            if (typeBuilder == null) continue;
            ep = EdmProperty.newBuilder(collectionPropName).setNullable(true).setCollectionKind(EdmProperty.CollectionKind.Collection).setType(typeBuilder);
            if (decorator != null) {
                ep.setDocumentation(decorator.getDocumentationForProperty(this.namespace, structuralTypename, collectionPropName));
                ep.setAnnotations(decorator.getAnnotationsForProperty(this.namespace, structuralTypename, collectionPropName));
            }
            rt.add(ep);
        }
        return rt;
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected void addFunctions(EdmSchema.Builder schema, EdmEntityContainer.Builder container) {
    }
}

