/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import org.odata4j.core.ImmutableList;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmItem;

public class EdmAssociationSetEnd
extends EdmItem {
    private final EdmAssociationEnd role;
    private final EdmEntitySet entitySet;

    private EdmAssociationSetEnd(EdmAssociationEnd role, EdmEntitySet entitySet, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annots, ImmutableList<EdmAnnotation<?>> annotElements) {
        super(doc, annots, annotElements);
        this.role = role;
        this.entitySet = entitySet;
    }

    public EdmAssociationEnd getRole() {
        return this.role;
    }

    public EdmEntitySet getEntitySet() {
        return this.entitySet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(EdmAssociationSetEnd associationSetEnd, EdmItem.BuilderContext context) {
        return context.newBuilder(associationSetEnd, new Builder());
    }

    public static class Builder
    extends EdmItem.Builder<EdmAssociationSetEnd, Builder> {
        private EdmAssociationEnd.Builder role;
        private String roleName;
        private EdmEntitySet.Builder entitySet;
        private String entitySetName;

        @Override
        Builder newBuilder(EdmAssociationSetEnd associationSetEnd, EdmItem.BuilderContext context) {
            this.role = EdmAssociationEnd.newBuilder(associationSetEnd.role, context);
            this.entitySet = EdmEntitySet.newBuilder(associationSetEnd.entitySet, context);
            return this;
        }

        public Builder setRole(EdmAssociationEnd.Builder role) {
            this.role = role;
            return this;
        }

        public Builder setEntitySet(EdmEntitySet.Builder entitySet) {
            this.entitySet = entitySet;
            return this;
        }

        public EdmAssociationSetEnd build() {
            return new EdmAssociationSetEnd(this.role.build(), this.entitySet.build(), this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()), ImmutableList.copyOf(this.getAnnotationElements()));
        }

        public String getRoleName() {
            return this.roleName;
        }

        public Builder setRoleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public Builder setEntitySetName(String entitySetName) {
            this.entitySetName = entitySetName;
            return this;
        }

        public String getEntitySetName() {
            return this.entitySetName;
        }
    }
}

