<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1756708 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_alias.xml.meta">

<name>mod_alias</name>
<description>Permet d'atteindre différentes parties du système de
fichiers depuis l'arborescence des documents du site web, ainsi que la
redirection d'URL</description>
<status>Base</status>
<sourcefile>mod_alias.c</sourcefile>
<identifier>alias_module</identifier>

<summary>
    <p>Les directives fournies par ce module permettent de manipuler et
    de contrôler les URLs à l'arrivée des requêtes sur le serveur. Les
    directives <directive module="mod_alias">Alias</directive> et
    <directive module="mod_alias">ScriptAlias</directive> permettent de
    faire correspondre des URLs avec des chemins du système de fichiers.
    Ceci permet de servir des contenus qui ne sont pas situés dans
    l'arborescence de <directive
    module="core">DocumentRoot</directive> comme s'ils y étaient
    réellement. La directive <directive
    module="mod_alias">ScriptAlias</directive> a pour effet
    supplémentaire de marquer le répertoire cible comme conteneur de
    scripts CGI.</p>

    <p>Les directives <directive module="mod_alias">Redirect</directive>
    indiquent aux clients qu'ils doivent effectuer une nouvelle requête
    avec une URL différente. Elles sont souvent utilisées lorsqu'une
    ressource a été déplacée.</p>

    <p>Lorsque les directives <directive
    module="mod_alias">Alias</directive>, <directive
    module="mod_alias">ScriptAlias</directive> ou <directive
    module="mod_alias">Redirect</directive> sont définies au sein d'une
    section <directive type="section" module="core">Location</directive>
    ou <directive type="section"
    module="core">LocationMatch</directive>, vous pouvez utiliser la <a
    href="../expr.html">syntaxe des expressions</a> pour manipuler l'URL
    ou le chemin de destination.
	</p>

    <p><module>mod_alias</module> est conçu pour traiter des tâches
    simples de manipulation d'URL. Pour des tâches plus complexes comme
    la manipulation des chaînes d'arguments des requêtes, utilisez
    plutôt les outils fournis par le module <module>mod_rewrite</module></p>

</summary>

<seealso><module>mod_rewrite</module></seealso> <seealso><a
href="../urlmapping.html">Mise en correspondance des URLs avec le
système de fichiers</a></seealso>

<section id="order"><title>Chronologie du traitement</title>

    <p>Les alias et redirections apparaissant dans différents contextes
    sont traités comme les autres directives en respectant les <a
    href="../sections.html#mergin">règles de fusion</a> standards. Par
    contre, ils sont traités selon une chronologie particulière
    lorsqu'ils apparaissent dans le même contexte (par exemple, dans la
    même section <directive type="section"
    module="core">VirtualHost</directive>).</p>

    <p>Premièrement, toutes les redirections sont traitées avant les
    alias, et ainsi, une requête qui correspond à une directive
    <directive module="mod_alias">Redirect</directive> ou <directive
    module="mod_alias">RedirectMatch</directive> ne se verra jamais
    appliquer d'alias. Deuxièmement, les alias et redirections sont
    traités selon l'ordre dans lequel ils apparaissent dans le fichier
    de configuration, seule la première correspondance étant prise en
    compte.</p>

    <p>Ainsi, lorsqu'une ou plusieurs de ces directives s'appliquent au
    même sous-répertoire, vous devez classer les chemins du plus précis
    au moins précis afin que toutes les directives puissent
    éventuellement s'appliquer, comme dans l'exemple suivant :</p>

    <highlight language="config">
Alias "/foo/bar" "/baz"
Alias "/foo" "/gaq"
    </highlight>

    <p>Si l'ordre des directives était inversé, la directive <directive
    module="mod_alias">Alias</directive> ayant pour argument
    <code>/foo</code> serait toujours appliquée avant la directive
    <directive module="mod_alias">Alias</directive> ayant pour argument
    <code>/foo/bar</code>, et cette dernière serait toujours
    ignorée.</p>

    <p>La définition de directives <directive
    module="mod_alias">Alias</directive>, <directive
    module="mod_alias">ScriptAlias</directive> ou <directive
    module="mod_alias">Redirect</directive> au sein de sections
    <directive type="section" module="core">Location</directive> ou
    <directive type="section" module="core">LocationMatch</directive>
    l'emporte sur d'autres définitions éventuelles de ces mêmes
    directives au niveau de la configuration générale du serveur.</p>

</section>

<directivesynopsis>
<name>Alias</name>
<description>Met en correspondance des URLs avec des chemins du système
de fichiers</description>
<syntax>Alias [<var>chemin URL</var>]
<var>chemin fichier</var>|<var>chemin répertoire</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>

    <p>La directive <directive>Alias</directive> permet de stocker des
    documents (destinés à être servis) dans des zones du système de
    fichiers situées en dehors de l'arborescence du site web <directive
    module="core">DocumentRoot</directive>. Les URLs dont le chemin
    (décodé avec caractères %) commence par <var>chemin URL</var> seront
    mises en correspondance avec des fichiers locaux dont le chemin
    commence par <var>chemin répertoire</var>. Le <var>chemin URL</var>
    est sensible à la casse, même sur les systèmes de fichiers
    insensibles à la casse.</p>

    <highlight language="config">
      Alias "/image" "/ftp/pub/image"
    </highlight>

    <p>Une requête pour <code>http://example.com/image/foo.gif</code> fera
    renvoyer par le serveur le fichier
    <code>/ftp/pub/image/foo.gif</code>. Seuls les éléments de chemin
    complets sont testés ; ainsi l'alias précédent ne conviendra pas
    pour une requête du style <code>http://example.com/imagefoo.gif</code>.
    Pour des mises en correspondance plus complexes faisant intervenir
    les expressions rationnelles, veuillez vous reporter à la directive
    <directive module="mod_alias">AliasMatch</directive>.</p>

    <p>Notez que si vous ajoutez un slash de fin au <var>chemin
    URL</var>, vous devrez aussi ajouter un slash de fin au chemin de la
    requête. Autrement dit, si vous définissez</p>

    <highlight language="config">
      Alias "/icons/" "/usr/local/apache/icons/"
    </highlight>

    <p>l'alias précédent ne s'appliquera pas à l'URL
    <code>/icons</code> à cause de l'absence du slash final. Ainsi, si
    le slash final est absent du <var>chemin de l'URL</var>, il doit
    aussi l'être du <var>chemin du fichier</var>.</p>

    <p>Notez qu'il pourra s'avérer nécessaire de définir des sections
    <directive type="section" module="core">Directory</directive>
    supplémentaires qui couvriront la  <em>destination</em> des alias.
    Le traitement des alias intervenant avant le traitement des sections
    <directive type="section" module="core">Directory</directive>,
    seules les cibles des alias sont affectées (Notez cependant
    que les sections <directive type="section"
    module="core">Location</directive> sont traitées avant les alias, et
    s'appliqueront donc).</p>

    <p>En particulier, si vous créez un alias ayant pour cible un
    répertoire situé en dehors de l'arborescence de votre site web
    <directive module="core">DocumentRoot</directive>, vous devrez
    probablement permettre explicitement l'accès à ce répertoire.</p>

    <highlight language="config">
Alias "/image" "/ftp/pub/image"
&lt;Directory "/ftp/pub/image"&gt;
    Require all granted
&lt;/Directory&gt;
    </highlight>

    <p>Le nombre de slashes dans le paramètre <var>chemin URL</var> doit
    correspondre au nombre de slashes dans le chemin URL de la requête.</p>

    <p>Si la directive <directive>Alias</directive> est définie au sein
    d'une section <directive type="section"
    module="core">Location</directive> ou <directive type="section"
    module="core">LocationMatch</directive>, <var>chemin URL</var> est
    omis et <var>chemin fichier</var> est interprété en utilisant la <a
    href="../expr.html">syntaxe des expressions</a>.<br />
    Cette syntaxe est disponible à partir de la version 2.4.19 du
    serveur HTTP Apache.</p>

    <highlight language="config">
&lt;Location "/image"&gt;
    Alias "/ftp/pub/image"
&lt;/Location&gt;
&lt;LocationMatch "/error/(?&lt;NUMBER&gt;[0-9]+)"&gt;
    Alias "/usr/local/apache/errors/%{env:MATCH_NUMBER}.html"
&lt;/LocationMatch&gt;
    </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AliasMatch</name>
<description>Met en correspondance des URLs avec le système de fichiers
en faisant intervenir les expressions rationnelles</description>
<syntax>AliasMatch <var>regex</var>
<var>chemin fichier</var>|<var>chemin répertoire</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive est identique à la directive <directive
    module="mod_alias">Alias</directive>, mais fait appel aux <glossary
    ref="regex">expressions rationnelles</glossary>, à la place d'une
    simple mise en correspondance de préfixe. L'expression rationnelle
    fournie est mise en correspondance avec le chemin URL, et si elle
    correspond, le serveur va substituer toute partie de chemin
    correspondant à l'expression entre parenthèses dans la chaîne
    fournie et l'utiliser comme nom de fichier.
    Par exemple, pour activer le répertoire <code>/icons</code>, on peut
    utiliser :</p>

    <highlight language="config">
      AliasMatch "^/icons(.*)" "/usr/local/apache/icons$1$2"
    </highlight>

    <p>Toute la puissance des <glossary ref="regex">expressions
    rationnelles</glossary> peut être mise à contribution. Par exemple,
    il est possible de construire un alias avec un modèle de chemin URL
    insensible à la casse :</p>

    <highlight language="config">
      AliasMatch "(?i)^/image(.*)" "/ftp/pub/image$1"
    </highlight>

    <p>Il existe une différence subtile entre <directive
    module="mod_alias">Alias</directive> et <directive
    module="mod_alias">AliasMatch</directive> : <directive
    module="mod_alias">Alias</directive> copie automatiquement toute
    portion supplémentaire de l'URI située après la partie du modèle qui
    correspond, à la fin du chemin du fichier de la partie droite, alors
    que <directive module="mod_alias">AliasMatch</directive> ne le fait
    pas. Cela signifie qu'il sera préférable dans la plupart des cas de
    comparer l'expression rationnelle du modèle à la totalité de l'URI
    de la requête, et d'utiliser les substitutions dans la partie
    droite.</p>

    <p>En d'autres termes, le remplacement d'<directive
    module="mod_alias">Alias</directive> par <directive
    module="mod_alias">AliasMatch</directive> ne produira pas le même
    résultat. Au minimum, vous devez ajouter <code>^</code> au début de
    l'expression rationnelle, <code>(.*)$</code> à sa fin et
    <code>$1</code> à la fin de la chaîne de remplacement.</p>

    <p>Par exemple, supposons que nous voulions reformuler cet alias
    avec AliasMatch :</p>

    <highlight language="config">
      Alias "/image/" "/ftp/pub/image/"
    </highlight>

    <p>Le simple remplacement d'Alias par AliasMatch ne produira pas le
    même résultat. Ainsi, ce qui suit va rediriger toutes les requêtes
    qui contiennent /image/ vers /ftp/pub/image/ :</p>

    <highlight language="config">
      AliasMatch "/image/" "/ftp/pub/image/"
    </highlight>

    <p>Voici la directive AliasMatch qui produira le même résultat que
    la directive Alias ci-dessus :</p>

    <highlight language="config">
      AliasMatch "^/image/(.*)$" "/ftp/pub/image/$1"
    </highlight>

    <p>Bien entendu, il n'y a aucune raison d'utiliser <directive
    module="mod_alias">AliasMatch</directive> dans le cas où <directive
    module="mod_alias">Alias</directive> suffit. <directive
    module="mod_alias">AliasMatch</directive> vous permet d'effectuer
    des choses beaucoup plus sophistiquées. Par exemple, vous pouvez
    servir différentes sortes de fichiers à partir de répertoires
    différents :</p>

    <highlight language="config">
      AliasMatch "^/image/(.*)\.jpg$" "/fichiers/jpg.images/$1.jpg"
      AliasMatch "^/image/(.*)\.gif$" "/fichiers/gif.images/$1.gif"
    </highlight>

    <p>Les éventuels slashes de tête multiples seront supprimés par le
    serveur avant que les directives de ce module n'effectuent des
    comparaisons avec le chemin URL de la requête.
    </p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>Redirect</name>
<description>Envoie une redirection externe demandant au client
d'effectuer une autre requête avec une URL différente</description>
<syntax>Redirect [<var>état</var>] [<var>URL-path</var>]
<var>URL</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>La directive <directive>Redirect</directive> permet de faire correspondre
    une ancienne URL à une nouvelle en demandant au client d'aller chercher la
    ressource à une autre localisation.</p>

    <p>L'ancien <em>URL-path</em> est un chemin sensible à la casse
    (décodé à l'aide de caractères %) commençant par un slash. Les
    chemins relatifs ne sont pas autorisés.</p>

    <p>La nouvelle <em>URL</em>
    peut être une URL absolue commençant par un protocole et un nom
    d'hôte, mais on peut aussi utiliser un chemin URL commençant par un
    slash, auquel cas le protocole et le nom d'hôte du serveur local
    seront ajoutés.</p>

    <p>Ensuite, toute requête commençant par <em>URL-path</em> va
    renvoyer une redirection au client vers l'<em>URL</em> cible. Tout
    élément de chemin supplémentaire situé en aval du <em>URL-path</em> sera
    ajouté à l'URL cible.</p>

    <highlight language="config">
# Redirige vers une URL sur un serveur différent
Redirect "/service" "http://foo2.example.com/service"

# Redirige vers une URL sur le même serveur
Redirect "/one" "/two"
    </highlight>

    <p>Si le client effectue une requête pour l'URL
    <code>http://example.com/service/foo.txt</code>, il lui sera demandé
    d'en effectuer une autre pour l'URL
    <code>http://foo2.example.com/service/foo.txt</code>. Ceci concerne
    les requêtes avec paramètres <code>GET</code>, comme
    <code>http://example.com/service/foo.pl?q=23&amp;a=42</code>, qui
    seront redirigées vers
    <code>http://foo2.example.com/service/foo.pl?q=23&amp;a=42</code>.
    Notez que les <code>POST</code>s seront ignorés.<br />
    Seuls les
    éléments de chemin complets sont testés, si bien que l'exemple
    précédent ne s'appliquera pas à l'URL
    <code>http://example.com/servicefoo.txt</code>. Pour des mises en
    correspondance plus complexes utilisant la <a
    href="../expr.html">syntaxe des expressions</a>, ne spécifiez pas
    d'argument <var>URL-path</var> comme décrit ci-dessous. En outre,
    pour une mise en correspondance en utilisant les expressions
    rationnelles, veuillez vous reporter à la directive <directive
    module="mod_alias">RedirectMatch</directive>.</p>


    <note><title>Note</title>
    <p>Les directives <directive>Redirect</directive> ont priorité sur les
    directives <directive module="mod_alias">Alias</directive> et <directive
    module="mod_alias">ScriptAlias</directive>, quel que soit leur ordre
    d'apparition dans le fichier de configuration. Les directives
    <directive>Redirect</directive> définies au sein d'une section Location
    l'emportent sur les directives <directive>Redirect</directive> et <directive
    module="mod_alias">Alias</directive> comportant un argument
    <var>URL-path</var>.</p></note>

    <p>Si aucun argument <var>état</var> n'est spécifié, la
    redirection sera temporaire (code HTTP 302). Le client est alors
    informé que la ressource a été temporairement déplacée. On peut
    utiliser l'argument <var>état</var> pour renvoyer d'autres codes HTTP :</p>

    <dl>
      <dt>permanent</dt>

      <dd>Renvoie un code de redirection permanente (301), indiquant
      que la ressource a été définitivement déplacée.</dd>

      <dt>temp</dt>

      <dd>Renvoie un code de redirection temporaire (302). C'est le
      comportement par défaut.</dd>

      <dt>seeother</dt>

      <dd>Renvoie un code "See Other" (303) indiquant que la ressource
      a été remplacée par une autre.</dd>

      <dt>gone</dt>

      <dd>Renvoie un code "Gone" (410) indiquant que la ressource a
      été définitivement supprimée. Lorsque
      ce code est utilisé, on ne
      doit pas utiliser l'argument <var>URL</var>.</dd>
    </dl>

    <p>On peut renvoyer d'autres codes en spécifiant le code
    numérique comme valeur de l'argument of <var>état</var>.
    Si le code est compris entre 300 et 399, l'argument
    <var>URL</var> doit être présent. Si le code
    n'est <em>pas</em> compris entre 300 et 399, l'argument
    <var>URL</var> ne doit pas apparaître. Le code doit être un code
    HTTP valide, connu du serveur HTTP Apache (voir la
    fonction <code>send_error_response</code> dans
    http_protocol.c).</p>

    <highlight language="config">
Redirect permanent "/one" "http://example.com/two"
Redirect 303 "/three" "http://example.com/other"
    </highlight>

    <p>Si une directive <directive>Redirect</directive> est définie au
    sein d'une section <directive type="section"
    module="core">Location</directive> ou <directive type="section"
    module="core">LocationMatch</directive> et si l'argument <var>URL-path</var> est omis, l'argument <var>URL</var> sera interprété en
    utilisant la <a href="../expr.html">syntaxe des expressions</a>.<br />
    Cette syntaxe est disponible à partir de la version 2.4.19 du
    serveur HTTP Apache.</p>

    <highlight language="config">
&lt;Location "/one"&gt;
    Redirect permanent "http://example.com/two"
&lt;/Location&gt;
&lt;Location "/three"&gt;
    Redirect 303 "http://example.com/other"
&lt;/Location&gt;
&lt;LocationMatch "/error/(?&lt;NUMBER&gt;[0-9]+)"&gt;
    Redirect permanent "http://example.com/errors/%{env:MATCH_NUMBER}.html"
&lt;/LocationMatch&gt;
    </highlight>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>RedirectMatch</name>
<description>Envoie une redirection externe faisant appel aux
expressions rationnelles pour la mise en correspondance de l'URL
courante</description>
<syntax>RedirectMatch [<var>état</var>] <var>regex</var>
<var>URL</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>Cette directive est identique à la directive <directive
    module="mod_alias">Redirect</directive>, mais fait appel aux
    <glossary ref="regex">expressions rationnelles</glossary>, à la
    place d'une simple mise en correspondance de préfixe. L'expression
    rationnelle fournie est mise en correspondance avec le chemin URL,
    et si elle correspond, le serveur va substituer toute partie de
    chemin correspondante entre parenthèses dans la chaîne spécifiée et
    l'utiliser comme nom de fichier. Par exemple, pour rediriger tous
    les fichiers GIF vers les fichiers JPEG de même nom sur un autre
    serveur, on peut utiliser :</p>

    <highlight language="config">
      RedirectMatch "(.*)\.gif$" "http://autre.example.com$1.jpg"
    </highlight>

    <p>Les remarques à propos de la différence entre <directive
    module="mod_alias">Alias</directive> et <directive
    module="mod_alias">AliasMatch</directive> s'appliquent aussi à la
    différence entre les directives <directive
    module="mod_alias">Redirect</directive> et <directive
    module="mod_alias">RedirectMatch</directive>. Voir la directive
    <directive module="mod_alias">AliasMatch</directive> pour plus de
    détails.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>RedirectTemp</name>
<description>Envoie une redirection externe temporaire demandant au
client d'effectuer une nouvelle requête avec une URL
différente</description>
<syntax>RedirectTemp <var>chemin URL</var> <var>URL</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>Cette directive informe le client que la redirection n'est
    que temporaire (code 302). Son comportement est exactement le même
    que celui de <code>Redirect temp</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RedirectPermanent</name>
<description>Envoie une redirection externe permanente demandant au
client d'effectuer une nouvelle requête avec une URL
différente</description>
<syntax>RedirectPermanent <var>chemin URL</var> <var>URL</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context><context>.htaccess</context></contextlist>
<override>FileInfo</override>

<usage>
    <p>Cette directive informe le client que la redirection est
    permanente (code 301). Son comportement est exactement le même
    que celui de <code>Redirect permanent</code>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ScriptAlias</name>
<description>Fait correspondre une URL à une zone du système de fichiers
et désigne la cible comme script CGI</description>
<syntax>ScriptAlias [<var>chemin URL</var>]
<var>chemin fichier</var>|<var>chemin répertoire</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
<context>directory</context>
</contextlist>

<usage>
    <p>La directive <directive>ScriptAlias</directive> présente le même
    comportement que la directive <directive
    module="mod_alias">Alias</directive>, mais désigne en plus le
    répertoire cible comme conteneur de scripts CGI qui seront traitées
    par le gestionnaire cgi-script du module <module>mod_cgi</module>.
    Les URLs dont le chemin URL sensible à la casse (décodé avec
    caractères %) commence par <var>chemin URL</var> seront mises en
    correspondance avec les scripts dont le chemin commence par le
    second argument, qui est un chemin complet dans le système de
    fichiers local.</p>

    <highlight language="config">
      ScriptAlias "/cgi-bin/" "/web/cgi-bin/"
    </highlight>

    <p>Une requête pour <code>http://example.com/cgi-bin/foo</code>
    ferait exécuter par le serveur le script
    <code>/web/cgi-bin/foo</code>. Cette configuration est sensiblement
    équivalente à :</p>
    <highlight language="config">
Alias "/cgi-bin/" "/web/cgi-bin/"
&lt;Location "/cgi-bin"&gt;
    SetHandler cgi-script
    Options +ExecCGI
&lt;/Location&gt;
    </highlight>

	<p>Vous pouvez aussi utiliser <directive>ScriptAlias</directive>
	avec un script ou gestionnaire de votre cru. Par exemple :</p>

	<highlight language="config">
	  ScriptAlias "/cgi-bin/" "/web/cgi-handler.pl"
    </highlight>

    <p>Dans ce scénario, tous les fichiers faisant l'objet d'une requête
    dans <code>/cgi-bin/</code> seront traités par le fichier que vous
    avez spécifié, ce qui vous permet d'utiliser votre propre
    gestionnaire. Vous pouvez l'utiliser comme enveloppe (wrapper) pour
    les scripts CGI afin d'ajouter du contenu, ou autre action "maison".</p>

    <note type="warning">Il est préférable d'éviter de placer les
    scripts CGI dans l'arborescence de <directive
    module="core">DocumentRoot</directive> afin d'éviter de révéler
    accidentellement leur code source lors d'une modification de
    configuration. On y parvient aisément avec
    <directive>ScriptAlias</directive> en mettant en correspondance une
    URL et en désignant la cible comme scripts CGI par la même occasion.
    Si vous choisissez de placer vos scripts CGI dans un répertoire
    accessible depuis le web, n'utilisez pas
    <directive>ScriptAlias</directive>. Utilisez plutôt <directive
    module="core" type="section">Directory</directive>, <directive
    module="core">SetHandler</directive>, et <directive
    module="core">Options</directive> comme dans l'exemple suivant :
    <highlight language="config">
&lt;Directory "/usr/local/apache2/htdocs/cgi-bin"&gt;
    SetHandler cgi-script
    Options ExecCGI
&lt;/Directory&gt;
    </highlight>
    Ceci est nécessaire car plusieurs <var>chemins URL</var> peuvent
    correspondre à la même zone du système de fichiers, court-circuitant
    ainsi la directive <directive>ScriptAlias</directive> et révélant le
    code source des scripts CGI s'ils ne sont pas protégés par une
    section <directive module="core">Directory</directive>.</note>

    <p>Si la directive <directive>ScriptAlias</directive> est définie au
    sein d'une section <directive type="section"
    module="core">Location</directive> ou <directive type="section"
    module="core">LocationMatch</directive> et si l'argument <var>chemin
    URL</var> est omis, l'argument <var>URL</var> sera interprété en
    utilisant la <a href="../expr.html">syntaxe des expressions</a>.<br />
    Cette syntaxe est disponible à partir de la version 2.4.19 du
    serveur HTTP Apache.</p>

    <highlight language="config">
&lt;Location "/cgi-bin"&gt;
    ScriptAlias "/web/cgi-bin/"
&lt;/Location&gt;
&lt;LocationMatch "/cgi-bin/errors/(?&lt;NUMBER&gt;[0-9]+)"&gt;
    ScriptAlias "/web/cgi-bin/errors/%{env:MATCH_NUMBER}.cgi"
&lt;/LocationMatch&gt;
    </highlight>

</usage>
<seealso><a href="../howto/cgi.html">Tutoriel CGI</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ScriptAliasMatch</name>
<description>Fait correspondre une URL à une zone du système de fichiers
en faisant appel aux expressions rationnelles et en désignant la cible
comme un script CGI</description>
<syntax>ScriptAliasMatch <var>regex</var>
<var>chemin fichier</var>|<var>chemin répertoire</var></syntax>
<contextlist><context>server config</context><context>virtual host</context>
</contextlist>

<usage>
    <p>Cette directive est équivalente à la directive <directive
    module="mod_alias">ScriptAlias</directive>, mais fait appel aux
    <glossary ref="regex">expressions rationnelles</glossary>, à la
    place d'une simple mise en correspondance de préfixe. L'expression
    rationnelle fournie est mise en correspondance avec le chemin URL,
    et si elle correspond, le serveur va substituer toute partie de
    chemin entre parenthèses dans la chaîne spécifiée et l'utiliser
    comme nom de fichier. Par exemple, pour activer le répertoire
    standard <code>/cgi-bin</code>, on peut utiliser :</p>

    <highlight language="config">
      ScriptAliasMatch "^/cgi-bin(.*)" "/usr/local/apache/cgi-bin$1"
    </highlight>

    <p>Comme dans le cas d'AliasMatch, toute la puissance des <glossary
    ref="rexex">expressions rationnelles</glossary> peut être mise à
    contribution. Par exemple, il est possible de construire un alias
    avec une comparaison du modèle du chemin URL insensible à la casse :</p>

    <highlight language="config">
      ScriptAliasMatch "(?i)^/cgi-bin(.*)" "/usr/local/apache/cgi-bin$1"
    </highlight>

    <p>Les remarques à propos de la différence entre <directive
    module="mod_alias">Alias</directive> et <directive
    module="mod_alias">AliasMatch</directive> s'appliquent aussi à la
    différence entre les directives <directive
    module="mod_alias">ScriptAlias</directive> et <directive
    module="mod_alias">ScriptAliasMatch</directive>. Voir la directive
    <directive module="mod_alias">AliasMatch</directive> pour plus de
    détails.</p>

</usage>
</directivesynopsis>

</modulesynopsis>
