<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.en.xsl"?>
<!-- English Revision: 1837205 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="access.xml.meta">
<parentdocument href="./">How-To / Tutoriels</parentdocument>

<title>Contrôle d'accès</title>

<summary>
    <p>Le contrôle d'accès fait référence à tout concept de contrôle
    d'accès à une ressource quelconque. Il est distinct du processus d'<a
    href="auth.html">authentification et d'autorisation</a>.</p>
</summary>

<section id="related"><title>Modules et directives concernés</title>

    <p>Plusieurs modules peuvent intervenir dans le contrôle d'accès.
    Les plus importants sont <module>mod_authz_core</module> et
    <module>mod_authz_host</module>. Ce document illustre aussi comment
    utiliser <module>mod_rewrite</module> pour le contrôle
    d'accès.</p>

</section>

<section id="host"><title>Contrôle d'accès en fonction de l'hôte du
client</title>
    <p>
    Si vous souhaitez restreindre l'accès à certaines parties de votre
    site web en fonction de l'addresse de l'hôte de vos visiteurs, le
    plus simple pour y parvenir consiste à utiliser le module
    <module>mod_authz_host</module>.
    </p>

    <p>La directive <directive
    module="mod_authz_core">Require</directive> permet d'accorder ou
    d'interdire l'accès à certaines ressources de différentes manières.
    Ces critères d'accès, en conjonction avec les directives <directive
    module="mod_authz_core">RequireAll</directive>, <directive
    module="mod_authz_core">RequireAny</directive>, et <directive
    module="mod_authz_core">RequireNone</directive>, peuvent être
    combinés d'une manière suffisamment complexe pour
    satisfaire votre politique de contrôle d'accès.</p>

    <note type="warning"><p>
    Les directives <directive
    module="mod_access_compat">Allow</directive>, <directive
    module="mod_access_compat">Deny</directive>, et <directive
    module="mod_access_compat">Order</directive> fournies par le module
    <module>mod_access_compat</module> sont obsolètes, et sont appelées à
    disparaître dans les versions futures. Il est donc déconseillé de
    les utiliser, et de se fier aux tutoriels qui recommandent leur
    utilisation.
    </p></note>

    <p>Les directives Require s'utilisent comme suit :</p>

    <highlight language="config">
Require host address
Require ip ip.address
    </highlight>

    <p>Dans la première forme, <var>nom-hôte</var> est un nom de domaine
    pleinement qualifié (fqdn), ou un nom de domaine partiel ; vous
    pouvez spécifier plusieurs noms de domaines, si vous le désirez.</p>

    <p>Dans la seconde forme, <var>adresse-ip</var> est une adresse IP
    complète, une adresse IP partielle, une paire réseau/masque de
    sous-réseau ou une spécification CIDR de la forme réseau/nnn. Il est
    possible de spécifier des adresses IPv4 ou IPv6.</p>

    <p>Voir <a href="../mod/mod_authz_host.html#requiredirectives">la
    documentation de mod_authz_host</a> pour d'autres exemples de cette
    syntaxe.</p>

    <p>Vous pouvez insérer le mot-clé <code>not</code> pour inverser un
    critère particulier. Notez que le mot <code>not</code> étant la
    négation d'une valeur, il ne peut pas être utilisé pour autoriser
    ou interdire une requête, car <em>non vrai</em> ne
    sera pas interpreté par httpd comme <em>faux</em>. Ainsi, pour interdire la
    visite d'une page à l'aide d'une négation, le bloc doit contenir un
    élément évalué à vrai ou faux.
    Par exemple, si quelqu'un est en train d'inonder
    votre forum de messages indésirables, vous pouvez ajouter cette ligne pour lui refuser
    l'accès :</p>

    <highlight language="config">
&lt;RequireAll&gt;
    Require all granted
    Require not ip 10.252.46.165
&lt;/RequireAll&gt;
    </highlight>

    <p>Les visiteurs possédant cette adresse (<code>10.252.46.165</code>) ne pourront pas voir le
    contenu concerné par cette directive. Si vous voulez interdire
    l'accès à une machine en fonction de son nom, vous pouvez ajouter
    ceci :</p>

    <highlight language="config">
Require not host <var>host.example.com</var>
    </highlight>

    <p>Et si vous voulez interdire l'accès à un domaine particulier,
    vous pouvez spécifier des adresses IP partielles ou des noms de
    domaine, comme ceci :</p>

    <highlight language="config">
Require not ip 192.168.205
Require not host phishers.example.com moreidiots.example
Require not host gov
    </highlight>

    <p>Les directives <directive
    module="mod_authz_core">RequireAll</directive>, <directive
    module="mod_authz_core">RequireAny</directive>, et <directive
    module="mod_authz_core">RequireNone</directive> permettent également de préciser des
    critères d'accès plus complexes.</p>

</section>

<section id="env"><title>Contrôle d'accès en fonction de variables
arbitraires</title>

    <p>Vous pouvez accorder ou refuser l'accès en fonction de variables
    d'environnement arbitraires ou de valeurs d'en-têtes de la requête
    en utilisant la directive <directive type="section"
    module="core">If</directive>. Par exemple, pour interdire l'accès en
    fonction du user-agent (le type de navigateur), vous pouvez
    spécifier ceci :</p>

    <highlight language="config">
&lt;If "%{HTTP_USER_AGENT} == 'BadBot'"&gt;
    Require all denied
&lt;/If&gt;
    </highlight>

    <p>La syntaxe <code>expr</code> de la directive <directive
    module="mod_authz_core">Require</directive> permet de réécrire
    l'exemple précédent de la manière suivante :</p>


    <highlight language="config">
Require expr %{HTTP_USER_AGENT} != 'BadBot'
    </highlight>

    <note><title>Avertissement :</title>
    <p>Contrôler l'accès en fonction de l'en-tête
    <code>User-Agent</code> n'est pas une technique fiable, car cet
    en-tête peut être défini à une valeur quelconque, selon le bon
    vouloir de l'utilisateur.</p>
    </note>

    <p>Voir le document à propos des <a
    href="../expr.html">expressions</a> pour une description plus
    approfondie des syntaxes d'expressions et des variables disponibles.</p>

</section>

<section id="rewrite"><title>Utilisation de mod_rewrite pour le contrôle
d'accès</title>

    <p>Le drapeau <code>[F]</code> de la directive <directive
    module="mod_rewrite">RewriteRule</directive> permet d'envoyer une
    réponse de type 403 Forbidden. Il vous permet donc d'interdire
    l'accès à une ressource en fonction d'un critère arbitraire.</p>

    <p>Par exemple, pour bloquer l'accès à une ressources entre 20h et
    7h du matin, vous pouvez utiliser <module>mod_rewrite</module> :</p>

    <highlight language="config">
RewriteEngine On
RewriteCond "%{TIME_HOUR}" "&gt;=20" [OR]
RewriteCond "%{TIME_HOUR}" "&lt;07"
RewriteRule "^/fridge"     "-" [F]
    </highlight>

    <p>Toute requête arrivant après 20h ou avant 7h du matin provoquera
    l'envoi d'une réponse de type 403 Forbidden. Vous pouvez utiliser
    cette technique pour vérifier toutes sortes de critères. En outre,
    si vous le préférez, vous pouvez rediriger ou réécrire la requête.</p>

    <p>Notez que la directive <directive type="section"
    module="core">If</directive>, introduite à partir de la version 2.4,
    permet de remplacer le module <module>mod_rewrite</module> dans de
    nombreuses situations où il était traditionnellement utilisé, et
    il sera probablement préférable pour vous de tenter de l'utiliser
    avant de vous tourner vers mod_rewrite.</p>

</section>

<section id="moreinformation"><title>Informations complémentaires</title>

    <p>Le <a href="../expr.html">moteur d'expressions</a> vous fournit
    une grande puissance d'action en fonction de variables du serveur
    arbitraires, et il vous est conseillé de consulter le document
    correspondant pour plus de détails.</p>

    <p>De même, vous devez lire la documentation du module
    <module>mod_authz_core</module> pour des exemples de combinaison de
    critères d'accès multiples, et en particulier la manière dont ces
    derniers interagissent.</p>

    <p>Voir aussi le How-To <a href="auth.html">Authentification and
    autorisation</a>.</p>
</section>

</manualpage>
