<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1817952 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_sed.xml.meta">

<name>mod_sed</name>
<description>Filtre les contenus en entrée (requêtes) et en sortie
(réponses) en utilisant la syntaxe de <code>sed</code></description>
<status>Expérimental</status>
<sourcefile>mod_sed.c sed0.c sed1.c regexp.c regexp.h sed.h</sourcefile>
<identifier>sed_module</identifier>
<compatibility>Disponible depuis la version 2.3 d'Apache</compatibility>

<summary>
<p><module>mod_sed</module> est un filtre de contenu "in-process". Le
filtre <module>mod_sed</module> fournit les commandes d'édition de
<code>sed</code> implémentées par le programme <code>sed</code> de
Solaris 10 comme décrit dans la <a
href="http://www.gnu.org/software/sed/manual/sed.txt">page de
manuel</a>. Cependant, à la différence de <code>sed</code>,
<module>mod_sed</module> ne reçoit pas de données sur son entrée
standard. Au lieu de cela, le filtre agit sur les données échangées
entre le client et le serveur. <module>mod_sed</module> peut être
utilisé comme filtre en entrée ou en sortie. <module>mod_sed</module>
est un filtre de contenu, ce qui signifie qu'on ne peut pas l'utiliser
pour modifier les en-têtes http du client ou du serveur.
</p>
<p>
Le filtre en sortie <module>mod_sed</module> accepte un tronçon de
données, exécute le script <code>sed</code> sur ces données, puis génère
une sortie qui est transmise au filtre suivant dans la chaîne.
</p>

<p>
Le filtre en entrée <module>mod_sed</module> reçoit des données en
provenance du filtre suivant dans la chaîne, exécute les scripts
<code>sed</code>, et renvoie les données générées au filtre appelant
dans la chaîne de filtrage.
</p>

<p>
Les filtres en entrée ou en sortie ne traitent les données que si des
caractères newline sont détectés dans le contenu à filtrer. A la fin des
données, ce qui reste est traité comme la dernière ligne.
</p>

</summary>

<section id="sampleconf"><title>Exemple de configuration</title>
    <example><title>Ajout d'un filtre en sortie</title>
	    <highlight language="config">
# Dans l'exemple suivant, le filtre sed va remplacer la chaîne
	 # "monday" par "MON" et la chaîne "sunday" par "SUN" dans les
	 # documents html avant de les envoyer au client.
&lt;Directory "/var/www/docs/sed"&gt; 
    AddOutputFilter Sed html 
    OutputSed "s/monday/MON/g" 
    OutputSed "s/sunday/SUN/g" 
&lt;/Directory&gt; 
    </highlight>
    </example>

    <example><title>Ajout d'un filtre en entrée</title>
    <highlight language="config">
         # Dans l'exemple suivant, le filtre sed va remplacer la chaîne
	 # "monday" par "MON" et la chaîne "sunday" par "SUN" dans les
	 # données POST envoyées à PHP.
        &lt;Directory "/var/www/docs/sed"&gt; 
    AddInputFilter Sed php 
    InputSed "s/monday/MON/g" 
    InputSed "s/sunday/SUN/g" 
&lt;/Directory&gt; 
        </highlight>
    </example>
</section>
<section id="sed_commands"><title>Commandes sed</title>
    <p>
    Vous trouverez tous les détails à propos de la commande
    <code>sed</code> dans sa <a href="http://www.gnu.org/software/sed/manual/sed.txt">page
    de manuel</a>.
    </p>
    <dl>
        <dt><code>b</code></dt>
        <dd>Saut vers le label spécifié (similaire à goto).</dd>
        <dt><code>h</code></dt>
        <dd>Copie la ligne courante dans le tampon.</dd>
        <dt><code>H</code></dt>
        <dd>Ajoute la ligne courante au tampon.</dd>
        <dt><code>g</code></dt>
        <dd>Copie le contenu du tampon dans la ligne courante.</dd>
        <dt><code>G</code></dt>
        <dd>Ajoute le contenu du tampon à la ligne courante.</dd>
        <dt><code>x</code></dt>
        <dd>Echange les contenus du tampon et de la ligne courante.</dd>
    </dl>
</section>

<directivesynopsis>
<name>OutputSed</name>
<description>Commande sed pour le filtrage des contenus de type
réponse</description>
<syntax>OutputSed <var>commande-sed</var></syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>OutputSed</directive> permet de spécifier
    la commande <code>sed</code> à exécuter dans le cadre du traitement
    d'une réponse.
    </p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>InputSed</name>
<description>Commande sed à exécuter pour le filtrage des données d'une
requête (en général des données <code>POST</code>)</description>
<syntax>InputSed <var>commande-sed</var></syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>

<usage>
    <p>La directive <directive>InputSed</directive> permet de spécifier
    la commande sed à exécuter pour le filtrage des données (en général
    des données <code>POST</code>) d'une requête.
    </p>
</usage>
</directivesynopsis>

</modulesynopsis>
