<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 1836760 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="expr.xml.meta">

  <title>Les expressions dans le serveur HTTP Apache</title>

  <summary>
    <p>Historiquement, il existe de nombreuses variantes dans la syntaxe
    des expressions permettant d'exprimer une condition dans les
    différents modules du serveur HTTP Apache. À ce titre, des travaux sont
    en cours pour n'utiliser qu'une seule variante nommée
    <em>ap_expr</em>, pour toutes les directives de configuration. Ce
    document décrit l'interpréteur d'expressions <em>ap_expr</em>.
    </p>
    <p>Le type d'expression <em>ap_expr</em> est appelé à remplacer la
    plupart des autres types d'expressions dans HTTPD. Par exemple, la
    directive obsolète <directive
    module="mod_ssl">SSLRequire</directive> peut être remplacée par la
    directive <a href="mod/mod_authz_core.html#reqexpr">Require
    expr</a>.
    </p>
  </summary>

<seealso><directive module="core">If</directive></seealso>
<seealso><directive module="core" type="section">If</directive></seealso>
<seealso><directive module="core" type="section">ElseIf</directive></seealso>
<seealso><directive module="core" type="section">Else</directive></seealso>
<seealso><directive module="core">ErrorDocument</directive></seealso>
<seealso><directive module="mod_alias">Alias</directive></seealso>
<seealso><directive module="mod_alias">ScriptAlias</directive></seealso>
<seealso><directive module="mod_alias">Redirect</directive></seealso>
<seealso><directive module="mod_auth_basic">AuthBasicFake</directive></seealso>
<seealso><directive module="mod_auth_form">AuthFormLoginRequiredLocation</directive></seealso>
<seealso><directive module="mod_auth_form">AuthFormLoginSuccessLocation</directive></seealso>
<seealso><directive module="mod_auth_form">AuthFormLogoutLocation</directive></seealso>
<seealso><directive module="mod_rewrite">RewriteCond</directive></seealso>
<seealso><directive module="mod_setenvif">SetEnvIfExpr</directive></seealso>
<seealso><directive module="mod_headers">Header</directive></seealso>
<seealso><directive module="mod_headers">RequestHeader</directive></seealso>
<seealso><directive module="mod_filter">FilterProvider</directive></seealso>
<seealso><a href="mod/mod_authz_core.html#reqexpr">Require expr</a></seealso>
<seealso><a href="mod/mod_authnz_ldap.html#requser">Require ldap-user</a></seealso>
<seealso><a href="mod/mod_authnz_ldap.html#reqgroup">Require ldap-group</a></seealso>
<seealso><a href="mod/mod_authnz_ldap.html#reqdn">Require ldap-dn</a></seealso>
<seealso><a href="mod/mod_authnz_ldap.html#reqattribute">Require ldap-attribute</a></seealso>
<seealso><a href="mod/mod_authnz_ldap.html#reqfilter">Require ldap-filter</a></seealso>
<seealso><a href="mod/mod_authz_dbd.html#reqgroup">Require dbd-group</a></seealso>
<seealso><a href="mod/mod_authz_dbm.html#reqgroup">Require dbm-group</a></seealso>
<seealso><a href="mod/mod_authz_groupfile.html#reqgroup">Require group</a></seealso>
<seealso><a href="mod/mod_authz_host.html#reqhost">Require host</a></seealso>
<seealso><directive module="mod_ssl">SSLRequire</directive></seealso>
<seealso><directive module="mod_log_debug">LogMessage</directive></seealso>
<seealso><module>mod_include</module></seealso>

  <section id="grammar">
    <title>Syntaxe en Forme de Backus-Naur</title>
      <p>La <a href="http://fr.wikipedia.org/wiki/Forme_de_Backus-Naur">Forme de Backus-Naur</a>
      (souvent abrégée en BNF, de l'anglais Backus-Naur Form) est une notation permettant de décrire
      les règles syntaxiques des langages de programmation. En
      général, les expressions représentent des valeurs booléennes. Dans
      ce cas, le point de départ de la BNF est <code>expr</code>.
      Cependant, certaines directives comme <directive
      module="mod_log_debug">LogMessage</directive> utilisent comme
      paramètres des expressions qui représentent des chaînes de
      caractères. Dans ce cas, le point de départ de la BNF est
      <code>string</code>.
      </p>
<blockquote>
<pre>
expr        ::= "<strong>true</strong>" | "<strong>false</strong>"
              | "<strong>!</strong>" expr
              | expr "<strong>&amp;&amp;</strong>" expr
              | expr "<strong>||</strong>" expr
              | "<strong>(</strong>" expr "<strong>)</strong>"
              | comp

comp        ::= stringcomp
              | integercomp
              | unaryop word
              | word binaryop word
              | word "<strong>in</strong>" "<strong>{</strong>" wordlist "<strong>}</strong>"
              | word "<strong>in</strong>" listfunction
              | word "<strong>=~</strong>" regex
              | word "<strong>!~</strong>" regex


stringcomp  ::= word "<strong>==</strong>" word
              | word "<strong>!=</strong>" word
              | word "<strong>&lt;</strong>"  word
              | word "<strong>&lt;=</strong>" word
              | word "<strong>&gt;</strong>"  word
              | word "<strong>&gt;=</strong>" word

integercomp ::= word "<strong>-eq</strong>" word | word "<strong>eq</strong>" word
              | word "<strong>-ne</strong>" word | word "<strong>ne</strong>" word
              | word "<strong>-lt</strong>" word | word "<strong>lt</strong>" word
              | word "<strong>-le</strong>" word | word "<strong>le</strong>" word
              | word "<strong>-gt</strong>" word | word "<strong>gt</strong>" word
              | word "<strong>-ge</strong>" word | word "<strong>ge</strong>" word

wordlist    ::= word
              | wordlist "<strong>,</strong>" word

word        ::= word "<strong>.</strong>" word
              | digit
              | "<strong>'</strong>" string "<strong>'</strong>"
              | "<strong>"</strong>" string "<strong>"</strong>"
              | variable
	      | rebackref
              | function

string      ::= stringpart
              | string stringpart

stringpart  ::= cstring
              | variable
	      | rebackref

cstring     ::= ...
digit       ::= [0-9]+

variable    ::= "<strong>%{</strong>" varname "<strong>}</strong>"
              | "<strong>%{</strong>" funcname "<strong>:</strong>" funcargs "<strong>}</strong>"

rebackref   ::= "<strong>$</strong>" [0-9]

function     ::= funcname "<strong>(</strong>" word "<strong>)</strong>"

listfunction ::= listfuncname "<strong>(</strong>" word "<strong>)</strong>"
</pre>
</blockquote>

</section>

<section id="vars">
    <title>Variables</title>

    <p>L'interpréteur d'expressions fournit plusieurs variables de la
    forme <code>%{HTTP_HOST}</code>. Notez que la valeur d'une variable
    peut dépendre de la phase du traitement de la requête au cours de
    laquelle elle est évaluée. Par exemple, une expression utilisée dans
    une directive <directive>&lt;If &gt;</directive> sera évaluée avant
    la phase d'authentification. Par conséquent, la variable
    <code>%{REMOTE_USER}</code> ne sera pas encore définie à ce stade.</p>

    <p>Les variables suivantes contiennent la valeur de l'en-tête de
    requête HTTP correspondant. La <a href="#functions">fonction</a>
    <code>req</code> permet d'extraire les valeurs des autres
    en-têtes. L'utilisation de ces variables peut provoquer
    l'ajout du nom d'en-tête correspondant à l'en-tête Vary de la
    réponse HTTP, sauf spécification contraire pour la directive
    qui accepte l'expression comme paramètre. La <a
    href="#functions">function</a> <code>req_novary</code> permet de
    modifier ce comportement.</p>

    <table border="1" style="zebra">
    <columnspec><column width="1"/></columnspec>

    <tr><th>Nom</th></tr>
    <tr><td><code>HTTP_ACCEPT</code></td></tr>
    <tr><td><code>HTTP_COOKIE</code></td></tr>
    <tr><td><code>HTTP_FORWARDED</code></td></tr>
    <tr><td><code>HTTP_HOST</code></td></tr>
    <tr><td><code>HTTP_PROXY_CONNECTION</code></td></tr>
    <tr><td><code>HTTP_REFERER</code></td></tr>
    <tr><td><code>HTTP_USER_AGENT</code></td></tr>

    </table>

    <p>Autres variables liées aux requêtes</p>

    <table border="1" style="zebra">
    <columnspec><column width=".4"/><column width=".6"/></columnspec>

    <tr><th>Nom</th><th>Description</th></tr>
    <tr><td><code>REQUEST_METHOD</code></td>
        <td>La méthode HTTP de la requête entrante (par exemple
	<code>GET</code>)</td></tr>
    <tr><td><code>REQUEST_SCHEME</code></td>
        <td>Le protocole associé à l'URI de la requête</td></tr>
    <tr><td><code>REQUEST_URI</code></td>
        <td>La partie chemin de l'URI de la requête</td></tr>
    <tr><td><code>DOCUMENT_URI</code></td>
        <td>Idem <code>REQUEST_URI</code></td></tr>
    <tr><td><code>REQUEST_FILENAME</code></td>
        <td>Le chemin complet dans le système de fichiers local du
	fichier ou du script correspondant à la requête, si le serveur
	l'a dèjà déterminé à l'instant où <code>REQUEST_FILENAME</code>
	est référencée. Dans le cas contraire, comme dans un
	contexte de serveur virtuel, même valeur que <code>REQUEST_URI</code> </td></tr>	
    <tr><td><code>SCRIPT_FILENAME</code></td>
        <td>Identique à <code>REQUEST_FILENAME</code></td></tr>
    <tr><td><code>LAST_MODIFIED</code></td>
        <td>La date et heure de dernière modification du fichier au
	format <code>20101231235959</code>, si elle est déjà connue du
	serveur au moment où <code>LAST_MODIFIED</code> est référencé.
        </td></tr>
    <tr><td><code>SCRIPT_USER</code></td>
        <td>Le nom d'utilisateur du propriétaire du script.</td></tr>
    <tr><td><code>SCRIPT_GROUP</code></td>
        <td>Le nom du groupe auquel appartient le script.</td></tr>
    <tr><td><code>PATH_INFO</code></td>
        <td>L'information relative au nom de chemin située en fin, voir
	la directive <directive module="core">AcceptPathInfo</directive></td></tr>
    <tr><td><code>QUERY_STRING</code></td>
        <td>La chaîne de paramètres de la requête courante</td></tr>
    <tr><td><code>IS_SUBREQ</code></td>
        <td>"<code>true</code>" si la requête courante est une
	sous-requête, "<code>false</code>" dans le cas contraire</td></tr>
    <tr><td><code>THE_REQUEST</code></td>
        <td>La requête complète (par exemple "<code>GET /index.html
	HTTP/1.1</code>")</td></tr>
    <tr><td><code>REMOTE_ADDR</code></td>
        <td>L'adresse IP de l'hôte distant</td></tr>
    <tr><td><code>REMOTE_PORT</code></td>
        <td>Le port de l'hôte distant (versions 2.4.26 et supérieures)</td></tr>
    <tr><td><code>REMOTE_HOST</code></td>
        <td>Le nom d'hôte de l'hôte distant</td></tr>
    <tr><td><code>REMOTE_USER</code></td>
        <td>Le nom de l'utilisateur authentifié, s'il existe (non
	disponible à l'intérieur d'un bloc <directive>&lt;If&gt;</directive>)</td></tr>
    <tr><td><code>REMOTE_IDENT</code></td>
        <td>Le nom de l'utilisateur défini par <module>mod_ident</module></td></tr>
    <tr><td><code>SERVER_NAME</code></td>
        <td>La valeur de la directive <directive
	module="core">ServerName</directive> du serveur virtuel courant</td></tr>
    <tr><td><code>SERVER_PORT</code></td>
        <td>Le port associé au serveur virtuel courant ; voir la
	directive <directive module="core">ServerName</directive></td></tr>
    <tr><td><code>SERVER_ADMIN</code></td>
        <td>La valeur de la directive <directive
	module="core">ServerAdmin</directive> du serveur virtuel courant</td></tr>
    <tr><td><code>SERVER_PROTOCOL</code></td>
        <td>Le protocole utilisé par la requête</td></tr>
    <tr><td><code>DOCUMENT_ROOT</code></td>
        <td>La valeur de la directive <directive
	module="core">DocumentRoot</directive> du serveur virtuel
	courant</td></tr>
    <tr><td><code>AUTH_TYPE</code></td>
        <td>La valeur de la directive <directive
	module="mod_authn_core">AuthType</directive> (par exemple
	"<code>basic</code>")</td></tr>
    <tr><td><code>CONTENT_TYPE</code></td>
        <td>Le type de contenu de la réponse (non
	disponible à l'intérieur d'un bloc <directive>&lt;If&gt;</directive>)</td></tr>
    <tr><td><code>HANDLER</code></td>
        <td>Le nom du <a href="handler.html">gestionnaire</a> qui a
	généré la réponse</td></tr>
    <tr><td><code>HTTP2</code></td>
        <td>"<code>on</code>" si la requête utilise http/2,
            "<code>off</code>" dans le cas contraire</td></tr>
    <tr><td><code>HTTPS</code></td>
        <td>"<code>on</code>" si la requête utilise https,
	"<code>off</code>" dans le cas contraire</td></tr>
    <tr><td><code>IPV6</code></td>
        <td>"<code>on</code>" si la connexion utilise IPv6,
	"<code>off</code>" dans le cas contraire</td></tr>
    <tr><td><code>REQUEST_STATUS</code></td>
        <td>Le code d'erreur HTTP de la requête (non
	disponible à l'intérieur d'un bloc <directive>&lt;If&gt;</directive>)</td></tr>
    <tr><td><code>REQUEST_LOG_ID</code></td>
        <td>L'identifiant du message d'erreur associé à la requête (voir
	la directive <directive
	module="core">ErrorLogFormat</directive>)</td></tr>
    <tr><td><code>CONN_LOG_ID</code></td>
        <td>L'identifiant du message d'erreur associé à la connexion
	(voir la directive <directive
	module="core">ErrorLogFormat</directive>)</td></tr>
    <tr><td><code>CONN_REMOTE_ADDR</code></td>
        <td>L'adresse IP du correspondant pour la connexion (voir le module
	<module>mod_remoteip</module>)</td></tr>
    <tr><td><code>CONTEXT_PREFIX</code></td>
        <td></td></tr>
    <tr><td><code>CONTEXT_DOCUMENT_ROOT</code></td>
        <td></td></tr>	

    </table>

    <p>Variables diverses</p>

    <table border="1" style="zebra">
    <columnspec><column width=".4"/><column width=".6"/></columnspec>

    <tr><th>Nom</th><th>Description</th></tr>
    <tr><td><code>TIME_YEAR</code></td>
        <td>L'année courante (par exemple <code>2010</code>)</td></tr>
    <tr><td><code>TIME_MON</code></td>
        <td>Le mois courant (<code>01</code>, ..., <code>12</code>)</td></tr>
    <tr><td><code>TIME_DAY</code></td>
        <td>Le jour courant dans le mois (<code>01</code>, ...)</td></tr>
    <tr><td><code>TIME_HOUR</code></td>
        <td>Les heures de la date courante (<code>00</code>, ...,
	<code>23</code>)</td></tr>
    <tr><td><code>TIME_MIN</code></td>
        <td>Les minutes de la date courante</td></tr>
    <tr><td><code>TIME_SEC</code></td>
        <td>Les secondes de la date courante</td></tr>
    <tr><td><code>TIME_WDAY</code></td>
        <td>Le jour de la semaine (à partir de <code>0</code> pour
	dimanche)</td></tr>
    <tr><td><code>TIME</code></td>
        <td>La date et heure au format <code>20101231235959</code></td></tr>
    <tr><td><code>SERVER_SOFTWARE</code></td>
        <td>La chaîne contenant la version du serveur</td></tr>
    <tr><td><code>API_VERSION</code></td>
        <td>La date de la version de l'API (module magic number)</td></tr>
    </table>

    <p>Certains modules, comme <module>mod_ssl</module>, définissent des
    variables supplémentaires.</p>

</section>

<section id="binop">
    <title>Opérateurs binaires</title>

    <p>À l'exception de quelques opérateurs de comparaison internes, les
    opérateurs binaires sont de la forme
    "<code>-[a-zA-Z][a-zA-Z0-9_]+</code>", autrement dit un signe moins
    et au moins deux caractères. Le nom est insensible à la casse. Les
    modules peuvent fournir des opérateurs binaires supplémentaires.</p>

    <section id="comp">
    <title>Opérateurs de comparaison</title>

    <table border="1" style="zebra">
    <columnspec><column width=".2"/><column width=".2"/><column width=".6"/></columnspec>

    <tr><th>Nom</th><th>Alternative</th> <th>Description</th></tr>
    <tr><td><code>==</code></td>
        <td><code>=</code></td>
        <td>Egalité de chaînes</td></tr>
    <tr><td><code>!=</code></td>
        <td></td>
        <td>Inégalité de chaînes</td></tr>
    <tr><td><code>&lt;</code></td>
        <td></td>
        <td>Chaîne inférieure à</td></tr>
    <tr><td><code>&lt;=</code></td>
        <td></td>
        <td>Chaîne inférieure ou égale à</td></tr>
    <tr><td><code>&gt;</code></td>
        <td></td>
        <td>Chaîne supérieure à</td></tr>
    <tr><td><code>&gt;=</code></td>
        <td></td>
        <td>Chaîne supérieure ou égale à</td></tr>
    <tr><td><code>=~</code></td>
        <td></td>
        <td>La chaîne correspond à l'expression rationnelle</td></tr>
    <tr><td><code>!~</code></td>
        <td></td>
        <td>La chaîne ne correspond pas à l'expression rationnelle</td></tr>	
    <tr><td><code>-eq</code></td>
        <td><code>eq</code></td>
        <td>Egalité d'entiers</td></tr>
    <tr><td><code>-ne</code></td>
        <td><code>ne</code></td>
        <td>Inégalité d'entiers</td></tr>
    <tr><td><code>-lt</code></td>
        <td><code>lt</code></td>
        <td>Entier inférieur à</td></tr>
    <tr><td><code>-le</code></td>
        <td><code>le</code></td>
        <td>Entier inférieur ou égal à</td></tr>
    <tr><td><code>-gt</code></td>
        <td><code>gt</code></td>
        <td>Entier supérieur à</td></tr>
    <tr><td><code>-ge</code></td>
        <td><code>ge</code></td>
        <td>Entier supérieur ou égal à</td></tr>
    </table>
    </section>

    <section id="binaryother">
    <title>Autres opérateurs binaires</title>

    <table border="1" style="zebra">
    <columnspec><column width=".2"/><column width=".8"/></columnspec>

    <tr><th>Nom</th><th>Description</th></tr>
    <tr><td><code>-ipmatch</code></td>
        <td>L'adresse IP correspond à adresse/masque</td></tr>
    <tr><td><code>-strmatch</code></td>
        <td>la chaîne de gauche correspond au modèle constitué par la
	chaîne de droite (contenant des caractères génériques *, ?, [])</td></tr>
    <tr><td><code>-strcmatch</code></td>
        <td>idem <code>-strmatch</code>, mais insensible à la casse</td></tr>
    <tr><td><code>-fnmatch</code></td>
        <td>idem <code>-strmatch</code>, mais les slashes ne sont pas
	pris en compte par les caractères génériques</td></tr>
    </table>
    </section>

</section>

<section id="unnop">
    <title>Opérateurs unaires</title>

    <p>Les opérateurs unaires acceptent un seul argument et sont
    de la forme "<code>-[a-zA-Z]</code>",
    autrement dit le signe moins et un caractère. Le nom <em>est</em>
    sensible à la casse. Les modules peuvent fournir des opérateurs
    unaires supplémentaires.</p>

    <table border="1" style="zebra">
    <columnspec><column width=".2"/><column width=".2"/><column width=".6"/></columnspec>

    <tr><th>Nom</th><th>Description</th><th>Remarques particulières</th></tr>
    <tr><td><code>-d</code></td>
        <td>L'argument est traité comme un nom de fichier. 
	Vrai si le fichier existe et correspond à un
	répertoire</td><td>oui</td></tr>
    <tr><td><code>-e</code></td>
        <td>L'argument est traité comme un nom de fichier. Vrai si le
	fichier (ou dir ou special) existe</td><td>oui</td></tr>
    <tr><td><code>-f</code></td>
        <td>L'argument est traité comme un nom de fichier. Vrai si le
	fichier existe et correspond à un fichier
	régulier</td><td>oui</td></tr>
    <tr><td><code>-s</code></td>
        <td>L'argument est traité comme un nom de fichier. Vrai si le
	fichier existe et n'est pas vide</td><td>oui</td></tr>
    <tr><td><code>-L</code></td>
        <td>L'argument est traité comme un nom de fichier. Vrai si le
	fichier existe et correspond à un lien
	symbolique</td><td>oui</td></tr>
    <tr><td><code>-h</code></td>
        <td>L'argument est traité comme un nom de fichier. Vrai si le
	fichier existe et correspond à un lien symbolique
	(identique à <code>-L</code>)</td><td>oui</td></tr>
    <tr><td><code>-F</code></td>
        <td>Vrai si la chaîne correspond a un fichier valide, accessible
	avec tous les contrôles d'accès configurés pour ce chemin. A
	cette fin, une sous-requête effectue la vérification, et vous
	devez utiliser ce drapeau avec soin car il peut impacter les
	performances de votre serveur !</td><td></td></tr>
    <tr><td><code>-U</code></td>
        <td>Vrai si la chaîne correspond a une URL valide, accessible
	avec tous les contrôles d'accès configurés pour ce chemin. A
	cette fin, une sous-requête effectue la vérification, et vous
	devez utiliser ce drapeau avec soin car il peut impacter les
	performances de votre serveur !</td><td></td></tr>
    <tr><td><code>-A</code></td>
        <td>Alias pour <code>-U</code></td><td></td></tr>
    <tr><td><code>-n</code></td>
        <td>Vrai si la chaîne n'est pas vide</td><td></td></tr>
    <tr><td><code>-z</code></td>
        <td>Vrai si la chaîne est vide</td><td></td></tr>
    <tr><td><code>-T</code></td>
        <td>Faux si la chaîne est vide, "<code>0</code>",
	"<code>off</code>", "<code>false</code>", ou "<code>no</code>"
	(insensibilité à la casse). Vrai dans le cas contraire.</td><td></td></tr>
    <tr><td><code>-R</code></td>
        <td>Idem "<code>%{REMOTE_ADDR} -ipmatch ...</code>", en plus
	efficace
        </td><td></td></tr>
    </table>

    <p>Les opérateurs marqués comme "restreints" ne sont pas disponibles
    avec certains modules comme <module>mod_include</module>.</p>

</section>

<section id="functions">
    <title>Fonctions</title>

    <p>Normalement, les fonctions dont la valeur est une chaîne acceptent une chaîne
    comme argument et renvoient une chaîne. Les noms de fonctions sont
    insensibles à la casse. Les modules peuvent fournir des fonctions
    supplémentaires.</p>

    <table border="1" style="zebra">
    <columnspec><column width=".2"/><column width=".8"/></columnspec>

    <tr><th>Nom</th><th>Description</th><th>Notes particulières</th></tr>
    <tr><td><code>req</code>, <code>http</code></td>
        <td>Lit l'en-tête de requête HTTP ; les noms
	d'en-tête correspondants peuvent être ajoutés
	à l'en-tête Vary,
	voir ci-dessous</td><td></td></tr>
    <tr><td><code>req_novary</code></td>
        <td>Identique à <code>req</code>, mais aucun nom d'en-tête n'est
	ajouté à l'en-tête Vary</td><td></td></tr>
    <tr><td><code>resp</code></td>
        <td>Lit l'en-tête de réponse HTTP (La plupart des en-têtes de la réponse
	ne seront pas encore définis pendant le traitement de la directive
	<directive>&lt;If&gt;</directive>)</td><td></td></tr>
    <tr><td><code>reqenv</code></td>
        <td>Recherche une variable d'environnement de requête (on
	peut aussi utiliser le raccourci <code>v</code>).
	</td>
	<td>ordonnancement</td></tr>
    <tr><td><code>osenv</code></td>
        <td>Recherche une variable d'environnement du système
	d'exploitation</td><td></td></tr>
    <tr><td><code>note</code></td>
        <td>Recherche une note de requête</td><td>ordonnancement</td></tr>
    <tr><td><code>env</code></td>
        <td>Renvoie le premier résultat positif de <code>note</code>,
	<code>reqenv</code>, <code>osenv</code></td><td>ordonnancement</td></tr>
    <tr><td><code>tolower</code></td>
        <td>Convertit une chaîne en minuscules</td><td></td></tr>
    <tr><td><code>toupper</code></td>
        <td>Convertit une chaîne en majuscules</td><td></td></tr>
    <tr><td><code>escape</code></td>
        <td>Echappe les caractères spéciaux en codage hexadécimal</td><td></td></tr>
    <tr><td><code>unescape</code></td>
        <td>"Déséchappe" les chaînes codées
	en hexadécimal, en ne gardant encodés que les slashes; renvoie la chaîne vide
	si la séquence %00 est rencontrée</td><td></td></tr>
    <tr><td><code>base64</code></td>
        <td>Encode la chaîne en base64</td><td></td></tr>
    <tr><td><code>unbase64</code></td>
        <td>Décode les chaînes codées en base64, renvoie une chaîne
	tronquée si le caractère 0x00 est rencontré</td><td></td></tr>
    <tr><td><code>md5</code></td>
        <td>Génère un hash de la chaîne en utilisant MD5, puis code le
	hash obtenu en hexadécimal</td><td></td></tr>
    <tr><td><code>sha1</code></td>
        <td>Génère un hash de la chaîne en utilisant SHA1, puis encode
	le hash obtenu en hexadécimal</td><td></td></tr>
    <tr><td><code>file</code></td>
        <td>Lit le contenu d'un fichier(fins de lignes incluses, si
	elles existent)</td><td>limité</td></tr>
    <tr><td><code>filemod</code></td>
        <td>Renvoie la date de dernière modification d'un fichier (ou 0 si le
	fichier n'existe pas ou n'est pas un fichier régulier)</td><td>limité</td></tr>	
    <tr><td><code>filesize</code></td>
        <td>Renvoie la taille d'un fichier (ou 0 si le fichier n'existe
	pas ou ne correspond pas à un fichier régulier)</td><td>limité</td></tr>

    </table>

    <p>Les fonctions marquées comme "limité" dans la dernière colonne ne sont
    pas disponibles avec certains modules comme
    <module>mod_include</module>.</p>

    <p>Les fonctions marquées comme "ordonnancement" dans la dernière colonne
    nécessitent une attention particulière pour l'ordonnancement des différents
    composants du serveur, spécialement lorsque la fonction est utilisée au sein
    d'une directive &lt;<directive module="core">If</directive>&gt; qui est
    évaluée relativement tôt.</p>
    <note>
    <title>Ordonnancement des variables d'environnement</title>
    Lorsque des variables d'environnement sont évaluées au sein d'une directive
    &lt;<directive module="core">If</directive>&gt;, il est important de tenir
    compte du moment où cette évaluation intervient dans le traitement de la
    requête. Par exemple, toute directive définie en dehors d'un contexte de
    serveur virtuel (directory, location, htaccess) aura peu de chance d'être
    déjà exécutée. Ainsi la directive <directive
    module="mod_setenvif">SetEnvIf</directive> est une directive qui s'exécute
    avant cette évaluation.
    <br/>
    <br/>
    Lorsque <code>reqenv</code> est utilisé en dehors de la directive
    &lt;<directive module="core">If</directive>&gt;, l'évaluation survient en
    général plus tard, mais le moment exact dépend de la directive dans laquelle
    l'expression a été utilisée.
    </note>

    <p>Lorsque les fonctions <code>req</code> ou <code>http</code> sont
    utilisées, le nom d'en-tête sera automatiquement ajouté à l'en-tête
    Vary de la réponse HTTP, sauf spécification contraire pour la
    directive qui accepte l'expression comme paramètre. La
    fonction <code>req_novary</code> permet d'empêcher l'ajout de noms
    d'en-têtes à l'en-tête Vary.</p>

    <p>En plus des fonctions dont la valeur est une chaîne, il existe
    aussi des fonctions dont la valeur est une liste, qui acceptent une
    chaîne comme argument, et renvoient une liste de mots, autrement dit
    une liste de chaînes. La liste de mot peut être utilisée avec
    l'opérateur spécial <code>-in</code>. Les noms de fonctions sont
    insensibles à la casse. Les modules peuvent fournir des fonctions
    supplémentaires.</p>

    <p>Il n'existe pas de fonctions internes dont la valeur est une
    liste. Le module <module>mod_ssl</module> fournit la fonction
    <code>PeerExtList</code>. Voir la description de la directive
    <directive module="mod_ssl">SSLRequire</directive> pour plus de
    détails (notez que la fonction <code>PeerExtList</code> peut aussi
    être utilisée en dehors de la directive <directive
    module="mod_ssl">SSLRequire</directive>).</p>

</section>
<section id="examples">
    
	<title>Exemples d'expressions</title>
	<p>Les exemples suivants montent comment utiliser les
	expressions pour évaluer les requêtes :</p>
	<!-- This section should probably be extended with more, useful examples -->
	<highlight language="config">
# Comparer le nom d'hôte avec example.com et rediriger vers
# www.example.com si le nom d'hôte correspond
&lt;If "%{HTTP_HOST} == 'example.com'"&gt;
    Redirect permanent "/" "http://www.example.com/"
&lt;/If&gt;

# Forcer le type text/plain si un fichier fait l'objet d'une
# requête dont la chaîne de paramètres contient 'forcetext'
&lt;If "%{QUERY_STRING} =~ /forcetext/"&gt;
    ForceType text/plain
&lt;/If&gt;

# N'autoriser l'accès à ce contenu que pendant les heures de
# travail
&lt;Directory "/foo/bar/business"&gt;
     Require expr %{TIME_HOUR} -gt 9 &amp;&amp; %{TIME_HOUR} -lt 17
&lt;/Directory&gt;

# Vérifie si un en-tête HTTP correspond à une des valeurs d'une liste
&lt;If "%{HTTP:X-example-header} in { 'foo', 'bar', 'baz' }"&gt;
    La définition de l'en-tête correspond à une des valeurs recherchées
&lt;/If&gt;

# Recherche la valeur d'une expression rationnelle dans une variable
# d'environnement, et renvoie la négation du résultat.
&lt;If "! reqenv('REDIRECT_FOO') =~ /bar/"&gt;
    La condition est vérifiée
&lt;/If&gt;

# Vérifie le résultat de la recherche d'une correspondance d'URI dans un
# contexte de répertoire avec l'option -f
&lt;Directory "/var/www"&gt;
    AddEncoding x-gzip gz
&lt;If "-f '%{REQUEST_FILENAME}.unzipme' &amp;&amp; ! %{HTTP:Accept-Encoding} =~ /gzip/"&gt;
      SetOutputFilter INFLATE
&lt;/If&gt;
&lt;/Directory&gt;

# Vérifie l'adresse IP du client
&lt;If "-R '192.168.1.0/24'"&gt;
    Header set matched true
&lt;/If&gt;

# Exemple de fonction dans un contexte booléen
&lt;If "md5('foo') == 'acbd18db4cc2f85cedef654fccc4a4d8'"&gt;
  Header set checksum-matched true
&lt;/If&gt;

# Function example in string context
Header set foo-checksum "expr=%{md5:foo}"

# L'exemple suivant retarde l'évaluation de la clause de condition par rapport à
# &lt;If&gt;
Header always set CustomHeader my-value "expr=%{REQUEST_URI} =~ m#^/special_path\.php$#"

# Journalisation conditionnelle
CustomLog logs/access-errors.log common "expr=%{REQUEST_STATUS} >= 400"
CustomLog logs/access-errors-specific.log common "expr=%{REQUEST_STATUS} -in {'405','410'}"

	</highlight>
</section>

<section id="other">
    <title>Autres</title>

    <table border="1" style="zebra">
    <columnspec><column width=".2"/><column width=".2"/><column width=".6"/></columnspec>

    <tr><th>Nom</th><th>Alternative</th> <th>Description</th></tr>
    <tr><td><code>-in</code></td>
        <td><code>in</code></td>
        <td>chaîne contenue dans une liste de mots</td></tr>
    <tr><td><code>/regexp/</code></td>
        <td><code>m#regexp#</code></td>
        <td>Expression rationnelle (la seconde forme permet de spécifier
	des délimiteurs autres que /)</td></tr>
    <tr><td><code>/regexp/i</code></td>
        <td><code>m#regexp#i</code></td>
        <td>Expression rationnelle insensible à la casse</td></tr>
    <tr><td><code>$0 ... $9</code></td>
        <td></td>
        <td>Références arrières dans les expressions rationnelles</td></tr>
    </table>

    <section id="rebackref">
        <title>Références arrières dans les expressions rationnelles</title>
        <p>Les chaînes <code>$0</code> ... <code>$9</code> permettent de
	référencer les groupes de capture en provenance d'expressions
	rationnelles précédemment exécutées et mises en correspondance avec
	succès. Elles ne peuvent normalement être utilisées que dans la
	même expression que celle mise en correspondance, mais certains
	modules permettent de les utiliser de manière spéciale.</p>
    </section>

</section>

<section id="sslrequire">
    <title>Comparaison avec SSLRequire</title>
    <p>La syntaxe <em>ap_expr</em> consiste principalement en une
    surcouche de la syntaxe de la directive obsolète <directive
    module="mod_ssl">SSLRequire</directive>. Vous pouvez consulter la
    liste de leur différences dans la documentation de la directive
    <directive module="mod_ssl">SSLRequire</directive>.</p>
</section>

<section id="compatibility">
    <title>Historique de version</title>
    <p>La <a href="#functions">fonction</a> <code>req_novary</code> est
    disponible à partir de la version 2.4.4 du serveur HTTP Apache.</p>
</section>

</manualpage>
